/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.wizards;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.domain.ModeShapeWorkspace;
import org.jboss.tools.modeshape.rest.jobs.PublishJob;
import org.jboss.tools.modeshape.rest.wizards.PublishPage;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.rest.client.Status;

public final class PublishWizard
extends Wizard {
    private final PublishPage page;
    private final ServerManager serverManager;
    private final PublishJob.Type type;

    public PublishWizard(PublishJob.Type type, List<IResource> resources, ServerManager serverManager) throws CoreException {
        CheckArg.isNotNull((Object)((Object)type), (String)"type");
        CheckArg.isNotNull(resources, (String)"resources");
        CheckArg.isNotNull((Object)serverManager, (String)"serverManager");
        this.type = type;
        this.page = new PublishPage(type, resources);
        this.serverManager = serverManager;
        this.setWindowTitle(type == PublishJob.Type.PUBLISH ? RestClientI18n.publishWizardPublishTitle : RestClientI18n.publishWizardUnpublishTitle);
        this.setDefaultPageImageDescriptor(Activator.getDefault().getImageDescriptor("icons/wizards/wizard_banner.png"));
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings == null) {
            IDialogSettings temp = Activator.getDefault().getDialogSettings();
            settings = temp.getSection(((Object)((Object)this)).getClass().getSimpleName());
            if (settings == null) {
                settings = temp.addNewSection(((Object)((Object)this)).getClass().getSimpleName());
            }
            this.setDialogSettings(settings);
        }
        return super.getDialogSettings();
    }

    protected ServerManager getServerManager() {
        return this.serverManager;
    }

    public boolean performFinish() {
        try {
            this.page.wizardFinished();
        }
        catch (Exception e) {
            Activator.getDefault().log(new Status(Status.Severity.ERROR, RestClientI18n.publishPageFinishedErrorMsg, (Throwable)e));
        }
        ModeShapeWorkspace workspace = this.page.getWorkspace();
        List<IFile> files = this.page.getFiles();
        String workspaceArea = this.page.getWorkspaceArea();
        PublishJob job = new PublishJob(this.type, files, workspace, workspaceArea, this.page.isVersioning());
        job.schedule();
        return true;
    }
}

