/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.views;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IDecoratorManager;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.IServerRegistryListener;
import org.jboss.tools.modeshape.rest.PublishedResourceHelper;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.ServerRegistryEvent;
import org.jboss.tools.modeshape.rest.domain.ModeShapeDomainObject;
import org.jboss.tools.modeshape.rest.domain.ModeShapeRepository;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.jboss.tools.modeshape.rest.domain.ModeShapeWorkspace;
import org.jboss.tools.modeshape.rest.domain.WorkspaceArea;

public final class ModeShapeContentProvider
extends ColumnLabelProvider
implements ILightweightLabelDecorator,
IServerRegistryListener,
ILazyTreeContentProvider {
    private static final String ID = "org.jboss.tools.modeshape.rest.decorator";
    private static final long RETRY_DURATION = 5000L;
    private static boolean _alreadyCalledByFramework;
    private static final Map<ModeShapeServer, Long> _offlineServerMap;
    private static final ReadWriteLock _offlineServersLock;
    private ServerManager serverManager;
    private TreeViewer viewer;

    static {
        _offlineServerMap = new HashMap<ModeShapeServer, Long>();
        _offlineServersLock = new ReentrantReadWriteLock();
    }

    public static ModeShapeContentProvider getDecorator() {
        IDecoratorManager decoratorMgr = Activator.getDefault().getWorkbench().getDecoratorManager();
        if (decoratorMgr.getEnabled(ID)) {
            return (ModeShapeContentProvider)decoratorMgr.getBaseLabelProvider(ID);
        }
        return null;
    }

    void addOfflineServer(ModeShapeServer server) {
        if (this.viewer != null) {
            this.viewer.setHasChildren((Object)server, false);
        }
        try {
            _offlineServersLock.writeLock().lock();
            _offlineServerMap.put(server, System.currentTimeMillis());
            this.refresh(server);
        }
        finally {
            _offlineServersLock.writeLock().unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void decorate(Object element, IDecoration decoration) {
        overlay = null;
        display = Display.getDefault();
        if (display.isDisposed()) {
            return;
        }
        if (element instanceof ModeShapeServer) {
            server = (ModeShapeServer)element;
            try {
                ModeShapeContentProvider._offlineServersLock.readLock().lock();
                if (!ModeShapeContentProvider._offlineServerMap.containsKey(server)) ** GOTO lbl17
                overlay = Activator.getDefault().getImageDescriptor("icons/views/error_overlay.gif");
            }
            finally {
                ModeShapeContentProvider._offlineServersLock.readLock().unlock();
            }
        } else if (element instanceof IFile && (file = (IFile)element).exists() && !file.isHidden() && new PublishedResourceHelper(this.getServerManager()).isPublished((IFile)element)) {
            overlay = Activator.getDefault().getImageDescriptor("icons/views/published_overlay.png");
        }
lbl17:
        // 5 sources

        if (overlay != null) {
            decoration.addOverlay(overlay);
        }
    }

    public void dispose() {
    }

    public Image getImage(Object element) {
        return Activator.getDefault().getImage(element);
    }

    public Object getParent(Object element) {
        assert (element instanceof ModeShapeDomainObject);
        if (element instanceof WorkspaceArea) {
            return ((WorkspaceArea)element).getWorkspace();
        }
        if (element instanceof ModeShapeWorkspace) {
            return ((ModeShapeWorkspace)element).getRepository();
        }
        if (element instanceof ModeShapeRepository) {
            return ((ModeShapeRepository)element).getServer();
        }
        if (element instanceof ModeShapeServer) {
            return this.getServerManager();
        }
        assert (false) : "unknown ModeShapeDomainObject=" + element.getClass();
        return null;
    }

    ServerManager getServerManager() {
        if (this.serverManager == null) {
            this.serverManager = Activator.getDefault().getServerManager();
        }
        return this.serverManager;
    }

    Shell getShell() {
        return this.viewer.getTree().getShell();
    }

    public String getText(Object element) {
        assert (element instanceof ModeShapeDomainObject);
        return ((ModeShapeDomainObject)element).getName();
    }

    public Image getToolTipImage(Object object) {
        return this.getImage(object);
    }

    public String getToolTipText(Object element) {
        if (element instanceof ModeShapeDomainObject) {
            return ((ModeShapeDomainObject)element).getShortDescription();
        }
        return super.getToolTipText(element);
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 3000;
    }

    TreeViewer getViewer() {
        return this.viewer;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private boolean isOkToConnect(ModeShapeServer server) {
        boolean check = false;
        try {
            _offlineServersLock.readLock().lock();
            check = _offlineServerMap.containsKey(server);
        }
        finally {
            _offlineServersLock.readLock().unlock();
        }
        if (check) {
            try {
                _offlineServersLock.writeLock().lock();
                if (_offlineServerMap.containsKey(server)) {
                    long checkTime = _offlineServerMap.get(server);
                    if (System.currentTimeMillis() - checkTime > 5000L) {
                        _offlineServerMap.remove(server);
                        this.refresh(server);
                        return true;
                    }
                    return false;
                }
            }
            finally {
                _offlineServersLock.writeLock().unlock();
            }
        }
        return true;
    }

    public void refresh(final Object element) {
        Display display = Display.getDefault();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ModeShapeContentProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ModeShapeContentProvider.this, element));
            }
        });
    }

    private void run(ServerOperation op, boolean enforceNonEmptyPassword) {
        try {
            Object dialog;
            ModeShapeServer server = op.getServer();
            if (enforceNonEmptyPassword && (server.getPassword() == null || server.getPassword().isEmpty()) && MessageDialog.openQuestion((Shell)this.getShell(), (String)RestClientI18n.missingServerPasswordDialogTitle, (String)RestClientI18n.missingServerPasswordDialogMsg) && (dialog = new NewPasswordDialog(this.getShell())).open() == 0) {
                this.getServerManager().updateServer(server, new ModeShapeServer(server.getOriginalUrl(), server.getUser(), ((NewPasswordDialog)((Object)dialog)).getNewPassword(), server.isPasswordBeingPersisted()));
                for (ModeShapeServer registeredServer : this.getServerManager().getServers()) {
                    if (!registeredServer.hasSameKey(server)) continue;
                    op.setUpdatedServer(registeredServer);
                    break;
                }
            }
            dialog = new ProgressMonitorDialog(this.getShell()){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setText(RestClientI18n.requestDialogTitle);
                }
            };
            dialog.run(true, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            if (op.getUpdatedServer() == null) {
                this.addOfflineServer(op.getServer());
            } else {
                this.addOfflineServer(op.getUpdatedServer());
            }
            Status error = new Status(4, "org.jboss.tools.modeshape.rest", RestClientI18n.runningServerRequestErrorMsg, e.getCause());
            ErrorDialog.openError((Shell)this.getShell(), (String)RestClientI18n.runningServerRequestErrorDialogTitle, (String)RestClientI18n.runningServerRequestErrorDialogMsg, (IStatus)error);
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public Exception[] serverRegistryChanged(ServerRegistryEvent event) {
        Exception[] errors = null;
        if (event.isRemove() || event.isUpdate()) {
            try {
                try {
                    _offlineServersLock.writeLock().lock();
                    _offlineServerMap.remove(event.getServer());
                }
                catch (Exception e) {
                    errors = new Exception[]{e};
                    _offlineServersLock.writeLock().unlock();
                }
            }
            finally {
                _offlineServersLock.writeLock().unlock();
            }
        }
        return errors;
    }

    void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void updateChildCount(Object element, final int currentChildCount) {
        ModeShapeWorkspace workspace;
        this.getServerManager();
        if (element == this.serverManager) {
            Collection<ModeShapeServer> servers = this.serverManager.getServers();
            if (servers.size() != currentChildCount) {
                this.viewer.setChildCount(element, servers.size());
            }
            if (_alreadyCalledByFramework) {
                this.updateElement(element, 0);
            } else {
                _alreadyCalledByFramework = true;
            }
        } else if (element instanceof ModeShapeServer) {
            final ModeShapeServer server = (ModeShapeServer)element;
            if (this.isOkToConnect(server)) {
                try {
                    ServerOperation op = new ServerOperation(this, server){

                        @Override
                        void doRun(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            monitor.beginTask(RestClientI18n.runningRepositoriesQueryMsg, -1);
                            ModeShapeServer serverToQuery = this.getUpdatedServer() == null ? server : this.getUpdatedServer();
                            try {
                                try {
                                    Collection<ModeShapeRepository> repositories = this.getServerManager().getRepositories(serverToQuery);
                                    if (repositories.size() != currentChildCount) {
                                        this.getViewer().setChildCount((Object)serverToQuery, repositories.size());
                                    }
                                }
                                catch (Exception e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }

                        @Override
                        Display getDisplay() {
                            return this.getViewer().getTree().getDisplay();
                        }
                    };
                    this.run(op, true);
                }
                catch (Exception exception) {
                    this.addOfflineServer(server);
                }
            }
        } else if (element instanceof ModeShapeRepository) {
            final ModeShapeRepository repository = (ModeShapeRepository)element;
            if (this.isOkToConnect(repository.getServer())) {
                try {
                    ServerOperation op = new ServerOperation(this, repository.getServer()){

                        @Override
                        void doRun(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            monitor.beginTask(RestClientI18n.runningWorkspacesQueryMsg, -1);
                            try {
                                try {
                                    Collection<ModeShapeWorkspace> workspaces = this.getServerManager().getWorkspaces(repository);
                                    if (workspaces.size() != currentChildCount) {
                                        this.getViewer().setChildCount((Object)repository, workspaces.size());
                                    }
                                }
                                catch (Exception e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }

                        @Override
                        Display getDisplay() {
                            return this.getViewer().getTree().getDisplay();
                        }
                    };
                    this.run(op, true);
                }
                catch (Exception exception) {
                    this.addOfflineServer(repository.getServer());
                }
            }
        } else if (element instanceof ModeShapeWorkspace && this.isOkToConnect((workspace = (ModeShapeWorkspace)element).getServer())) {
            try {
                ServerOperation op = new ServerOperation(this, workspace.getServer()){

                    @Override
                    void doRun(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        monitor.beginTask(RestClientI18n.runningWorkspacesQueryMsg, -1);
                        try {
                            try {
                                WorkspaceArea[] workspaceAreas = this.getServerManager().getWorkspaceAreas(workspace);
                                if (workspaceAreas.length != currentChildCount) {
                                    this.getViewer().setChildCount((Object)workspace, workspaceAreas.length);
                                }
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }

                    @Override
                    Display getDisplay() {
                        return this.getViewer().getTree().getDisplay();
                    }
                };
                this.run(op, true);
            }
            catch (Exception exception) {
                this.addOfflineServer(workspace.getServer());
            }
        }
    }

    public void updateElement(Object parent, int index) {
        ModeShapeWorkspace workspace;
        this.getServerManager();
        if (parent == this.serverManager) {
            ModeShapeServer server = new ArrayList<ModeShapeServer>(this.serverManager.getServers()).get(index);
            this.viewer.replace((Object)this.serverManager, index, (Object)server);
            this.viewer.setHasChildren((Object)server, true);
        } else if (parent instanceof ModeShapeServer) {
            ModeShapeServer server = (ModeShapeServer)parent;
            if (this.isOkToConnect(server)) {
                try {
                    ModeShapeRepository repository = new ArrayList<ModeShapeRepository>(this.serverManager.getRepositories(server)).get(index);
                    this.viewer.replace((Object)server, index, (Object)repository);
                    this.viewer.setHasChildren((Object)repository, true);
                }
                catch (Exception exception) {
                    this.addOfflineServer(server);
                }
            }
        } else if (parent instanceof ModeShapeRepository) {
            ModeShapeRepository repository = (ModeShapeRepository)parent;
            if (this.isOkToConnect(repository.getServer())) {
                try {
                    ModeShapeWorkspace workspace2 = new ArrayList<ModeShapeWorkspace>(this.serverManager.getWorkspaces(repository)).get(index);
                    this.viewer.replace((Object)repository, index, (Object)workspace2);
                    this.viewer.setHasChildren((Object)workspace2, true);
                }
                catch (Exception exception) {
                    this.addOfflineServer(repository.getServer());
                }
            }
        } else if (parent instanceof ModeShapeWorkspace && this.isOkToConnect((workspace = (ModeShapeWorkspace)parent).getServer())) {
            try {
                WorkspaceArea workspaceArea = Arrays.asList(this.serverManager.getWorkspaceAreas(workspace)).get(index);
                this.viewer.replace((Object)workspace, index, (Object)workspaceArea);
            }
            catch (Exception exception) {
                this.addOfflineServer(workspace.getServer());
            }
        }
    }

    class NewPasswordDialog
    extends MessageDialog {
        private Button btnOk;
        private String newPassword;

        public NewPasswordDialog(Shell parentShell) {
            super(parentShell, RestClientI18n.runningServerRequestNewPasswordDialogTitle, null, RestClientI18n.runningServerRequestNewPasswordDialogMsg, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.newPassword = "";
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            Button btn = super.createButton(parent, id, label, defaultButton);
            if (id == 0) {
                this.btnOk = btn;
                btn.setEnabled(false);
            }
            return btn;
        }

        protected Control createCustomArea(Composite parent) {
            Composite panel = new Composite(parent, 0);
            panel.setLayout((Layout)new GridLayout(2, false));
            panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label lbl = new Label(panel, 0);
            lbl.setText(RestClientI18n.serverPagePasswordLabel);
            Text txt = new Text(panel, 2048);
            txt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            txt.setToolTipText(RestClientI18n.serverPagePasswordToolTip);
            txt.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewPasswordDialog.this.handlePasswordChanged(((Text)e.widget).getText());
                }
            });
            return super.createCustomArea(parent);
        }

        public String getNewPassword() {
            return this.newPassword;
        }

        void handlePasswordChanged(String newPassword) {
            boolean enable;
            this.newPassword = newPassword;
            boolean bl = enable = this.newPassword != null && !this.newPassword.isEmpty();
            if (this.btnOk.getEnabled() != enable) {
                this.btnOk.setEnabled(enable);
            }
        }
    }

    abstract class ServerOperation
    implements IRunnableWithProgress {
        private ModeShapeServer updatedServer;
        private final ModeShapeServer server;

        public ServerOperation(ModeShapeServer server) {
            this.server = server;
        }

        abstract void doRun(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

        abstract Display getDisplay();

        ModeShapeServer getServer() {
            return this.server;
        }

        ModeShapeServer getUpdatedServer() {
            return this.updatedServer;
        }

        public final void run(final IProgressMonitor monitor) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ServerOperation.this.doRun(monitor);
                    }
                    catch (InvocationTargetException e) {
                        if (ServerOperation.this.getUpdatedServer() == null) {
                            ModeShapeContentProvider.this.addOfflineServer(ServerOperation.this.getServer());
                        } else {
                            ModeShapeContentProvider.this.addOfflineServer(ServerOperation.this.getUpdatedServer());
                        }
                        Status error = new Status(4, "org.jboss.tools.modeshape.rest", RestClientI18n.runningServerRequestErrorMsg, e.getCause());
                        ErrorDialog.openError((Shell)ModeShapeContentProvider.this.getShell(), (String)RestClientI18n.runningServerRequestErrorDialogTitle, (String)RestClientI18n.runningServerRequestErrorDialogMsg, (IStatus)error);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
        }

        void setUpdatedServer(ModeShapeServer updatedServer) {
            this.updatedServer = updatedServer;
        }
    }
}

