/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.domain.WorkspaceArea;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.rest.client.Status;

public final class DeletePublishAreaAction
extends BaseSelectionListenerAction {
    private final ServerManager serverManager;
    private WorkspaceArea publishArea;
    private final Shell shell;
    private final TreeViewer viewer;

    public DeletePublishAreaAction(Shell shell, ServerManager serverManager, TreeViewer viewer) {
        super(RestClientI18n.unmarkPublishActionText);
        CheckArg.isNotNull((Object)serverManager, (String)"serverManager");
        this.setToolTipText(RestClientI18n.unmarkPublishAreaActionToolTip);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/views/delete_publish_area.png"));
        this.setEnabled(false);
        this.shell = shell;
        this.serverManager = serverManager;
        this.viewer = viewer;
    }

    public void run() {
        if (MessageDialog.openConfirm((Shell)this.shell, (String)RestClientI18n.deletePublishAreaDialogTitle, (String)NLS.bind((String)RestClientI18n.deletePublishAreaDialogMessage, (Object)this.publishArea.getName(), (Object)this.publishArea.getWorkspace().getName()))) {
            boolean errorOccurred = false;
            try {
                Status status = this.serverManager.unmarkAsPublishArea(this.publishArea);
                if (status.isOk()) {
                    if (this.viewer != null) {
                        this.viewer.refresh((Object)this.publishArea.getWorkspace());
                    }
                } else {
                    Activator.getDefault().log(status);
                    if (status.isError()) {
                        errorOccurred = true;
                    }
                }
            }
            catch (Exception e) {
                Activator.getDefault().log(new Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.errorUnmarkingPublishArea, (Object)this.publishArea.getWorkspace().getName(), (Object)this.publishArea.getName()), (Throwable)e));
                errorOccurred = true;
            }
            if (errorOccurred) {
                MessageDialog.openError((Shell)this.shell, (String)RestClientI18n.errorDialogTitle, (String)RestClientI18n.unmarkPublishAreaDialogErrorsOccurredMsg);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.publishArea = null;
        if (selection.isEmpty() || selection.size() > 1) {
            return false;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof WorkspaceArea) {
            this.publishArea = (WorkspaceArea)obj;
            return true;
        }
        return false;
    }
}

