/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.modeshape.rest.IUiConstants;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.Utils;
import org.jboss.tools.modeshape.rest.domain.ModeShapeDomainObject;
import org.jboss.tools.modeshape.rest.domain.ModeShapeRepository;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;
import org.jboss.tools.modeshape.rest.domain.ModeShapeWorkspace;
import org.jboss.tools.modeshape.rest.domain.WorkspaceArea;
import org.modeshape.common.util.CheckArg;
import org.modeshape.web.jcr.rest.client.Status;
import org.osgi.framework.BundleContext;

public final class Activator
extends AbstractUIPlugin
implements IUiConstants {
    private static Activator plugin;
    private Image missingImage;
    private ServerManager serverMgr;

    public static Activator getDefault() {
        return plugin;
    }

    private ImageDescriptor createImageDescriptor(String key) {
        CheckArg.isNotNull((Object)key, (String)"key");
        try {
            URL url = new URL(String.valueOf(this.getBundle().getEntry("/").toString()) + key);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            this.log(new org.modeshape.web.jcr.rest.client.Status(Status.Severity.ERROR, NLS.bind((String)RestClientI18n.missingImage, (Object)key), (Throwable)e));
            return null;
        }
    }

    private Image getMissingImage() {
        if (this.missingImage == null) {
            this.missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.missingImage;
    }

    public Image getSharedImage(String imageId) {
        CheckArg.isNotNull((Object)imageId, (String)"imageId");
        Image result = PlatformUI.getWorkbench().getSharedImages().getImage(imageId);
        return result == null ? this.getMissingImage() : result;
    }

    public ImageDescriptor getSharedImageDescriptor(String imageId) {
        CheckArg.isNotNull((Object)imageId, (String)"imageId");
        ImageDescriptor result = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageId);
        if (result != null) {
            return result;
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public Image getImage(Object object) {
        String key = null;
        if (object instanceof ModeShapeWorkspace) {
            key = "icons/objects/workspace.gif";
        } else if (object instanceof ModeShapeRepository) {
            key = "icons/objects/repository.gif";
        } else if (object instanceof ModeShapeServer) {
            key = "icons/objects/server.gif";
        } else if (object instanceof WorkspaceArea) {
            key = "icons/objects/publish_area.png";
        }
        if (object instanceof String) {
            key = (String)object;
        }
        if (key != null) {
            ImageRegistry registry = this.getImageRegistry();
            Image image = registry.get(key);
            if (image == null) {
                ImageDescriptor descriptor = this.createImageDescriptor(key);
                if (descriptor == null) {
                    return this.getMissingImage();
                }
                image = descriptor.createImage();
                registry.put(key, image);
            }
            return image;
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        String key = null;
        if (object instanceof ModeShapeWorkspace) {
            key = "icons/objects/workspace.gif";
        } else if (object instanceof ModeShapeRepository) {
            key = "icons/objects/repository.gif";
        } else if (object instanceof ModeShapeServer) {
            key = "icons/objects/server.gif";
        } else if (object instanceof ModeShapeDomainObject) {
            assert (false);
        } else if (object instanceof String) {
            key = (String)object;
        }
        if (key != null) {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.jboss.tools.modeshape.rest", (String)((String)object));
            return descriptor == null ? ImageDescriptor.getMissingImageDescriptor() : descriptor;
        }
        return null;
    }

    public ServerManager getServerManager() {
        return this.serverMgr;
    }

    public void log(org.modeshape.web.jcr.rest.client.Status status) {
        CheckArg.isNotNull((Object)status, (String)"status");
        Status eclipseStatus = new Status(Utils.convertSeverity(status.getSeverity()), "org.jboss.tools.modeshape.rest", status.getMessage(), status.getException());
        this.getLog().log((IStatus)eclipseStatus);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.serverMgr = new ServerManager(this.getStateLocation().toFile().getAbsolutePath());
        org.modeshape.web.jcr.rest.client.Status status = this.serverMgr.restoreState();
        if (!status.isOk()) {
            this.log(status);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.missingImage != null) {
            this.missingImage.dispose();
        }
        if (this.serverMgr != null) {
            org.modeshape.web.jcr.rest.client.Status status = this.serverMgr.saveState();
            if (!status.isOk()) {
                this.log(status);
            }
            this.serverMgr = null;
        }
        super.stop(context);
        plugin = null;
    }
}

