/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.zip.test;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.tools.common.zip.DefaultZipEntryVisitor;
import org.jboss.tools.common.zip.IZipEntryVisitor;
import org.jboss.tools.common.zip.UnzipOperation;
import org.jboss.tools.common.zip.ZipArchive;
import org.jboss.tools.common.zip.test.AbstractZipTestCase;

public class ZipArchiveTest
extends AbstractZipTestCase {
    public void testZipArchiveString() {
        ZipArchive archive = new ZipArchive(this.getZip().getAbsolutePath());
        ZipArchiveTest.assertEquals((String)this.getZip().getAbsolutePath(), (String)archive.getAbsolutePath());
    }

    public void testZipArchiveFile() {
        ZipArchive archive = new ZipArchive(this.getZip());
        ZipArchiveTest.assertEquals((String)this.getZip().getAbsolutePath(), (String)archive.getAbsolutePath());
    }

    public void testAcceptVisitor() throws IOException {
        ZipArchive archive = new ZipArchive(this.getZip());
        ZipVisitor visitor = new ZipVisitor();
        archive.acceptVisitor((IZipEntryVisitor)new UnzipOperation.FilteredZipEntryVisitor("META-INF.*", (IZipEntryVisitor)visitor));
        ZipArchiveTest.assertTrue((visitor.isDirVisited() && visitor.isFileVisited() ? 1 : 0) != 0);
        ZipArchive.acceptVisitor((ZipFile)new ZipFileWrapper(this.getZip()), (IZipEntryVisitor)visitor);
    }

    public class ZipFileWrapper
    extends ZipFile {
        public ZipFileWrapper(File file) throws ZipException, IOException {
            super(file);
        }

        @Override
        public void close() throws IOException {
            super.close();
            throw new IOException("Fake error");
        }
    }

    public class ZipVisitor
    extends DefaultZipEntryVisitor {
        boolean dirVisited = false;
        boolean fileVisited = false;

        public boolean isDirVisited() {
            return this.dirVisited;
        }

        public boolean isFileVisited() {
            return this.fileVisited;
        }

        public void visiteDirectoryEntry(ZipFile zipFIle, ZipEntry dir) throws IOException {
            super.visiteDirectoryEntry(zipFIle, dir);
            this.dirVisited = true;
        }

        public void visiteFileEntry(ZipFile zipFile, ZipEntry file) throws IOException {
            super.visiteFileEntry(zipFile, file);
            this.fileVisited = true;
        }
    }
}

