/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.table;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiConstants;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiPlugin;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizard;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.table.LdapConnectionContentProvider;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.table.LdapConnectionLabelProvider;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.UiPlugin;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;

public class LdapTablesPage
extends WizardPage
implements IChangeListener,
ModelGeneratorLdapUiConstants,
ModelGeneratorLdapUiConstants.Images,
ModelGeneratorLdapUiConstants.HelpContexts {
    private static final int[] SPLITTER_WEIGHTS = new int[]{30, 70};
    private final LdapImportWizardManager importManager;
    private IContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private SashForm splitter;
    private ViewForm objsView;
    private TreeViewer treeViewer;
    private Text tableNameText;
    private Text tableSourceNameText;
    private Text tableSourceSuffixText;
    private boolean synchronising;

    public LdapTablesPage(LdapImportWizardManager theImportManager) {
        super(LdapTablesPage.class.getSimpleName(), LdapTablesPage.getString("title", new Object[0]), null);
        this.importManager = theImportManager;
        this.setDescription(LdapTablesPage.getString("description", new Object[0]));
        this.setImageDescriptor(LdapImportWizard.BANNER);
        this.importManager.addChangeListener(this);
        this.contentProvider = new LdapConnectionContentProvider(this.importManager);
        this.labelProvider = new LdapConnectionLabelProvider(this.importManager);
    }

    private static String getString(String key, Object ... properties) {
        return ModelGeneratorLdapUiConstants.UTIL.getString(String.valueOf(LdapTablesPage.class.getSimpleName()) + "_" + key, properties);
    }

    private boolean isSynchronising() {
        return this.synchronising;
    }

    private void refresh() {
        this.importManager.clearEntries();
        this.treeViewer.refresh();
    }

    private void nodeSelected(ILdapEntryNode node) {
        if (node.isRoot()) {
            this.tableNameText.setText("");
            this.tableNameText.setEditable(false);
            this.tableSourceNameText.setText("");
            this.tableSourceSuffixText.setText("");
            this.tableSourceSuffixText.setEditable(false);
        } else {
            this.tableNameText.setText(node.getLabel());
            this.tableNameText.setEditable(true);
            this.tableSourceNameText.setText(node.getSourceName());
            this.tableSourceSuffixText.setText(node.getSourceNameSuffix());
            this.tableSourceSuffixText.setEditable(true);
        }
    }

    private void treeItemChecked(TreeItem item, boolean selected) {
        if (item == null) {
            return;
        }
        final ILdapEntryNode entryNode = (ILdapEntryNode)item.getData();
        if (entryNode.isRoot()) {
            return;
        }
        if (selected) {
            this.importManager.addEntry(entryNode);
        } else {
            this.importManager.removeEntry(entryNode);
        }
        this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                LdapTablesPage.this.treeViewer.update((Object)entryNode, null);
            }
        });
    }

    private void deselectAllButtonSelected() {
        ArrayList<ILdapEntryNode> oldSelection = new ArrayList<ILdapEntryNode>();
        oldSelection.addAll(this.importManager.getSelectedEntries());
        for (ILdapEntryNode entryNode : oldSelection) {
            TreeItem treeItem = WidgetUtil.findTreeItem((Object)entryNode, (TreeViewer)this.treeViewer);
            if (treeItem == null) continue;
            this.treeItemChecked(treeItem, false);
        }
    }

    public void createControl(Composite parent) {
        Composite pg = new Composite(parent, 0){

            public Point computeSize(int widthHint, int heightHint, boolean changed) {
                Point size = super.computeSize(widthHint, heightHint, changed);
                size.x = 800;
                return size;
            }
        };
        GridLayoutFactory.fillDefaults().applyTo(pg);
        this.setControl((Control)pg);
        this.splitter = WidgetFactory.createSplitter((Composite)pg);
        this.objsView = new ViewForm((Composite)this.splitter, 2048);
        CLabel ldapLabel = new CLabel((Composite)this.objsView, 0);
        ldapLabel.setImage(ModelGeneratorLdapUiPlugin.getDefault().getImage("icons/full/ctool16/ldap_banner_icon.png"));
        GridDataFactory.swtDefaults().applyTo((Control)ldapLabel);
        this.objsView.setTopLeft((Control)ldapLabel);
        ToolBar bar = new ToolBar((Composite)this.objsView, 0x800000);
        ToolBarManager mgr = new ToolBarManager(bar);
        Action action = new Action(){

            public String getToolTipText() {
                return LdapTablesPage.getString("refreshTooltip", new Object[0]);
            }

            public ImageDescriptor getImageDescriptor() {
                return UiPlugin.getDefault().getImageDescriptor("icons/full/elcl16/refresh_nav.gif");
            }

            public void run() {
                LdapTablesPage.this.refresh();
            }
        };
        mgr.add((IAction)action);
        mgr.update(true);
        this.objsView.setTopRight((Control)bar);
        this.treeViewer = new TreeViewer((Composite)this.objsView, 2052);
        this.treeViewer.setUseHashlookup(true);
        Tree tree = this.treeViewer.getTree();
        this.objsView.setContent((Control)tree);
        this.treeViewer.setContentProvider(this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)LdapTablesPage.this.treeViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Object node = selection.getFirstElement();
                LdapTablesPage.this.treeViewer.setExpandedState(node, !LdapTablesPage.this.treeViewer.getExpandedState(node));
            }

            public void mouseDown(MouseEvent e) {
                TreeItem[] selectedItems = LdapTablesPage.this.treeViewer.getTree().getSelection();
                if (selectedItems.length == 0) {
                    return;
                }
                TreeItem[] treeItemArray = selectedItems;
                int n = selectedItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    if (treeItem.getImage() != null) {
                        ILdapEntryNode entryNode = (ILdapEntryNode)treeItem.getData();
                        Rectangle imageRec = treeItem.getImageBounds(0);
                        if (imageRec.contains(e.x, e.y)) {
                            LdapTablesPage.this.treeItemChecked(treeItem, !LdapTablesPage.this.importManager.entrySelected(entryNode));
                        }
                        LdapTablesPage.this.nodeSelected(entryNode);
                    }
                    ++n2;
                }
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
            }

            public void treeExpanded(TreeExpansionEvent e) {
                Object element = e.getElement();
                TreeItem treeItem = WidgetUtil.findTreeItem((Object)element, (TreeViewer)LdapTablesPage.this.treeViewer);
                if (treeItem == null) {
                    return;
                }
                ILdapEntryNode entryNode = (ILdapEntryNode)treeItem.getData();
                LdapTablesPage.this.treeItemChecked(treeItem, LdapTablesPage.this.importManager.entrySelected(entryNode));
            }
        });
        ViewForm detailsView = new ViewForm((Composite)this.splitter, 2048);
        Group detailsGroup = WidgetFactory.createGroup((Composite)detailsView, (String)LdapTablesPage.getString("tableAttributesTitle", new Object[0]), (int)0, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo((Composite)detailsGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)detailsGroup);
        detailsView.setContent((Control)detailsGroup);
        Label tableNameLabel = new Label((Composite)detailsGroup, 0);
        tableNameLabel.setText(LdapTablesPage.getString("detailTableNameLabel", new Object[0]));
        this.tableNameText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.tableNameText);
        this.tableNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LdapTablesPage.this.isSynchronising()) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)LdapTablesPage.this.treeViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                ILdapEntryNode node = (ILdapEntryNode)selection.getFirstElement();
                String tblNameText = LdapTablesPage.this.tableNameText.getText();
                if (!tblNameText.equals(node.getLabel())) {
                    node.setLabel(tblNameText);
                    LdapTablesPage.this.notifyChanged();
                }
            }
        });
        Label tableSourceNameLabel = new Label((Composite)detailsGroup, 0);
        tableSourceNameLabel.setText(LdapTablesPage.getString("detailTableSourceNameLabel", new Object[0]));
        this.tableSourceNameText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.tableSourceNameText);
        this.tableSourceNameText.setForeground(this.tableSourceNameText.getDisplay().getSystemColor(10));
        this.tableSourceNameText.setBackground(this.tableSourceNameText.getDisplay().getSystemColor(19));
        this.tableSourceNameText.setEditable(false);
        Label tableSourceSuffixLabel = new Label((Composite)detailsGroup, 0);
        tableSourceSuffixLabel.setText(LdapTablesPage.getString("detailTableSourceSuffixLabel", new Object[0]));
        tableSourceSuffixLabel.setToolTipText(LdapTablesPage.getString("detailTableSourceSuffixToolTip", new Object[0]));
        this.tableSourceSuffixText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.tableSourceSuffixText);
        this.tableSourceSuffixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LdapTablesPage.this.isSynchronising()) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)LdapTablesPage.this.treeViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                ILdapEntryNode node = (ILdapEntryNode)selection.getFirstElement();
                String tableSuffixText = LdapTablesPage.this.tableSourceSuffixText.getText();
                if (!tableSuffixText.equals(node.getLabel())) {
                    node.setSourceNameSuffix(tableSuffixText);
                    LdapTablesPage.this.notifyChanged();
                }
            }
        });
        this.splitter.setWeights(SPLITTER_WEIGHTS);
        Button deselectAllButton = WidgetFactory.createButton((Composite)pg, (String)InternalUiConstants.Widgets.DESELECT_ALL_BUTTON);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LdapTablesPage.this.deselectAllButtonSelected();
            }
        });
    }

    private void setPageStatus() {
        if (this.importManager.hasSelectedEntries()) {
            WizardUtil.setPageComplete((WizardPage)this, (String)LdapTablesPage.getString("noSourceModelTables", new Object[0]), (int)3);
            return;
        }
        for (ILdapEntryNode entry : this.importManager.getSelectedEntries()) {
            String suffix = entry.getSourceNameSuffix();
            if (suffix.length() == 0) continue;
            int qmarks = 0;
            int i = 0;
            while (i < suffix.length()) {
                char c = suffix.charAt(i);
                if (c == '?') {
                    ++qmarks;
                }
                ++i;
            }
            if (qmarks == 2) continue;
            WizardUtil.setPageComplete((WizardPage)this, (String)LdapTablesPage.getString("invalidSourceNameSuffix", new Object[0]), (int)3);
            return;
        }
        WizardUtil.setPageComplete((WizardPage)this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        if (this.importManager.getConnectionProfile() == null) {
            return;
        }
        if (this.treeViewer.getInput() == null) {
            this.treeViewer.setInput((Object)this.importManager);
        }
        this.setPageStatus();
    }

    public void stateChanged(IChangeNotifier theSource) {
        if (this.treeViewer != null && this.treeViewer.getInput() != null) {
            this.treeViewer.refresh();
        }
        this.setPageStatus();
    }

    private void notifyChanged() {
        this.importManager.notifyChanged();
    }
}

