/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.definition;

import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoHelper;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiConstants;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.MetamodelSelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public class SourceModelPanel
implements IChangeListener,
ModelGeneratorLdapUiConstants {
    private Text sourceModelFileText;
    private Text sourceModelContainerText;
    private IConnectionInfoHelper connectionInfoHelper;
    private final LdapImportWizardManager importManager;
    private final ModelWorkspaceManager modelWorkspaceManager = ModelWorkspaceManager.getModelWorkspaceManager();
    private boolean refreshing = false;

    public SourceModelPanel(Composite parent, LdapImportWizardManager importManager) {
        this.importManager = importManager;
        this.importManager.addChangeListener(this);
        this.init(parent);
    }

    private String getString(String key, Object ... properties) {
        return ModelGeneratorLdapUiConstants.UTIL.getString(String.valueOf(this.getClass().getSimpleName()) + "_" + key, properties);
    }

    private void init(Composite parent) {
        this.connectionInfoHelper = new ConnectionInfoHelper();
        Group group = WidgetFactory.createGroup((Composite)parent, (String)this.getString("sourceModelDefinition", new Object[0]), (int)768, (int)1, (int)3);
        Label locationLabel = new Label((Composite)group, 0);
        locationLabel.setText(this.getString("location", new Object[0]));
        this.sourceModelContainerText = new Text((Composite)group, 2052);
        GridData gridData = new GridData(768);
        this.sourceModelContainerText.setLayoutData((Object)gridData);
        WidgetUtil.colorizeWidget((Control)this.sourceModelContainerText, (int)1, (boolean)true);
        this.sourceModelContainerText.setEditable(false);
        Button browseButton = new Button((Composite)group, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(this.getString("browseElipsis", new Object[0]));
        browseButton.setToolTipText(this.getString("browseToSelectModelsLocation", this.getString("source_lower", new Object[0])));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SourceModelPanel.this.handleSourceModelLocationBrowse();
            }
        });
        Label fileLabel = new Label((Composite)group, 0);
        fileLabel.setText(this.getString("name", new Object[0]));
        fileLabel.setToolTipText(this.getString("sourceNameTooltip", new Object[0]));
        this.sourceModelFileText = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.sourceModelFileText.setLayoutData((Object)gridData);
        this.sourceModelFileText.setToolTipText(this.getString("sourceNameTooltip", new Object[0]));
        WidgetUtil.colorizeWidget((Control)this.sourceModelFileText, (int)1, (boolean)false);
        this.sourceModelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SourceModelPanel.this.handleSourceModelTextChanged();
            }
        });
        browseButton = new Button((Composite)group, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(this.getString("browseElipsis", new Object[0]));
        browseButton.setToolTipText(this.getString("browseToSelect_0_Model", this.getString("source_lower", new Object[0])));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SourceModelPanel.this.handleSourceModelBrowse();
            }
        });
    }

    public void refresh() {
        this.refreshing = true;
        this.refreshUiFromManager();
        this.refreshing = false;
    }

    private void handleSourceModelLocationBrowse() {
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)ModelerCore.getWorkspace().getRoot(), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.sourceModelContainerText != null) {
            this.importManager.setSourceModelLocation(folder);
            this.sourceModelContainerText.setText(folder.getFullPath().makeRelative().toString());
        }
        this.notifyChanged();
    }

    private void handleSourceModelBrowse() {
        IFile modelFile = MetamodelSelectionUtilities.selectSourceModelInWorkspace();
        if (modelFile != null) {
            IContainer folder = modelFile.getParent();
            String modelName = modelFile.getFullPath().lastSegment();
            this.importManager.setSourceModelExists(true);
            this.importManager.setSourceModelLocation(folder);
            this.importManager.setSourceModelName(modelName);
            this.sourceModelContainerText.setText(folder.getFullPath().makeRelative().toString());
            this.sourceModelFileText.setText(modelName);
        }
        this.notifyChanged();
    }

    private void handleSourceModelTextChanged() {
        if (this.refreshing) {
            return;
        }
        String newName = "";
        if (this.sourceModelFileText.getText() != null) {
            if (this.sourceModelFileText.getText().length() == 0) {
                this.importManager.setSourceModelName(newName);
                this.importManager.setSourceModelExists(false);
            } else {
                newName = this.sourceModelFileText.getText();
                this.importManager.setSourceModelName(newName);
                this.importManager.setSourceModelExists(this.sourceModelExists());
            }
        }
        this.notifyChanged();
    }

    public boolean sourceModelExists() {
        if (this.importManager.getSourceModelLocation() == null) {
            return false;
        }
        return this.modelWorkspaceManager.modelExists(this.importManager.getSourceModelLocation().getFullPath().toOSString(), this.sourceModelFileText.getText());
    }

    private void refreshUiFromManager() {
        this.refreshing = true;
        IContainer sourceLocation = this.importManager.getSourceModelLocation();
        if (sourceLocation != null) {
            this.sourceModelContainerText.setText(sourceLocation.getFullPath().makeRelative().toString());
        }
        if (this.importManager.getSourceModelName() != null && !this.sourceModelFileText.getText().equals(this.importManager.getSourceModelName())) {
            this.sourceModelFileText.setText(this.importManager.getSourceModelName());
        }
        this.updateDesignerProperties();
        this.refreshing = false;
    }

    public boolean sourceModelHasConnectionProfile() {
        if (!this.sourceModelExists()) {
            return false;
        }
        try {
            IFile sourceModel = ModelUtilities.getModelFile((String)this.importManager.getSourceModelLocation().getFullPath().toOSString(), (String)this.sourceModelFileText.getText());
            ModelResource smr = ModelUtilities.getModelResourceForIFile((IFile)sourceModel, (boolean)false);
            if (smr != null) {
                IConnectionProfile profile = this.connectionInfoHelper.getConnectionProfile(smr);
                return profile != null && this.importManager.getConnectionProfile() != null;
            }
        }
        catch (ModelWorkspaceException ex) {
            ModelGeneratorLdapUiConstants.UTIL.log(4, (Throwable)ex, this.getString("errorDeterminingSourceModelHasProfile", new Object[0]));
        }
        return false;
    }

    public boolean sourceModelHasSameConnectionProfile() {
        block5: {
            IConnectionProfile profile;
            block6: {
                if (!this.sourceModelExists()) {
                    return false;
                }
                IFile sourceModel = ModelUtilities.getModelFile((String)this.importManager.getSourceModelLocation().getFullPath().toOSString(), (String)this.sourceModelFileText.getText());
                ModelResource smr = ModelUtilities.getModelResourceForIFile((IFile)sourceModel, (boolean)false);
                if (smr == null) break block5;
                profile = this.connectionInfoHelper.getConnectionProfile(smr);
                if (profile != null && this.importManager.getConnectionProfile() != null) break block6;
                return false;
            }
            try {
                if (profile.getName().equalsIgnoreCase(this.importManager.getConnectionProfile().getName())) {
                    return true;
                }
            }
            catch (ModelWorkspaceException ex) {
                ModelGeneratorLdapUiConstants.UTIL.log(4, (Throwable)ex, this.getString("errorDeterminingSourceModelHasMatchingProfile", new Object[0]));
            }
        }
        return false;
    }

    private void updateDesignerProperties() {
        Properties designerProperties = this.importManager.getDesignerProperties();
        if (designerProperties != null) {
            if (this.sourceModelFileText.getText() != null) {
                DesignerPropertiesUtil.setSourceModelName((Properties)designerProperties, (String)this.sourceModelFileText.getText());
            }
            if (this.importManager.getSourceModelLocation() != null) {
                DesignerPropertiesUtil.setProjectName((Properties)designerProperties, (String)this.importManager.getSourceModelLocation().getProject().getName());
            }
        }
    }

    public void stateChanged(IChangeNotifier theSource) {
        this.refreshUiFromManager();
    }

    private void notifyChanged() {
        this.importManager.notifyChanged();
    }
}

