/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.columns;

import java.util.Collection;
import java.util.HashMap;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiConstants;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.AbstractLdapContentProvider;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;

public class LdapEntryContentProvider
extends AbstractLdapContentProvider {
    public LdapEntryContentProvider(LdapImportWizardManager manager) {
        super(manager);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(this.getImportManager());
    }

    private String getObjectClassFilter(ILdapEntryNode contextNode) {
        String[] nameInSourceArray = contextNode.getSourceNameSuffix().split("\\?");
        String objectClass = null;
        if (nameInSourceArray.length >= 3) {
            objectClass = nameInSourceArray[2];
        }
        if (objectClass == null || objectClass.equals("")) {
            return "objectClass=*";
        }
        return "objectClass=" + objectClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<ILdapAttributeNode> findChildAttributes(ILdapEntryNode contextNode) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        searchControls.setReturningAttributes(null);
        String filter = this.getObjectClassFilter(contextNode);
        NamingEnumeration<SearchResult> searchEnumeration = this.getLdapContext().search(contextNode.getSourceName(), filter, searchControls);
        HashMap<Integer, ILdapAttributeNode> childAttributes = new HashMap<Integer, ILdapAttributeNode>();
        while (searchEnumeration != null && searchEnumeration.hasMore()) {
            SearchResult searchResult = searchEnumeration.next();
            Attributes resultAttrs = searchResult.getAttributes();
            if (resultAttrs.size() == 0) continue;
            try {
                NamingEnumeration<? extends Attribute> attrEnum = resultAttrs.getAll();
                while (attrEnum.hasMore()) {
                    NamingEnumeration<?> valuesEnum;
                    Attribute attribute = attrEnum.next();
                    ILdapAttributeNode newAttribute = this.getImportManager().newAttribute(contextNode, attribute);
                    ILdapAttributeNode childAttribute = (ILdapAttributeNode)childAttributes.get(newAttribute.hashCode());
                    if (childAttribute == null) {
                        childAttributes.put(newAttribute.hashCode(), newAttribute);
                        childAttribute = newAttribute;
                    }
                    if ((valuesEnum = attribute.getAll()) == null) {
                        childAttribute.incrementNullValueCount();
                        continue;
                    }
                    while (valuesEnum.hasMore()) {
                        Object value = valuesEnum.next();
                        childAttribute.addValue(value);
                    }
                }
            }
            catch (NamingException ex) {
                ModelGeneratorLdapUiConstants.UTIL.log((Throwable)ex);
            }
        }
        return childAttributes.values();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof LdapImportWizardManager) {
            return this.getImportManager().getSelectedEntries().toArray();
        }
        if (parentElement instanceof ILdapEntryNode) {
            try {
                ILdapEntryNode parentNode = (ILdapEntryNode)parentElement;
                Collection<ILdapAttributeNode> childAttributes = this.findChildAttributes(parentNode);
                return childAttributes.toArray();
            }
            catch (NamingException ex) {
                ModelGeneratorLdapUiConstants.UTIL.log((Throwable)ex);
                return EMPTY_ARRAY;
            }
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof ILdapAttributeNode) {
            return ((ILdapAttributeNode)element).getAssociatedEntry();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof ILdapEntryNode;
    }
}

