/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.columns;

import java.util.ArrayList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiConstants;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiPlugin;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizard;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.columns.LdapEntryContentProvider;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.columns.LdapEntryLabelProvider;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;

public class LdapColumnsPage
extends WizardPage
implements IChangeListener,
ModelGeneratorLdapUiConstants,
ModelGeneratorLdapUiConstants.Images,
ModelGeneratorLdapUiConstants.HelpContexts {
    private static final String NULL_STRING = "";
    private static final int[] SPLITTER_WEIGHTS = new int[]{30, 70};
    private final LdapImportWizardManager importManager;
    private IContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private SashForm splitter;
    private ViewForm objsView;
    private TreeViewer treeViewer;
    private Text columnNameText;
    private Text columnSourceNameText;
    private Text columnDVCountText;
    private Text columnNVCountText;
    private Text columnMaxValueText;
    private boolean synchronising;

    public LdapColumnsPage(LdapImportWizardManager theImportManager) {
        super(LdapColumnsPage.class.getSimpleName(), LdapColumnsPage.getString("title", new Object[0]), null);
        this.importManager = theImportManager;
        this.setDescription(LdapColumnsPage.getString("description", new Object[0]));
        this.setImageDescriptor(LdapImportWizard.BANNER);
        this.importManager.addChangeListener(this);
        this.contentProvider = new LdapEntryContentProvider(this.importManager);
        this.labelProvider = new LdapEntryLabelProvider(this.importManager);
    }

    private static String getString(String key, Object ... properties) {
        return ModelGeneratorLdapUiConstants.UTIL.getString(String.valueOf(LdapColumnsPage.class.getSimpleName()) + "_" + key, properties);
    }

    private boolean isSynchronising() {
        return this.synchronising;
    }

    private void nodeSelected(Object node) {
        if (node instanceof ILdapAttributeNode) {
            ILdapAttributeNode attributeNode = (ILdapAttributeNode)node;
            this.columnNameText.setText(attributeNode.getLabel());
            this.columnNameText.setEditable(true);
            this.columnSourceNameText.setText(attributeNode.getId());
            this.columnDVCountText.setText(Integer.toString(attributeNode.getDistinctValueCount()));
            this.columnNVCountText.setText(Integer.toString(attributeNode.getNullValueCount()));
            this.columnMaxValueText.setText(Integer.toString(attributeNode.getMaximumValueLength()));
        } else {
            this.columnNameText.setText(NULL_STRING);
            this.columnNameText.setEditable(false);
            this.columnSourceNameText.setText(NULL_STRING);
            this.columnDVCountText.setText(NULL_STRING);
            this.columnNVCountText.setText(NULL_STRING);
            this.columnMaxValueText.setText(NULL_STRING);
        }
    }

    private void treeItemChecked(TreeItem item, boolean selected) {
        if (item == null) {
            return;
        }
        if (!(item.getData() instanceof ILdapAttributeNode)) {
            return;
        }
        final ILdapAttributeNode attributeNode = (ILdapAttributeNode)item.getData();
        try {
            if (selected) {
                this.importManager.addAttribute(attributeNode);
            } else {
                this.importManager.removeAttribute(attributeNode);
            }
            this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LdapColumnsPage.this.treeViewer.update((Object)attributeNode, null);
                }
            });
        }
        catch (Exception ex) {
            ModelGeneratorLdapUiConstants.UTIL.log((Throwable)ex);
            WizardUtil.setPageComplete((WizardPage)this, (String)ex.getLocalizedMessage(), (int)3);
        }
    }

    private void deselectAllButtonSelected() {
        ArrayList<ILdapAttributeNode> oldSelection = new ArrayList<ILdapAttributeNode>();
        oldSelection.addAll(this.importManager.getSelectedAttributes());
        for (ILdapAttributeNode attributeNode : oldSelection) {
            TreeItem treeItem = WidgetUtil.findTreeItem((Object)attributeNode, (TreeViewer)this.treeViewer);
            if (treeItem == null) continue;
            this.treeItemChecked(treeItem, false);
        }
    }

    private void setNonEditable(Text control) {
        if (control == null) {
            return;
        }
        Display display = control.getDisplay();
        control.setForeground(display.getSystemColor(10));
        control.setBackground(display.getSystemColor(19));
        control.setEditable(false);
    }

    public void createControl(Composite parent) {
        Composite pg = new Composite(parent, 0){

            public Point computeSize(int widthHint, int heightHint, boolean changed) {
                Point size = super.computeSize(widthHint, heightHint, changed);
                size.x = 800;
                return size;
            }
        };
        GridLayoutFactory.fillDefaults().applyTo(pg);
        this.setControl((Control)pg);
        this.splitter = WidgetFactory.createSplitter((Composite)pg);
        this.objsView = new ViewForm((Composite)this.splitter, 2048);
        CLabel ldapLabel = new CLabel((Composite)this.objsView, 0);
        ldapLabel.setImage(ModelGeneratorLdapUiPlugin.getDefault().getImage("icons/full/ctool16/ldap_banner_icon.png"));
        GridDataFactory.swtDefaults().applyTo((Control)ldapLabel);
        this.objsView.setTopLeft((Control)ldapLabel);
        this.treeViewer = new TreeViewer((Composite)this.objsView, 2052);
        this.treeViewer.setUseHashlookup(true);
        Tree tree = this.treeViewer.getTree();
        this.objsView.setContent((Control)tree);
        this.treeViewer.setContentProvider(this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)LdapColumnsPage.this.treeViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Object node = selection.getFirstElement();
                LdapColumnsPage.this.treeViewer.setExpandedState(node, !LdapColumnsPage.this.treeViewer.getExpandedState(node));
            }

            public void mouseDown(MouseEvent e) {
                TreeItem[] selectedItems = LdapColumnsPage.this.treeViewer.getTree().getSelection();
                if (selectedItems.length == 0) {
                    return;
                }
                TreeItem[] treeItemArray = selectedItems;
                int n = selectedItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    if (treeItem.getImage() != null) {
                        if (treeItem.getData() instanceof ILdapAttributeNode) {
                            ILdapAttributeNode attributeNode = (ILdapAttributeNode)treeItem.getData();
                            Rectangle imageRec = treeItem.getImageBounds(0);
                            if (imageRec.contains(e.x, e.y)) {
                                LdapColumnsPage.this.treeItemChecked(treeItem, !LdapColumnsPage.this.importManager.attributeSelected(attributeNode));
                            }
                        }
                        LdapColumnsPage.this.nodeSelected(treeItem.getData());
                    }
                    ++n2;
                }
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
            }

            public void treeExpanded(TreeExpansionEvent e) {
                Object element = e.getElement();
                TreeItem treeItem = WidgetUtil.findTreeItem((Object)element, (TreeViewer)LdapColumnsPage.this.treeViewer);
                if (treeItem == null) {
                    return;
                }
                if (treeItem.getData() instanceof ILdapEntryNode) {
                    return;
                }
                ILdapAttributeNode attributeNode = (ILdapAttributeNode)treeItem.getData();
                LdapColumnsPage.this.treeItemChecked(treeItem, LdapColumnsPage.this.importManager.attributeSelected(attributeNode));
            }
        });
        ViewForm detailsView = new ViewForm((Composite)this.splitter, 2048);
        Group detailsGroup = WidgetFactory.createGroup((Composite)detailsView, (String)LdapColumnsPage.getString("columnAttributesTitle", new Object[0]), (int)0, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo((Composite)detailsGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)detailsGroup);
        detailsView.setContent((Control)detailsGroup);
        Label columnNameLabel = new Label((Composite)detailsGroup, 0);
        columnNameLabel.setText(LdapColumnsPage.getString("detailColumnNameLabel", new Object[0]));
        this.columnNameText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.columnNameText);
        this.columnNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LdapColumnsPage.this.isSynchronising()) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)LdapColumnsPage.this.treeViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (selection.getFirstElement() instanceof ILdapAttributeNode) {
                    ILdapAttributeNode node = (ILdapAttributeNode)selection.getFirstElement();
                    String colNameText = LdapColumnsPage.this.columnNameText.getText();
                    if (!colNameText.equals(node.getLabel())) {
                        node.setLabel(colNameText);
                        LdapColumnsPage.this.notifyChanged();
                    }
                }
            }
        });
        Label columnSourceNameLabel = new Label((Composite)detailsGroup, 0);
        columnSourceNameLabel.setText(LdapColumnsPage.getString("detailColumnSourceNameLabel", new Object[0]));
        this.columnSourceNameText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.columnSourceNameText);
        this.setNonEditable(this.columnSourceNameText);
        Label columnDVCountLabel = new Label((Composite)detailsGroup, 0);
        columnDVCountLabel.setText(LdapColumnsPage.getString("detailColumnDVCountLabel", new Object[0]));
        this.columnDVCountText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.columnDVCountText);
        this.setNonEditable(this.columnDVCountText);
        Label columnNVCountLabel = new Label((Composite)detailsGroup, 0);
        columnNVCountLabel.setText(LdapColumnsPage.getString("detailColumnNVCountLabel", new Object[0]));
        this.columnNVCountText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.columnNVCountText);
        this.setNonEditable(this.columnNVCountText);
        Label maxValueLabel = new Label((Composite)detailsGroup, 0);
        maxValueLabel.setText(LdapColumnsPage.getString("detailMaxValueLabel", new Object[0]));
        this.columnMaxValueText = new Text((Composite)detailsGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.columnMaxValueText);
        this.setNonEditable(this.columnMaxValueText);
        this.splitter.setWeights(SPLITTER_WEIGHTS);
        Button deselectAllButton = WidgetFactory.createButton((Composite)pg, (String)InternalUiConstants.Widgets.DESELECT_ALL_BUTTON);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LdapColumnsPage.this.deselectAllButtonSelected();
            }
        });
    }

    private void setPageStatus() {
        if (!this.importManager.hasAttributesForEachSelectedEntry()) {
            WizardUtil.setPageComplete((WizardPage)this, (String)LdapColumnsPage.getString("sourceColumnsIncomplete", new Object[0]), (int)3);
            return;
        }
        WizardUtil.setPageComplete((WizardPage)this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        if (this.importManager.getConnectionProfile() == null) {
            return;
        }
        if (this.treeViewer.getInput() == null) {
            this.treeViewer.setInput((Object)this.importManager);
            this.treeViewer.expandToLevel(2);
        }
        this.setPageStatus();
    }

    public void stateChanged(IChangeNotifier theSource) {
        if (this.treeViewer != null && this.treeViewer.getInput() != null) {
            this.treeViewer.refresh(true);
        }
        this.setPageStatus();
    }

    private void notifyChanged() {
        this.importManager.notifyChanged();
    }
}

