/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.directory.SearchResult;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;

public class LdapEntryNode
implements ILdapEntryNode {
    private String label;
    private String sourceNameSuffix = "";
    private final String sourceBaseName;
    private final ILdapEntryNode parent;
    private final boolean relative;
    private final Set<ILdapAttributeNode> attributes = new HashSet<ILdapAttributeNode>();

    public LdapEntryNode(SearchResult searchResult, ILdapEntryNode parent) {
        this.sourceBaseName = searchResult.getName();
        this.parent = parent;
        this.relative = searchResult.isRelative();
        this.setLabel(this.getSourceBaseName());
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isRelative() {
        return this.relative;
    }

    @Override
    public ILdapEntryNode getParent() {
        return this.parent;
    }

    @Override
    public String getSourceBaseName() {
        return this.sourceBaseName;
    }

    @Override
    public String getSourceName() {
        if (this.isRelative()) {
            return String.valueOf(this.getSourceBaseName()) + "," + this.parent.getSourceName();
        }
        return this.getSourceBaseName();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getSourceNameSuffix() {
        return this.sourceNameSuffix;
    }

    @Override
    public void setSourceNameSuffix(String sourceNameSuffix) {
        this.sourceNameSuffix = sourceNameSuffix;
    }

    @Override
    public boolean addAttribute(ILdapAttributeNode attribute) {
        return this.attributes.add(attribute);
    }

    @Override
    public boolean removeAttribute(ILdapAttributeNode attribute) {
        return this.attributes.remove(attribute);
    }

    @Override
    public Collection<ILdapAttributeNode> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.relative ? 1231 : 1237);
        result = 31 * result + (this.sourceBaseName == null ? 0 : this.sourceBaseName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LdapEntryNode other = (LdapEntryNode)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.relative != other.relative) {
            return false;
        }
        return !(this.sourceBaseName == null ? other.sourceBaseName != null : !this.sourceBaseName.equals(other.sourceBaseName));
    }
}

