/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;

public class ConnectionNode
implements ILdapEntryNode {
    private static final String SLASH = "/";
    private String rootDN;
    private String context;

    public ConnectionNode(LdapImportWizardManager manager) {
        IConnectionProfile connectionProfile = manager.getConnectionProfile();
        Properties properties = connectionProfile.getBaseProperties();
        this.rootDN = properties.getProperty("LdapRootDNSuffix");
        this.context = properties.getProperty("LdapUrl");
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public boolean isRelative() {
        return false;
    }

    @Override
    public ILdapEntryNode getParent() {
        return null;
    }

    @Override
    public String getSourceName() {
        return this.rootDN;
    }

    @Override
    public String getSourceBaseName() {
        return this.rootDN;
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.context) + SLASH + this.rootDN;
    }

    @Override
    public void setLabel(String label) {
    }

    @Override
    public String getSourceNameSuffix() {
        return "";
    }

    @Override
    public void setSourceNameSuffix(String tableNameSuffix) {
    }

    @Override
    public boolean addAttribute(ILdapAttributeNode attribute) {
        return false;
    }

    @Override
    public boolean removeAttribute(ILdapAttributeNode attribute) {
        return false;
    }

    @Override
    public Collection<ILdapAttributeNode> getAttributes() {
        return Collections.emptyList();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.rootDN == null ? 0 : this.rootDN.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionNode other = (ConnectionNode)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        return !(this.rootDN == null ? other.rootDN != null : !this.rootDN.equals(other.rootDN));
    }
}

