/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.designer.core.util.KeyInValueHashMap;
import org.teiid.designer.modelgenerator.ldap.RelationalModelBuilder;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiConstants;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.ILdapEntryNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.impl.LdapAttributeNode;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.impl.LdapEntryNode;

public class LdapImportWizardManager
implements IChangeNotifier {
    private String sourceModelName;
    private boolean sourceModelExists;
    private IContainer sourceModelLocation;
    private IConnectionProfile connectionProfile;
    private Properties designerProperties;
    private Collection<IChangeListener> listeners;
    private KeyInValueHashMap<Integer, ILdapEntryNode> ldapEntryNodes = new KeyInValueHashMap((KeyInValueHashMap.KeyFromValueAdapter)new LdapEntryKeyAdapter());

    public LdapImportWizardManager() {
        this.listeners = new ArrayList<IChangeListener>(5);
    }

    private static String getString(String key, Object ... properties) {
        return ModelGeneratorLdapUiConstants.UTIL.getString(String.valueOf(LdapImportWizardManager.class.getSimpleName()) + "_" + key, properties);
    }

    public IConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    public void setConnectionProfile(IConnectionProfile connectionProfile) {
        if (this.connectionProfile == connectionProfile) {
            return;
        }
        this.connectionProfile = connectionProfile;
        this.notifyChanged();
    }

    public String getSourceModelName() {
        return this.sourceModelName;
    }

    public void setSourceModelName(String sourceModelName) {
        if (this.sourceModelName != null && this.sourceModelName.equals(sourceModelName)) {
            return;
        }
        this.sourceModelName = sourceModelName;
        this.notifyChanged();
    }

    public IContainer getSourceModelLocation() {
        return this.sourceModelLocation;
    }

    public void setSourceModelLocation(IContainer sourceModelLocation) {
        if (this.sourceModelLocation != null && this.sourceModelLocation.equals((Object)sourceModelLocation)) {
            return;
        }
        this.sourceModelLocation = sourceModelLocation;
        this.notifyChanged();
    }

    public void setSourceModelExists(boolean sourceModelExists) {
        if (this.sourceModelExists == sourceModelExists) {
            return;
        }
        this.sourceModelExists = sourceModelExists;
        this.notifyChanged();
    }

    public boolean sourceModelExists() {
        return this.sourceModelExists;
    }

    public ILdapEntryNode newEntry(SearchResult searchResult, ILdapEntryNode contextNode) {
        LdapEntryNode newNode = new LdapEntryNode(searchResult, contextNode);
        ILdapEntryNode currNode = (ILdapEntryNode)this.ldapEntryNodes.get((Object)((Object)newNode).hashCode());
        if (currNode != null) {
            return currNode;
        }
        return newNode;
    }

    public void addEntry(ILdapEntryNode entryNode) {
        if (this.ldapEntryNodes.containsKey((Object)entryNode.hashCode())) {
            return;
        }
        this.ldapEntryNodes.add((Object)entryNode);
        this.notifyChanged();
    }

    public void removeEntry(ILdapEntryNode entryNode) {
        if (this.ldapEntryNodes.remove((Object)entryNode) != null) {
            this.notifyChanged();
        }
    }

    public boolean entrySelected(ILdapEntryNode entryNode) {
        return this.ldapEntryNodes.containsKey((Object)entryNode.hashCode());
    }

    public boolean hasSelectedEntries() {
        return this.ldapEntryNodes.isEmpty();
    }

    public Collection<ILdapEntryNode> getSelectedEntries() {
        return Collections.unmodifiableCollection(this.ldapEntryNodes.values());
    }

    public ILdapAttributeNode newAttribute(ILdapEntryNode contextNode, Attribute attribute) {
        Collection<ILdapAttributeNode> attributeNodes;
        LdapAttributeNode newAttributeNode = new LdapAttributeNode(contextNode, attribute);
        ILdapEntryNode entryNode = (ILdapEntryNode)this.ldapEntryNodes.get((Object)contextNode.hashCode());
        if (entryNode == null) {
            entryNode = contextNode;
        }
        if ((attributeNodes = entryNode.getAttributes()).contains(newAttributeNode)) {
            for (ILdapAttributeNode attributeNode : attributeNodes) {
                if (!attributeNode.equals(newAttributeNode)) continue;
                return attributeNode;
            }
        }
        return newAttributeNode;
    }

    public void addAttribute(ILdapAttributeNode attribute) throws Exception {
        ILdapEntryNode associatedEntry = attribute.getAssociatedEntry();
        if ((associatedEntry = (ILdapEntryNode)this.ldapEntryNodes.get((Object)associatedEntry.hashCode())) == null) {
            throw new Exception(LdapImportWizardManager.getString("noEntryForAttribute", new Object[0]));
        }
        associatedEntry.addAttribute(attribute);
        this.notifyChanged();
    }

    public void removeAttribute(ILdapAttributeNode attribute) throws Exception {
        ILdapEntryNode associatedEntry = attribute.getAssociatedEntry();
        if ((associatedEntry = (ILdapEntryNode)this.ldapEntryNodes.get((Object)associatedEntry.hashCode())) == null) {
            throw new Exception(LdapImportWizardManager.getString("noEntryForAttribute", new Object[0]));
        }
        if (associatedEntry.removeAttribute(attribute)) {
            this.notifyChanged();
        }
    }

    public boolean attributeSelected(ILdapAttributeNode attribute) {
        ILdapEntryNode associatedEntry = attribute.getAssociatedEntry();
        if ((associatedEntry = (ILdapEntryNode)this.ldapEntryNodes.get((Object)associatedEntry.hashCode())) == null) {
            return false;
        }
        return associatedEntry.getAttributes().contains(attribute);
    }

    public boolean hasAttributesForEachSelectedEntry() {
        if (this.ldapEntryNodes.isEmpty()) {
            return false;
        }
        for (ILdapEntryNode entry : this.ldapEntryNodes.values()) {
            if (!entry.getAttributes().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Collection<ILdapAttributeNode> getSelectedAttributes() {
        ArrayList<ILdapAttributeNode> allAttributes = new ArrayList<ILdapAttributeNode>();
        for (ILdapEntryNode entry : this.ldapEntryNodes.values()) {
            allAttributes.addAll(entry.getAttributes());
        }
        return Collections.unmodifiableCollection(allAttributes);
    }

    public void clearEntries() {
        this.ldapEntryNodes.clear();
        this.notifyChanged();
    }

    public void setDesignerProperties(Properties properties) {
        this.designerProperties = properties;
    }

    public Properties getDesignerProperties() {
        return this.designerProperties;
    }

    public void setDesignerProperty(String key, String value) {
        if (this.designerProperties != null) {
            this.designerProperties.put(key, value);
        }
    }

    void createModel() {
        RelationalModelBuilder modelBuilder = new RelationalModelBuilder();
        try {
            modelBuilder.modelEntries(this.getSourceModelLocation(), this.getSourceModelName(), this.getConnectionProfile(), this.getSelectedEntries());
        }
        catch (Exception e) {
            ModelGeneratorLdapUiConstants.UTIL.log((Throwable)e);
        }
    }

    public void notifyChanged() {
        for (IChangeListener listener : this.listeners) {
            listener.stateChanged((IChangeNotifier)this);
        }
    }

    public void addChangeListener(IChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        this.listeners.remove(listener);
    }

    private class LdapEntryKeyAdapter
    implements KeyInValueHashMap.KeyFromValueAdapter<Integer, ILdapEntryNode> {
        private LdapEntryKeyAdapter() {
        }

        public Integer getKey(ILdapEntryNode value) {
            return value.hashCode();
        }
    }
}

