/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.ldap.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiConstants;
import org.teiid.designer.modelgenerator.ldap.ui.ModelGeneratorLdapUiPlugin;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.LdapImportWizardManager;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.columns.LdapColumnsPage;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.definition.LdapDefinitionPage;
import org.teiid.designer.modelgenerator.ldap.ui.wizards.pages.table.LdapTablesPage;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.IPropertiesContext;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class LdapImportWizard
extends AbstractWizard
implements IImportWizard,
IPropertiesContext,
ModelGeneratorLdapUiConstants.Images {
    public static final ImageDescriptor BANNER = ModelGeneratorLdapUiPlugin.getDefault().getImageDescriptor("icons/full/wizban/ldap_banner_icon.png");
    private static final ImageDescriptor LDAP_ICON = ModelGeneratorLdapUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/import_ldap_wiz.gif");
    private LdapImportWizardManager importManager = new LdapImportWizardManager();
    private LdapDefinitionPage ldapDefinitionPage;
    private LdapTablesPage ldapTablesPage;
    private LdapColumnsPage ldapColumnsPage;
    private boolean openProjectExists = true;

    public LdapImportWizard() {
        super((AbstractUIPlugin)ModelGeneratorLdapUiPlugin.getDefault(), LdapImportWizard.getString("ImportLdapWizard_title"), LDAP_ICON);
    }

    private static String getString(String key) {
        return ModelGeneratorLdapUiConstants.UTIL.getString(key, new Object[0]);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.updateForProperties();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        IStructuredSelection selection = currentSelection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        if (!selectedResources.isEmpty()) {
            selection = new StructuredSelection(selectedResources);
        }
        this.openProjectExists = ModelerUiViewUtils.workspaceHasOpenModelProjects();
        if (!this.openProjectExists) {
            IProject newProject = ModelerUiViewUtils.queryUserToCreateModelProject();
            if (newProject != null) {
                selection = new StructuredSelection((Object)newProject);
                this.openProjectExists = true;
            } else {
                this.openProjectExists = false;
            }
        }
        this.createWizardPages((ISelection)selection);
        this.setNeedsProgressMonitor(true);
    }

    public void createWizardPages(ISelection theSelection) {
        this.ldapDefinitionPage = new LdapDefinitionPage(this.importManager);
        this.ldapDefinitionPage.setPageComplete(false);
        this.addPage((IWizardPage)this.ldapDefinitionPage);
        this.ldapTablesPage = new LdapTablesPage(this.importManager);
        this.ldapTablesPage.setPageComplete(false);
        this.addPage((IWizardPage)this.ldapTablesPage);
        this.ldapColumnsPage = new LdapColumnsPage(this.importManager);
        this.ldapColumnsPage.setPageComplete(false);
        this.addPage((IWizardPage)this.ldapColumnsPage);
    }

    public boolean finish() {
        boolean result = false;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Generate Model From LDAP Server Service", (Object)new Object());
                boolean succeeded = false;
                try {
                    try {
                        LdapImportWizard.this.importManager.createModel();
                        succeeded = true;
                    }
                    catch (Exception ex) {
                        ModelGeneratorLdapUiConstants.UTIL.log((Throwable)ex);
                        throw new InvocationTargetException(ex);
                    }
                    catch (Throwable t) {
                        throw new InvocationTargetException(t);
                    }
                }
                finally {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        };
        try {
            try {
                ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
                dlg.run(true, true, op);
                result = true;
            }
            catch (Throwable err) {
                Status status;
                if (err instanceof InvocationTargetException) {
                    Throwable t = ((InvocationTargetException)err).getTargetException();
                    status = new Status(4, ModelGeneratorLdapUiConstants.PLUGIN_ID, 4, LdapImportWizard.getString("importError_msg"), t);
                } else {
                    status = new Status(4, ModelGeneratorLdapUiConstants.PLUGIN_ID, 4, LdapImportWizard.getString("importError_msg"), err);
                }
                ErrorDialog.openError((Shell)this.getShell(), (String)LdapImportWizard.getString("ImportLdapWizard_importError_title"), (String)LdapImportWizard.getString("ImportLdapWizard_importError_msg"), (IStatus)status);
                ModelGeneratorLdapUiConstants.UTIL.log(err);
                this.dispose();
            }
        }
        finally {
            this.dispose();
        }
        return result;
    }

    public void setProperties(Properties props) {
        this.importManager.setDesignerProperties(props);
    }

    protected void updateForProperties() {
        String profileName;
        Properties designerProperties = this.importManager.getDesignerProperties();
        if (designerProperties == null) {
            return;
        }
        if (this.importManager.getSourceModelLocation() == null) {
            IProject project = DesignerPropertiesUtil.getProject((Properties)designerProperties);
            IContainer srcResource = DesignerPropertiesUtil.getSourcesFolder((Properties)designerProperties);
            if (srcResource != null) {
                this.importManager.setSourceModelLocation(srcResource);
            } else if (project != null) {
                this.importManager.setSourceModelLocation((IContainer)project);
            }
        }
        if (this.importManager.getConnectionProfile() == null && (profileName = DesignerPropertiesUtil.getConnectionProfileName((Properties)designerProperties)) != null && !profileName.isEmpty()) {
            this.ldapDefinitionPage.selectConnectionProfile(profileName);
        }
        if (!this.openProjectExists) {
            DesignerPropertiesUtil.setProjectStatus((Properties)designerProperties, (String)"noOpenProject");
        }
    }
}

