/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.xsd.XSDSchema;
import org.jdom.Namespace;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.modelgenerator.wsdl.model.Model;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.model.Port;
import org.teiid.designer.modelgenerator.wsdl.model.Service;

public class ModelImpl
implements Model {
    private Service[] m_services;
    private Map m_namespaces;
    private Map m_reverseNamespaceLookup;
    private Map<String, Service> serviceNameToService = new HashMap<String, Service>();
    private Map<String, Port> portNameToPort = new HashMap<String, Port>();
    private Map<String, Operation> operationNameToOperation = new HashMap<String, Operation>();
    private XSDSchema[] m_schemas;
    private Map<String, Map<String, Operation>> modelableOperationsMaps = new HashMap<String, Map<String, Operation>>();

    @Override
    public Service[] getServices() {
        Service[] retSvc = new Service[this.m_services.length];
        int i = 0;
        while (i < this.m_services.length) {
            retSvc[i] = this.m_services[i].copy();
            ++i;
        }
        return retSvc;
    }

    @Override
    public void setServices(Service[] services) {
        this.m_services = services;
        int i = 0;
        while (i < services.length) {
            Service service = services[i];
            this.serviceNameToService.put(service.getName(), service);
            Port[] ports = service.getPorts();
            int j = 0;
            while (j < ports.length) {
                Port port = ports[j];
                this.portNameToPort.put(port.getName(), port);
                Operation[] operations = port.getBinding().getOperations();
                int k = 0;
                while (k < operations.length) {
                    Operation operation = operations[k];
                    this.operationNameToOperation.put(operation.getName(), operation);
                    this.addOperationToMap(operation);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void addOperationToMap(Operation operation) {
        if (operation.canModel()) {
            Map<String, Operation> existingMap = this.modelableOperationsMaps.get(operation.getBinding().getPort().getName());
            if (existingMap == null) {
                existingMap = new HashMap<String, Operation>();
                this.modelableOperationsMaps.put(operation.getBinding().getPort().getName(), existingMap);
            }
            existingMap.put(operation.getName(), operation);
        }
    }

    @Override
    public Operation[] getModelableOperations(String portName) {
        Map<String, Operation> existingMap = this.modelableOperationsMaps.get(portName);
        if (existingMap == null) {
            return new Operation[0];
        }
        int nValues = existingMap.values().size();
        ArrayList<Operation> ops = new ArrayList<Operation>(existingMap.values());
        Collections.sort(ops, new OperationComparator());
        return ops.toArray(new Operation[nValues]);
    }

    @Override
    public String[] getModelablePortNames() {
        int nPorts = this.modelableOperationsMaps.keySet().size();
        return this.modelableOperationsMaps.keySet().toArray(new String[nPorts]);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.m_services.length) {
            buff.append("\n");
            buff.append(this.m_services[i].toString());
            ++i;
        }
        buff.append("\n");
        return buff.toString();
    }

    @Override
    public XSDSchema[] getSchemas() {
        return this.m_schemas;
    }

    @Override
    public void setSchemas(XSDSchema[] schemas) {
        this.m_schemas = schemas;
    }

    public Map getNamespaces() {
        return this.m_namespaces;
    }

    public Map getReverseNamespaces() {
        return this.m_reverseNamespaceLookup;
    }

    @Override
    public void setNamespaces(Map collection) {
        this.m_namespaces = collection;
        this.m_reverseNamespaceLookup = new HashMap(collection.size());
        for (Object key : collection.keySet()) {
            Object payload = collection.get(key);
            this.m_reverseNamespaceLookup.put(payload, key);
        }
    }

    @Override
    public void addNamespaceToMap(Namespace ns) {
        String uri = ns.getURI();
        String prefix = ns.getPrefix();
        this.addNamespaceToMap(prefix, uri);
    }

    @Override
    public void addNamespaceToMap(String prefix, String namespaceURI) {
        if (this.m_reverseNamespaceLookup.get(namespaceURI) != null) {
            return;
        }
        if (this.m_namespaces.get(prefix) != null) {
            int pre = 0;
            while (this.m_namespaces.get("mmn" + pre) != null) {
                ++pre;
            }
            prefix = "mmn" + pre;
        }
        this.m_namespaces.put(prefix, namespaceURI);
        this.m_reverseNamespaceLookup.put(namespaceURI, prefix);
    }

    @Override
    public void addNamespaceToMap(String namespaceURI) {
        this.addNamespaceToMap("mmn0", namespaceURI);
    }

    @Override
    public Service getService(String name) {
        return this.serviceNameToService.get(name);
    }

    @Override
    public Port getPort(String name) {
        return this.portNameToPort.get(name);
    }

    @Override
    public Operation getOperation(String name) {
        return this.operationNameToOperation.get(name);
    }

    private class OperationComparator
    implements Comparator {
        public int compare(Object oper1, Object oper2) {
            CoreArgCheck.isInstanceOf(Operation.class, (Object)oper1);
            CoreArgCheck.isInstanceOf(Operation.class, (Object)oper2);
            Operation op1 = (Operation)oper1;
            Operation op2 = (Operation)oper2;
            return op1.getName().compareTo(op2.getName());
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject == this) {
                return true;
            }
            return anObject != null && anObject.getClass() == this.getClass();
        }
    }
}

