/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.page;

import org.eclipse.birt.report.designer.core.mediator.IMediatorColleague;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.mediator.MediatorManager;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.data.DataService;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.dialog.FilterListDialog;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.AbstractCubePropertyPage;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeBuilder;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DatasetSelectionPage
extends AbstractCubePropertyPage {
    private static final String NEW_DATA_SET = Messages.getString("DatasetSelectionPage.Combo.NewDataSet0");
    private CubeHandle input;
    private Combo dataSetCombo;
    private Text nameText;
    private CubeBuilder builder;
    private Button filterButton;
    private Button primaryKeyButton;
    private Label primaryKeyLabel;
    private Label primaryKeyHint;

    public DatasetSelectionPage(CubeBuilder builder, CubeHandle model) {
        this.input = model;
        this.builder = builder;
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginRight = 20;
        container.setLayout((Layout)layout);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(Messages.getString("DatasetPage.Label.Name"));
        this.nameText = new Text(container, 2048);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    DatasetSelectionPage.this.input.setName(DatasetSelectionPage.this.nameText.getText());
                    DatasetSelectionPage.this.builder.setErrorMessage(null);
                    DatasetSelectionPage.this.builder.setTitleMessage(Messages.getString("DatasetPage.Title.Message"));
                }
                catch (NameException e1) {
                    if (DatasetSelectionPage.this.nameText.getText().trim().length() == 0) {
                        DatasetSelectionPage.this.builder.setErrorMessage(Messages.getString("DatasePage.EmptyName.ErrorMessage"));
                    }
                    DatasetSelectionPage.this.builder.setErrorMessage(e1.getLocalizedMessage());
                }
            }
        });
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.nameText.setLayoutData((Object)data);
        Label dateSetLabel = new Label(container, 0);
        dateSetLabel.setText(Messages.getString("DatasetPage.Label.PrimaryDataset"));
        this.dataSetCombo = new Combo(container, 2056);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.dataSetCombo.setLayoutData((Object)data);
        this.dataSetCombo.setVisibleItemCount(30);
        this.dataSetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatasetSelectionPage.this.handleDatasetComboSelectedEvent();
            }
        });
        this.filterButton = new Button(container, 8);
        this.filterButton.setText(Messages.getString("DatasetPage.Button.Filter"));
        data = new GridData();
        data.widthHint = Math.max(60, this.filterButton.computeSize((int)-1, (int)-1).x);
        this.filterButton.setLayoutData((Object)data);
        this.filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans("");
                FilterHandleProvider provider = (FilterHandleProvider)ElementAdapterManager.getAdapter((Object)((Object)DatasetSelectionPage.this.builder), FilterHandleProvider.class);
                if (provider == null) {
                    provider = new FilterHandleProvider();
                }
                FilterListDialog dialog = new FilterListDialog(provider);
                dialog.setInput((ReportElementHandle)DatasetSelectionPage.this.input);
                if (dialog.open() == 0) {
                    stack.commit();
                } else {
                    stack.rollback();
                }
            }
        });
        this.filterButton.setEnabled(false);
        new Label(container, 0);
        this.primaryKeyButton = new Button(container, 32);
        this.primaryKeyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ((TabularCubeHandle)DatasetSelectionPage.this.input).setAutoPrimaryKey(DatasetSelectionPage.this.primaryKeyButton.getSelection());
                }
                catch (SemanticException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.primaryKeyLabel = new Label(container, 64);
        data = new GridData(4, 0, false, false);
        data.horizontalSpan = 2;
        data.widthHint = 400;
        this.primaryKeyLabel.setLayoutData((Object)data);
        this.primaryKeyLabel.setText(Messages.getString("DatasetSelectionPage.Label.Auto.Primary.Key"));
        this.primaryKeyLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    DatasetSelectionPage.this.primaryKeyButton.setSelection(!DatasetSelectionPage.this.primaryKeyButton.getSelection());
                }
            }
        });
        new Label(container, 0);
        this.primaryKeyHint = new Label(container, 64);
        data = new GridData(4, 0, false, false);
        data.horizontalSpan = 3;
        data.widthHint = 400;
        this.primaryKeyHint.setLayoutData((Object)data);
        this.primaryKeyHint.setText(Messages.getString("DatasetSelectionPage.Text.Auto.Primary.Key"));
        this.primaryKeyHint.setForeground(ColorManager.getColor((int)128, (int)128, (int)128));
        FontData fontData = this.primaryKeyHint.getFont().getFontData()[0];
        Font font = new Font((Device)parent.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 2));
        this.primaryKeyHint.setFont(font);
        return container;
    }

    public void pageActivated() {
        UIUtil.bindHelp((Control)this.builder.getShell(), (String)"org.eclipse.birt.cshelp.CubeBuilderDataSetSelectionPage_ID");
        this.getContainer().setMessage(Messages.getString("DatasetPage.Container.Title.Message"), 0);
        this.builder.setTitleTitle(Messages.getString("DatasetPage.Title.Title"));
        this.builder.setErrorMessage(null);
        this.builder.setTitleMessage(Messages.getString("DatasetPage.Title.Message"));
        this.load();
    }

    private void refresh() {
        if (this.dataSetCombo != null && !this.dataSetCombo.isDisposed()) {
            this.dataSetCombo.setItems(OlapUtil.getAvailableDatasetNames());
            this.dataSetCombo.add(NEW_DATA_SET);
            if (((TabularCubeHandle)this.input).getDataSet() != null) {
                String datasetName = ((TabularCubeHandle)this.input).getDataSet().getQualifiedName();
                if (this.dataSetCombo.indexOf(datasetName) == -1) {
                    this.dataSetCombo.add(datasetName, 0);
                }
                this.dataSetCombo.setText(datasetName);
            }
            if (this.dataSetCombo.getSelectionIndex() == -1 && this.dataSetCombo.getItemCount() == 2) {
                this.dataSetCombo.select(0);
                if (((TabularCubeHandle)this.input).getDataSet() == null) {
                    this.handleDatasetComboSelectedEvent();
                }
            }
            if (this.dataSetCombo.getSelectionIndex() == -1) {
                this.builder.setOKEnable(false);
                this.filterButton.setEnabled(false);
            } else {
                this.builder.setOKEnable(true);
                this.filterButton.setEnabled(true);
            }
        }
        this.primaryKeyButton.setSelection(((TabularCubeHandle)this.input).autoPrimaryKey());
    }

    private void load() {
        if (this.input != null) {
            if (this.input.getName() != null) {
                this.nameText.setText(this.input.getName());
            }
            this.refresh();
        }
    }

    private void setDataset(String datasetName) {
        if (this.dataSetCombo.getSelectionIndex() == -1) {
            this.builder.setOKEnable(false);
            this.filterButton.setEnabled(false);
        } else {
            try {
                ((TabularCubeHandle)this.input).setDataSet(OlapUtil.getDataset(datasetName));
            }
            catch (SemanticException e1) {
                ExceptionUtil.handle((Throwable)e1);
            }
            this.builder.setOKEnable(true);
            this.filterButton.setEnabled(true);
        }
    }

    private void handleRequest(ReportRequest request) {
        Object obj;
        if ("create element".equals(request.getType()) && (obj = DEUtil.getInputFirstElement((Object)request.getSelectionObject())) instanceof DataSetHandle) {
            this.dataSetCombo.removeAll();
            this.refresh();
            this.dataSetCombo.setText(((DataSetHandle)obj).getQualifiedName());
            this.setDataset(this.dataSetCombo.getItem(this.dataSetCombo.getSelectionIndex()));
        }
    }

    private void handleDatasetComboSelectedEvent() {
        if (this.dataSetCombo.getItemCount() == 0) {
            return;
        }
        String datasetName = this.dataSetCombo.getItem(this.dataSetCombo.getSelectionIndex());
        if (NEW_DATA_SET.equals(datasetName)) {
            IMediatorColleague colleague = new IMediatorColleague(){

                public boolean isInterested(IMediatorRequest request) {
                    return request instanceof ReportRequest;
                }

                public void performRequest(IMediatorRequest request) {
                    DatasetSelectionPage.this.handleRequest((ReportRequest)request);
                }
            };
            MediatorManager.addGlobalColleague((IMediatorColleague)colleague);
            this.dataSetCombo.removeAll();
            this.refresh();
            DataService.getInstance().createDataSet();
            MediatorManager.removeGlobalColleague((IMediatorColleague)colleague);
            return;
        }
        this.setDataset(datasetName);
    }
}

