/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.manifest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.teiid.designer.vdb.TranslatorOverride;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbDataRole;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbImportVdbEntry;
import org.teiid.designer.vdb.VdbModelEntry;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.manifest.DataRoleElement;
import org.teiid.designer.vdb.manifest.EntryElement;
import org.teiid.designer.vdb.manifest.ImportVdbElement;
import org.teiid.designer.vdb.manifest.ModelElement;
import org.teiid.designer.vdb.manifest.PropertyElement;
import org.teiid.designer.vdb.manifest.TranslatorElement;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="")
@XmlRootElement(name="vdb")
public class VdbElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="version", required=true)
    private int version;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="property", type=PropertyElement.class)
    private List<PropertyElement> properties;
    @XmlElement(name="import-vdb", type=ImportVdbElement.class)
    private List<ImportVdbElement> importVdbs;
    @XmlElement(name="model", required=true, type=ModelElement.class)
    private List<ModelElement> models;
    @XmlElement(name="translator", type=TranslatorElement.class)
    private List<TranslatorElement> translators;
    @XmlElement(name="data-role", type=DataRoleElement.class)
    private List<DataRoleElement> dataRoles;
    @XmlElement(name="entry", type=EntryElement.class)
    private List<EntryElement> entries;

    public VdbElement() {
    }

    public VdbElement(Vdb vdb) throws Exception {
        String valueStr;
        this.name = vdb.getName().removeFileExtension().lastSegment();
        this.description = vdb.getDescription();
        this.version = vdb.getVersion();
        for (VdbEntry entry : vdb.getEntries()) {
            this.getEntries().add(new EntryElement(entry));
        }
        for (VdbModelEntry modelEntry : vdb.getModelEntries()) {
            this.getModels().add(new ModelElement(modelEntry));
        }
        for (VdbImportVdbEntry importVdbEntry : vdb.getImportVdbEntries()) {
            this.getImportVdbEntries().add(new ImportVdbElement(importVdbEntry));
        }
        for (TranslatorOverride translator : vdb.getTranslators()) {
            this.getTranslators().add(new TranslatorElement(translator));
        }
        for (VdbDataRole dataPolicyEntry : vdb.getDataPolicyEntries()) {
            this.getDataPolicies().add(new DataRoleElement(dataPolicyEntry));
        }
        this.getProperties().add(new PropertyElement("preview", Boolean.toString(vdb.isPreview())));
        if (vdb.getQueryTimeout() > 0) {
            int timeoutMillis = vdb.getQueryTimeout() * 1000;
            this.getProperties().add(new PropertyElement("query-timeout", Integer.toString(timeoutMillis)));
        }
        if (!vdb.getAllowedLanguages().isEmpty() && (valueStr = VdbUtil.buildCommaDelimitedString(vdb.getAllowedLanguages())) != null && valueStr.length() > 1) {
            this.getProperties().add(new PropertyElement("allowed-languages", valueStr));
        }
        if (vdb.isAutoGenerateRESTWAR()) {
            this.getProperties().add(new PropertyElement("{http://teiid.org/rest}auto-generate", Boolean.TRUE.toString()));
        }
        if (vdb.getSecurityDomain() != null && vdb.getSecurityDomain().trim().length() > 0) {
            this.getProperties().add(new PropertyElement("security-domain", vdb.getSecurityDomain()));
        }
        if (vdb.getGssPattern() != null && vdb.getGssPattern().trim().length() > 0) {
            this.getProperties().add(new PropertyElement("gss-pattern", vdb.getGssPattern()));
        }
        if (vdb.getPasswordPattern() != null && vdb.getPasswordPattern().trim().length() > 0) {
            this.getProperties().add(new PropertyElement("password-pattern", vdb.getPasswordPattern()));
        }
        if (vdb.getAuthenticationType() != null && vdb.getAuthenticationType().trim().length() > 0) {
            this.getProperties().add(new PropertyElement("authentication-type", vdb.getAuthenticationType()));
        }
        if (vdb.getValidationDateTime() != null) {
            String dateTimeString = vdb.getValidationDateTime().toString();
            this.getProperties().add(new PropertyElement("validationDateTime", dateTimeString));
        }
        if (vdb.getValidationVersion() != null) {
            String versionString = vdb.getValidationVersion();
            this.getProperties().add(new PropertyElement("validationVersion", versionString));
        }
        for (String key : vdb.getGeneralProperties().keySet()) {
            String value = vdb.getGeneralProperties().get(key);
            this.getProperties().add(new PropertyElement(key, value));
        }
    }

    public List<DataRoleElement> getDataPolicies() {
        if (this.dataRoles == null) {
            this.dataRoles = new ArrayList<DataRoleElement>();
        }
        return this.dataRoles;
    }

    public String getDescription() {
        return this.description;
    }

    public List<EntryElement> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<EntryElement>();
        }
        return this.entries;
    }

    public List<ModelElement> getModels() {
        if (this.models == null) {
            this.models = new ArrayList<ModelElement>();
        }
        return this.models;
    }

    public List<ImportVdbElement> getImportVdbEntries() {
        if (this.importVdbs == null) {
            this.importVdbs = new ArrayList<ImportVdbElement>();
        }
        return this.importVdbs;
    }

    public String getName() {
        return this.name;
    }

    public List<PropertyElement> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyElement>();
        }
        return this.properties;
    }

    public List<TranslatorElement> getTranslators() {
        if (this.translators == null) {
            this.translators = new ArrayList<TranslatorElement>();
        }
        return this.translators;
    }

    public int getVersion() {
        return this.version;
    }
}

