/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.manifest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.vdb.VdbDataRole;
import org.teiid.designer.vdb.manifest.PermissionElement;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="")
public class DataRoleElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="any-authenticated", required=false)
    private boolean anyAuthenticated;
    @XmlAttribute(name="allow-create-temporary-tables", required=false)
    private boolean allowCreateTempTables;
    @XmlAttribute(name="grant-all", required=false)
    private boolean grantAll;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="permission", required=true, type=PermissionElement.class)
    private List<PermissionElement> permissions;
    @XmlElement(name="mapped-role-name")
    private List<String> mappedRoleNames;

    public DataRoleElement() {
    }

    DataRoleElement(VdbDataRole dataRole) {
        this.name = dataRole.getName();
        this.anyAuthenticated = dataRole.isAnyAuthenticated();
        this.allowCreateTempTables = dataRole.allowCreateTempTables();
        this.grantAll = dataRole.doGrantAll();
        this.description = dataRole.getDescription();
        for (Permission perm : dataRole.getPermissions()) {
            this.getPermissions().add(new PermissionElement(perm));
        }
        this.mappedRoleNames = new ArrayList<String>(dataRole.getMappedRoleNames());
    }

    public boolean allowCreateTempTables() {
        return this.allowCreateTempTables;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getMappedRoleNames() {
        if (this.mappedRoleNames == null) {
            this.mappedRoleNames = new ArrayList<String>();
        }
        return this.mappedRoleNames;
    }

    public String getName() {
        return this.name;
    }

    public List<PermissionElement> getPermissions() {
        if (this.permissions == null) {
            this.permissions = new ArrayList<PermissionElement>();
        }
        return this.permissions;
    }

    public boolean isAnyAuthenticated() {
        return this.anyAuthenticated;
    }

    public boolean doGrantAll() {
        return this.grantAll;
    }
}

