/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.file;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.vdb.file.IVdbFileCallback;

public class VdbFileProcessor {
    private final IVdbFileCallback callback;

    public VdbFileProcessor(IVdbFileCallback callback) {
        CoreArgCheck.isNotNull((Object)callback);
        CoreArgCheck.isNotNull((Object)callback.getVdb());
        this.callback = callback;
    }

    public void process() {
        block14: {
            IFile vdbFile = this.callback.getVdb();
            if (!vdbFile.exists()) {
                return;
            }
            ZipFile archive = null;
            try {
                try {
                    archive = new ZipFile(vdbFile.getLocation().toString());
                    Enumeration<? extends ZipEntry> iter = archive.entries();
                    while (iter.hasMoreElements()) {
                        ZipEntry zipEntry = iter.nextElement();
                        InputStream entryStream = archive.getInputStream(zipEntry);
                        if (!this.callback.getFilesOfInterest().contains(zipEntry.getName())) continue;
                        this.callback.processStream(zipEntry.getName(), entryStream);
                        break;
                    }
                }
                catch (Exception ex) {
                    this.callback.exceptionThrown(ex);
                    if (archive == null) break block14;
                    try {
                        archive.close();
                    }
                    catch (IOException ex2) {
                        this.callback.exceptionThrown(ex2);
                    }
                }
            }
            finally {
                if (archive != null) {
                    try {
                        archive.close();
                    }
                    catch (IOException ex) {
                        this.callback.exceptionThrown(ex);
                    }
                }
            }
        }
    }
}

