/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.io.File;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.teiid.designer.core.util.VdbHelper;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.manifest.EntryElement;

@ThreadSafe
public final class VdbFileEntry
extends VdbEntry {
    private IPath sourceFilePath;
    private FileEntryType fileType;

    public VdbFileEntry(Vdb vdb, IPath sourcePath, FileEntryType entryType, IProgressMonitor monitor) throws Exception {
        super(vdb, sourcePath, monitor);
        this.sourceFilePath = sourcePath;
        this.fileType = entryType;
        this.setName(this.determinePath(sourcePath, entryType));
    }

    VdbFileEntry(Vdb vdb, EntryElement element, IProgressMonitor monitor) throws Exception {
        super(vdb, Path.fromPortableString((String)element.getPath()), monitor);
        this.sourceFilePath = Path.fromPortableString((String)element.getPath());
        this.fileType = element.getPath().startsWith("/" + VdbHelper.VdbFolders.UDF.getReadFolder()) ? FileEntryType.UDFJar : FileEntryType.UserFile;
        this.setName(this.determinePath(this.sourceFilePath, this.fileType));
    }

    private IPath determinePath(IPath sourcePath, FileEntryType entryType) {
        String fileName = sourcePath.lastSegment();
        if (entryType == FileEntryType.UDFJar) {
            return new Path("/" + VdbHelper.VdbFolders.UDF.getWriteFolder() + "/" + fileName);
        }
        return new Path("/" + VdbHelper.VdbFolders.OTHER_FILES.getWriteFolder() + "/" + fileName);
    }

    @Override
    void save(ZipOutputStream out, IProgressMonitor monitor) throws Exception {
        String zipName = this.getName().toString();
        if (zipName.startsWith("/")) {
            zipName = zipName.substring(1, zipName.length());
        }
        ZipEntry zipEntry = new ZipEntry(zipName);
        zipEntry.setComment((String)this.description.get());
        IProject vdbProject = this.getVdb().getFile().getProject();
        File theFile = this.findUdfFile(vdbProject);
        if (theFile != null && theFile.exists()) {
            this.save(out, zipEntry, theFile, monitor);
        }
    }

    public FileEntryType getFileType() {
        return this.fileType;
    }

    private File findUdfFile(IProject project) {
        IPath locationPath;
        IFile file;
        String filePath;
        String udfPath = this.sourceFilePath.toString();
        File theFile = null;
        if (udfPath != null && !(theFile = new File(filePath = udfPath.toString())).exists() && (file = project.getFile(this.getName())) != null && (locationPath = file.getLocation()) != null && !(theFile = locationPath.toFile()).exists()) {
            theFile = null;
        }
        return theFile;
    }

    public static enum FileEntryType {
        UserFile,
        UDFJar;

    }
}

