/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.roles.DataRole;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.manifest.ConditionElement;
import org.teiid.designer.vdb.manifest.DataRoleElement;
import org.teiid.designer.vdb.manifest.MaskElement;
import org.teiid.designer.vdb.manifest.PermissionElement;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="")
public class VdbDataRole {
    private final Vdb vdb;
    private final String name;
    private final boolean anyAuthenticated;
    private final boolean allowCreateTempTables;
    private final boolean grantAll;
    final AtomicReference<String> description = new AtomicReference();
    private List<Permission> permissions = new ArrayList<Permission>();
    private List<String> mappedRoleNames = new ArrayList<String>();

    VdbDataRole(Vdb vdb, DataRole dataRole, IProgressMonitor monitor) {
        this.vdb = vdb;
        this.name = dataRole.getName();
        this.anyAuthenticated = dataRole.isAnyAuthenticated();
        this.allowCreateTempTables = dataRole.allowCreateTempTables();
        this.grantAll = dataRole.doGrantAll();
        this.permissions = new ArrayList<Permission>(dataRole.getPermissions());
        this.mappedRoleNames = new ArrayList<String>(dataRole.getRoleNames());
        this.description.set(dataRole.getDescription() == null ? "" : dataRole.getDescription());
    }

    VdbDataRole(Vdb vdb, DataRoleElement element) {
        this.vdb = vdb;
        this.name = element.getName();
        this.anyAuthenticated = element.isAnyAuthenticated();
        this.allowCreateTempTables = element.allowCreateTempTables();
        this.grantAll = element.doGrantAll();
        this.description.set(element.getDescription() == null ? "" : element.getDescription());
        for (PermissionElement pe : element.getPermissions()) {
            MaskElement mask;
            boolean allow = false;
            if (pe != null) {
                allow = pe.isAllowLanguage();
            }
            Permission permission = new Permission(pe.getResourceName(), pe.isCreate(), pe.isRead(), pe.isUpdate(), pe.isDelete(), pe.isExecute(), pe.isAlter());
            ConditionElement condition = pe.getCondition();
            if (condition != null) {
                permission.setCondition(condition.getSql());
                if (!condition.getConstraint().booleanValue()) {
                    permission.setConstraint(condition.getConstraint().booleanValue());
                }
            }
            if ((mask = pe.getMask()) != null) {
                permission.setMask(mask.getSql());
                if (mask.getOrder() != null) {
                    permission.setOrder(Integer.valueOf(mask.getOrder()).intValue());
                }
            }
            if (allow) {
                permission.setAllowLanguage(true);
            }
            this.permissions.add(permission);
        }
        this.mappedRoleNames = new ArrayList<String>(element.getMappedRoleNames());
    }

    public boolean allowCreateTempTables() {
        return this.allowCreateTempTables;
    }

    public final String getDescription() {
        return this.description.get();
    }

    public List<String> getMappedRoleNames() {
        return Collections.unmodifiableList(this.mappedRoleNames);
    }

    public String getName() {
        return this.name;
    }

    public boolean isAnyAuthenticated() {
        return this.anyAuthenticated;
    }

    public boolean doGrantAll() {
        return this.grantAll;
    }

    public final List<Permission> getPermissions() {
        return Collections.unmodifiableList(this.permissions);
    }

    public final void setDescription(String description) {
        String oldDescription = this.description.get();
        if (StringUtilities.equals((String)description, (String)oldDescription)) {
            return;
        }
        this.description.set(description);
        this.vdb.setModified(this, "entry.description", oldDescription, description);
    }
}

