/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.FileUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.OperationUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.VdbModelBuilder;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.roles.DataRole;
import org.teiid.designer.vdb.TranslatorOverride;
import org.teiid.designer.vdb.VdbConstants;
import org.teiid.designer.vdb.VdbDataRole;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbFileEntry;
import org.teiid.designer.vdb.VdbImportVdbEntry;
import org.teiid.designer.vdb.VdbModelEntry;
import org.teiid.designer.vdb.VdbPlugin;
import org.teiid.designer.vdb.VdbSchemaEntry;
import org.teiid.designer.vdb.manifest.DataRoleElement;
import org.teiid.designer.vdb.manifest.EntryElement;
import org.teiid.designer.vdb.manifest.ImportVdbElement;
import org.teiid.designer.vdb.manifest.ModelElement;
import org.teiid.designer.vdb.manifest.PropertyElement;
import org.teiid.designer.vdb.manifest.TranslatorElement;
import org.teiid.designer.vdb.manifest.VdbElement;
import org.xml.sax.SAXException;

@ThreadSafe
public final class Vdb
implements VdbConstants {
    public static final String FILE_EXTENSION = ".vdb";
    public static final String FILE_EXTENSION_NO_DOT = "vdb";
    private static final int DEFAULT_TIMEOUT = 0;
    public static final String PREVIEW_PREFIX = "PREVIEW_";
    final IFile file;
    private final File folder;
    final CopyOnWriteArraySet<VdbFileEntry> fileEntries = new CopyOnWriteArraySet();
    final CopyOnWriteArraySet<VdbFileEntry> udfJarEntries = new CopyOnWriteArraySet();
    final CopyOnWriteArraySet<VdbSchemaEntry> schemaEntries = new CopyOnWriteArraySet();
    final CopyOnWriteArraySet<VdbModelEntry> modelEntries = new CopyOnWriteArraySet();
    final CopyOnWriteArraySet<VdbDataRole> dataPolicyEntries = new CopyOnWriteArraySet();
    final CopyOnWriteArraySet<VdbImportVdbEntry> importModelEntries = new CopyOnWriteArraySet();
    final Set<TranslatorOverride> translatorOverrides = new TreeSet<TranslatorOverride>(new Comparator<TranslatorOverride>(){

        @Override
        public int compare(TranslatorOverride translator1, TranslatorOverride translator2) {
            return translator1.getName().compareTo(translator2.getName());
        }
    });
    final Map<String, String> generalPropertiesMap = new HashMap<String, String>();
    final Set<String> allowedLanguages = new TreeSet<String>(new Comparator<String>(){

        @Override
        public int compare(String str1, String str2) {
            return str1.compareTo(str2);
        }
    });
    private final CopyOnWriteArrayList<PropertyChangeListener> listeners = new CopyOnWriteArrayList();
    final AtomicBoolean modified = new AtomicBoolean();
    private final AtomicReference<String> description = new AtomicReference();
    private final boolean preview;
    private int version;
    private int queryTimeout = 0;
    private boolean autoGenerateRESTWAR;
    private Date validateDateTime;
    private String validationVersion;
    private String securityDomain;
    private String gssPattern;
    private String passwordPattern;
    private String authenticationType;
    private VdbModelBuilder builder;
    private Map<String, Set<String>> modelToImportVdbMap = new HashMap<String, Set<String>>();

    public static String getPreviewVdbPrefix(IResource resource) {
        String prefix;
        CoreArgCheck.isNotNull((Object)resource, (String)"resource is null");
        char delim = '_';
        StringBuilder name = new StringBuilder(PREVIEW_PREFIX + ModelerCore.workspaceUuid().toString() + delim);
        if (resource instanceof IFile) {
            IPath path = resource.getParent().getFullPath();
            String[] stringArray = path.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                name.append(segment).append(delim);
                ++n2;
            }
        }
        if ((prefix = name.toString()).contains(" ")) {
            prefix = prefix.replaceAll(" ", "_");
        }
        return prefix;
    }

    public Vdb(final IFile file, boolean preview, final IProgressMonitor monitor) throws Exception {
        this.builder = new VdbModelBuilder();
        this.file = file;
        this.folder = VdbPlugin.singleton().getStateLocation().append(file.getFullPath()).toFile();
        this.folder.mkdirs();
        if (file.getLocation().toFile().length() == 0L) {
            this.preview = preview;
            this.version = 1;
            return;
        }
        final boolean[] previewable = new boolean[1];
        final int[] vdbVersion = new int[1];
        final int[] queryTimeout = new int[1];
        final String[] valDateTime = new String[1];
        final String[] valVersion = new String[1];
        final boolean[] autoGen = new boolean[1];
        final String[] secDomain = new String[1];
        final String[] gssPatt = new String[1];
        final String[] pwdPatt = new String[1];
        final String[] authType = new String[1];
        OperationUtil.perform((OperationUtil.Unreliable)new OperationUtil.Unreliable(){
            ZipFile archive = null;
            InputStream entryStream = null;

            public void doIfFails() {
            }

            public void finallyDo() throws Exception {
                if (this.entryStream != null) {
                    this.entryStream.close();
                }
                if (this.archive != null) {
                    this.archive.close();
                }
            }

            public void tryToDo() throws Exception {
                this.archive = new ZipFile(file.getLocation().toString());
                Enumeration<? extends ZipEntry> iter = this.archive.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry zipEntry = iter.nextElement();
                    this.entryStream = this.archive.getInputStream(zipEntry);
                    if (zipEntry.getName().equals("META-INF/vdb.xml")) {
                        VdbSchemaEntry vdbSchemaEntry;
                        IPath path;
                        Unmarshaller unmarshaller = Vdb.this.getJaxbContext().createUnmarshaller();
                        unmarshaller.setSchema(Vdb.this.getManifestSchema());
                        VdbElement manifest = (VdbElement)unmarshaller.unmarshal(this.entryStream);
                        Vdb.this.setDescription(manifest.getDescription());
                        vdbVersion[0] = manifest.getVersion();
                        for (PropertyElement propertyElement : manifest.getProperties()) {
                            String name = propertyElement.getName();
                            String value = propertyElement.getValue();
                            if ("preview".equals(name)) {
                                previewable[0] = Boolean.parseBoolean(value);
                                continue;
                            }
                            if ("query-timeout".equals(name)) {
                                int timeoutMillis = Integer.parseInt(value);
                                if (timeoutMillis <= 0) continue;
                                queryTimeout[0] = timeoutMillis / 1000;
                                continue;
                            }
                            if ("allowed-languages".equals(name)) {
                                String[] langs;
                                String[] stringArray = langs = StringUtilities.parseCommaDelimitedString((String)value);
                                int n = langs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String lang = stringArray[n2];
                                    Vdb.this.allowedLanguages.add(lang);
                                    ++n2;
                                }
                                continue;
                            }
                            if ("validationDateTime".equals(name)) {
                                valDateTime[0] = value;
                                continue;
                            }
                            if ("validationVersion".equals(name)) {
                                valVersion[0] = value;
                                continue;
                            }
                            if ("security-domain".equals(name)) {
                                secDomain[0] = value;
                                continue;
                            }
                            if ("gss-pattern".equals(name)) {
                                gssPatt[0] = value;
                                continue;
                            }
                            if ("password-pattern".equals(name)) {
                                pwdPatt[0] = value;
                                continue;
                            }
                            if ("authentication-type".equals(name)) {
                                authType[0] = value;
                                continue;
                            }
                            if ("{http://teiid.org/rest}auto-generate".equals(name)) {
                                autoGen[0] = Boolean.parseBoolean(value);
                                continue;
                            }
                            Vdb.this.generalPropertiesMap.put(name, value);
                        }
                        for (ModelElement modelElement : manifest.getModels()) {
                            path = Path.fromPortableString((String)modelElement.getPath());
                            if (ModelUtil.isXsdFile((IPath)path)) {
                                vdbSchemaEntry = new VdbSchemaEntry(Vdb.this, modelElement, monitor);
                                Vdb.this.schemaEntries.add(vdbSchemaEntry);
                                continue;
                            }
                            Vdb.this.modelEntries.add(new VdbModelEntry(Vdb.this, modelElement, monitor));
                        }
                        for (VdbModelEntry vdbModelEntry : Vdb.this.modelEntries) {
                            vdbModelEntry.initializeImports();
                        }
                        for (EntryElement entryElement : manifest.getEntries()) {
                            path = Path.fromPortableString((String)entryElement.getPath());
                            if (ModelUtil.isXsdFile((IPath)path)) {
                                vdbSchemaEntry = new VdbSchemaEntry(Vdb.this, entryElement, monitor);
                                Vdb.this.schemaEntries.add(vdbSchemaEntry);
                                continue;
                            }
                            VdbFileEntry vdbFileEntry = new VdbFileEntry(Vdb.this, entryElement, monitor);
                            switch (vdbFileEntry.getFileType()) {
                                case UDFJar: {
                                    Vdb.this.udfJarEntries.add(vdbFileEntry);
                                    break;
                                }
                                case UserFile: {
                                    Vdb.this.fileEntries.add(vdbFileEntry);
                                }
                            }
                        }
                        for (ImportVdbElement importVdbElement : manifest.getImportVdbEntries()) {
                            Vdb.this.importModelEntries.add(new VdbImportVdbEntry(Vdb.this, importVdbElement));
                        }
                        for (TranslatorElement translatorElement : manifest.getTranslators()) {
                            Vdb.this.translatorOverrides.add(new TranslatorOverride(Vdb.this, translatorElement));
                        }
                        for (DataRoleElement dataRoleElement : manifest.getDataPolicies()) {
                            Vdb.this.dataPolicyEntries.add(new VdbDataRole(Vdb.this, dataRoleElement));
                        }
                        continue;
                    }
                    if (zipEntry.isDirectory()) continue;
                    FileUtils.copy((InputStream)this.entryStream, (File)new File(Vdb.this.getFolder(), zipEntry.getName()));
                }
                Vdb.this.modified.set(false);
            }
        });
        this.preview = previewable[0];
        this.version = vdbVersion[0];
        this.queryTimeout = queryTimeout[0];
        this.autoGenerateRESTWAR = autoGen[0];
        this.securityDomain = secDomain[0];
        this.gssPattern = gssPatt[0];
        this.passwordPattern = pwdPatt[0];
        this.authenticationType = authType[0];
        if (valDateTime[0] != null) {
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
            this.validateDateTime = format.parse(valDateTime[0]);
        }
        this.validationVersion = valVersion[0];
    }

    public Vdb(IFile file, IProgressMonitor monitor) throws Exception {
        this(file, false, monitor);
    }

    public final VdbDataRole addDataPolicy(DataRole dataPolicy, IProgressMonitor monitor) {
        VdbDataRole policy = new VdbDataRole(this, dataPolicy, monitor);
        this.dataPolicyEntries.add(policy);
        this.setModified(this, "dataPolicyAdded", policy, null);
        return policy;
    }

    public final void addChangeListener(PropertyChangeListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public final <T extends VdbEntry> T addEntry(IPath name, IProgressMonitor monitor) throws Exception {
        CoreArgCheck.isNotNull((Object)name);
        if (ModelUtil.isXsdFile((IPath)name)) {
            return (T)this.addSchemaEntry(name, monitor);
        }
        if (ModelUtil.isModelFile((IPath)name) && !ModelUtil.isXsdFile((IPath)name)) {
            return (T)this.addModelEntry(name, monitor);
        }
        String fileType = FileUtil.guessFileType((File)name.toFile());
        VdbFileEntry.FileEntryType fileEntryType = VdbFileEntry.FileEntryType.UserFile;
        if ("application/java-archive".equals(fileType)) {
            fileEntryType = VdbFileEntry.FileEntryType.UDFJar;
        }
        return (T)this.addFileEntry(name, fileEntryType, monitor);
    }

    private VdbSchemaEntry addSchemaEntry(IPath name, IProgressMonitor monitor) throws Exception {
        VdbSchemaEntry schemaEntry = new VdbSchemaEntry(this, name, monitor);
        VdbSchemaEntry addedEntry = this.addEntry(schemaEntry, this.schemaEntries, monitor);
        if (schemaEntry == addedEntry) {
            schemaEntry.synchronizeSchemaEntry(monitor);
        } else {
            schemaEntry = addedEntry;
        }
        return schemaEntry;
    }

    private VdbFileEntry addFileEntry(IPath name, VdbFileEntry.FileEntryType entryType, IProgressMonitor monitor) throws Exception {
        CoreArgCheck.isNotNull((Object)((Object)entryType));
        CopyOnWriteArraySet<VdbFileEntry> entries = null;
        switch (entryType) {
            case UDFJar: {
                entries = this.udfJarEntries;
                break;
            }
            case UserFile: {
                entries = this.fileEntries;
            }
        }
        return this.addEntry(new VdbFileEntry(this, name, entryType, monitor), entries, monitor);
    }

    private <T extends VdbEntry> T addEntry(T entry, Set<T> entries, IProgressMonitor monitor) {
        if (!entries.add(entry)) {
            for (VdbEntry existingEntry : entries) {
                if (!existingEntry.equals(entry)) continue;
                return (T)existingEntry;
            }
        }
        this.setModified(this, "entryAdded", null, entry);
        return entry;
    }

    private VdbModelEntry addModelEntry(IPath name, IProgressMonitor monitor) throws Exception {
        VdbModelEntry modelEntry = new VdbModelEntry(this, name, monitor);
        VdbModelEntry addedEntry = this.addEntry(modelEntry, this.modelEntries, monitor);
        if (modelEntry == addedEntry) {
            modelEntry.synchronizeModelEntry(monitor);
        } else {
            modelEntry = addedEntry;
        }
        return modelEntry;
    }

    public final boolean addTranslator(TranslatorOverride translatorOverride, IProgressMonitor monitor) {
        if (this.translatorOverrides.add(translatorOverride)) {
            this.setModified(this, "translatorOverrideAdded", null, translatorOverride);
            return true;
        }
        return false;
    }

    public final boolean addImportVdb(String importVdbName) {
        if (this.importModelEntries.add(new VdbImportVdbEntry(this, importVdbName))) {
            this.setModified(this, "importVdbEntryAdded", null, importVdbName);
            return true;
        }
        return false;
    }

    public final boolean addAllowedLanguage(String name) {
        if (this.allowedLanguages.add(name)) {
            this.setModified(this, "allowed-languages", name, name);
            return true;
        }
        return false;
    }

    public final boolean setGeneralProperty(String key, String value) {
        if (value == null) {
            return this.removeGeneralProperty(key, value);
        }
        String oldValue = this.generalPropertiesMap.put(key, value);
        if (oldValue == null) {
            this.setModified(this, "generalProperty", null, value);
            return true;
        }
        if (!oldValue.equals(value)) {
            this.setModified(this, "generalProperty", oldValue, value);
            return true;
        }
        return false;
    }

    public final void synchronizeUdfJars(Set<VdbFileEntry> newJarEntries) {
        HashSet<VdbFileEntry> allRequiredUdfJars = new HashSet<VdbFileEntry>(newJarEntries);
        for (VdbModelEntry entry : this.modelEntries) {
            Set<VdbFileEntry> jarEntries = entry.getUdfJars();
            allRequiredUdfJars.addAll((Collection<VdbFileEntry>)jarEntries);
        }
        HashMap<String, VdbFileEntry> allRequiredJarsMap = new HashMap<String, VdbFileEntry>();
        for (VdbFileEntry fileEntry : allRequiredUdfJars) {
            allRequiredJarsMap.put(fileEntry.getName().toString(), fileEntry);
        }
        Set<String> currentUdfJarNames = this.getUdfJarNames();
        boolean jarsAdded = false;
        for (VdbFileEntry modelUdfJar : allRequiredUdfJars) {
            if (currentUdfJarNames.contains(modelUdfJar.getName().toString())) continue;
            this.udfJarEntries.add(modelUdfJar);
            jarsAdded = true;
        }
        boolean jarsRemoved = false;
        currentUdfJarNames = this.getUdfJarNames();
        for (String currentJarName : currentUdfJarNames) {
            Set allRequiredJarNames = allRequiredJarsMap.keySet();
            if (allRequiredJarNames.contains(currentJarName)) continue;
            for (VdbEntry vdbEntry : this.udfJarEntries) {
                String entryName = vdbEntry.getName().toString();
                if (entryName == null || !entryName.equals(currentJarName)) continue;
                this.udfJarEntries.remove(vdbEntry);
                break;
            }
            jarsRemoved = true;
        }
        if (jarsAdded || jarsRemoved) {
            this.setModified(this, "udfJarsModified", null, null);
        }
    }

    public final void close() {
        this.fileEntries.clear();
        this.udfJarEntries.clear();
        this.schemaEntries.clear();
        this.modelEntries.clear();
        this.listeners.clear();
        this.description.set("");
        FileUtils.removeDirectoryAndChildren((File)VdbPlugin.singleton().getStateLocation().append(this.file.getFullPath().segment(0)).toFile());
        if (this.isModified()) {
            this.modified.set(false);
        }
        this.notifyChangeListeners(this, "closed", null, null);
    }

    public final Set<String> getAllowedLanguages() {
        return Collections.unmodifiableSet(this.allowedLanguages);
    }

    public final Set<VdbDataRole> getDataPolicyEntries() {
        return Collections.unmodifiableSet(this.dataPolicyEntries);
    }

    public final String getDescription() {
        return this.description.get();
    }

    public final Set<VdbEntry> getEntries() {
        HashSet<VdbEntry> entries = new HashSet<VdbEntry>();
        entries.addAll(this.schemaEntries);
        entries.addAll(this.fileEntries);
        entries.addAll(this.udfJarEntries);
        return Collections.unmodifiableSet(entries);
    }

    public final Set<VdbSchemaEntry> getSchemaEntries() {
        return Collections.unmodifiableSet(this.schemaEntries);
    }

    public final Set<VdbFileEntry> getUdfJarEntries() {
        return Collections.unmodifiableSet(this.udfJarEntries);
    }

    public final Set<String> getUdfJarNames() {
        HashSet<String> udfJarNames = new HashSet<String>();
        for (VdbFileEntry entry : this.udfJarEntries) {
            String entryName = entry.getName().toString();
            udfJarNames.add(entryName);
        }
        return Collections.unmodifiableSet(udfJarNames);
    }

    public final Set<VdbFileEntry> getUserFileEntries() {
        return Collections.unmodifiableSet(this.fileEntries);
    }

    public final Map<String, String> getGeneralProperties() {
        return Collections.unmodifiableMap(this.generalPropertiesMap);
    }

    public final IFile getFile() {
        return this.file;
    }

    final File getFolder() {
        return this.folder;
    }

    JAXBContext getJaxbContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{VdbElement.class});
    }

    Schema getManifestSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return schemaFactory.newSchema(VdbElement.class.getResource("/vdb-deployer.xsd"));
    }

    public final Set<VdbModelEntry> getModelEntries() {
        HashSet<VdbModelEntry> entries = new HashSet<VdbModelEntry>();
        for (VdbModelEntry entry : this.modelEntries) {
            if (entry.isBuiltIn()) continue;
            entries.add(entry);
        }
        return Collections.unmodifiableSet(entries);
    }

    public final Collection<VdbImportVdbEntry> getImportVdbEntries() {
        return Collections.unmodifiableSet(this.importModelEntries);
    }

    private final Collection<File> convertEntries(Collection<? extends VdbEntry> entries) {
        ArrayList<File> entryFiles = new ArrayList<File>();
        for (VdbEntry vdbEntry : entries) {
            Path entryPath = new Path(String.valueOf(this.folder.getAbsolutePath()) + vdbEntry.getName());
            entryFiles.add(entryPath.toFile());
        }
        return Collections.unmodifiableCollection(entryFiles);
    }

    public final Collection<File> getModelFiles() {
        return this.convertEntries(this.getModelEntries());
    }

    public final Collection<File> getSchemaFiles() {
        return this.convertEntries(this.getSchemaEntries());
    }

    public final IPath getName() {
        return this.file.getFullPath();
    }

    private final VdbImportVdbEntry getImportVdbEntry(String vdbName) {
        for (VdbImportVdbEntry entry : this.getImportVdbEntries()) {
            if (!entry.getName().equalsIgnoreCase(vdbName)) continue;
            return entry;
        }
        return null;
    }

    private final void handleRemovedVdbModelEntry(String vdbModelEntryName) {
        Set<String> existingSet = this.modelToImportVdbMap.get(vdbModelEntryName);
        if (existingSet != null) {
            this.unregisterStaleImportVdbs(existingSet, (IProgressMonitor)new NullProgressMonitor());
            this.modelToImportVdbMap.remove(vdbModelEntryName);
        }
    }

    public final boolean isModified() {
        return this.modified.get();
    }

    public final boolean isPreview() {
        return this.preview;
    }

    public IMarker[] getProblems() throws Exception {
        return this.file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
    }

    public final Set<TranslatorOverride> getTranslators() {
        return Collections.unmodifiableSet(this.translatorOverrides);
    }

    public int getVersion() {
        return this.version;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public boolean isAutoGenerateRESTWAR() {
        return this.autoGenerateRESTWAR;
    }

    public String getValidationVersion() {
        return this.validationVersion;
    }

    public Date getValidationDateTime() {
        return this.validateDateTime;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public String getGssPattern() {
        return this.gssPattern;
    }

    public String getPasswordPattern() {
        return this.passwordPattern;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public final boolean isSynchronized() {
        for (VdbModelEntry vdbModelEntry : this.modelEntries) {
            if (vdbModelEntry.getSynchronization() != VdbEntry.Synchronization.NotSynchronized) continue;
            return false;
        }
        for (VdbEntry vdbEntry : this.getEntries()) {
            if (vdbEntry.getSynchronization() != VdbEntry.Synchronization.NotSynchronized) continue;
            return false;
        }
        return true;
    }

    void notifyChangeListeners(Object source, String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = null;
        if (!this.isPreview()) {
            for (PropertyChangeListener listener : this.listeners) {
                if (event == null) {
                    event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
                }
                listener.propertyChange(event);
            }
        }
    }

    public final void removeChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public final void registerImportVdbs(Collection<String> importVdbNames, String modelName, IProgressMonitor monitor) {
        Set<String> existingSet = this.modelToImportVdbMap.get(modelName);
        HashSet<String> staleImportVdbs = new HashSet<String>();
        if (existingSet == null) {
            existingSet = new HashSet<String>();
            this.modelToImportVdbMap.put(modelName, existingSet);
        } else {
            for (String importVdb : existingSet) {
                if (importVdbNames.contains(importVdb)) continue;
                staleImportVdbs.add(importVdb);
            }
        }
        existingSet.addAll(importVdbNames);
        this.unregisterStaleImportVdbs(staleImportVdbs, monitor);
        for (String importVdbName : importVdbNames) {
            if (this.getImportVdbEntry(importVdbName) != null) continue;
            this.addImportVdb(importVdbName);
        }
    }

    public final boolean removeAllowedLanguage(String name) {
        if (this.allowedLanguages.remove(name)) {
            this.setModified(this, "allowed-languages", name, null);
            return true;
        }
        return false;
    }

    public final void removeEntry(VdbEntry entry) {
        entry.dispose();
        if (entry instanceof VdbModelEntry) {
            String entryName = entry.getName().toString();
            this.modelEntries.remove(entry);
            this.synchronizeUdfJars(new HashSet<VdbFileEntry>());
            this.handleRemovedVdbModelEntry(entryName);
        } else if (entry instanceof VdbSchemaEntry) {
            String entryName = entry.getName().toString();
            this.schemaEntries.remove(entry);
            this.handleRemovedVdbModelEntry(entryName);
        } else {
            this.fileEntries.remove(entry);
            this.udfJarEntries.remove(entry);
        }
        this.setModified(this, "entryRemoved", entry, null);
    }

    public final void removeDataPolicy(VdbDataRole policy) {
        this.dataPolicyEntries.remove(policy);
        this.setModified(this, "dataPolicyRemoved", policy, null);
    }

    public final boolean removeTranslator(TranslatorOverride translatorOverride, IProgressMonitor monitor) {
        if (this.translatorOverrides.remove(translatorOverride)) {
            this.setModified(this, "translatorOverrideRemoved", translatorOverride, null);
            return true;
        }
        return false;
    }

    public final boolean removeImportVdb(VdbImportVdbEntry entry, IProgressMonitor monitor) {
        if (this.importModelEntries.remove(entry)) {
            this.setModified(this, "importVdbEntryRemoved", entry, null);
            return true;
        }
        return false;
    }

    public final void removeAllImportVdbs() {
        ArrayList<VdbImportVdbEntry> entries = new ArrayList<VdbImportVdbEntry>(this.importModelEntries);
        for (VdbImportVdbEntry entry : entries) {
            if (!this.importModelEntries.remove(entry)) continue;
            this.setModified(this, "importVdbEntryRemoved", entry, null);
        }
    }

    public final boolean removeGeneralProperty(String key, String value) {
        if (this.generalPropertiesMap.remove(key) != null) {
            this.setModified(this, "generalProperty", value, null);
            return true;
        }
        return false;
    }

    public final void save(final IProgressMonitor monitor) throws Exception {
        final VdbElement vdbElement = new VdbElement(this);
        final File tmpFolder = VdbPlugin.singleton().getStateLocation().toFile();
        OperationUtil.perform((OperationUtil.Unreliable)new OperationUtil.Unreliable(){
            ZipOutputStream out = null;

            public void doIfFails() {
            }

            public void finallyDo() throws Exception {
                if (this.out != null) {
                    this.out.close();
                }
            }

            public void tryToDo() throws Exception {
                IPath path = Vdb.this.file.getFullPath();
                File tmpArchive = File.createTempFile(path.removeFileExtension().toString(), String.valueOf('.') + path.getFileExtension(), tmpFolder);
                tmpArchive.getParentFile().mkdirs();
                this.out = new ZipOutputStream(new FileOutputStream(tmpArchive));
                ZipEntry zipEntry = new ZipEntry("META-INF/vdb.xml");
                zipEntry.setComment(Vdb.this.getDescription());
                this.out.putNextEntry(zipEntry);
                try {
                    Marshaller marshaller = Vdb.this.getJaxbContext().createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                    marshaller.setSchema(Vdb.this.getManifestSchema());
                    marshaller.marshal((Object)vdbElement, (OutputStream)this.out);
                }
                finally {
                    this.out.closeEntry();
                }
                IMarker[] iMarkerArray = Vdb.this.file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker iMarker = iMarkerArray[n2];
                    iMarker.delete();
                    ++n2;
                }
                for (VdbEntry vdbEntry : Vdb.this.getEntries()) {
                    vdbEntry.save(this.out, monitor);
                }
                for (VdbModelEntry vdbModelEntry : Vdb.this.modelEntries) {
                    vdbModelEntry.save(this.out, monitor);
                }
                this.out.close();
                this.out = null;
                File file = ModelerCore.getWorkspace().getRoot().findMember(Vdb.this.getName()).getLocation().toFile();
                if (!file.delete()) {
                    throw new Exception(VdbPlugin.UTIL.getString("unableToDelete", (Object)file));
                }
                if (!tmpArchive.renameTo(file)) {
                    throw new Exception(VdbPlugin.UTIL.getString("unableToRename", new Object[]{tmpArchive, file}));
                }
                if (Vdb.this.isModified()) {
                    Vdb.this.modified.set(false);
                }
                Vdb.this.notifyChangeListeners(this, "saved", null, null);
            }
        });
    }

    public final void setDescription(String description) {
        String oldDescription;
        if (StringUtilities.isEmpty((String)description)) {
            description = null;
        }
        if (StringUtilities.equals((String)description, (String)(oldDescription = this.description.get()))) {
            return;
        }
        this.description.set(description);
        this.setModified(this, "description", oldDescription, description);
    }

    void setModified(Object source, String propertyName, Object oldValue, Object newValue) {
        this.modified.set(true);
        this.notifyChangeListeners(source, propertyName, oldValue, newValue);
    }

    public final void setQueryTimeout(int valueInSeconds) {
        int oldTimeout = this.queryTimeout;
        if (oldTimeout == valueInSeconds) {
            return;
        }
        this.queryTimeout = valueInSeconds;
        this.setModified(this, "queryTimeout", oldTimeout, valueInSeconds);
    }

    public final void setVersion(int intVersion) {
        int oldVersion = this.version;
        if (oldVersion == intVersion) {
            return;
        }
        this.version = intVersion;
        this.setModified(this, "version", oldVersion, intVersion);
    }

    public final void setAutoGenerateRESTWAR(boolean autoGenerateRESTWAR) {
        boolean oldValue = this.autoGenerateRESTWAR;
        if (oldValue == autoGenerateRESTWAR) {
            return;
        }
        this.autoGenerateRESTWAR = autoGenerateRESTWAR;
        this.setModified(this, "autoGenerateRESTWAR", oldValue, autoGenerateRESTWAR);
    }

    public final void setValidationVersion(String valVersion) {
        String oldVersion = this.validationVersion;
        if (StringUtilities.equals((String)oldVersion, (String)valVersion)) {
            return;
        }
        this.validationVersion = valVersion;
        this.setModified(this, "generalProperty", oldVersion, valVersion);
    }

    public final void setValidationDateTime(Date dateTime) {
        Date oldDateTime = this.validateDateTime;
        if (oldDateTime != null && oldDateTime.equals(dateTime)) {
            return;
        }
        this.validateDateTime = dateTime;
        this.setModified(this, "generalProperty", oldDateTime, dateTime);
    }

    public final void setSecurityDomain(String newValue) {
        String old = this.securityDomain;
        if (old == null && (newValue == null || newValue.length() == 0) || newValue.equals(old)) {
            return;
        }
        this.securityDomain = newValue.length() == 0 ? null : newValue;
        this.setModified(this, "securityDomain", old, newValue);
    }

    public final void setGssPattern(String newValue) {
        String old = this.gssPattern;
        if (old == null && (newValue == null || newValue.length() == 0) || newValue.equals(old)) {
            return;
        }
        this.gssPattern = newValue.length() == 0 ? null : newValue;
        this.setModified(this, "gssPattern", old, newValue);
    }

    public final void setPasswordPattern(String newValue) {
        String old = this.passwordPattern;
        if (old == null && (newValue == null || newValue.length() == 0) || newValue.equals(old)) {
            return;
        }
        this.passwordPattern = newValue.length() == 0 ? null : newValue;
        this.setModified(this, "passwordPattern", old, newValue);
    }

    public final void setAuthenticationType(String newValue) {
        String old = this.authenticationType;
        if (old == null && (newValue == null || newValue.length() == 0) || newValue.equals(old)) {
            return;
        }
        this.authenticationType = newValue.length() == 0 ? null : newValue;
        this.setModified(this, "authenticationType", old, newValue);
    }

    private final void synchronize(Collection<VdbEntry> entries, IProgressMonitor monitor) throws Exception {
        for (VdbEntry entry : entries) {
            if (entry.getSynchronization() != VdbEntry.Synchronization.NotSynchronized) continue;
            entry.synchronize(monitor);
        }
    }

    public final void synchronize(IProgressMonitor monitor) throws Exception {
        this.getBuilder().start();
        this.synchronize(new HashSet<VdbEntry>(this.modelEntries), monitor);
        this.synchronize(this.getEntries(), monitor);
        this.getBuilder().stop();
    }

    private final void unregisterStaleImportVdbs(Set<String> proposedStaleImportVdbs, IProgressMonitor monitor) {
        HashSet<String> actualStaleImportVdbs = new HashSet<String>();
        for (String importVdb : proposedStaleImportVdbs) {
            boolean keep = true;
            for (String modelName : this.modelToImportVdbMap.keySet()) {
                Set<String> importVdbSet = this.modelToImportVdbMap.get(modelName);
                if (!importVdbSet.contains(importVdb)) continue;
                keep = false;
                break;
            }
            if (keep) continue;
            actualStaleImportVdbs.add(importVdb);
        }
        for (String staleImportVdb : actualStaleImportVdbs) {
            VdbImportVdbEntry entry = this.getImportVdbEntry(staleImportVdb);
            if (entry == null) continue;
            this.removeImportVdb(entry, monitor);
        }
    }

    public VdbModelBuilder getBuilder() {
        return this.builder;
    }

    public static class Event {
        public static final String DESCRIPTION = "description";
        public static final String ENTRY_ADDED = "entryAdded";
        public static final String ENTRY_REMOVED = "entryRemoved";
        public static final String ENTRY_CHECKSUM = "entry.checksum";
        public static final String ENTRY_SYNCHRONIZATION = "entry.synchronization";
        public static final String ENTRY_DESCRIPTION = "entry.description";
        public static final String MODEL_VISIBLE = "modelentry.visible";
        public static final String MODEL_SOURCE_NAME = "modelentry.sourceName";
        public static final String MODEL_TRANSLATOR = "modelEntry.translator";
        public static final String MODEL_JNDI_NAME = "modelEntry.jndiName";
        public static final String MODEL_SOURCES = "modelEntry.sources";
        public static final String DATA_POLICY_ADDED = "dataPolicyAdded";
        public static final String DATA_POLICY_REMOVED = "dataPolicyRemoved";
        public static final String IMPORT_VDB_ENTRY_VERSION = "importVdbEntryVersion";
        public static final String IMPORT_VDB_ENTRY_DATA_POLICY = "importVdbEntryDataPolicies";
        public static final String IMPORT_VDB_ENTRY_ADDED = "importVdbEntryAdded";
        public static final String UDF_JARS_MODIFIED = "udfJarsModified";
        public static final String IMPORT_VDB_ENTRY_REMOVED = "importVdbEntryRemoved";
        public static final String CLOSED = "closed";
        public static final String SAVED = "saved";
        public static final String TRANSLATOR_OVERRIDE_ADDED = "translatorOverrideAdded";
        public static final String TRANSLATOR_PROPERTY = "translatorOverrideProperty";
        public static final String TRANSLATOR_OVERRIDE_REMOVED = "translatorOverrideRemoved";
        public static final String QUERY_TIMEOUT = "queryTimeout";
        public static final String VERSION = "version";
        public static final String AUTO_GENERATE_REST_WAR = "autoGenerateRESTWAR";
        public static final String GENERAL_PROPERTY = "generalProperty";
        public static final String ALLOWED_LANGUAGES = "allowed-languages";
        public static final String SECURITY_DOMAIN = "securityDomain";
        public static final String GSS_PATTERN = "gssPattern";
        public static final String PASSWORD_PATTERN = "passwordPattern";
        public static final String AUTHENTICATION_TYPE = "authenticationType";
    }

    public static class Xml {
        public static final String PREVIEW = "preview";
        public static final String QUERY_TIMEOUT = "query-timeout";
        public static final String AUTO_GENERATE_REST_WAR = "{http://teiid.org/rest}auto-generate";
        public static final String ALLOWED_LANGUAGES = "allowed-languages";
        public static final String VALIDATION_DATETIME = "validationDateTime";
        public static final String VALIDATION_VERSION = "validationVersion";
        public static final String SECURITY_DOMAIN = "security-domain";
        public static final String GSS_PATTERN = "gss-pattern";
        public static final String PASSWORD_PATTERN = "password-pattern";
        public static final String AUTHENTICATION_TYPE = "authentication-type";
        public static final String AUTHENTICATION_TYPE_GSS = "GSS";
        public static final String AUTHENTICATION_TYPE_USERPASSWORD = "USERPASSWORD";
    }
}

