/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.dnd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.List;
import org.jboss.tools.modeshape.jcr.ChildNodeDefinition;
import org.jboss.tools.modeshape.jcr.JcrModelObject;
import org.jboss.tools.modeshape.jcr.NodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.PropertyDefinition;
import org.jboss.tools.modeshape.jcr.ui.dnd.ChildNodeDefinitionTransfer;
import org.jboss.tools.modeshape.jcr.ui.dnd.JcrTransfer;
import org.jboss.tools.modeshape.jcr.ui.dnd.PropertyDefinitionTransfer;
import org.jboss.tools.modeshape.ui.UiUtils;

public final class NodeTypeDefinitionTransfer
extends JcrTransfer {
    private static NodeTypeDefinitionTransfer _instance;

    public static NodeTypeDefinitionTransfer get() {
        if (_instance == null) {
            _instance = new NodeTypeDefinitionTransfer();
        }
        return _instance;
    }

    private NodeTypeDefinitionTransfer() {
        super(NodeTypeDefinitionTransfer.class);
    }

    @Override
    protected Class<? extends JcrModelObject> getJcrModelObjectClass() {
        return NodeTypeDefinition.class;
    }

    @Override
    protected JcrModelObject readFromStream(DataInputStream inStream) throws Exception {
        int childNodeDefnsCount;
        int propDefnsCount;
        NodeTypeDefinition nodeTypeDefn = new NodeTypeDefinition();
        nodeTypeDefn.setName(inStream.readUTF());
        nodeTypeDefn.setComment(inStream.readUTF());
        nodeTypeDefn.setAbstract(inStream.readBoolean());
        nodeTypeDefn.setMixin(inStream.readBoolean());
        nodeTypeDefn.setOrderableChildNodes(inStream.readBoolean());
        nodeTypeDefn.setQueryable(inStream.readBoolean());
        nodeTypeDefn.setPrimaryItemName(inStream.readUTF());
        int superTypesCount = inStream.readInt();
        if (superTypesCount != 0) {
            int superTypeIndex = 0;
            while (superTypeIndex < superTypesCount) {
                nodeTypeDefn.addSuperType(inStream.readUTF());
                ++superTypeIndex;
            }
        }
        if ((propDefnsCount = inStream.readInt()) != 0) {
            PropertyDefinitionTransfer propTransfer = PropertyDefinitionTransfer.get();
            int propDefnIndex = 0;
            while (propDefnIndex < propDefnsCount) {
                JcrModelObject propDefn = propTransfer.readFromStream(inStream);
                assert (propDefn instanceof PropertyDefinition);
                nodeTypeDefn.addPropertyDefinition((PropertyDefinition)propDefn);
                ++propDefnIndex;
            }
        }
        if ((childNodeDefnsCount = inStream.readInt()) != 0) {
            ChildNodeDefinitionTransfer propTransfer = ChildNodeDefinitionTransfer.get();
            int childNodeDefnIndex = 0;
            while (childNodeDefnIndex < childNodeDefnsCount) {
                JcrModelObject childNodeDefn = propTransfer.readFromStream(inStream);
                assert (childNodeDefn instanceof ChildNodeDefinition);
                nodeTypeDefn.addChildNodeDefinition((ChildNodeDefinition)childNodeDefn);
                ++childNodeDefnIndex;
            }
        }
        return nodeTypeDefn;
    }

    @Override
    protected void writeToStream(JcrModelObject jcrModelObject, DataOutputStream outStream) throws Exception {
        int length;
        assert (jcrModelObject instanceof NodeTypeDefinition);
        NodeTypeDefinition nodeTypeDefn = (NodeTypeDefinition)jcrModelObject;
        outStream.writeUTF(UiUtils.ensureNotNull((String)nodeTypeDefn.getName()));
        outStream.writeUTF(UiUtils.ensureNotNull((String)nodeTypeDefn.getComment()));
        outStream.writeBoolean(nodeTypeDefn.isAbstract());
        outStream.writeBoolean(nodeTypeDefn.isMixin());
        outStream.writeBoolean(nodeTypeDefn.hasOrderableChildNodes());
        outStream.writeBoolean(nodeTypeDefn.isQueryable());
        outStream.writeUTF(UiUtils.ensureNotNull((String)nodeTypeDefn.getPrimaryItemName()));
        String[] superTypes = nodeTypeDefn.getDeclaredSupertypeNames();
        if (superTypes == null || superTypes.length == 0) {
            outStream.writeInt(0);
        } else {
            outStream.writeInt(superTypes.length);
            String[] stringArray = superTypes;
            int n = superTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String superType = stringArray[n2];
                outStream.writeUTF(superType);
                ++n2;
            }
        }
        List propertyDefinitions = nodeTypeDefn.getPropertyDefinitions();
        if (propertyDefinitions.isEmpty()) {
            outStream.writeInt(0);
        } else {
            PropertyDefinitionTransfer propTransfer = PropertyDefinitionTransfer.get();
            length = propertyDefinitions.size();
            outStream.writeInt(length);
            for (PropertyDefinition propDefn : propertyDefinitions) {
                propTransfer.writeToStream((JcrModelObject)propDefn, outStream);
            }
        }
        List childNodeDefinitions = nodeTypeDefn.getChildNodeDefinitions();
        if (childNodeDefinitions.isEmpty()) {
            outStream.writeInt(0);
        } else {
            ChildNodeDefinitionTransfer childNodeTransfer = ChildNodeDefinitionTransfer.get();
            length = childNodeDefinitions.size();
            outStream.writeInt(length);
            for (ChildNodeDefinition childNodeDefn : childNodeDefinitions) {
                childNodeTransfer.writeToStream((JcrModelObject)childNodeDefn, outStream);
            }
        }
    }
}

