/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.cnd;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.jboss.tools.modeshape.jcr.ItemOwnerProvider;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.MultiValidationStatus;
import org.jboss.tools.modeshape.jcr.PropertyDefinition;
import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.ValidationStatus;
import org.jboss.tools.modeshape.jcr.attributes.OnParentVersion;
import org.jboss.tools.modeshape.jcr.attributes.PropertyType;
import org.jboss.tools.modeshape.jcr.attributes.QueryOperators;
import org.jboss.tools.modeshape.jcr.cnd.CndValidator;
import org.jboss.tools.modeshape.jcr.cnd.CommentedCndElement;
import org.jboss.tools.modeshape.jcr.ui.Activator;
import org.jboss.tools.modeshape.jcr.ui.JcrUiConstants;
import org.jboss.tools.modeshape.jcr.ui.JcrUiUtils;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndMessages;
import org.jboss.tools.modeshape.jcr.ui.cnd.QualifiedNameEditor;
import org.jboss.tools.modeshape.jcr.ui.cnd.StringValueEditorDialog;
import org.jboss.tools.modeshape.ui.UiMessages;
import org.jboss.tools.modeshape.ui.UiUtils;
import org.jboss.tools.modeshape.ui.actions.DelegateAction;
import org.jboss.tools.modeshape.ui.forms.ErrorMessage;
import org.jboss.tools.modeshape.ui.forms.FormUtils;
import org.jboss.tools.modeshape.ui.forms.MessageFormDialog;

final class PropertyDialog
extends FormDialog {
    private IAction addDefaultValue;
    private IAction addValueConstraint;
    private Button btnOk;
    private final ErrorMessage defaultValuesError;
    private TableViewer defaultValuesViewer;
    private IAction deleteDefaultValue;
    private IAction deleteValueConstraint;
    private IAction editDefaultValue;
    private IAction editValueConstraint;
    private final Collection<String> existingNamespacePrefixes;
    private final Collection<QualifiedName> existingPropertyNames;
    private QualifiedNameEditor nameEditor;
    private final ErrorMessage nameError;
    private final boolean nodeTypeQueryable;
    private PropertyDefinition originalProperty;
    private PropertyDefinition propertyBeingEdited;
    private ScrolledForm scrolledForm;
    private final ErrorMessage valueConstraintsError;
    private TableViewer valueConstraintsViewer;

    public PropertyDialog(Shell parentShell, ItemOwnerProvider ownerProvider, Collection<QualifiedName> existingPropertyNames, Collection<String> existingNamespacePrefixes, boolean nodeTypeQueryable) {
        super(parentShell);
        this.existingPropertyNames = existingPropertyNames == null ? Collections.emptyList() : new ArrayList<QualifiedName>(existingPropertyNames);
        this.existingNamespacePrefixes = existingNamespacePrefixes == null ? Collections.emptyList() : new ArrayList<String>(existingNamespacePrefixes);
        this.nodeTypeQueryable = nodeTypeQueryable;
        this.defaultValuesError = new ErrorMessage();
        this.nameError = new ErrorMessage();
        this.valueConstraintsError = new ErrorMessage();
        this.propertyBeingEdited = new PropertyDefinition(ownerProvider);
    }

    public PropertyDialog(Shell parentShell, ItemOwnerProvider ownerProvider, Collection<QualifiedName> existingPropertyNames, Collection<String> existingNamespacePrefixes, boolean nodeTypeQueryable, PropertyDefinition propertyDefinitionBeingEdited) {
        this(parentShell, ownerProvider, existingPropertyNames, existingNamespacePrefixes, nodeTypeQueryable);
        Utils.verifyIsNotNull((Object)propertyDefinitionBeingEdited, (String)"propertyDefinitionBeingEdited");
        this.originalProperty = propertyDefinitionBeingEdited;
        this.propertyBeingEdited = PropertyDefinition.copy((PropertyDefinition)this.originalProperty, (ItemOwnerProvider)ownerProvider);
        if (!Utils.isEmpty((String)this.propertyBeingEdited.getName())) {
            this.existingPropertyNames.remove(this.propertyBeingEdited.getQualifiedName());
        }
    }

    PropertyDefinition accessModel() {
        return this.propertyBeingEdited;
    }

    Collection<String> accessExistingNamespacePrefixes() {
        return this.existingNamespacePrefixes;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CndMessages.propertyDialogTitle);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    void createDefaultValuesActions() {
        this.addDefaultValue = new Action(""){

            public void run() {
                PropertyDialog.this.handleAddDefaultValue();
            }
        };
        this.addDefaultValue.setToolTipText(CndMessages.addDefaultValueToolTip);
        this.addDefaultValue.setImageDescriptor(JcrUiUtils.getNewImageDescriptor());
        this.deleteDefaultValue = new Action(""){

            public void run() {
                PropertyDialog.this.handleDeleteDefaultValue();
            }
        };
        this.deleteDefaultValue.setEnabled(false);
        this.deleteDefaultValue.setToolTipText(CndMessages.deleteDefaultValueToolTip);
        this.deleteDefaultValue.setImageDescriptor(JcrUiUtils.getDeleteImageDescriptor());
        this.editDefaultValue = new Action(""){

            public void run() {
                PropertyDialog.this.handleEditDefaultValue();
            }
        };
        this.editDefaultValue.setEnabled(false);
        this.editDefaultValue.setToolTipText(CndMessages.editDefaultValueToolTip);
        this.editDefaultValue.setImageDescriptor(JcrUiUtils.getEditImageDescriptor());
    }

    private void createDefaultValuesViewer(Table defaultValuesTable) {
        this.defaultValuesViewer = new TableViewer(defaultValuesTable);
        this.defaultValuesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.defaultValuesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                PropertyDefinition propDefn = PropertyDialog.this.accessModel();
                return propDefn.getDefaultValuesAsStrings().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.defaultValuesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PropertyDialog.this.handleEditDefaultValue();
            }
        });
        this.defaultValuesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PropertyDialog.this.handleDefaultValueSelected();
            }
        });
    }

    protected void createFormContent(IManagedForm managedForm) {
        String currentOpv;
        int index;
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setText(this.isEditMode() ? CndMessages.propertyDialogEditTitle : CndMessages.propertyDialogCreateTitle);
        this.scrolledForm.setImage(Activator.getSharedInstance().getImage("icons/cnd-editor-16x.png"));
        this.scrolledForm.setMessage(CndMessages.propertyDialogMsg, 0);
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.scrolledForm.getForm());
        Composite body = this.scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout(2, false));
        Composite topContainer = toolkit.createComposite(body);
        topContainer.setLayout((Layout)new GridLayout(2, false));
        topContainer.setLayoutData((Object)new GridData(4, 128, true, false));
        ((GridData)topContainer.getLayoutData()).horizontalSpan = 2;
        toolkit.paintBordersFor(topContainer);
        this.nameEditor = new QualifiedNameEditor(topContainer, 0, toolkit, Messages.propertyDefinitionName, this.existingNamespacePrefixes, this.propertyBeingEdited.getQualifiedName());
        ((GridData)this.nameEditor.getLayoutData()).horizontalSpan = 2;
        this.nameEditor.setAllowsResidualName(true);
        this.nameEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                PropertyDialog.this.handleNameChanged(e.text);
            }
        });
        this.nameError.setControl((Control)this.nameEditor);
        Label lblType = toolkit.createLabel(topContainer, CndMessages.typeLabel, 0);
        lblType.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        CCombo cbxType = new CCombo(topContainer, 0x800808);
        toolkit.adapt((Control)cbxType, true, false);
        cbxType.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)cbxType.getLayoutData()).heightHint = cbxType.getItemHeight() + 4;
        cbxType.setToolTipText(CndMessages.propertyTypeToolTip);
        PropertyType[] propertyTypeArray = PropertyType.values();
        int n = propertyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyType type = propertyTypeArray[n2];
            if (type != PropertyType.VARIANT) {
                cbxType.add(type.toString());
            }
            ++n2;
        }
        if (this.isEditMode()) {
            String currentType = this.propertyBeingEdited.getType().toString();
            int index2 = cbxType.indexOf(currentType);
            if (index2 == -1) {
                cbxType.setText(PropertyType.DEFAULT_VALUE.toString());
            } else {
                cbxType.select(index2);
            }
        } else {
            cbxType.setText(PropertyType.DEFAULT_VALUE.toString());
        }
        cbxType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newOpv = ((CCombo)e.widget).getText();
                PropertyDialog.this.handleTypeChanged(newOpv);
            }
        });
        Group attributesContainer = new Group(body, 32);
        attributesContainer.setText(CndMessages.attributesHeaderText);
        attributesContainer.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        attributesContainer.setLayoutData((Object)gd);
        toolkit.adapt((Composite)attributesContainer);
        toolkit.paintBordersFor((Composite)attributesContainer);
        Button btnAutocreated = toolkit.createButton((Composite)attributesContainer, CndMessages.autocreatedAttribute, 32);
        btnAutocreated.setBackground(attributesContainer.getBackground());
        if (this.isEditMode() && this.propertyBeingEdited.isAutoCreated()) {
            btnAutocreated.setSelection(true);
        }
        btnAutocreated.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyDialog.this.handleAutocreatedChanged(((Button)e.widget).getSelection());
            }
        });
        btnAutocreated.setToolTipText(CndMessages.autocreatedAttributeToolTip);
        Button btnMandatory = toolkit.createButton((Composite)attributesContainer, CndMessages.mandatoryAttribute, 32);
        btnMandatory.setBackground(attributesContainer.getBackground());
        if (this.isEditMode() && this.propertyBeingEdited.isMandatory()) {
            btnMandatory.setSelection(true);
        }
        btnMandatory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyDialog.this.handleMandatoryChanged(((Button)e.widget).getSelection());
            }
        });
        btnMandatory.setToolTipText(CndMessages.mandatoryAttributeToolTip);
        Button btnProtected = toolkit.createButton((Composite)attributesContainer, CndMessages.protectedAttribute, 32);
        btnProtected.setBackground(attributesContainer.getBackground());
        if (this.isEditMode() && this.propertyBeingEdited.isProtected()) {
            btnProtected.setSelection(true);
        }
        btnProtected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyDialog.this.handleProtectedChanged(((Button)e.widget).getSelection());
            }
        });
        btnProtected.setToolTipText(CndMessages.protectedAttributeToolTip);
        Button btnMultiple = toolkit.createButton((Composite)attributesContainer, CndMessages.multipleAttribute, 32);
        btnMultiple.setBackground(attributesContainer.getBackground());
        if (this.isEditMode() && this.propertyBeingEdited.isMultiple()) {
            btnMultiple.setSelection(true);
        }
        btnMultiple.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyDialog.this.handleMultipleChanged(((Button)e.widget).getSelection());
            }
        });
        btnMultiple.setToolTipText(CndMessages.multipleAttributeToolTip);
        Button btnNoFullText = toolkit.createButton((Composite)attributesContainer, CndMessages.noFullTextAttribute, 32);
        btnNoFullText.setBackground(attributesContainer.getBackground());
        if (this.isEditMode() && !this.propertyBeingEdited.isFullTextSearchable()) {
            btnNoFullText.setSelection(true);
        }
        btnNoFullText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyDialog.this.handleNoFullTextChanged(((Button)e.widget).getSelection());
            }
        });
        btnNoFullText.setToolTipText(CndMessages.noFullTextAttributeToolTip);
        Button btnNoQueryOrder = toolkit.createButton((Composite)attributesContainer, CndMessages.noQueryOrderAttribute, 32);
        btnNoQueryOrder.setBackground(attributesContainer.getBackground());
        if (this.isEditMode() && !this.propertyBeingEdited.isQueryOrderable()) {
            btnNoQueryOrder.setSelection(true);
        }
        btnNoQueryOrder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyDialog.this.handleNoQueryOrderChanged(((Button)e.widget).getSelection());
            }
        });
        btnNoQueryOrder.setToolTipText(CndMessages.noQueryOrderAttributeToolTip);
        Composite opvContainer = toolkit.createComposite((Composite)attributesContainer);
        opvContainer.setLayout((Layout)new GridLayout(2, false));
        ((GridLayout)opvContainer.getLayout()).marginHeight = 0;
        ((GridLayout)opvContainer.getLayout()).marginWidth = 0;
        opvContainer.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ((GridData)opvContainer.getLayoutData()).horizontalSpan = 2;
        toolkit.paintBordersFor(opvContainer);
        Label lblOpv = toolkit.createLabel(opvContainer, CndMessages.onParentVersionLabel, 0);
        lblOpv.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        CCombo cbxOpvs = new CCombo(opvContainer, 0x800808);
        cbxOpvs.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ((GridData)cbxOpvs.getLayoutData()).heightHint = cbxOpvs.getItemHeight() + 4;
        cbxOpvs.setToolTipText(CndMessages.onParentVersionToolTip);
        toolkit.adapt((Control)cbxOpvs, true, false);
        OnParentVersion[] onParentVersionArray = OnParentVersion.values();
        int n3 = onParentVersionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            OnParentVersion opv = onParentVersionArray[n4];
            if (opv != OnParentVersion.VARIANT) {
                cbxOpvs.add(opv.toString());
            }
            ++n4;
        }
        if (this.isEditMode() && (index = cbxOpvs.indexOf(currentOpv = OnParentVersion.findUsingJcrValue((int)this.propertyBeingEdited.getOnParentVersion()).toString())) != -1) {
            cbxOpvs.select(index);
        }
        cbxOpvs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newOpv = ((CCombo)e.widget).getText();
                PropertyDialog.this.handleOnParentVersionChanged(newOpv);
            }
        });
        if (this.nodeTypeQueryable) {
            List<String> supportedQueryOps = Arrays.asList(this.propertyBeingEdited.getAvailableQueryOperators());
            Composite queryOpsContainer = toolkit.createComposite((Composite)attributesContainer);
            queryOpsContainer.setLayout((Layout)new GridLayout(7, false));
            ((GridLayout)queryOpsContainer.getLayout()).marginHeight = 0;
            ((GridLayout)queryOpsContainer.getLayout()).marginWidth = 0;
            queryOpsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            toolkit.paintBordersFor(queryOpsContainer);
            toolkit.createLabel(queryOpsContainer, CndMessages.queryOperatorsLabel);
            Button btnEquals = toolkit.createButton(queryOpsContainer, QueryOperators.QueryOperator.EQUALS.toString(), 32);
            btnEquals.setBackground(attributesContainer.getBackground());
            if (supportedQueryOps.contains(btnEquals.getText())) {
                btnEquals.setSelection(true);
            }
            btnEquals.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button btn = (Button)e.widget;
                    PropertyDialog.this.handleQueryOperatorChanged(btn.getText(), btn.getSelection());
                }
            });
            btnEquals.setToolTipText(CndMessages.equalsOperatorToolTip);
            Button btnNotEquals = toolkit.createButton(queryOpsContainer, QueryOperators.QueryOperator.NOT_EQUALS.toString(), 32);
            btnNotEquals.setBackground(attributesContainer.getBackground());
            if (supportedQueryOps.contains(btnNotEquals.getText())) {
                btnNotEquals.setSelection(true);
            }
            btnNotEquals.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button btn = (Button)e.widget;
                    PropertyDialog.this.handleQueryOperatorChanged(btn.getText(), btn.getSelection());
                }
            });
            btnNotEquals.setToolTipText(CndMessages.notEqualsOperatorToolTip);
            Button btnGreaterThan = toolkit.createButton(queryOpsContainer, QueryOperators.QueryOperator.GREATER_THAN.toString(), 32);
            btnGreaterThan.setBackground(attributesContainer.getBackground());
            if (supportedQueryOps.contains(btnGreaterThan.getText())) {
                btnGreaterThan.setSelection(true);
            }
            btnGreaterThan.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button btn = (Button)e.widget;
                    PropertyDialog.this.handleQueryOperatorChanged(btn.getText(), btn.getSelection());
                }
            });
            btnGreaterThan.setToolTipText(CndMessages.greaterThanOperatorToolTip);
            Button btnLessThan = toolkit.createButton(queryOpsContainer, QueryOperators.QueryOperator.LESS_THAN.toString(), 32);
            btnLessThan.setBackground(attributesContainer.getBackground());
            if (supportedQueryOps.contains(btnLessThan.getText())) {
                btnLessThan.setSelection(true);
            }
            btnLessThan.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button btn = (Button)e.widget;
                    PropertyDialog.this.handleQueryOperatorChanged(btn.getText(), btn.getSelection());
                }
            });
            btnLessThan.setToolTipText(CndMessages.lessThanOperatorToolTip);
            Button btnGreaterThanEquals = toolkit.createButton(queryOpsContainer, QueryOperators.QueryOperator.GREATER_THAN_EQUALS.toString(), 32);
            btnGreaterThanEquals.setBackground(attributesContainer.getBackground());
            if (supportedQueryOps.contains(btnGreaterThanEquals.getText())) {
                btnGreaterThanEquals.setSelection(true);
            }
            btnGreaterThanEquals.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button btn = (Button)e.widget;
                    PropertyDialog.this.handleQueryOperatorChanged(btn.getText(), btn.getSelection());
                }
            });
            btnGreaterThanEquals.setToolTipText(CndMessages.greaterThanEqualsOperatorToolTip);
            Button btnLessThanEquals = toolkit.createButton(queryOpsContainer, QueryOperators.QueryOperator.LESS_THAN_EQUALS.toString(), 32);
            btnLessThanEquals.setBackground(attributesContainer.getBackground());
            if (supportedQueryOps.contains(btnLessThanEquals.getText())) {
                btnLessThanEquals.setSelection(true);
            }
            btnLessThanEquals.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button btn = (Button)e.widget;
                    PropertyDialog.this.handleQueryOperatorChanged(btn.getText(), btn.getSelection());
                }
            });
            btnLessThanEquals.setToolTipText(CndMessages.lessThanEqualsOperatorToolTip);
        }
        Composite bottomContainer = toolkit.createComposite(body);
        bottomContainer.setLayout((Layout)new GridLayout(2, false));
        bottomContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.paintBordersFor(bottomContainer);
        Composite defaultValuesContainer = toolkit.createComposite(bottomContainer);
        defaultValuesContainer.setLayout((Layout)new GridLayout(2, false));
        defaultValuesContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.paintBordersFor(defaultValuesContainer);
        Label label = toolkit.createLabel(defaultValuesContainer, CndMessages.defaultValuesLabel);
        label.setLayoutData((Object)new GridData(1, 128, false, false));
        this.createDefaultValuesActions();
        ToolBarManager toolBarManager = new ToolBarManager(0x800100);
        ToolBar toolBar = toolBarManager.createControl(defaultValuesContainer);
        toolBar.setLayoutData((Object)new GridData(131072, 128, false, false));
        toolkit.adapt((Composite)toolBar);
        Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolBar.setCursor(handCursor);
        toolBarManager.add(this.addDefaultValue);
        toolBarManager.add(this.editDefaultValue);
        toolBarManager.add(this.deleteDefaultValue);
        toolBarManager.update(true);
        Table table = FormUtils.createTable((FormToolkit)toolkit, (Composite)defaultValuesContainer);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        GridData gd2 = (GridData)table.getLayoutData();
        gd2.heightHint = table.getItemHeight() * 4;
        gd2.horizontalSpan = 2;
        gd2.widthHint = UiUtils.convertWidthInCharsToPixels((Control)table, (int)40);
        table.setToolTipText(CndMessages.defaultValuesToolTip);
        this.defaultValuesError.setControl((Control)table);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new DelegateAction(CndMessages.addDefaultValueMenuText, this.addDefaultValue));
        menuManager.add((IAction)new DelegateAction(CndMessages.editDefaultValueMenuText, this.editDefaultValue));
        menuManager.add((IAction)new DelegateAction(CndMessages.deleteDefaultValueMenuText, this.deleteDefaultValue));
        table.setMenu(menuManager.createContextMenu((Control)table));
        this.createDefaultValuesViewer(table);
        this.defaultValuesViewer.setInput((Object)this);
        Composite valueConstraintsContainer = toolkit.createComposite(bottomContainer);
        valueConstraintsContainer.setLayout((Layout)new GridLayout(2, false));
        valueConstraintsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.paintBordersFor(valueConstraintsContainer);
        label = toolkit.createLabel(valueConstraintsContainer, CndMessages.valueConstraintsLabel);
        label.setLayoutData((Object)new GridData(1, 128, false, false));
        this.createValueConstraintsActions();
        toolBarManager = new ToolBarManager(0x800100);
        toolBar = toolBarManager.createControl(valueConstraintsContainer);
        toolBar.setLayoutData((Object)new GridData(131072, 128, false, false));
        toolkit.adapt((Composite)toolBar);
        handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolBar.setCursor(handCursor);
        toolBarManager.add(this.addValueConstraint);
        toolBarManager.add(this.editValueConstraint);
        toolBarManager.add(this.deleteValueConstraint);
        toolBarManager.update(true);
        table = FormUtils.createTable((FormToolkit)toolkit, (Composite)valueConstraintsContainer);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        gd2 = (GridData)table.getLayoutData();
        gd2.heightHint = table.getItemHeight() * 4;
        gd2.horizontalSpan = 2;
        gd2.widthHint = UiUtils.convertWidthInCharsToPixels((Control)table, (int)40);
        table.setToolTipText(CndMessages.valueConstraintsToolTip);
        this.valueConstraintsError.setControl((Control)table);
        menuManager = new MenuManager();
        menuManager.add((IAction)new DelegateAction(CndMessages.addValueConstraintMenuText, this.addValueConstraint));
        menuManager.add((IAction)new DelegateAction(CndMessages.editValueConstraintMenuText, this.editValueConstraint));
        menuManager.add((IAction)new DelegateAction(CndMessages.deleteValueConstraintMenuText, this.deleteValueConstraint));
        table.setMenu(menuManager.createContextMenu((Control)table));
        this.createValueConstraintsViewer(table);
        this.valueConstraintsViewer.setInput((Object)this);
        Composite commentsContainer = toolkit.createComposite(bottomContainer);
        commentsContainer.setLayout((Layout)new GridLayout(2, false));
        commentsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)commentsContainer.getLayoutData()).horizontalSpan = 2;
        toolkit.paintBordersFor(commentsContainer);
        Label lblComment = toolkit.createLabel(commentsContainer, CndMessages.commentLabel, 0);
        lblComment.setLayoutData((Object)new GridData(16384, 128, false, false));
        Text txtComment = toolkit.createText(commentsContainer, null, 2818);
        txtComment.setToolTipText(CndMessages.commentedToolTip);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.verticalIndent += ((GridLayout)body.getLayout()).verticalSpacing;
        gd3.heightHint = txtComment.getLineHeight() * 3;
        gd3.widthHint = UiUtils.convertWidthInCharsToPixels((Control)txtComment, (int)80);
        txtComment.setLayoutData((Object)gd3);
        if (this.isEditMode() && !Utils.isEmpty((String)this.propertyBeingEdited.getComment())) {
            txtComment.setText(CommentedCndElement.Helper.removeCommentCharacters((String)this.propertyBeingEdited.getComment()));
        }
        txtComment.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertyDialog.this.handleCommentChanged(((Text)e.widget).getText());
            }
        });
        this.propertyBeingEdited.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                PropertyDialog.this.handlePropertyChanged(e);
            }
        });
        this.validateAttributes();
        this.validateName();
        this.validateDefaultValues();
        this.validateValueConstraints();
        this.validateType();
        IWorkbenchHelpSystem helpSystem = Activator.getSharedInstance().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.scrolledForm, JcrUiConstants.HelpContexts.PROPERTY_EDITOR_HELP_CONTEXT);
    }

    void createValueConstraintsActions() {
        this.addValueConstraint = new Action(""){

            public void run() {
                PropertyDialog.this.handleAddValueConstraint();
            }
        };
        this.addValueConstraint.setToolTipText(CndMessages.addValueConstraintToolTip);
        this.addValueConstraint.setImageDescriptor(JcrUiUtils.getNewImageDescriptor());
        this.deleteValueConstraint = new Action(""){

            public void run() {
                PropertyDialog.this.handleDeleteValueConstraint();
            }
        };
        this.deleteValueConstraint.setEnabled(false);
        this.deleteValueConstraint.setToolTipText(CndMessages.deleteValueConstraintToolTip);
        this.deleteValueConstraint.setImageDescriptor(JcrUiUtils.getDeleteImageDescriptor());
        this.editValueConstraint = new Action(""){

            public void run() {
                PropertyDialog.this.handleEditValueConstraint();
            }
        };
        this.editValueConstraint.setEnabled(false);
        this.editValueConstraint.setToolTipText(CndMessages.editValueConstraintToolTip);
        this.editValueConstraint.setImageDescriptor(JcrUiUtils.getEditImageDescriptor());
    }

    private void createValueConstraintsViewer(Table valueConstraintsTable) {
        this.valueConstraintsViewer = new TableViewer(valueConstraintsTable);
        this.valueConstraintsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.valueConstraintsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                PropertyDefinition propDefn = PropertyDialog.this.accessModel();
                Object[] valueConstraints = propDefn.getValueConstraints();
                if (valueConstraints == null) {
                    return Utils.EMPTY_OBJECT_ARRAY;
                }
                return valueConstraints;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.valueConstraintsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PropertyDialog.this.handleEditValueConstraint();
            }
        });
        this.valueConstraintsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PropertyDialog.this.handleValueConstraintSelected();
            }
        });
    }

    public PropertyDefinition getPropertyDefinition() {
        return this.propertyBeingEdited;
    }

    String getSelectedDefaultValue() {
        IStructuredSelection selection = (IStructuredSelection)this.defaultValuesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        assert (selection.size() == 1) : "default values viewer should not allow multiple selections";
        assert (selection.getFirstElement() instanceof String) : "selection was not a string";
        return (String)selection.getFirstElement();
    }

    String getSelectedValueConstraint() {
        IStructuredSelection selection = (IStructuredSelection)this.valueConstraintsViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        assert (selection.size() == 1) : "value constraints viewer should not allow multiple selections";
        assert (selection.getFirstElement() instanceof String) : "selection was not a string";
        return (String)selection.getFirstElement();
    }

    void handleAddDefaultValue() {
        String newDefaultValue;
        final PropertyDefinition propDefn = this.getPropertyDefinition();
        final ArrayList currentDefaultValues = new ArrayList(propDefn.getDefaultValuesAsStrings());
        StringValueEditorDialog dialog = new StringValueEditorDialog(this.getShell()){

            @Override
            protected StringValueEditorDialog.Settings getSettings() {
                StringValueEditorDialog.Settings settings = new StringValueEditorDialog.Settings();
                settings.acceptMessage = CndMessages.acceptDefaultValueDialogMsg;
                settings.initialMessage = CndMessages.defaultValueDialogMsg;
                settings.labelText = CndMessages.defaultValueLabel;
                settings.messageAreaTitle = CndMessages.defaultValueDialogCreateMsg;
                settings.valueToolTip = CndMessages.defaultValueToolTip;
                settings.validator = new StringValueEditorDialog.Validator(){

                    @Override
                    public ValidationStatus validate(String newValue) {
                        ValidationStatus status = CndValidator.isValid((String)newValue, (PropertyType)propDefn.getType(), (String)propDefn.getName(), PropertyDialog.this.accessExistingNamespacePrefixes());
                        if (status.isError()) {
                            return status;
                        }
                        currentDefaultValues.add(newValue);
                        MultiValidationStatus validationStatus = CndValidator.validateDefaultValues((String)propDefn.getName(), (PropertyType)propDefn.getType(), (Collection)currentDefaultValues, PropertyDialog.this.accessExistingNamespacePrefixes());
                        currentDefaultValues.remove(newValue);
                        return validationStatus;
                    }
                };
                return settings;
            }
        };
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0 && !this.propertyBeingEdited.addDefaultValue(newDefaultValue = dialog.getValue())) {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorAddingDefaultValue, (Object)newDefaultValue));
        }
    }

    void handleAddValueConstraint() {
        String newValueConstraint;
        final PropertyDefinition propDefn = this.getPropertyDefinition();
        final ArrayList<String> currentConstraints = new ArrayList<String>(Arrays.asList(propDefn.getValueConstraints()));
        StringValueEditorDialog dialog = new StringValueEditorDialog(this.getShell()){

            @Override
            protected StringValueEditorDialog.Settings getSettings() {
                StringValueEditorDialog.Settings settings = new StringValueEditorDialog.Settings();
                settings.acceptMessage = CndMessages.acceptValueConstraintDialogMsg;
                settings.initialMessage = CndMessages.valueConstraintDialogMsg;
                settings.labelText = CndMessages.valueConstraintLabel;
                settings.messageAreaTitle = CndMessages.valueConstraintDialogCreateMsg;
                settings.valueToolTip = CndMessages.valueConstraintToolTip;
                settings.validator = new StringValueEditorDialog.Validator(){

                    @Override
                    public ValidationStatus validate(String newValue) {
                        ValidationStatus status = CndValidator.validateValueConstraint((String)newValue);
                        if (status.isError()) {
                            return status;
                        }
                        currentConstraints.add(newValue);
                        MultiValidationStatus validationStatus = CndValidator.validateValueConstraints((String)propDefn.getName(), (Collection)currentConstraints);
                        currentConstraints.remove(newValue);
                        return validationStatus;
                    }
                };
                return settings;
            }
        };
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0 && !this.propertyBeingEdited.addValueConstraint(newValueConstraint = dialog.getValue())) {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorAddingValueConstraint, (Object)newValueConstraint));
        }
    }

    void handleAutocreatedChanged(boolean newAutocreated) {
        this.propertyBeingEdited.setAutoCreated(newAutocreated);
    }

    void handleCommentChanged(String newComment) {
        this.propertyBeingEdited.setComment(newComment);
    }

    void handleDefaultValueSelected() {
        boolean enable;
        boolean bl = enable = this.getSelectedDefaultValue() != null;
        if (this.editDefaultValue.isEnabled() != enable) {
            this.editDefaultValue.setEnabled(enable);
        }
        if (this.deleteDefaultValue.isEnabled() != enable) {
            this.deleteDefaultValue.setEnabled(enable);
        }
    }

    void handleDeleteDefaultValue() {
        assert (this.getSelectedDefaultValue() != null) : "Delete default value handler called and there is no default value selected";
        String defaultValue = this.getSelectedDefaultValue();
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)CndMessages.deleteDefaultValueDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.deleteDefaultValueDialogMessage, (Object)defaultValue)) && !this.propertyBeingEdited.removeDefaultValue(defaultValue)) {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorDeletingDefaultValue, (Object)defaultValue));
        }
    }

    void handleDeleteValueConstraint() {
        assert (this.getSelectedValueConstraint() != null) : "Delete value constraint handler called and there is no value constraint selected";
        String valueConstraint = this.getSelectedValueConstraint();
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)CndMessages.deleteValueConstraintDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.deleteValueConstraintDialogMessage, (Object)valueConstraint)) && !this.propertyBeingEdited.removeValueConstraint(valueConstraint)) {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorDeletingValueConstraint, (Object)valueConstraint));
        }
    }

    void handleEditDefaultValue() {
        assert (this.getSelectedDefaultValue() != null) : "Edit default value handler called but there is not a default value selected";
        final PropertyDefinition propDefn = this.getPropertyDefinition();
        final String selectedDefaultValue = this.getSelectedDefaultValue();
        final ArrayList currentDefaultValues = new ArrayList(propDefn.getDefaultValuesAsStrings());
        currentDefaultValues.remove(selectedDefaultValue);
        StringValueEditorDialog dialog = new StringValueEditorDialog(this.getShell()){

            @Override
            protected StringValueEditorDialog.Settings getSettings() {
                StringValueEditorDialog.Settings settings = new StringValueEditorDialog.Settings();
                settings.acceptMessage = CndMessages.acceptDefaultValueDialogMsg;
                settings.initialMessage = CndMessages.defaultValueDialogMsg;
                settings.labelText = CndMessages.defaultValueLabel;
                settings.messageAreaTitle = CndMessages.defaultValueDialogEditMsg;
                settings.valueToolTip = CndMessages.defaultValueToolTip;
                settings.valueBeingEdited = selectedDefaultValue;
                settings.validator = new StringValueEditorDialog.Validator(){

                    @Override
                    public ValidationStatus validate(String newValue) {
                        ValidationStatus status = CndValidator.isValid((String)newValue, (PropertyType)propDefn.getType(), (String)propDefn.getName(), PropertyDialog.this.accessExistingNamespacePrefixes());
                        if (status.isError()) {
                            return status;
                        }
                        currentDefaultValues.add(newValue);
                        MultiValidationStatus validationStatus = CndValidator.validateDefaultValues((String)propDefn.getName(), (PropertyType)propDefn.getType(), (Collection)currentDefaultValues, PropertyDialog.this.accessExistingNamespacePrefixes());
                        currentDefaultValues.remove(newValue);
                        return validationStatus;
                    }
                };
                return settings;
            }
        };
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            String modifiedDefaultValue = dialog.getValue();
            boolean removed = false;
            boolean added = false;
            if (this.propertyBeingEdited.removeDefaultValue(selectedDefaultValue)) {
                removed = true;
                if (this.propertyBeingEdited.addDefaultValue(modifiedDefaultValue)) {
                    added = true;
                }
            }
            if (!removed || !added) {
                MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorEditingDefaultValue, (Object[])new Object[]{modifiedDefaultValue, removed, added}));
            }
        }
    }

    void handleEditValueConstraint() {
        assert (this.getSelectedValueConstraint() != null) : "Edit value constraint handler called but there is not a value constraint selected";
        final PropertyDefinition propDefn = this.getPropertyDefinition();
        final String selectedValueConstraint = this.getSelectedValueConstraint();
        final ArrayList<String> currentConstraints = new ArrayList<String>(Arrays.asList(propDefn.getValueConstraints()));
        currentConstraints.remove(selectedValueConstraint);
        StringValueEditorDialog dialog = new StringValueEditorDialog(this.getShell()){

            @Override
            protected StringValueEditorDialog.Settings getSettings() {
                StringValueEditorDialog.Settings settings = new StringValueEditorDialog.Settings();
                settings.acceptMessage = CndMessages.acceptValueConstraintDialogMsg;
                settings.initialMessage = CndMessages.valueConstraintDialogMsg;
                settings.labelText = CndMessages.valueConstraintLabel;
                settings.messageAreaTitle = CndMessages.valueConstraintDialogEditMsg;
                settings.valueToolTip = CndMessages.valueConstraintToolTip;
                settings.valueBeingEdited = selectedValueConstraint;
                settings.validator = new StringValueEditorDialog.Validator(){

                    @Override
                    public ValidationStatus validate(String newValue) {
                        ValidationStatus status = CndValidator.validateValueConstraint((String)newValue);
                        if (status.isError()) {
                            return status;
                        }
                        currentConstraints.add(newValue);
                        MultiValidationStatus validationStatus = CndValidator.validateValueConstraints((String)propDefn.getName(), (Collection)currentConstraints);
                        currentConstraints.remove(newValue);
                        return validationStatus;
                    }
                };
                return settings;
            }
        };
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            String modifiedValueConstraint = dialog.getValue();
            boolean removed = false;
            boolean added = false;
            if (this.propertyBeingEdited.removeValueConstraint(selectedValueConstraint)) {
                removed = true;
                if (this.propertyBeingEdited.addValueConstraint(modifiedValueConstraint)) {
                    added = true;
                }
            }
            if (!removed || !added) {
                MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorEditingValueConstraint, (Object[])new Object[]{modifiedValueConstraint, removed, added}));
            }
        }
    }

    void handleMandatoryChanged(boolean newMandatory) {
        this.propertyBeingEdited.setMandatory(newMandatory);
    }

    void handleMultipleChanged(boolean newMultiple) {
        this.propertyBeingEdited.setMultiple(newMultiple);
    }

    void handleNameChanged(String newName) {
        this.propertyBeingEdited.setName(newName);
    }

    void handleNoFullTextChanged(boolean newNoFullText) {
        this.propertyBeingEdited.setFullTextSearchable(!newNoFullText);
    }

    void handleNoQueryOrderChanged(boolean newNoQueryOrder) {
        this.propertyBeingEdited.setQueryOrderable(!newNoQueryOrder);
    }

    void handleOnParentVersionChanged(String newOpv) {
        this.propertyBeingEdited.setOnParentVersion(newOpv);
    }

    void handlePropertyChanged(PropertyChangeEvent e) {
        String propName = e.getPropertyName();
        if (PropertyDefinition.PropertyName.AUTOCREATED.toString().equals(propName) || PropertyDefinition.PropertyName.MANDATORY.toString().equals(propName) || PropertyDefinition.PropertyName.MULTIPLE.toString().equals(propName) || PropertyDefinition.PropertyName.NO_FULL_TEXT.toString().equals(propName) || PropertyDefinition.PropertyName.NO_QUERY_ORDER.toString().equals(propName) || PropertyDefinition.PropertyName.PROTECTED.toString().equals(propName) || PropertyDefinition.PropertyName.ON_PARENT_VERSION.toString().equals(propName) || PropertyDefinition.PropertyName.QUERY_OPS.toString().equals(propName)) {
            this.validateAttributes();
        } else if (PropertyDefinition.PropertyName.DEFAULT_VALUES.toString().equals(propName)) {
            this.validateDefaultValues();
            this.defaultValuesViewer.refresh();
        } else if (PropertyDefinition.PropertyName.NAME.toString().equals(propName)) {
            this.validateName();
        } else if (PropertyDefinition.PropertyName.TYPE.toString().equals(propName)) {
            this.validateType();
        } else if (PropertyDefinition.PropertyName.VALUE_CONSTRAINTS.toString().equals(propName)) {
            this.validateValueConstraints();
            this.valueConstraintsViewer.refresh();
        }
        this.updateState();
    }

    void handleProtectedChanged(boolean newProtected) {
        this.propertyBeingEdited.setProtected(newProtected);
    }

    protected void handleQueryOperatorChanged(String text, boolean selection) {
        if (selection) {
            this.propertyBeingEdited.addQueryOperator(QueryOperators.QueryOperator.find((String)text));
        } else {
            this.propertyBeingEdited.removeQueryOperator(QueryOperators.QueryOperator.find((String)text));
        }
    }

    void handleTypeChanged(String newType) {
        this.propertyBeingEdited.setType(PropertyType.valueOf((String)newType));
    }

    void handleValueConstraintSelected() {
        boolean enable;
        boolean bl = enable = this.getSelectedValueConstraint() != null;
        if (this.editValueConstraint.isEnabled() != enable) {
            this.editValueConstraint.setEnabled(enable);
        }
        if (this.deleteValueConstraint.isEnabled() != enable) {
            this.deleteValueConstraint.setEnabled(enable);
        }
    }

    private boolean isEditMode() {
        return this.originalProperty != null;
    }

    private void updateMessage(ValidationStatus status, ErrorMessage errorMsg) {
        JcrUiUtils.setMessage(status, errorMsg);
        if (errorMsg.isOk()) {
            this.scrolledForm.getMessageManager().removeMessage(errorMsg.getKey(), errorMsg.getControl());
        } else {
            this.scrolledForm.getMessageManager().addMessage(errorMsg.getKey(), errorMsg.getMessage(), null, errorMsg.getMessageType(), errorMsg.getControl());
        }
    }

    private void updateState() {
        boolean enable;
        int messageType = this.scrolledForm.getMessageType();
        boolean bl = enable = messageType != 3;
        if (enable && this.isEditMode() && this.originalProperty.equals((Object)this.propertyBeingEdited)) {
            enable = false;
        }
        if (this.btnOk.getEnabled() != enable) {
            this.btnOk.setEnabled(enable);
        }
    }

    private void validateAttributes() {
    }

    private void validateDefaultValues() {
        this.updateMessage((ValidationStatus)CndValidator.validateDefaultValues((PropertyDefinition)this.propertyBeingEdited, this.existingNamespacePrefixes), this.defaultValuesError);
    }

    private void validateName() {
        this.updateMessage(this.nameEditor.getStatus(), this.nameError);
    }

    private void validateType() {
    }

    private void validateValueConstraints() {
        this.updateMessage((ValidationStatus)CndValidator.validateValueConstraints((PropertyDefinition)this.propertyBeingEdited), this.valueConstraintsError);
    }
}

