/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementDetailHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.gef.commands.Command;

public class FlowMoveChildCommand
extends Command {
    private static Logger logger = Logger.getLogger(FlowMoveChildCommand.class.getName());
    private static final String TRANS_LABEL_MOVE_ELEMENT = Messages.getString("FlowMoveChildCommand.transLabel.moveElement");
    private Object child = null;
    private Object after = null;
    private Object container = null;

    public FlowMoveChildCommand(Object child, Object after, Object container) {
        this.child = child;
        this.after = after;
        this.container = container;
    }

    public void execute() {
        if (DesignerConstants.TRACING_COMMANDS) {
            System.out.println("FlowMoveChildCommand >> Starts ... ");
        }
        try {
            DesignElementHandle containerHandle = null;
            int slotID = -1;
            int pos = -1;
            String contentString = null;
            if (this.container instanceof ListBandProxy) {
                containerHandle = ((ListBandProxy)this.container).getSlotHandle().getElementHandle();
                ElementDetailHandle slot = ((ListBandProxy)this.container).getSlotHandle();
                slotID = slot instanceof SlotHandle ? ((SlotHandle)slot).getSlotID() : -1;
                pos = DEUtil.findInsertPosition(containerHandle, (DesignElementHandle)this.after, slotID);
                int cur = DEUtil.findInsertPosition(containerHandle, (DesignElementHandle)this.child, slotID);
                if (cur < pos) {
                    --pos;
                }
            } else if (this.container instanceof DesignElementHandle) {
                containerHandle = (DesignElementHandle)this.container;
                slotID = DEUtil.getSlotID(containerHandle, this.after);
                if (slotID == -1) {
                    contentString = DEUtil.getDefaultContentName(containerHandle);
                    pos = DEUtil.findInsertPosition(containerHandle, (DesignElementHandle)this.after, contentString);
                } else {
                    pos = DEUtil.findInsertPosition(containerHandle, (DesignElementHandle)this.after);
                }
            } else if (this.container instanceof SlotHandle) {
                containerHandle = ((SlotHandle)this.container).getElementHandle();
                slotID = ((SlotHandle)this.container).getSlotID();
                pos = DEUtil.findInsertPosition(containerHandle, (DesignElementHandle)this.after, slotID);
            }
            DesignElementHandle handle = (DesignElementHandle)this.child;
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(TRANS_LABEL_MOVE_ELEMENT);
            if (slotID == -1) {
                handle.moveTo(containerHandle, contentString);
                containerHandle.getPropertyHandle(contentString).shift(handle, pos);
            } else {
                handle.moveTo(containerHandle, slotID);
                containerHandle.getSlot(slotID).shift(handle, pos);
            }
            stack.commit();
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("FlowMoveChildCommand >> Finished. Moved " + DEUtil.getDisplayLabel(handle) + " to the slot " + slotID + " of " + DEUtil.getDisplayLabel(containerHandle) + ",Position: " + pos);
            }
        }
        catch (ContentException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("FlowMoveChildCommand >> Failed");
            }
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (SemanticException ee) {
            logger.log(Level.SEVERE, ee.getMessage(), ee);
        }
    }
}

