/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx;

import java.io.OutputStream;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.CompressionMode;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.ppt.util.PPTUtil;
import org.eclipse.birt.report.engine.emitter.pptx.PPTXPage;
import org.eclipse.birt.report.engine.emitter.pptx.PPTXPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class PPTXRender
extends PageDeviceRender {
    private OutputStream out = null;
    private String tempFileDir;
    public static final String REPORT_FILE = "Report.pptx";
    private RenderOption renderOption = null;

    public PPTXRender(IEmitterServices services) throws EngineException {
        this.initialize(services);
        this.tempFileDir = services.getReportEngine().getConfig().getTempDir();
    }

    public IPageDevice createPageDevice(String title, String author, String subject, String description, IReportContext context, IReportContent report) throws Exception {
        try {
            int compressionMode = this.getCompressionMode(this.renderOption).getValue();
            PPTXPageDevice pageDevice = new PPTXPageDevice(this.out, title, author, description, subject, this.tempFileDir, compressionMode);
            return pageDevice;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    private CompressionMode getCompressionMode(RenderOption renderOption) {
        CompressionMode compressionMode = CompressionMode.BEST_COMPRESSION;
        Object mode = renderOption.getOption("BEST_COMPRESSION");
        if (mode instanceof CompressionMode) {
            compressionMode = (CompressionMode)mode;
        }
        return compressionMode;
    }

    public String getOutputFormat() {
        return "pptx";
    }

    public void initialize(IEmitterServices services) throws EngineException {
        this.services = services;
        this.renderOption = (RenderOption)services.getRenderOption();
        this.reportRunnable = services.getReportRunnable();
        if (this.reportRunnable != null) {
            this.reportDesign = (ReportDesignHandle)this.reportRunnable.getDesignHandle();
        }
        this.context = services.getReportContext();
        this.out = EmitterUtil.getOuputStream((IEmitterServices)services, (String)REPORT_FILE);
    }

    public void visitImage(IImageArea imageArea) {
        PPTXPage page = (PPTXPage)this.pageGraphic;
        page.setLink(PPTUtil.getHyperlink((IArea)imageArea, (IEmitterServices)this.services, (IReportRunnable)this.reportRunnable, (IReportContext)this.context));
        super.visitImage(imageArea);
        page.setLink(null);
    }

    public void visitText(ITextArea textArea) {
        PPTXPage page = (PPTXPage)this.pageGraphic;
        page.setLink(PPTUtil.getHyperlink((IArea)textArea, (IEmitterServices)this.services, (IReportRunnable)this.reportRunnable, (IReportContext)this.context));
        super.visitText(textArea);
        page.setLink(null);
    }

    protected void drawTextAt(ITextArea text, int x, int y, int width, int height, TextStyle textStyle) {
        this.pageGraphic.drawText(text.getLogicalOrderText(), x, y, width, height, textStyle);
    }
}

