/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles;

import org.teiid.designer.roles.Crud;

public class Permission {
    private String targetName;
    private Crud crud;
    private boolean primary;
    private boolean constraint;
    private String condition;
    private int order;
    private String mask;
    private boolean allowLanguage;
    private boolean canFilter;
    private boolean canMask;

    public Permission(String targetName) {
        this.targetName = targetName;
    }

    public Permission(Permission permission) {
        this.targetName = permission.getTargetName();
        this.crud = permission.getCRUD();
        this.constraint = permission.isConstraint();
        this.order = permission.getOrder();
        this.allowLanguage = permission.isAllowLanguage();
        this.condition = permission.getCondition();
        this.mask = permission.getMask();
        this.setCanFilter(permission.canFilter());
        this.setCanMask(permission.canMask());
    }

    public Permission(String targetName, Boolean createAllowed, Boolean readAllowed, Boolean updateAllowed, Boolean deleteAllowed, Boolean executeAllowed, Boolean alterAllowed) {
        this.targetName = targetName;
        this.crud = new Crud(createAllowed, readAllowed, updateAllowed, deleteAllowed, executeAllowed, alterAllowed);
        this.constraint = true;
    }

    public Permission(String targetName, Crud crud) {
        this.targetName = targetName;
        this.crud = new Crud(crud.c, crud.r, crud.u, crud.d, crud.e, crud.a);
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public Boolean isCreateAllowed() {
        return this.crud.c;
    }

    public void setCreateAllowed(Boolean createAllowed) {
        this.crud.c = createAllowed;
    }

    public Boolean isReadAllowed() {
        return this.crud.r;
    }

    public void setReadAllowed(Boolean readAllowed) {
        this.crud.r = readAllowed;
    }

    public Boolean isUpdateAllowed() {
        return this.crud.u;
    }

    public void setUpdateAllowed(Boolean updateAllowed) {
        this.crud.u = updateAllowed;
    }

    public Boolean isDeleteAllowed() {
        return this.crud.d;
    }

    public void setDeleteAllowed(Boolean deleteAllowed) {
        this.crud.d = deleteAllowed;
    }

    public Boolean isExecuteAllowed() {
        return this.crud.e;
    }

    public void setExecuteAllowed(Boolean executeAllowed) {
        this.crud.e = executeAllowed;
    }

    public Boolean isAlterAllowed() {
        return this.crud.a;
    }

    public void setAlterAllowed(Boolean alterAllowed) {
        this.crud.a = alterAllowed;
    }

    public Crud getCRUD() {
        return new Crud(this.crud);
    }

    public void setCRUD(Boolean c, Boolean r, Boolean u, Boolean d, Boolean e, Boolean a) {
        this.crud = new Crud(c, r, u, d, e, a);
    }

    public void setCRUDValue(Boolean value, Crud.Type type) {
        switch (type) {
            case CREATE: {
                this.setCreateAllowed(value);
                break;
            }
            case READ: {
                this.setReadAllowed(value);
                break;
            }
            case UPDATE: {
                this.setUpdateAllowed(value);
                break;
            }
            case DELETE: {
                this.setDeleteAllowed(value);
                break;
            }
            case EXECUTE: {
                this.setExecuteAllowed(value);
                break;
            }
            case ALTER: {
                this.setAlterAllowed(value);
            }
        }
    }

    public Boolean getCRUDValue(Crud.Type type) {
        switch (type) {
            case CREATE: {
                return this.isCreateAllowed();
            }
            case READ: {
                return this.isReadAllowed();
            }
            case UPDATE: {
                return this.isUpdateAllowed();
            }
            case DELETE: {
                return this.isDeleteAllowed();
            }
            case EXECUTE: {
                return this.isExecuteAllowed();
            }
            case ALTER: {
                return this.isAlterAllowed();
            }
        }
        return null;
    }

    public void toggleCRUDValue(Crud.Type type) {
        Boolean currentValue = this.getCRUDValue(type);
        if (currentValue == Boolean.FALSE) {
            this.setCRUDValue(Boolean.TRUE, type);
        } else {
            this.setCRUDValue(Boolean.FALSE, type);
        }
    }

    public boolean childCrudValueIsDifferent(Boolean parentValue, Boolean childValue) {
        if (parentValue == null) {
            return true;
        }
        if (parentValue == Boolean.TRUE && childValue == null) {
            return false;
        }
        return parentValue != Boolean.TRUE || childValue != Boolean.TRUE;
    }

    public Boolean isEquivalentCRUD(Permission permission) {
        return this.crud.equivalent(permission.getCRUD());
    }

    public boolean isNullCrud() {
        return this.crud.c == null && this.crud.r == null && this.crud.u == null && this.crud.d == null && this.crud.e == null && this.crud.a == null;
    }

    public boolean isFalseCrud() {
        return this.crud.c == Boolean.FALSE && this.crud.r == Boolean.FALSE && this.crud.u == Boolean.FALSE && this.crud.d == Boolean.FALSE && this.crud.e == Boolean.FALSE && this.crud.a == Boolean.FALSE;
    }

    public boolean equals(Object obj) {
        Permission perm;
        if (obj instanceof Permission && (perm = (Permission)obj).getTargetName().equalsIgnoreCase(this.getTargetName())) {
            return perm.getCRUD().isSameAs(this.getCRUD());
        }
        return false;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Permission: ").append(this.targetName);
        sb.append("\n\t").append("c = " + this.crud.c);
        sb.append("\n\t").append("r = " + this.crud.r);
        sb.append("\n\t").append("u = " + this.crud.u);
        sb.append("\n\t").append("d = " + this.crud.d);
        sb.append("\n\t").append("e = " + this.crud.e);
        sb.append("\n\t").append("a = " + this.crud.a);
        sb.append("\n\t").append("allow-language = " + this.allowLanguage);
        return sb.toString();
    }

    public boolean isConstraint() {
        return this.constraint;
    }

    public void setConstraint(boolean constraint) {
        this.constraint = constraint;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public boolean isAllowLanguage() {
        return this.allowLanguage;
    }

    public void setAllowLanguage(boolean allowLanguage) {
        this.allowLanguage = allowLanguage;
    }

    public boolean canMask() {
        return this.canMask;
    }

    public void setCanMask(boolean canMask) {
        this.canMask = canMask;
    }

    public boolean canFilter() {
        return this.canFilter;
    }

    public void setCanFilter(boolean canFilter) {
        this.canFilter = canFilter;
    }
}

