/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllerEnvironment;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.SubsystemModel;
import org.jboss.tools.as.test.core.subsystems.impl.System1aSubsystem;
import org.jboss.tools.as.test.core.subsystems.impl.System6Subsystem;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ServerSubsystemTest1
extends TestCase {
    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testSystem1Type() {
        try {
            ServerSubsystemTest1.assertNotNull((Object)this.convenience("customServer1", "system1"));
        }
        catch (CoreException ce) {
            ServerSubsystemTest1.fail((String)ce.getMessage());
        }
    }

    @Test
    public void testSystem2DefaultFlag() {
        ModelSubclass c = new ModelSubclass();
        try {
            SubsystemModel.SubsystemMapping[] types = c.getSubsystemMappings("customServer1", "system2");
            ServerSubsystemTest1.assertTrue((types.length == 2 ? 1 : 0) != 0);
            ISubsystemController controller = c.createSubsystemController(null, "customServer1", "system2", null, null, null);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system2.implB"));
        }
        catch (CoreException ce) {
            ServerSubsystemTest1.fail((String)ce.getMessage());
        }
    }

    @Test
    public void testMissingSystem() {
        ModelSubclass c = new ModelSubclass();
        try {
            SubsystemModel.SubsystemMapping[] types = c.getSubsystemMappings("customServer1", "missingSystem");
            ServerSubsystemTest1.assertTrue((types.length == 0 ? 1 : 0) != 0);
            c.createSubsystemController(null, "customServer1", "missingSystem", null, null, null);
            ServerSubsystemTest1.fail();
        }
        catch (CoreException coreException) {}
    }

    public void testSystem2DefaultParameter() {
        ModelSubclass c = new ModelSubclass();
        try {
            SubsystemModel.SubsystemMapping[] types = c.getSubsystemMappings("customServer1", "system2");
            ServerSubsystemTest1.assertTrue((types.length == 2 ? 1 : 0) != 0);
            ISubsystemController controller = c.createSubsystemController(null, "customServer1", "system2", null, "system2.implA", null);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system2.implA"));
        }
        catch (CoreException ce) {
            ServerSubsystemTest1.fail((String)ce.getMessage());
        }
    }

    public void testSystem2RequiredParameter() {
        ISubsystemController controller;
        HashMap<String, String> map;
        SubsystemModel.SubsystemMapping[] types;
        ModelSubclass c = new ModelSubclass();
        try {
            types = c.getSubsystemMappings("customServer1", "system2");
            ServerSubsystemTest1.assertTrue((types.length == 2 ? 1 : 0) != 0);
            map = new HashMap<String, String>();
            map.put("someKey", "someVal");
            controller = c.createSubsystemController(null, "customServer1", "system2", map, null, null);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system2.implA"));
        }
        catch (CoreException ce) {
            ServerSubsystemTest1.fail((String)ce.getMessage());
        }
        try {
            types = c.getSubsystemMappings("customServer1", "system2");
            ServerSubsystemTest1.assertTrue((types.length == 2 ? 1 : 0) != 0);
            map = new HashMap();
            map.put("otherKey", "otherVal");
            controller = c.createSubsystemController(null, "customServer1", "system2", map, null, null);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system2.implB"));
        }
        catch (CoreException ce) {
            ServerSubsystemTest1.fail((String)ce.getMessage());
        }
    }

    public void testSystemMissingDependency() {
        ModelSubclass c = new ModelSubclass();
        try {
            SubsystemModel.SubsystemMapping[] types = c.getSubsystemMappings("customServer1", "system3");
            ServerSubsystemTest1.assertTrue((types.length == 2 ? 1 : 0) != 0);
            ISubsystemController controller = c.createSubsystemController(null, "customServer1", "system3", null, null, null);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertEquals((String)controller.getSubsystemMappedId(), (String)"system3.implA");
        }
        catch (CoreException ce) {
            ServerSubsystemTest1.fail((String)ce.getMessage());
        }
    }

    public void testChildSystemRequiredProperty() {
        ModelSubclass c = new ModelSubclass();
        try {
            SubsystemModel.SubsystemMapping[] types = c.getSubsystemMappings("customServer1", "system4");
            ServerSubsystemTest1.assertTrue((types.length == 1 ? 1 : 0) != 0);
            HashMap<String, String> env = new HashMap<String, String>();
            ISubsystemController controller = c.createSubsystemController(null, "customServer1", "system4", null, null, env);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system4.implSingleton"));
            ServerSubsystemTest1.assertTrue((boolean)(controller instanceof System1aSubsystem));
            System1aSubsystem tmp = (System1aSubsystem)controller;
            try {
                tmp.findDependency("system4a", "customServer1");
                ServerSubsystemTest1.fail();
            }
            catch (CoreException coreException) {}
            env.put("system4a.RESERVED_requiredProperties", "animal=tiger");
            controller = c.createSubsystemController(null, "customServer1", "system4", null, null, env);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system4.implSingleton"));
            ServerSubsystemTest1.assertTrue((boolean)(controller instanceof System1aSubsystem));
            tmp = (System1aSubsystem)controller;
            ISubsystemController tmp2 = tmp.findDependency("system4a", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)tmp2);
            ServerSubsystemTest1.assertTrue((boolean)tmp2.getSubsystemMappedId().equals("system4a.tiger"));
            env.put("system4a.RESERVED_requiredProperties", "animal=mantis");
            controller = c.createSubsystemController(null, "customServer1", "system4", null, null, env);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system4.implSingleton"));
            ServerSubsystemTest1.assertTrue((boolean)(controller instanceof System1aSubsystem));
            tmp = (System1aSubsystem)controller;
            tmp2 = tmp.findDependency("system4a", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)tmp2);
            ServerSubsystemTest1.assertTrue((boolean)tmp2.getSubsystemMappedId().equals("system4a.mantis"));
        }
        catch (CoreException ce) {
            ServerSubsystemTest1.fail((String)ce.getMessage());
        }
    }

    public void testGrandChildSystemRequiredProperty() {
        ModelSubclass c = new ModelSubclass();
        try {
            SubsystemModel.SubsystemMapping[] types = c.getSubsystemMappings("customServer1", "system5");
            ServerSubsystemTest1.assertTrue((types.length == 1 ? 1 : 0) != 0);
            HashMap<String, String> env = new HashMap<String, String>();
            ISubsystemController controller = c.createSubsystemController(null, "customServer1", "system5", null, null, env);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system5.implSingleton5"));
            ServerSubsystemTest1.assertTrue((boolean)(controller instanceof System1aSubsystem));
            System1aSubsystem tmp = (System1aSubsystem)controller;
            ISubsystemController system4 = tmp.findDependency("system4", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)system4);
            ServerSubsystemTest1.assertTrue((boolean)system4.getSubsystemMappedId().equals("system4.implSingleton"));
            ServerSubsystemTest1.assertTrue((boolean)(system4 instanceof System1aSubsystem));
            System1aSubsystem tmp4 = (System1aSubsystem)system4;
            ISubsystemController system4a = null;
            try {
                system4a = tmp4.findDependency("system4a", "customServer1");
                ServerSubsystemTest1.assertNotNull((Object)system4a);
                ServerSubsystemTest1.fail();
            }
            catch (CoreException coreException) {}
            env.put("system4a.RESERVED_requiredProperties", "animal=tiger");
            controller = c.createSubsystemController(null, "customServer1", "system5", null, null, env);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system5.implSingleton5"));
            ServerSubsystemTest1.assertTrue((boolean)(controller instanceof System1aSubsystem));
            tmp = (System1aSubsystem)controller;
            system4 = tmp.findDependency("system4", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)system4);
            ServerSubsystemTest1.assertTrue((boolean)system4.getSubsystemMappedId().equals("system4.implSingleton"));
            ServerSubsystemTest1.assertTrue((boolean)(system4 instanceof System1aSubsystem));
            tmp4 = (System1aSubsystem)system4;
            system4a = tmp4.findDependency("system4a", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)system4a);
            ServerSubsystemTest1.assertTrue((boolean)system4a.getSubsystemMappedId().equals("system4a.tiger"));
            env.put("system4a.RESERVED_requiredProperties", "animal=mantis");
            controller = c.createSubsystemController(null, "customServer1", "system5", null, null, env);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system5.implSingleton5"));
            ServerSubsystemTest1.assertTrue((boolean)(controller instanceof System1aSubsystem));
            tmp = (System1aSubsystem)controller;
            system4 = tmp.findDependency("system4", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)system4);
            ServerSubsystemTest1.assertTrue((boolean)system4.getSubsystemMappedId().equals("system4.implSingleton"));
            ServerSubsystemTest1.assertTrue((boolean)(system4 instanceof System1aSubsystem));
            tmp4 = (System1aSubsystem)system4;
            system4a = tmp4.findDependency("system4a", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)system4a);
            ServerSubsystemTest1.assertTrue((boolean)system4a.getSubsystemMappedId().equals("system4a.mantis"));
        }
        catch (CoreException ce) {
            ServerSubsystemTest1.fail((String)ce.getMessage());
        }
    }

    public void testGrandChildSystemRequiredPropertySecondApi() {
        ModelSubclass c = new ModelSubclass();
        try {
            SubsystemModel.SubsystemMapping[] types = c.getSubsystemMappings("customServer1", "system5");
            ServerSubsystemTest1.assertTrue((types.length == 1 ? 1 : 0) != 0);
            ISubsystemController controller = c.createControllerForSubsystem(null, "customServer1", "system5", "system5.implSingleton5", new ControllerEnvironment().addRequiredProperty("system4a", "animal", "mantis").getMap());
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system5.implSingleton5"));
            ServerSubsystemTest1.assertTrue((boolean)(controller instanceof System1aSubsystem));
            System1aSubsystem tmp = (System1aSubsystem)controller;
            ISubsystemController system4 = tmp.findDependency("system4", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)system4);
            ServerSubsystemTest1.assertTrue((boolean)system4.getSubsystemMappedId().equals("system4.implSingleton"));
            ServerSubsystemTest1.assertTrue((boolean)(system4 instanceof System1aSubsystem));
            System1aSubsystem tmp4 = (System1aSubsystem)system4;
            ISubsystemController system4a = tmp4.findDependency("system4a", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)system4a);
            ServerSubsystemTest1.assertTrue((boolean)system4a.getSubsystemMappedId().equals("system4a.mantis"));
        }
        catch (CoreException ce) {
            ServerSubsystemTest1.fail((String)ce.getMessage());
        }
    }

    public void testArbitraryDependencyResolution() {
        ModelSubclass c = new ModelSubclass();
        try {
            SubsystemModel.SubsystemMapping[] types = c.getSubsystemMappings("customServer1", "system6");
            ServerSubsystemTest1.assertTrue((types.length == 1 ? 1 : 0) != 0);
            ISubsystemController controller = c.createControllerForSubsystem(null, "customServer1", "system6", "system6.implSingleton6", new ControllerEnvironment().addProperty("subsystem6.prop.LEGS", (Object)new Integer(4)).getMap());
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system6.implSingleton6"));
            ServerSubsystemTest1.assertTrue((boolean)(controller instanceof System6Subsystem));
            System6Subsystem tmp = (System6Subsystem)controller;
            ISubsystemController system4 = tmp.findDependency("system4a", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)system4);
            ServerSubsystemTest1.assertTrue((boolean)system4.getSubsystemMappedId().equals("system4a.tiger"));
            ServerSubsystemTest1.assertTrue((boolean)system4.validate().isOK());
            controller = c.createControllerForSubsystem(null, "customServer1", "system6", "system6.implSingleton6", new ControllerEnvironment().addProperty("subsystem6.prop.LEGS", (Object)new Integer(2)).getMap());
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system6.implSingleton6"));
            ServerSubsystemTest1.assertTrue((boolean)(controller instanceof System6Subsystem));
            tmp = (System6Subsystem)controller;
            system4 = tmp.findDependency("system4a", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)system4);
            ServerSubsystemTest1.assertTrue((boolean)system4.getSubsystemMappedId().equals("system4a.mantis"));
            ServerSubsystemTest1.assertTrue((boolean)system4.validate().isOK());
            controller = c.createControllerForSubsystem(null, "customServer1", "system6", "system6.implSingleton6", new ControllerEnvironment().addProperty("subsystem6.prop.LEGS", (Object)new Integer(666)).getMap());
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system6.implSingleton6"));
            ServerSubsystemTest1.assertTrue((boolean)(controller instanceof System6Subsystem));
            tmp = (System6Subsystem)controller;
            ServerSubsystemTest1.assertTrue((!tmp.validate().isOK() ? 1 : 0) != 0);
        }
        catch (CoreException ce) {
            ServerSubsystemTest1.fail((String)ce.getMessage());
        }
    }

    public void testSubsystemDependencyResolved() {
        ISubsystemController system4;
        System1aSubsystem tmp;
        ISubsystemController controller;
        SubsystemModel.SubsystemMapping[] types;
        ModelSubclass c = new ModelSubclass();
        try {
            types = c.getSubsystemMappings("customServer1", "system7");
            ServerSubsystemTest1.assertTrue((types.length == 1 ? 1 : 0) != 0);
            controller = c.createControllerForSubsystem(null, "customServer1", "system7", "system7.implSingleton7", null);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system7.implSingleton7"));
            ServerSubsystemTest1.assertTrue((boolean)(controller instanceof System1aSubsystem));
            tmp = (System1aSubsystem)controller;
            system4 = tmp.findDependency("system4a", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)system4);
            ServerSubsystemTest1.assertTrue((boolean)system4.getSubsystemMappedId().equals("system4a.mantis"));
            ServerSubsystemTest1.assertTrue((boolean)(system4 instanceof System1aSubsystem));
        }
        catch (CoreException ce) {
            ServerSubsystemTest1.fail((String)ce.getMessage());
        }
        c = new ModelSubclass();
        try {
            types = c.getSubsystemMappings("customServer1", "system8");
            ServerSubsystemTest1.assertTrue((types.length == 1 ? 1 : 0) != 0);
            controller = c.createControllerForSubsystem(null, "customServer1", "system8", "system8.implSingleton8", null);
            ServerSubsystemTest1.assertNotNull((Object)controller);
            ServerSubsystemTest1.assertTrue((boolean)controller.getSubsystemMappedId().equals("system8.implSingleton8"));
            ServerSubsystemTest1.assertTrue((boolean)(controller instanceof System1aSubsystem));
            tmp = (System1aSubsystem)controller;
            system4 = tmp.findDependency("system4a", "customServer1");
            ServerSubsystemTest1.assertNotNull((Object)system4);
            ServerSubsystemTest1.assertTrue((boolean)system4.getSubsystemMappedId().equals("system4a.tiger"));
            ServerSubsystemTest1.assertTrue((boolean)(system4 instanceof System1aSubsystem));
        }
        catch (CoreException ce) {
            ServerSubsystemTest1.fail((String)ce.getMessage());
        }
    }

    private ISubsystemController convenience(String serverType, String system) throws CoreException {
        return SubsystemModel.getInstance().createSubsystemController(null, serverType, system, null, null, null);
    }

    static class ModelSubclass
    extends SubsystemModel {
        ModelSubclass() {
        }

        public SubsystemModel.SubsystemMapping[] getSubsystemMappings(String serverType, String system) {
            return super.getSubsystemMappings(serverType, system);
        }

        public String getSubsystemMappedId(Object o) {
            if (o instanceof SubsystemModel.SubsystemMapping) {
                return ((SubsystemModel.SubsystemMapping)o).getMappedId();
            }
            return null;
        }
    }
}

