/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.jboss.ide.eclipse.as.core.publishers.patterns.ModuleDirectoryScannerPathFilter;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.tools.as.test.core.internal.utils.MockModule;
import org.jboss.tools.as.test.core.internal.utils.MockModuleUtil;

public class ModulePathFilterUtilityTest
extends TestCase {
    private IModule m;

    public void setUp() {
        this.m = this.createTestMockModule();
    }

    public void testStandard() throws Exception {
        IModule m = this.createTestMockModule();
        ModuleDelegate md = (ModuleDelegate)m.loadAdapter(ModuleDelegate.class, null);
        IModuleResource[] members = md.members();
        int count = ModuleResourceUtil.countMembers((IModuleResource[])members);
        int countWithFolders = ModuleResourceUtil.countMembers((IModuleResource[])members, (boolean)true);
        ModulePathFilterUtilityTest.assertEquals((int)count, (int)20);
        ModulePathFilterUtilityTest.assertEquals((int)countWithFolders, (int)25);
    }

    public void testFilteredMembersIncludeAll() throws Exception {
        this.testStandard();
        ModuleDirectoryScannerPathFilter filter = new ModuleDirectoryScannerPathFilter(this.m, "**", "");
        IModuleResource[] filtered = filter.getFilteredMembers();
        int count = ModuleResourceUtil.countMembers((IModuleResource[])filtered);
        int countWithFolders = ModuleResourceUtil.countMembers((IModuleResource[])filtered, (boolean)true);
        ModulePathFilterUtilityTest.assertEquals((int)count, (int)20);
        ModulePathFilterUtilityTest.assertEquals((int)countWithFolders, (int)25);
    }

    public void testFilteredMembersExcludeFiles() throws Exception {
        this.testStandard();
        ModuleDirectoryScannerPathFilter filter = new ModuleDirectoryScannerPathFilter(this.m, "**", "b/**");
        IModuleResource[] filtered = filter.getFilteredMembers();
        int count = ModuleResourceUtil.countMembers((IModuleResource[])filtered);
        int countWithFolders = ModuleResourceUtil.countMembers((IModuleResource[])filtered, (boolean)true);
        ModulePathFilterUtilityTest.assertEquals((int)count, (int)16);
        ModulePathFilterUtilityTest.assertEquals((int)countWithFolders, (int)20);
    }

    public void testFilteredMembersExcludeFolderB() throws Exception {
        this.testStandard();
        ModuleDirectoryScannerPathFilter filter = new ModuleDirectoryScannerPathFilter(this.m, "**", "b/");
        IModuleResource[] filtered = filter.getFilteredMembers();
        int count = ModuleResourceUtil.countMembers((IModuleResource[])filtered);
        int countWithFolders = ModuleResourceUtil.countMembers((IModuleResource[])filtered, (boolean)true);
        ModulePathFilterUtilityTest.assertEquals((int)count, (int)16);
        ModulePathFilterUtilityTest.assertEquals((int)countWithFolders, (int)20);
    }

    public void testFilteredMembersIncludeNestedF() throws Exception {
        this.testStandard();
        ModuleDirectoryScannerPathFilter filter = new ModuleDirectoryScannerPathFilter(this.m, "d/F/**", "");
        IModuleResource[] filtered = filter.getFilteredMembers();
        int count = ModuleResourceUtil.countMembers((IModuleResource[])filtered);
        int countWithFolders = ModuleResourceUtil.countMembers((IModuleResource[])filtered, (boolean)true);
        ModulePathFilterUtilityTest.assertEquals((int)count, (int)4);
        ModulePathFilterUtilityTest.assertEquals((int)countWithFolders, (int)6);
    }

    public void testFilteredMembersIncludeNestedFWithExcludes() throws Exception {
        this.testStandard();
        ModuleDirectoryScannerPathFilter filter = new ModuleDirectoryScannerPathFilter(this.m, new String[]{"d/F/**"}, new String[]{"**/f1", "**/f2"});
        IModuleResource[] filtered = filter.getFilteredMembers();
        int count = ModuleResourceUtil.countMembers((IModuleResource[])filtered);
        int countWithFolders = ModuleResourceUtil.countMembers((IModuleResource[])filtered, (boolean)true);
        ModulePathFilterUtilityTest.assertEquals((int)count, (int)2);
        ModulePathFilterUtilityTest.assertEquals((int)countWithFolders, (int)4);
    }

    public void testIncludeNestedFWithExcludes_AutoExplode() throws Exception {
        this.testStandard();
        ModuleDirectoryScannerPathFilter filter = new ModuleDirectoryScannerPathFilter(this.m, "d/F/**", "**/f1,**/f2");
        IModuleResource[] filtered = filter.getFilteredMembers();
        int count = ModuleResourceUtil.countMembers((IModuleResource[])filtered);
        int countWithFolders = ModuleResourceUtil.countMembers((IModuleResource[])filtered, (boolean)true);
        ModulePathFilterUtilityTest.assertEquals((int)count, (int)2);
        ModulePathFilterUtilityTest.assertEquals((int)countWithFolders, (int)4);
    }

    public void testFilteredDelta1() throws Exception {
        this.testStandard();
        ModuleDirectoryScannerPathFilter filter = new ModuleDirectoryScannerPathFilter(this.m, "**", "b/**");
        IModuleResource[] filtered = filter.getFilteredMembers();
        int count = ModuleResourceUtil.countMembers((IModuleResource[])filtered);
        int countWithFolders = ModuleResourceUtil.countMembers((IModuleResource[])filtered, (boolean)true);
        ModulePathFilterUtilityTest.assertEquals((int)count, (int)16);
        ModulePathFilterUtilityTest.assertEquals((int)countWithFolders, (int)20);
        IModuleResource[] members = ((MockModule)this.m).members();
        List<IModuleResource> asList = Arrays.asList(members);
        IPath[] changed = new IPath[]{new Path("w"), new Path("a/a1"), new Path("b/b1"), new Path("d/F/f1")};
        int changedFlag = 2;
        int[] kind = new int[]{changedFlag, changedFlag, changedFlag, changedFlag};
        IModuleResourceDelta[] mockDelta = MockModuleUtil.createMockResourceDeltas(asList, changed, kind);
        ModulePathFilterUtilityTest.assertEquals((int)4, (int)ModuleResourceUtil.countChanges((IModuleResourceDelta[])mockDelta));
        int i = 0;
        while (i < changed.length) {
            IModuleResourceDelta found = MockModuleUtil.findDelta(mockDelta, changed[i]);
            ModulePathFilterUtilityTest.assertNotNull((Object)found);
            ++i;
        }
        IModuleResourceDelta[] afterFilter = filter.getFilteredDelta(mockDelta);
        ModulePathFilterUtilityTest.assertEquals((int)3, (int)ModuleResourceUtil.countChanges((IModuleResourceDelta[])afterFilter));
    }

    private IModule createTestMockModule() {
        MockModule m = MockModuleUtil.createMockWebModule();
        IPath[] leafs = new IPath[]{new Path("w"), new Path("x"), new Path("y"), new Path("z"), new Path("a/a1"), new Path("a/a2"), new Path("a/q1"), new Path("a/q2"), new Path("b/b1"), new Path("b/b2"), new Path("b/b3"), new Path("b/b4"), new Path("c/y1"), new Path("c/y2"), new Path("c/y3"), new Path("c/y4"), new Path("d/F/f1"), new Path("d/F/f2"), new Path("d/F/f3"), new Path("d/F/f4")};
        IModuleResource[] all = MockModuleUtil.createMockResources(leafs, new IPath[0]);
        m.setMembers(all);
        return m;
    }
}

