/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.preference;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.jboss.tools.modeshape.jcr.Activator;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceConstants;
import org.osgi.service.prefs.BackingStoreException;

public final class JcrPreferenceStore
extends AbstractPreferenceInitializer {
    private static JcrPreferenceStore _store;
    private final boolean eclipse;
    private final IEclipsePreferences prefs;
    private final Map<String, String> testDefaultPrefs;
    private final Map<String, String> testPrefs;

    public static void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        Utils.verifyIsNotNull(listener, "listener");
        JcrPreferenceStore.get().prefs.addPreferenceChangeListener(listener);
    }

    public static JcrPreferenceStore get() {
        if (_store == null) {
            _store = new JcrPreferenceStore();
        }
        return _store;
    }

    public static void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        Utils.verifyIsNotNull(listener, "listener");
        JcrPreferenceStore.get().prefs.removePreferenceChangeListener(listener);
    }

    public JcrPreferenceStore() {
        if (Platform.isRunning()) {
            this.eclipse = true;
            this.prefs = InstanceScope.INSTANCE.getNode(Activator.PLUGIN_ID);
            this.testDefaultPrefs = null;
            this.testPrefs = null;
        } else {
            this.eclipse = false;
            this.prefs = null;
            this.testDefaultPrefs = new HashMap<String, String>();
            this.testPrefs = new HashMap<String, String>();
            this.initializeTestDefaultPreferences();
        }
    }

    public String get(JcrPreferenceConstants.Preference pref) {
        Utils.verifyIsNotNull(pref, "pref");
        if (this.eclipse) {
            String value = this.prefs.get(pref.getId(), null);
            if (value == null) {
                return this.getDefault(pref);
            }
            return value;
        }
        String value = this.testPrefs.get(pref.getId());
        if (value == null) {
            value = this.testDefaultPrefs.get(pref.getId());
        }
        return value;
    }

    public String getDefault(JcrPreferenceConstants.Preference pref) {
        if (this.eclipse) {
            return DefaultScope.INSTANCE.getNode(Activator.PLUGIN_ID).get(pref.getId(), null);
        }
        return this.testDefaultPrefs.get(pref.getId());
    }

    public void initializeDefaultPreferences() {
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode(Activator.PLUGIN_ID);
        prefs.put(JcrPreferenceConstants.CndPreference.ATTRIBUTE_LIST_ITEM_QUOTE_CHAR.getId(), "");
        prefs.put(JcrPreferenceConstants.CndPreference.CHILD_NODE_ATTRIBUTES_DELIMITER.getId(), " ");
        prefs.put(JcrPreferenceConstants.CndPreference.CHILD_NODE_PROPERTY_DELIMITER.getId(), " ");
        prefs.put(JcrPreferenceConstants.CndPreference.ELEMENT_DELIMITER.getId(), "\n");
        prefs.put(JcrPreferenceConstants.CndPreference.ELEMENTS_END_DELIMITER.getId(), "");
        prefs.put(JcrPreferenceConstants.CndPreference.NAMESPACE_MAPPING_DELIMITER.getId(), "\n");
        prefs.put(JcrPreferenceConstants.CndPreference.NAMESPACE_MAPPING_SECTION_END_DELIMITER.getId(), "\n");
        prefs.put(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_ATTRIBUTES_DELIMITER.getId(), " ");
        prefs.put(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_ATTRIBUTES_END_DELIMITER.getId(), "\n");
        prefs.put(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_DELIMITER.getId(), "\n");
        prefs.put(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_NAME_END_DELIMITER.getId(), " ");
        prefs.put(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_SECTION_END_DELIMITER.getId(), "\n");
        prefs.put(JcrPreferenceConstants.CndPreference.NOTATION_TYPE.getId(), CndElement.NotationType.LONG.toString());
        prefs.put(JcrPreferenceConstants.CndPreference.PROPERTY_DEFINITION_ATTRIBUTES_DELIMITER.getId(), " ");
        prefs.put(JcrPreferenceConstants.CndPreference.QUOTE_CHAR.getId(), "");
        prefs.put(JcrPreferenceConstants.CndPreference.SUPER_TYPES_END_DELIMITER.getId(), " ");
    }

    private void initializeTestDefaultPreferences() {
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.ATTRIBUTE_LIST_ITEM_QUOTE_CHAR.getId(), "");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.CHILD_NODE_ATTRIBUTES_DELIMITER.getId(), " ");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.CHILD_NODE_PROPERTY_DELIMITER.getId(), " ");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.ELEMENT_DELIMITER.getId(), "\n");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.ELEMENTS_END_DELIMITER.getId(), "");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.NAMESPACE_MAPPING_DELIMITER.getId(), "\n");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.NAMESPACE_MAPPING_SECTION_END_DELIMITER.getId(), "\n");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_ATTRIBUTES_DELIMITER.getId(), " ");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_ATTRIBUTES_END_DELIMITER.getId(), "\n");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_DELIMITER.getId(), "\n");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_NAME_END_DELIMITER.getId(), " ");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_SECTION_END_DELIMITER.getId(), "\n");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.NOTATION_TYPE.getId(), CndElement.NotationType.LONG.toString());
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.PROPERTY_DEFINITION_ATTRIBUTES_DELIMITER.getId(), " ");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.QUOTE_CHAR.getId(), "");
        this.testDefaultPrefs.put(JcrPreferenceConstants.CndPreference.SUPER_TYPES_END_DELIMITER.getId(), " ");
    }

    public void set(JcrPreferenceConstants.Preference pref, String newValue) {
        block5: {
            Utils.verifyIsNotNull(pref, "pref");
            if (this.eclipse) {
                this.prefs.put(pref.getId(), newValue);
                try {
                    this.prefs.flush();
                }
                catch (BackingStoreException e) {
                    if (Platform.isRunning()) {
                        Activator.get().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, null, (Throwable)e));
                        break block5;
                    }
                    System.err.print(e.getMessage());
                }
            } else {
                this.testPrefs.put(pref.getId(), newValue);
            }
        }
    }
}

