/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.cnd;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.modeshape.jcr.Activator;
import org.jboss.tools.modeshape.jcr.ChildNodeDefinition;
import org.jboss.tools.modeshape.jcr.ItemDefinition;
import org.jboss.tools.modeshape.jcr.NamespaceMapping;
import org.jboss.tools.modeshape.jcr.NodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.PropertyDefinition;
import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.WorkspaceRegistry;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceConstants;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceStore;

public class CompactNodeTypeDefinition
implements CndElement {
    private final CopyOnWriteArrayList<PropertyChangeListener> listeners = new CopyOnWriteArrayList();
    private List<NamespaceMapping> namespaceMappings;
    private List<NodeTypeDefinition> nodeTypeDefinitions;

    public static CompactNodeTypeDefinition copy(CompactNodeTypeDefinition cndToCopy) {
        Utils.verifyIsNotNull(cndToCopy, "cndToCopy");
        CompactNodeTypeDefinition copy = new CompactNodeTypeDefinition();
        for (NamespaceMapping namespaceMapping : cndToCopy.getNamespaceMappings()) {
            copy.addNamespaceMapping(NamespaceMapping.copy(namespaceMapping));
        }
        for (NodeTypeDefinition nodeTypeDefinition : cndToCopy.getNodeTypeDefinitions()) {
            copy.addNodeTypeDefinition(NodeTypeDefinition.copy(nodeTypeDefinition));
        }
        return copy;
    }

    public boolean addListener(PropertyChangeListener newListener) {
        Utils.verifyIsNotNull(newListener, "newListener");
        return this.listeners.addIfAbsent(newListener);
    }

    public boolean addNamespaceMapping(NamespaceMapping namespaceMappingToAdd) {
        Utils.verifyIsNotNull(namespaceMappingToAdd, "namespaceMappingToAdd");
        if (this.namespaceMappings == null) {
            this.namespaceMappings = new ArrayList<NamespaceMapping>();
        }
        if (this.namespaceMappings.add(namespaceMappingToAdd)) {
            this.notifyChangeListeners(PropertyName.NAMESPACE_MAPPINGS, null, namespaceMappingToAdd);
            return true;
        }
        return false;
    }

    public boolean addNodeTypeDefinition(NodeTypeDefinition nodeTypeDefinitionToAdd) {
        Utils.verifyIsNotNull(nodeTypeDefinitionToAdd, "nodeTypeDefinitionToAdd");
        if (this.nodeTypeDefinitions == null) {
            this.nodeTypeDefinitions = new ArrayList<NodeTypeDefinition>();
        }
        if (this.nodeTypeDefinitions.add(nodeTypeDefinitionToAdd)) {
            this.notifyChangeListeners(PropertyName.NODE_TYPE_DEFINITIONS, null, nodeTypeDefinitionToAdd);
            return true;
        }
        return false;
    }

    public boolean clearNamespaceMappings() {
        if (this.namespaceMappings == null) {
            return false;
        }
        boolean wasCleared = false;
        if (!this.namespaceMappings.isEmpty()) {
            ArrayList<NamespaceMapping> oldValue = new ArrayList<NamespaceMapping>(this.namespaceMappings);
            wasCleared = true;
            this.namespaceMappings.clear();
            this.notifyChangeListeners(PropertyName.NAMESPACE_MAPPINGS, oldValue, null);
        }
        this.namespaceMappings = null;
        return wasCleared;
    }

    public boolean clearNodeTypeDefinitions() {
        if (this.nodeTypeDefinitions == null) {
            return false;
        }
        boolean wasCleared = false;
        if (!this.nodeTypeDefinitions.isEmpty()) {
            ArrayList<NodeTypeDefinition> oldValue = new ArrayList<NodeTypeDefinition>(this.nodeTypeDefinitions);
            wasCleared = true;
            this.nodeTypeDefinitions.clear();
            this.notifyChangeListeners(PropertyName.NODE_TYPE_DEFINITIONS, oldValue, null);
        }
        this.nodeTypeDefinitions = null;
        return wasCleared;
    }

    public boolean equals(Object obj) {
        List<NodeTypeDefinition> thatNodeTypes;
        List<NamespaceMapping> thatNamespaces;
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        CompactNodeTypeDefinition that = (CompactNodeTypeDefinition)obj;
        List<NamespaceMapping> thisNamespaces = this.getNamespaceMappings();
        if (!Utils.equivalent(thisNamespaces, thatNamespaces = that.getNamespaceMappings())) {
            return false;
        }
        List<NodeTypeDefinition> thisNodeTypes = this.getNodeTypeDefinitions();
        return Utils.equivalent(thisNodeTypes, thatNodeTypes = that.getNodeTypeDefinitions());
    }

    public Collection<ChildNodeDefinition> getChildNodeDefinitions(String nodeTypeDefinitionName, boolean includeInherited) throws Exception {
        NodeTypeDefinition nodeType = this.getNodeTypeDefinition(nodeTypeDefinitionName);
        if (nodeType == null) {
            return Collections.emptyList();
        }
        ArrayList<ChildNodeDefinition> childNodes = new ArrayList<ChildNodeDefinition>(nodeType.getChildNodeDefinitions());
        if (includeInherited) {
            for (QualifiedName superType : nodeType.getSupertypes()) {
                NodeTypeDefinition superTypeNodeType = this.getNodeTypeDefinition(superType.get());
                if (superTypeNodeType == null) {
                    childNodes.addAll(WorkspaceRegistry.get().getChildNodeDefinitions(superType.get(), true));
                    continue;
                }
                if (nodeTypeDefinitionName.equals(superTypeNodeType.getName())) continue;
                childNodes.addAll(this.getChildNodeDefinitions(superTypeNodeType.getName(), true));
            }
        }
        return childNodes;
    }

    public Collection<ItemDefinition> getItemDefinitions(String nodeTypeDefinitionName, boolean includeInherited) throws Exception {
        ArrayList<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>(this.getChildNodeDefinitions(nodeTypeDefinitionName, includeInherited));
        itemDefinitions.addAll(this.getPropertyDefinitions(nodeTypeDefinitionName, includeInherited));
        Collections.sort(itemDefinitions);
        return itemDefinitions;
    }

    public List<NodeTypeDefinition> getMatchingNodeTypeDefinitions(String namespacePrefix, boolean includeInherited) {
        boolean matchEmptyPrefix = Utils.isEmpty(namespacePrefix);
        ArrayList<NodeTypeDefinition> matches = new ArrayList<NodeTypeDefinition>();
        for (NodeTypeDefinition nodeType : this.getNodeTypeDefinitions()) {
            String qualifier = nodeType.getQualifiedName().getQualifier();
            if (matchEmptyPrefix) {
                if (!Utils.isEmpty(qualifier)) continue;
                matches.add(nodeType);
                continue;
            }
            if (!namespacePrefix.equals(qualifier)) continue;
            matches.add(nodeType);
        }
        if (includeInherited) {
            try {
                matches.addAll(WorkspaceRegistry.get().getMatchingNodeTypeDefinitions(namespacePrefix));
            }
            catch (Exception e) {
                if (Platform.isRunning()) {
                    Activator.get().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, null, (Throwable)e));
                }
                System.err.print(e.getMessage());
            }
        }
        return matches;
    }

    public List<NamespaceMapping> getNamespaceMappings() {
        if (this.namespaceMappings == null) {
            return Collections.emptyList();
        }
        return this.namespaceMappings;
    }

    public Collection<String> getNamespacePrefixes() {
        List<NamespaceMapping> namespaces = this.getNamespaceMappings();
        if (namespaces.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> prefixes = new ArrayList<String>(namespaces.size());
        for (NamespaceMapping namespace : namespaces) {
            prefixes.add(namespace.getPrefix());
        }
        return prefixes;
    }

    public NodeTypeDefinition getNodeTypeDefinition(String name) {
        Utils.verifyIsNotEmpty(name, "name");
        for (NodeTypeDefinition ntd : this.getNodeTypeDefinitions()) {
            if (!name.equals(ntd.getName())) continue;
            return ntd;
        }
        return null;
    }

    public List<NodeTypeDefinition> getNodeTypeDefinitions() {
        if (this.nodeTypeDefinitions == null) {
            return Collections.emptyList();
        }
        return this.nodeTypeDefinitions;
    }

    public Collection<PropertyDefinition> getPropertyDefinitions(String nodeTypeDefinitionName, boolean includeInherited) throws Exception {
        NodeTypeDefinition nodeType = this.getNodeTypeDefinition(nodeTypeDefinitionName);
        if (nodeType == null) {
            return Collections.emptyList();
        }
        ArrayList<PropertyDefinition> properties = new ArrayList<PropertyDefinition>(nodeType.getPropertyDefinitions());
        if (includeInherited) {
            for (QualifiedName superType : nodeType.getSupertypes()) {
                NodeTypeDefinition superTypeNodeType = this.getNodeTypeDefinition(superType.get());
                if (superTypeNodeType == null) {
                    properties.addAll(WorkspaceRegistry.get().getPropertyDefinitions(superType.get(), true));
                    continue;
                }
                if (nodeTypeDefinitionName.equals(superTypeNodeType.getName())) continue;
                properties.addAll(this.getPropertyDefinitions(superTypeNodeType.getName(), true));
            }
        }
        return properties;
    }

    public int hashCode() {
        int result1 = Utils.hashCode(this.getNamespaceMappings().toArray());
        int result2 = Utils.hashCode(this.getNodeTypeDefinitions().toArray());
        return Utils.hashCode(result1, result2);
    }

    private void notifyChangeListeners(PropertyName property, Object oldValue, Object newValue) {
        assert (property != null) : "property is null";
        PropertyChangeEvent event = new PropertyChangeEvent(this, property.toString(), oldValue, newValue);
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((PropertyChangeListener)listener).propertyChange(event);
            }
            catch (Exception e) {
                if (Platform.isRunning()) {
                    Activator.get().getLog().log((IStatus)new Status(4, Activator.PLUGIN_ID, null, (Throwable)e));
                } else {
                    System.err.print(e.getMessage());
                }
                this.listeners.remove(listener);
            }
            ++n2;
        }
    }

    public boolean removeListener(PropertyChangeListener listener) {
        Utils.verifyIsNotNull(listener, "listener");
        return this.listeners.remove(listener);
    }

    public boolean removeNamespaceMapping(NamespaceMapping namespaceMappingToRemove) {
        Utils.verifyIsNotNull(namespaceMappingToRemove, "namespaceMappingToRemove");
        if (this.namespaceMappings != null && this.namespaceMappings.remove(namespaceMappingToRemove)) {
            this.notifyChangeListeners(PropertyName.NAMESPACE_MAPPINGS, namespaceMappingToRemove, null);
            if (this.namespaceMappings.isEmpty()) {
                this.namespaceMappings = null;
            }
            return true;
        }
        return false;
    }

    public boolean removeNodeTypeDefinition(NodeTypeDefinition nodeTypeDefinitionToRemove) {
        Utils.verifyIsNotNull(nodeTypeDefinitionToRemove, "nodeTypeDefinitionToRemove");
        if (this.nodeTypeDefinitions != null && this.nodeTypeDefinitions.remove(nodeTypeDefinitionToRemove)) {
            this.notifyChangeListeners(PropertyName.NODE_TYPE_DEFINITIONS, nodeTypeDefinitionToRemove, null);
            if (this.nodeTypeDefinitions.isEmpty()) {
                this.nodeTypeDefinitions = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        String DELIM;
        JcrPreferenceStore prefStore = JcrPreferenceStore.get();
        StringBuilder builder = new StringBuilder();
        boolean addDelim = false;
        if (!Utils.isEmpty(this.namespaceMappings)) {
            DELIM = prefStore.get(JcrPreferenceConstants.CndPreference.NAMESPACE_MAPPING_DELIMITER);
            for (NamespaceMapping namespaceMapping : this.namespaceMappings) {
                if (!Utils.build(builder, addDelim, DELIM, namespaceMapping.toCndNotation(notationType))) continue;
                addDelim = true;
            }
            if (CndElement.NotationType.COMPACT != notationType) {
                builder.append(prefStore.get(JcrPreferenceConstants.CndPreference.NAMESPACE_MAPPING_SECTION_END_DELIMITER));
            }
        }
        if (!Utils.isEmpty(this.nodeTypeDefinitions)) {
            DELIM = prefStore.get(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_DELIMITER);
            for (NodeTypeDefinition nodeTypeDefinition : this.nodeTypeDefinitions) {
                if (!Utils.build(builder, addDelim, DELIM, nodeTypeDefinition.toCndNotation(notationType))) continue;
                boolean bl = addDelim = CndElement.NotationType.COMPACT != notationType;
            }
            if (CndElement.NotationType.COMPACT != notationType) {
                builder.append(prefStore.get(JcrPreferenceConstants.CndPreference.NODE_TYPE_DEFINITION_SECTION_END_DELIMITER));
            }
        }
        return builder.toString();
    }

    public static enum PropertyName {
        NAMESPACE_MAPPINGS,
        NODE_TYPE_DEFINITIONS;


        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + super.toString();
        }
    }
}

