/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.attributes;

import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.attributes.AttributeState;
import org.jboss.tools.modeshape.jcr.attributes.Autocreated;
import org.jboss.tools.modeshape.jcr.attributes.Mandatory;
import org.jboss.tools.modeshape.jcr.attributes.OnParentVersion;
import org.jboss.tools.modeshape.jcr.attributes.Protected;
import org.jboss.tools.modeshape.jcr.attributes.SameNameSiblings;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceConstants;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceStore;

public class NodeAttributes
implements CndElement {
    private final Autocreated autocreated = new Autocreated();
    private final Mandatory mandatory = new Mandatory();
    private final Protected notDeletable = new Protected();
    private OnParentVersion opv = OnParentVersion.DEFAULT_VALUE;
    private final SameNameSiblings sns = new SameNameSiblings();

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        NodeAttributes that = (NodeAttributes)obj;
        return this.autocreated.equals(that.autocreated) && this.mandatory.equals(that.mandatory) && this.notDeletable.equals(that.notDeletable) && this.opv == that.opv && this.sns.equals(that.sns);
    }

    public Autocreated getAutocreated() {
        return this.autocreated;
    }

    public Mandatory getMandatory() {
        return this.mandatory;
    }

    public OnParentVersion getOnParentVersion() {
        return this.opv;
    }

    public Protected getProtected() {
        return this.notDeletable;
    }

    public SameNameSiblings getSameNameSiblings() {
        return this.sns;
    }

    public int hashCode() {
        return Utils.hashCode(this.autocreated, this.mandatory, this.notDeletable, this.opv, this.sns);
    }

    public boolean setAutocreated(AttributeState.Value newState) {
        return this.autocreated.set(newState);
    }

    public boolean setMandatory(AttributeState.Value newState) {
        return this.mandatory.set(newState);
    }

    public boolean setOnParentVersion(OnParentVersion newOpv) {
        Utils.verifyIsNotNull(newOpv, "newOpv");
        if (this.opv != newOpv) {
            this.opv = newOpv;
            return true;
        }
        return false;
    }

    public boolean setProtected(AttributeState.Value newState) {
        return this.notDeletable.set(newState);
    }

    public boolean setSameNameSibling(AttributeState.Value newState) {
        return this.sns.set(newState);
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        StringBuilder builder = new StringBuilder();
        JcrPreferenceStore prefStore = JcrPreferenceStore.get();
        String DELIM = prefStore.get(JcrPreferenceConstants.CndPreference.CHILD_NODE_ATTRIBUTES_DELIMITER);
        boolean addDelim = Utils.build(builder, false, DELIM, this.autocreated.toCndNotation(notationType));
        if (Utils.build(builder, addDelim, DELIM, this.mandatory.toCndNotation(notationType))) {
            addDelim = true;
        }
        if (Utils.build(builder, addDelim, DELIM, this.notDeletable.toCndNotation(notationType))) {
            addDelim = true;
        }
        if (Utils.build(builder, addDelim, DELIM, this.opv.toCndNotation(notationType))) {
            addDelim = true;
        }
        if (Utils.build(builder, addDelim, DELIM, this.sns.toCndNotation(notationType))) {
            addDelim = true;
        }
        return builder.toString().trim();
    }
}

