/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.ISingleClickContext;
import org.eclipse.graphiti.features.context.impl.DirectEditingContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.internal.features.context.impl.base.DoubleClickContext;
import org.eclipse.graphiti.internal.features.context.impl.base.SingleClickContext;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.contextbuttons.IContextButtonManager;
import org.eclipse.graphiti.ui.internal.parts.AnchorContainerDelegate;
import org.eclipse.graphiti.ui.internal.parts.IAnchorContainerDelegate;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.graphiti.ui.internal.parts.IShapeEditPart;
import org.eclipse.graphiti.ui.internal.parts.directedit.GFDirectEditManager;
import org.eclipse.graphiti.ui.internal.parts.directedit.TextCellLocator;
import org.eclipse.graphiti.ui.internal.policy.DefaultEditPolicyFactory;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFChopboxAnchor;
import org.eclipse.graphiti.ui.platform.GraphitiShapeEditPart;
import org.eclipse.graphiti.util.LocationInfo;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeEditPart
extends GraphitiShapeEditPart
implements IShapeEditPart,
NodeEditPart {
    private static final boolean TRACE_OUT = false;
    private final IAnchorContainerDelegate delegate;
    private boolean directEditingDelayed = false;

    public ShapeEditPart(IConfigurationProviderInternal configurationProvider, Shape shape) {
        this.delegate = new AnchorContainerDelegate(configurationProvider, (PictogramElement)shape, (EditPart)this);
        this.setModel(shape);
    }

    public void activate() {
        super.activate();
        IContextButtonManager contextButtonManager = this.getConfigurationProvider().getContextButtonManager();
        contextButtonManager.register((GraphicalEditPart)this);
        this.delegate.activate();
    }

    public void deactivate() {
        this.delegate.deactivate();
        IContextButtonManager contextButtonManager = this.getConfigurationProvider().getContextButtonManager();
        contextButtonManager.deRegister((GraphicalEditPart)this);
        super.deactivate();
    }

    @Override
    public void deleteChildAndRefresh(EditPart childEditPart) {
        this.removeChild(childEditPart);
        super.refresh();
    }

    public Object getAdapter(Class key) {
        Object ret = this.delegate.getAdapter(key);
        if (ret == null) {
            ret = super.getAdapter(key);
        }
        return ret;
    }

    @Override
    public IConfigurationProviderInternal getConfigurationProvider() {
        return this.delegate.getConfigurationProvider();
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker((EditPart)this){

            protected Collection<?> getExclusionSet() {
                Collection exclusionSet2 = super.getExclusionSet();
                LayerManager layerManager = (LayerManager)this.getCurrentViewer().getEditPartRegistry().get(LayerManager.ID);
                if (layerManager != null) {
                    exclusionSet2.remove(layerManager.getLayer((Object)"Connection Layer"));
                }
                return exclusionSet2;
            }
        };
    }

    @Override
    public List<PictogramElement> getModelChildren() {
        ArrayList<PictogramElement> ret = new ArrayList<PictogramElement>();
        ret.addAll(this.delegate.getModelChildren());
        return ret;
    }

    @Override
    public List<Connection> getModelSourceConnections() {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        Anchor anchor = this.getChopboxAnchor((AnchorContainer)((Shape)this.getModel()));
        if (anchor != null) {
            connections.addAll((Collection<Connection>)anchor.getOutgoingConnections());
        }
        return connections;
    }

    @Override
    public List<Connection> getModelTargetConnections() {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        Anchor anchor = this.getChopboxAnchor((AnchorContainer)((Shape)this.getModel()));
        if (anchor != null) {
            connections.addAll((Collection<Connection>)anchor.getIncomingConnections());
        }
        return connections;
    }

    @Override
    public PictogramElement getPictogramElement() {
        return this.delegate.getPictogramElement();
    }

    public RootEditPart getRoot() {
        return this.getConfigurationProvider().getDiagramContainer().getGraphicalViewer().getRootEditPart();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.createGFChopboxAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof CreateConnectionRequest) {
            return this.createGFChopboxAnchor();
        }
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.createGFChopboxAnchor();
    }

    private GFChopboxAnchor createGFChopboxAnchor() {
        IDiagramTypeProvider dtp = this.getConfigurationProvider().getDiagramTypeProvider();
        IToolBehaviorProvider tbp = dtp.getCurrentToolBehaviorProvider();
        GraphicsAlgorithm ga = tbp.getChopboxAnchorArea(this.getPictogramElement());
        IFigure f = this.delegate.getFigureForGraphicsAlgorithm(ga);
        if (f == null) {
            f = this.getFigure();
        }
        return new GFChopboxAnchor(f);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    public boolean isSelectable() {
        PictogramElement pe = this.getPictogramElement();
        return super.isSelectable() && pe != null && GraphitiInternal.getEmfService().isObjectAlive((EObject)pe) && pe.isActive();
    }

    public void performRequest(Request request) {
        Point point = this.getRelativeMouseLocation();
        Shape shape = (Shape)this.getModel();
        Object locationInfo = shape instanceof ConnectionDecorator && shape.getGraphicsAlgorithm() instanceof Text ? new LocationInfo(shape, shape.getGraphicsAlgorithm()) : Graphiti.getLayoutService().getLocationInfo(shape, point.x, point.y);
        if (request.getType() == "direct edit" && this.getModel() instanceof Shape) {
            IToolBehaviorProvider tbp = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            locationInfo = tbp.getLocationInfo((PictogramElement)shape, locationInfo);
            if (locationInfo != null) {
                DirectEditingContext directEditingContext = new DirectEditingContext((PictogramElement)locationInfo.getShape(), locationInfo.getGraphicsAlgorithm());
                IFeatureProvider featureProvider = this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider();
                IDirectEditingFeature directEditingFeature = featureProvider.getDirectEditingFeature((IDirectEditingContext)directEditingContext);
                if (directEditingFeature != null && directEditingFeature.canExecute((IContext)directEditingContext)) {
                    IFigure figure = this.delegate.getFigureForGraphicsAlgorithm(locationInfo.getGraphicsAlgorithm());
                    if (figure != null) {
                        this.bringUpDirectEditField(directEditingFeature, (IDirectEditingContext)directEditingContext, figure);
                    }
                } else if (request instanceof DirectEditRequest) {
                    SingleClickContext scc = new SingleClickContext(this.getPictogramElement(), (PictogramElement)locationInfo.getShape(), locationInfo.getGraphicsAlgorithm());
                    IToolBehaviorProvider currentToolBehaviorProvider = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
                    ICustomFeature singleClickFeature = currentToolBehaviorProvider.getSingleClickFeature((ISingleClickContext)scc);
                    if (singleClickFeature != null && singleClickFeature.canExecute((IContext)scc)) {
                        GenericFeatureCommandWithContext commandWithContext = new GenericFeatureCommandWithContext((IFeature)singleClickFeature, (IContext)scc);
                        DiagramBehavior diagramBehavior = this.getConfigurationProvider().getDiagramBehavior();
                        CommandStack commandStack = diagramBehavior.getEditDomain().getCommandStack();
                        commandStack.execute((Command)new GefCommandWrapper((ICommand)commandWithContext, diagramBehavior.getEditingDomain()));
                    }
                }
            }
        } else if (request.getType().equals("open") && locationInfo != null) {
            IToolBehaviorProvider currentToolBehaviorProvider;
            ICustomFeature doubleClickFeature;
            DoubleClickContext dcc = new DoubleClickContext(this.getPictogramElement(), (PictogramElement)locationInfo.getShape(), locationInfo.getGraphicsAlgorithm());
            DiagramBehavior diagramBehavior = this.getConfigurationProvider().getDiagramBehavior();
            if (request instanceof LocationRequest) {
                Point location = ((LocationRequest)request).getLocation();
                location = diagramBehavior.calculateRealMouseLocation(location);
                dcc.setLocation(location.x, location.y);
            }
            if ((doubleClickFeature = (currentToolBehaviorProvider = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider()).getDoubleClickFeature((IDoubleClickContext)dcc)) != null && doubleClickFeature.canExecute((IContext)dcc)) {
                GenericFeatureCommandWithContext commandWithContext = new GenericFeatureCommandWithContext((IFeature)doubleClickFeature, (IContext)dcc);
                CommandStack commandStack = diagramBehavior.getEditDomain().getCommandStack();
                commandStack.execute((Command)new GefCommandWrapper((ICommand)commandWithContext, diagramBehavior.getEditingDomain()));
            }
        }
        super.performRequest(request);
    }

    public void refresh() {
        if (this.getConfigurationProvider().getDiagramBehavior().isAlive()) {
            long start = System.currentTimeMillis();
            super.refresh();
            long l = System.currentTimeMillis();
        }
    }

    public void switchToDirectEditingMode(PictogramElement pictogramElement, GraphicsAlgorithm graphicsAlgorithm) {
        IFigure figure;
        if (pictogramElement == null || graphicsAlgorithm == null) {
            return;
        }
        DirectEditingContext directEditingContext = new DirectEditingContext(pictogramElement, graphicsAlgorithm);
        IFeatureProvider featureProvider = this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider();
        IDirectEditingFeature directEditingFeature = featureProvider.getDirectEditingFeature((IDirectEditingContext)directEditingContext);
        if (directEditingFeature != null && directEditingFeature.canExecute((IContext)directEditingContext) && (figure = this.delegate.getFigureForGraphicsAlgorithm(graphicsAlgorithm)) != null) {
            this.bringUpDirectEditField(directEditingFeature, (IDirectEditingContext)directEditingContext, figure);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", this.getConfigurationProvider().getEditPolicyFactory().createShapeHighlightEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createShapeForbidLayoutEditPolicy());
        this.installEditPolicy("DirectEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createDirectEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createModelObjectDeleteEditPolicy(this.getConfigurationProvider()));
        this.installEditPolicy("GraphicalNodeEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createConnectionEditPolicy());
        this.installEditPolicy(DefaultEditPolicyFactory.HOVER_POLICY_KEY, this.getConfigurationProvider().getEditPolicyFactory().createShapeHoverEditPolicy());
    }

    protected IFigure createFigure() {
        IFigure theFigure = this.delegate.createFigure();
        return theFigure;
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.delegate.refreshEditPartsForModelChildrenAndSourceConnections((EditPart)this);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshSourceConnections();
        this.refreshTargetConnections();
        this.delegate.refreshFigureForEditPart();
    }

    private void bringUpDirectEditField(IDirectEditingFeature directEditingFeature, IDirectEditingContext directEditingContext, IFigure figure) {
        if (this.isDirectEditingDelayed()) {
            return;
        }
        if (directEditingFeature.getEditingType() == 0) {
            return;
        }
        TextCellLocator cellEditorLocator = new TextCellLocator(figure, directEditingFeature);
        GFDirectEditManager directEditManager = new GFDirectEditManager(this, cellEditorLocator);
        directEditManager.setDirectEditingFeature(directEditingFeature);
        directEditManager.setDirectEditingContext(directEditingContext);
        directEditManager.show();
        this.getConfigurationProvider().getDiagramBehavior().setPictogramElementForSelection(this.getPictogramElement());
    }

    private Anchor getChopboxAnchor(AnchorContainer anchorContainer) {
        if (GraphitiInternal.getEmfService().isObjectAlive((EObject)anchorContainer)) {
            EList existingAnchors = anchorContainer.getAnchors();
            for (Anchor anchor : existingAnchors) {
                if (!(anchor instanceof ChopboxAnchor)) continue;
                return anchor;
            }
        }
        return null;
    }

    private Point getRelativeMouseLocation() {
        DiagramBehavior diagramBehavior = this.getConfigurationProvider().getDiagramBehavior();
        Point mouseLocation = new Point(diagramBehavior.getMouseLocation());
        mouseLocation = diagramBehavior.calculateRealMouseLocation(mouseLocation);
        Rectangle bounds = this.getFigure().getBounds().getCopy();
        bounds.setLocation(diagramBehavior.calculateRealMouseLocation(bounds.getLocation()));
        this.getFigure().translateToAbsolute((Translatable)bounds);
        mouseLocation = mouseLocation.getTranslated(bounds.getLocation().getNegated());
        return mouseLocation;
    }

    public EditPart getTargetEditPart(Request request) {
        Object object;
        IConfigurationProviderInternal configurationProvider;
        PictogramElement alternativeSelection;
        if ((request instanceof SelectionRequest || request != null && request.getType() != null && "selection".equalsIgnoreCase(request.getType().toString())) && (alternativeSelection = (configurationProvider = this.getConfigurationProvider()).getDiagramTypeProvider().getCurrentToolBehaviorProvider().getSelection(this.getPictogramElement(), configurationProvider.getDiagramBehavior().getSelectedPictogramElements())) != null && (object = configurationProvider.getDiagramContainer().getGraphicalViewer().getEditPartRegistry().get(alternativeSelection)) instanceof EditPart) {
            return (EditPart)object;
        }
        return super.getTargetEditPart(request);
    }

    public void showSourceFeedback(Request request) {
        if (("move".equals(request.getType()) || "add children".equals(request.getType())) && request instanceof ChangeBoundsRequest) {
            Shape shape = (Shape)this.getPictogramElement();
            ContainerShape containerShape = shape.getContainer();
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            Point oldLocation = this.getFigure().getBounds().getLocation();
            Point currentDelta = changeBoundsRequest.getMoveDelta();
            IMoveShapeContext context = this.createMoveShapeContext(shape, containerShape, containerShape, oldLocation, currentDelta);
            IMoveShapeFeature moveShapeFeature = this.getConfigurationProvider().getFeatureProvider().getMoveShapeFeature(context);
            if (moveShapeFeature == null) {
                return;
            }
        }
        super.showSourceFeedback(request);
    }

    private IMoveShapeContext createMoveShapeContext(Shape shape, ContainerShape source, ContainerShape target, Point location, Point delta) {
        MoveShapeContext ret = new MoveShapeContext(shape);
        ret.setSourceContainer(source);
        ret.setTargetContainer(target);
        ret.setX(location.x);
        ret.setY(location.y);
        ret.setDeltaX(delta.x);
        ret.setDeltaY(delta.y);
        return ret;
    }

    public IFeatureProvider getFeatureProvider() {
        IFeatureProvider ret = null;
        if (this.delegate != null) {
            ret = this.delegate.getFeatureProvider();
        }
        return ret;
    }

    @Override
    public IPictogramElementDelegate getPictogramElementDelegate() {
        return this.delegate;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode());
    }

    @Override
    public void refreshDecorators() {
        this.delegate.refreshDecorators();
    }

    public void delayDirectEditing() {
        this.setDirectEditingDelayed(true);
        Runnable runnable = new Runnable(){

            public void run() {
                ShapeEditPart.this.setDirectEditingDelayed(false);
            }
        };
        Display.getCurrent().timerExec(600, runnable);
    }

    private boolean isDirectEditingDelayed() {
        return this.directEditingDelayed;
    }

    private void setDirectEditingDelayed(boolean directEditingDelayed) {
        this.directEditingDelayed = directEditingDelayed;
    }
}

