/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpel;

import javax.xml.namespace.QName;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.platform.GFPropertySection;
import org.eclipse.soa.sca.sca1_1.model.sca.BPELImplementation;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.bpel.Activator;
import org.switchyard.tools.ui.bpel.BPELResourceAdapterFactory;
import org.switchyard.tools.ui.bpel.Messages;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;

public class BPELImplementationPropertySection
extends GFPropertySection
implements ITabbedPropertyConstants {
    private Composite _panel;
    private Link _newBPELLink;
    private Text _bpelFileText;
    private Button _browseBPELButton;
    private BPELImplementation _implementation;
    private IProject _project;
    private boolean _updating;

    public void refresh() {
        this._implementation = null;
        PictogramElement pe = this.getSelectedPictogramElement();
        if (pe != null) {
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            this._implementation = (BPELImplementation)((Component)bo).getImplementation();
            this._project = PlatformResourceAdapterFactory.getContainingProject((Object)this._implementation);
        }
        this._updating = true;
        try {
            if (this._implementation == null || this._implementation.getProcess() == null) {
                this._bpelFileText.setText("");
            } else {
                this._bpelFileText.setText(this._implementation.getProcess().toString());
            }
        }
        finally {
            this._updating = false;
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this._panel = factory.createComposite(parent);
        this._panel.setLayout((Layout)new GridLayout(3, false));
        this._newBPELLink = new Link(this._panel, 0);
        this._newBPELLink.setText("<a>" + Messages.BPELImplementationPropertySection_textLabel + "</a>");
        this._newBPELLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BPELImplementationPropertySection.this.openFile();
            }
        });
        this._bpelFileText = factory.createText(this._panel, "", 8);
        this._bpelFileText.setLayoutData((Object)new GridData(768));
        this._bpelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                QName newValue;
                QName qName = newValue = BPELImplementationPropertySection.this._bpelFileText.getText().length() == 0 ? null : QName.valueOf(BPELImplementationPropertySection.this._bpelFileText.getText());
                if (!BPELImplementationPropertySection.this._updating && (newValue == null && BPELImplementationPropertySection.this._implementation.getProcess() != null || newValue != null && !newValue.equals(BPELImplementationPropertySection.this._implementation.getProcess()))) {
                    BPELImplementationPropertySection.this.wrapOperation(new Runnable(){

                        @Override
                        public void run() {
                            BPELImplementationPropertySection.this._implementation.setProcess(newValue);
                        }
                    });
                }
            }
        });
        this._browseBPELButton = factory.createButton(this._panel, Messages.BPELImplementationPropertySection_browseButtonLabel, 8);
        this._browseBPELButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BPELImplementationPropertySection.this.handleBrowse();
            }
        });
    }

    private void openFile() {
        IFile resource = BPELResourceAdapterFactory.getFileForObject(this._implementation, this._project);
        if (resource != null) {
            try {
                IDE.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (IFile)resource);
            }
            catch (PartInitException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    private void handleBrowse() {
        Object[] result;
        Object container = this._project == null ? ResourcesPlugin.getWorkspace().getRoot() : this._project.getProject();
        ClasspathResourceSelectionDialog dialog = new ClasspathResourceSelectionDialog(this._panel.getShell(), (IContainer)container, "bpel");
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IFile) {
            IFile bpelFile = (IFile)result[0];
            String bpelFilePath = JavaUtil.getJavaPathForResource((IResource)bpelFile).toString();
            this._implementation = ScaFactory.eINSTANCE.createBPELImplementation();
            QName processName = Activator.getDefault().getProcessForFile(bpelFile);
            this._implementation.setProcess(processName);
            this._bpelFileText.setText(bpelFilePath);
        }
    }

    private void wrapOperation(final Runnable runner) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this._implementation);
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    try {
                        runner.run();
                    }
                    catch (Exception e) {
                        Activator.logError(e);
                    }
                }
            });
        } else {
            try {
                runner.run();
            }
            catch (Exception e) {
                Activator.logError(e);
            }
        }
    }
}

