/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpel;

import javax.xml.namespace.QName;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.switchyard.tools.ui.JavaUtil;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.switchyard.tools.ui.bpel";
    public static final QualifiedName PROCESS_NAME_PROPERTY = new QualifiedName("org.switchyard.tools.ui.bpel", "bpelProcessName");
    private static final QName NULL_NAME = new QName("null:NULL", "null");
    private static Activator plugin;
    private IResourceChangeListener _resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            Activator.this.clearRelated(event.getDelta());
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this._resourceListener, 1);
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this._resourceListener);
        plugin = null;
        super.stop(context);
    }

    public IFile getFileForProcess(IProject project, QName process) {
        if (process == null || project == null || !project.isAccessible()) {
            return null;
        }
        IContainer resourceRoot = (IContainer)JavaUtil.getFirstResourceRoot((IJavaProject)JavaCore.create((IProject)project));
        if (resourceRoot == null) {
            return null;
        }
        try {
            IResource[] iResourceArray = resourceRoot.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 1 && "bpel".equals(resource.getFileExtension())) {
                    QName processName = (QName)resource.getSessionProperty(PROCESS_NAME_PROPERTY);
                    if (processName == null) {
                        processName = this.loadProcessName((IFile)resource);
                        resource.setSessionProperty(PROCESS_NAME_PROPERTY, (Object)processName);
                    }
                    if (processName.equals(process)) {
                        return (IFile)resource;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        return null;
    }

    public QName getProcessForFile(IFile file) {
        if (file == null || !file.isAccessible()) {
            return null;
        }
        try {
            QName name = (QName)file.getSessionProperty(PROCESS_NAME_PROPERTY);
            if (name == null) {
                name = this.loadProcessName(file);
                file.setSessionProperty(PROCESS_NAME_PROPERTY, (Object)name);
            }
            return name == NULL_NAME ? null : name;
        }
        catch (Exception e) {
            e.fillInStackTrace();
            return null;
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logError(Exception e) {
        Activator.getDefault().getLog().log((IStatus)Activator.createStatus(e));
    }

    private static Status createStatus(Exception e) {
        return new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e);
    }

    private void clearRelated(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource.getType() == 1) {
            if ("bpel".equals(resource.getFileExtension()) && (delta.getFlags() & 0x100) == 256) {
                try {
                    resource.setSessionProperty(PROCESS_NAME_PROPERTY, null);
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
            }
        } else if (resource.getType() == 4) {
            IContainer rootContainer = (IContainer)JavaUtil.getFirstResourceRoot((IJavaProject)JavaCore.create((IProject)((IProject)resource)));
            if (rootContainer == null) {
                return;
            }
            IResourceDelta containerDelta = delta.findMember(rootContainer.getProjectRelativePath());
            IResourceDelta[] iResourceDeltaArray = containerDelta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta memberDelta = iResourceDeltaArray[n2];
                this.clearRelated(memberDelta);
                ++n2;
            }
        }
    }

    private QName loadProcessName(IFile file) {
        QName qName;
        Process process = BPELUtil.getProcess((IResource)file, (ResourceSet)BPELUtil.createResourceSetImpl());
        try {
            String name = process.getName();
            String fileName = file.getName();
            qName = name == null ? NULL_NAME : new QName(process.getTargetNamespace(), process.getName(), String.valueOf(fileName.substring(0, 1).toLowerCase()) + fileName.substring(1, fileName.lastIndexOf(46)));
        }
        catch (Throwable throwable) {
            try {
                process.eResource().unload();
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        process.eResource().unload();
        return qName;
    }
}

