/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.Messages;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.extension.properties.Translation;

public class ModelExtensionPropertyDefinitionImpl
implements ModelExtensionPropertyDefinition {
    private boolean advanced = false;
    private Set<String> allowedValues;
    private String defaultValue;
    private Set<Translation> descriptions;
    private Set<Translation> displayNames;
    private String fixedValue;
    private boolean index = true;
    private CopyOnWriteArrayList<PropertyChangeListener> listeners;
    private boolean masked = false;
    private NamespaceProvider namespaceProvider;
    private boolean required = false;
    private String simpleId;
    private ModelExtensionPropertyDefinition.Type type = TYPE_DEFAULT;

    public ModelExtensionPropertyDefinitionImpl(NamespaceProvider namespacePrefixProvider) {
        CoreArgCheck.isNotNull((Object)namespacePrefixProvider, (String)"namespaceProvider is null");
        this.namespaceProvider = namespacePrefixProvider;
        this.listeners = new CopyOnWriteArrayList();
        this.allowedValues = new HashSet<String>();
        this.descriptions = new HashSet<Translation>();
        this.displayNames = new HashSet<Translation>();
    }

    public ModelExtensionPropertyDefinitionImpl(NamespaceProvider namespaceProvider, String simpleId, String runtimeType, String required, String defaultValue, String fixedValue, String advanced, String masked, String index, Set<String> allowedValues, Set<Translation> descriptions, Set<Translation> displayNames) {
        this(namespaceProvider);
        this.simpleId = simpleId;
        this.defaultValue = defaultValue;
        this.fixedValue = fixedValue;
        if (!CoreStringUtil.isEmpty((String)runtimeType)) {
            try {
                ModelExtensionPropertyDefinition.Type newType = ModelExtensionPropertyDefinition.Utils.convertRuntimeType(runtimeType);
                this.setType(newType);
            }
            catch (IllegalArgumentException e) {
                ExtensionPlugin.Util.log((Throwable)e);
            }
        }
        if (!CoreStringUtil.isEmpty((String)required)) {
            this.required = Boolean.parseBoolean(required);
        }
        if (!CoreStringUtil.isEmpty((String)advanced)) {
            this.advanced = Boolean.parseBoolean(advanced);
        }
        if (!CoreStringUtil.isEmpty((String)masked)) {
            this.masked = Boolean.parseBoolean(masked);
        }
        if (!CoreStringUtil.isEmpty((String)index)) {
            this.index = Boolean.parseBoolean(index);
        }
        if (ModelExtensionPropertyDefinition.Type.BOOLEAN == this.type) {
            this.allowedValues.add(BOOLEAN_ALLOWED_VALUES[0]);
            this.allowedValues.add(BOOLEAN_ALLOWED_VALUES[1]);
        }
        if (descriptions != null) {
            this.descriptions.addAll(descriptions);
        }
        if (displayNames != null) {
            this.displayNames.addAll(displayNames);
        }
        if (allowedValues != null) {
            this.allowedValues.addAll(allowedValues);
        }
    }

    @Override
    public boolean addAllowedValue(String newAllowedValue) {
        CoreStringUtil.isEmpty((String)newAllowedValue);
        boolean added = this.allowedValues.add(newAllowedValue);
        if (added) {
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.ALLOWED_VALUES, null, newAllowedValue);
        }
        return added;
    }

    @Override
    public boolean addDescription(Translation newDescription) {
        CoreArgCheck.isNotNull((Object)newDescription, (String)"newDescription is null");
        boolean added = this.descriptions.add(newDescription);
        if (added) {
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.DESCRIPTION, null, newDescription);
        }
        return added;
    }

    @Override
    public boolean addDisplayName(Translation newDisplayName) {
        CoreArgCheck.isNotNull((Object)newDisplayName, (String)"newDisplayName is null");
        boolean added = this.displayNames.add(newDisplayName);
        if (added) {
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.DISPLAY_NAME, null, newDisplayName);
        }
        return added;
    }

    @Override
    public boolean addListener(PropertyChangeListener newListener) {
        CoreArgCheck.isNotNull((Object)newListener, (String)"newListener is null");
        return this.listeners.addIfAbsent(newListener);
    }

    @Override
    public Set<String> allowedValues() {
        return new HashSet<String>(this.allowedValues);
    }

    @Override
    public Object clone() {
        try {
            ModelExtensionPropertyDefinitionImpl copy = (ModelExtensionPropertyDefinitionImpl)super.clone();
            copy.listeners = new CopyOnWriteArrayList();
            copy.allowedValues = new HashSet<String>(this.allowedValues);
            copy.descriptions = new HashSet<Translation>();
            for (Translation description : this.descriptions) {
                copy.descriptions.add((Translation)description.clone());
            }
            copy.displayNames = new HashSet<Translation>(this.displayNames);
            for (Translation description : this.descriptions) {
                copy.descriptions.add((Translation)description.clone());
            }
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("should never happen");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ModelExtensionPropertyDefinition that = (ModelExtensionPropertyDefinition)obj;
        if (this.getType() != that.getType() || this.isAdvanced() != that.isAdvanced() || this.shouldBeIndexed() != that.shouldBeIndexed() || this.isMasked() != that.isMasked() || this.isRequired() != that.isRequired()) {
            return false;
        }
        if (!(CoreStringUtil.valuesAreEqual((String)this.getSimpleId(), (String)that.getSimpleId()) && CoreStringUtil.valuesAreEqual((String)this.getId(), (String)that.getId()) && CoreStringUtil.valuesAreEqual((String)this.getFixedValue(), (String)that.getFixedValue()) && CoreStringUtil.valuesAreEqual((String)this.getDefaultValue(), (String)that.getDefaultValue()))) {
            return false;
        }
        Set<String> thisValues = this.allowedValues();
        Set<String> thatValues = that.allowedValues();
        if (thisValues.size() != thatValues.size()) {
            return false;
        }
        if (!thisValues.isEmpty() && !thisValues.containsAll(thatValues)) {
            return false;
        }
        Set<Translation> thisDescriptions = this.getDescriptions();
        Set<Translation> thatDescriptions = that.getDescriptions();
        if (thisDescriptions.size() != thatDescriptions.size()) {
            return false;
        }
        if (!thisDescriptions.isEmpty() && !thisDescriptions.containsAll(thatDescriptions)) {
            return false;
        }
        Set<Translation> thisDisplayNames = this.getDisplayNames();
        Set<Translation> thatDisplayNames = that.getDisplayNames();
        if (thisDisplayNames.size() != thatDisplayNames.size()) {
            return false;
        }
        return thisDisplayNames.isEmpty() || thisDisplayNames.containsAll(thatDisplayNames);
    }

    private String findTranslationMatch(Set<Translation> translations) {
        Locale defaultLocale = Locale.getDefault();
        String defaultLanguage = defaultLocale.getLanguage();
        String defaultCountry = defaultLocale.getCountry();
        String languageCountryMatch = null;
        String languageMatch = null;
        for (Translation translation : translations) {
            Locale locale = translation.getLocale();
            if (defaultLocale.equals(translation.getLocale())) {
                return translation.getTranslation();
            }
            String language = locale.getLanguage();
            String country = locale.getCountry();
            if (CoreStringUtil.equals((String)defaultLanguage, (String)language) && CoreStringUtil.equals((String)defaultCountry, (String)country)) {
                languageCountryMatch = translation.getTranslation();
                continue;
            }
            if (!CoreStringUtil.equals((String)defaultLanguage, (String)language)) continue;
            languageMatch = translation.getTranslation();
        }
        return languageCountryMatch == null ? languageMatch : languageCountryMatch;
    }

    public String[] getAllowedValues() {
        return this.allowedValues.toArray(new String[this.allowedValues.size()]);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.findTranslationMatch(this.descriptions);
    }

    @Override
    public Set<Translation> getDescriptions() {
        return this.descriptions;
    }

    public String getDisplayName() {
        return this.findTranslationMatch(this.displayNames);
    }

    @Override
    public Set<Translation> getDisplayNames() {
        return this.displayNames;
    }

    @Override
    public String getFixedValue() {
        return this.fixedValue;
    }

    public String getId() {
        return ModelExtensionPropertyDefinition.Utils.getPropertyId(this.namespaceProvider, this.simpleId);
    }

    @Override
    public NamespaceProvider getNamespaceProvider() {
        return this.namespaceProvider;
    }

    @Override
    public String getRuntimeType() {
        return this.type == null ? null : this.type.getRuntimeType();
    }

    @Override
    public String getSimpleId() {
        return this.simpleId;
    }

    @Override
    public ModelExtensionPropertyDefinition.Type getType() {
        return this.type;
    }

    public int hashCode() {
        Set<Translation> translations;
        int result = HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getType()});
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isAdvanced());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.shouldBeIndexed());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isMasked());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isRequired());
        if (!CoreStringUtil.isEmpty((String)this.getSimpleId())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getSimpleId()});
            if (!CoreStringUtil.isEmpty((String)this.getId())) {
                result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getId()});
            }
        }
        if (!CoreStringUtil.isEmpty((String)this.getFixedValue())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getFixedValue()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getDefaultValue())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getDefaultValue()});
        }
        if (!this.allowedValues().isEmpty()) {
            ArrayList<String> sortedValues = new ArrayList<String>(this.allowedValues());
            Collections.sort(sortedValues);
            for (String allowedValue : sortedValues) {
                result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{allowedValue});
            }
        }
        if (!(translations = this.getDescriptions()).isEmpty()) {
            ArrayList<Translation> sortedDescriptions = new ArrayList<Translation>(translations);
            Collections.sort(sortedDescriptions);
            for (Translation description : sortedDescriptions) {
                result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{description});
            }
        }
        if (!(translations = this.getDisplayNames()).isEmpty()) {
            ArrayList<Translation> sortedDisplayNames = new ArrayList<Translation>(translations);
            Collections.sort(sortedDisplayNames);
            for (Translation description : sortedDisplayNames) {
                result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{description});
            }
        }
        return result;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public boolean isMasked() {
        return this.masked;
    }

    public boolean isModifiable() {
        return CoreStringUtil.isEmpty((String)this.fixedValue);
    }

    public boolean isRequired() {
        return this.required;
    }

    public String isValidValue(String proposedValue) {
        return ModelExtensionPropertyDefinition.Utils.isValidValue(NLS.bind((String)Messages.propertyValue, (Object)this.getId()), this.type, proposedValue, this.required, this.getAllowedValues());
    }

    private void notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, property.toString(), oldValue, newValue);
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((PropertyChangeListener)listener).propertyChange(event);
            }
            catch (Exception e) {
                ExtensionPlugin.Util.log((Throwable)e);
                this.listeners.remove(listener);
            }
            ++n2;
        }
    }

    @Override
    public boolean removeAllowedValue(String allowedValueBeingRemoved) {
        CoreStringUtil.isEmpty((String)allowedValueBeingRemoved);
        String oldValue = allowedValueBeingRemoved;
        boolean removed = this.allowedValues.remove(allowedValueBeingRemoved);
        if (removed) {
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.ALLOWED_VALUES, oldValue, null);
        }
        return removed;
    }

    @Override
    public boolean removeDescription(Translation descriptionBeingRemoved) {
        CoreArgCheck.isNotNull((Object)descriptionBeingRemoved, (String)"description is null");
        Translation oldValue = descriptionBeingRemoved;
        boolean removed = this.descriptions.remove(descriptionBeingRemoved);
        if (removed) {
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.DESCRIPTION, oldValue, null);
        }
        return removed;
    }

    @Override
    public boolean removeDisplayName(Translation displayNameBeingRemoved) {
        CoreArgCheck.isNotNull((Object)displayNameBeingRemoved, (String)"displayName is null");
        Translation oldValue = displayNameBeingRemoved;
        boolean removed = this.displayNames.remove(displayNameBeingRemoved);
        if (removed) {
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.DISPLAY_NAME, oldValue, null);
        }
        return removed;
    }

    @Override
    public boolean removeListener(PropertyChangeListener listener) {
        CoreArgCheck.isNotNull((Object)listener, (String)"listener is null");
        return this.listeners.remove(listener);
    }

    @Override
    public void setAdvanced(boolean newAdvanced) {
        if (this.advanced != newAdvanced) {
            this.advanced = newAdvanced;
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.ADVANCED, !this.advanced, this.advanced);
        }
    }

    @Override
    public void setAllowedValues(Set<String> newAllowedValues) {
        boolean clearAllowedValues;
        boolean bl = clearAllowedValues = newAllowedValues == null || newAllowedValues.isEmpty();
        if (ModelExtensionPropertyDefinition.Type.BOOLEAN == this.type) {
            boolean error = false;
            if (clearAllowedValues || BOOLEAN_ALLOWED_VALUES.length != newAllowedValues.size()) {
                error = true;
            } else {
                String[] booleanValues = newAllowedValues.toArray(new String[BOOLEAN_ALLOWED_VALUES.length]);
                if (CoreStringUtil.isEmpty((String)booleanValues[0]) || CoreStringUtil.isEmpty((String)booleanValues[1])) {
                    error = true;
                } else if (!booleanValues[0].toLowerCase().equals(BOOLEAN_ALLOWED_VALUES[0].toLowerCase()) && !booleanValues[0].toLowerCase().equals(BOOLEAN_ALLOWED_VALUES[1].toLowerCase())) {
                    error = true;
                } else if (!booleanValues[1].toLowerCase().equals(BOOLEAN_ALLOWED_VALUES[0].toLowerCase()) && !booleanValues[1].toLowerCase().equals(BOOLEAN_ALLOWED_VALUES[1].toLowerCase())) {
                    error = true;
                }
            }
            if (error) {
                ExtensionPlugin.Util.log(2, NLS.bind((String)Messages.invalidBooleanAllowedValue, (Object)this.getId()));
                newAllowedValues = new HashSet<String>(2);
                newAllowedValues.add(BOOLEAN_ALLOWED_VALUES[0]);
                newAllowedValues.add(BOOLEAN_ALLOWED_VALUES[1]);
            }
        }
        boolean changed = false;
        if (this.allowedValues.isEmpty() && !clearAllowedValues) {
            changed = true;
        } else if (!this.allowedValues.isEmpty() && clearAllowedValues) {
            changed = true;
        } else if (this.allowedValues.size() != newAllowedValues.size()) {
            changed = true;
        } else {
            for (String value : this.allowedValues) {
                if (newAllowedValues.contains(value)) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            HashSet<String> oldValue = new HashSet<String>(this.allowedValues);
            this.allowedValues.clear();
            this.allowedValues.addAll(newAllowedValues);
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.ALLOWED_VALUES, oldValue, this.allowedValues);
        }
    }

    @Override
    public void setDefaultValue(String newDefaultValue) {
        if (!CoreStringUtil.valuesAreEqual((String)this.defaultValue, (String)newDefaultValue)) {
            String oldValue = this.defaultValue;
            this.defaultValue = newDefaultValue;
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.DEFAULT_VALUE, oldValue, this.defaultValue);
        }
    }

    @Override
    public void setDescriptions(Set<Translation> newDescriptions) {
        boolean changed = true;
        if (newDescriptions != null && this.descriptions.size() == newDescriptions.size() && this.descriptions.containsAll(newDescriptions)) {
            changed = false;
        }
        if (changed) {
            HashSet<Translation> oldValue = new HashSet<Translation>(this.descriptions);
            this.descriptions.clear();
            if (newDescriptions != null) {
                this.descriptions.addAll(newDescriptions);
            }
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.DESCRIPTION, oldValue, this.descriptions);
        }
    }

    @Override
    public void setDisplayNames(Set<Translation> newDisplayNames) {
        boolean changed = true;
        if (newDisplayNames != null && this.displayNames.size() == newDisplayNames.size() && this.displayNames.containsAll(newDisplayNames)) {
            changed = false;
        }
        if (changed) {
            HashSet<Translation> oldValue = new HashSet<Translation>(this.displayNames);
            this.displayNames.clear();
            if (newDisplayNames != null) {
                this.displayNames.addAll(newDisplayNames);
            }
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.DISPLAY_NAME, oldValue, this.displayNames);
        }
    }

    @Override
    public void setFixedValue(String newFixedValue) {
        if (!CoreStringUtil.valuesAreEqual((String)this.fixedValue, (String)newFixedValue)) {
            String oldValue = this.fixedValue;
            this.fixedValue = newFixedValue;
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.FIXED_VALUE, oldValue, this.fixedValue);
        }
    }

    @Override
    public void setIndex(boolean newIndex) {
        if (this.index != newIndex) {
            this.index = newIndex;
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.INDEX, !this.index, this.index);
        }
    }

    @Override
    public void setMasked(boolean newMasked) {
        if (this.masked != newMasked) {
            this.masked = newMasked;
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.MASKED, !this.masked, this.masked);
        }
    }

    @Override
    public void setNamespaceProvider(NamespaceProvider newNamespaceProvider) {
        CoreArgCheck.isNotNull((Object)newNamespaceProvider, (String)"newNamespaceProvider is null");
        this.namespaceProvider = newNamespaceProvider;
    }

    @Override
    public void setRequired(boolean newRequired) {
        if (this.required != newRequired) {
            this.required = newRequired;
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.REQUIRED, !this.required, this.required);
        }
    }

    @Override
    public void setSimpleId(String newSimpleId) {
        if (!CoreStringUtil.valuesAreEqual((String)this.simpleId, (String)newSimpleId)) {
            String oldValue = this.simpleId;
            this.simpleId = newSimpleId;
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.SIMPLE_ID, oldValue, this.simpleId);
        }
    }

    @Override
    public void setType(ModelExtensionPropertyDefinition.Type newRuntimeType) {
        if (this.type != newRuntimeType) {
            ModelExtensionPropertyDefinition.Type oldValue = this.type;
            this.type = newRuntimeType;
            this.notifyChangeListeners(ModelExtensionPropertyDefinition.PropertyName.TYPE, (Object)oldValue, (Object)this.type);
            if (ModelExtensionPropertyDefinition.Type.BOOLEAN == this.type) {
                HashSet<String> newAllowedValues = new HashSet<String>(2);
                newAllowedValues.add(BOOLEAN_ALLOWED_VALUES[0]);
                newAllowedValues.add(BOOLEAN_ALLOWED_VALUES[1]);
                this.setAllowedValues(newAllowedValues);
            }
        }
    }

    @Override
    public boolean shouldBeIndexed() {
        return this.index;
    }

    public String toString() {
        return "Model Extension Property: id=" + this.getId();
    }
}

