/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.definition;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.util.ArrayUtil;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.Messages;
import org.teiid.designer.extension.definition.MedStatus;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionHeader;
import org.teiid.designer.extension.definition.MultiValidationStatus;
import org.teiid.designer.extension.definition.ValidationStatus;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.Translation;

public final class ModelExtensionDefinitionValidator {
    private static MedStatus addStatus(MedStatus currentStatus, MedStatus statusToAdd) {
        if (statusToAdd.isOk()) {
            return currentStatus;
        }
        MultiValidationStatus multi = null;
        multi = currentStatus.isMulti() ? (MultiValidationStatus)currentStatus : MultiValidationStatus.create(currentStatus);
        multi.add(statusToAdd);
        return multi;
    }

    private static String containsOnlyIdCharactersCheck(String propertyName, String value) {
        if (!CoreStringUtil.isEmpty((String)value)) {
            char[] cArray = value.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isLetterOrDigit(c) && c != '_' && c != '-') {
                    return NLS.bind((String)Messages.invalidPropertyId, (Object)value);
                }
                ++n2;
            }
        }
        return null;
    }

    private static String containsSpecialCharactersCheck(String propertyName, String value) {
        if (!CoreStringUtil.isEmpty((String)value)) {
            char[] cArray = value.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isLetterOrDigit(c)) {
                    return NLS.bind((String)Messages.valueContainsSpecialCharactersValidationMsg, (Object)propertyName);
                }
                ++n2;
            }
        }
        return null;
    }

    private static String containsSpacesCheck(String propertyName, String value) {
        if (!CoreStringUtil.isEmpty((String)value) && value.contains(CoreStringUtil.Constants.SPACE)) {
            return NLS.bind((String)Messages.valueContainsSpacesValidationMsg, (Object)propertyName);
        }
        return null;
    }

    private static String emptyCheck(String propertyName, String value) {
        if (CoreStringUtil.isEmpty((String)value)) {
            return NLS.bind((String)Messages.propertyIsEmptyValidationMsg, (Object)propertyName);
        }
        return null;
    }

    private static String nullCheck(String name, Object object) {
        if (object == null) {
            return NLS.bind((String)Messages.objectIsNullValidationMsg, (Object)name);
        }
        return null;
    }

    private static String uriCheck(String propertyName, String value) {
        String errorMsg = ModelExtensionDefinitionValidator.emptyCheck(propertyName, value);
        if (CoreStringUtil.isEmpty((String)errorMsg) && CoreStringUtil.isEmpty((String)(errorMsg = ModelExtensionDefinitionValidator.containsSpacesCheck(propertyName, value)))) {
            try {
                URI.create(value);
            }
            catch (Exception exception) {
                errorMsg = NLS.bind((String)Messages.uriInvalidValidationMsg, (Object)propertyName);
            }
        }
        return errorMsg;
    }

    public static MedStatus validateDescription(String description) {
        return ValidationStatus.OK_STATUS;
    }

    public static MedStatus validateMed(ModelExtensionDefinition med, Collection<String> existingNamespacePrefixes, Collection<String> existingNamespaceUris, Collection<String> extendableMetamodelUris, Set<String> validModelTypes) {
        boolean builtIn = med.isBuiltIn();
        boolean imported = med.isImported();
        if (!builtIn && !imported) {
            MedStatus status = ModelExtensionDefinitionValidator.validateMedHeader(med.getHeader(), existingNamespacePrefixes, existingNamespaceUris, extendableMetamodelUris, validModelTypes);
            status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validateMetaclassNames(med.getExtendedMetaclasses(), true));
            return ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validatePropertyDefinitions(med.getPropertyDefinitions()));
        }
        return ValidationStatus.OK_STATUS;
    }

    public static MedStatus validateMedHeader(ModelExtensionDefinitionHeader header, Collection<String> existingNamespacePrefixes, Collection<String> existingNamespaceUris, Collection<String> extendableMetamodelUris, Set<String> validModelTypes) {
        MedStatus status = ModelExtensionDefinitionValidator.validateNamespacePrefix(header.getNamespacePrefix(), existingNamespacePrefixes);
        status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validateNamespaceUri(header.getNamespaceUri(), existingNamespaceUris));
        status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validateMetamodelUri(header.getMetamodelUri(), extendableMetamodelUris));
        status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validateModelTypes(header.getSupportedModelTypes(), validModelTypes));
        status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validateDescription(header.getDescription()));
        return ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validateVersion(Integer.toString(header.getVersion())));
    }

    public static MedStatus validateMetaclassName(String metaclassName) {
        String errorMsg = ModelExtensionDefinitionValidator.emptyCheck(Messages.metaclassName, metaclassName);
        if (CoreStringUtil.isEmpty((String)errorMsg)) {
            char[] cArray = metaclassName.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c != '.' && !Character.isJavaIdentifierPart(c)) {
                    errorMsg = Messages.metaclassNameHasInvalidCharactersValidationMsg;
                    break;
                }
                ++n2;
            }
        }
        if (CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.OK_STATUS;
        }
        return ValidationStatus.createErrorMessage(errorMsg);
    }

    public static MedStatus validateMetaclassNames(String[] metaclassNames, boolean validateEachName) {
        if (metaclassNames == null || metaclassNames.length == 0) {
            return ValidationStatus.createErrorMessage(Messages.medHasNoMetaclassesValidationMsg);
        }
        MedStatus status = ValidationStatus.OK_STATUS;
        if (metaclassNames.length != new HashSet<String>(Arrays.asList(metaclassNames)).size()) {
            status = MultiValidationStatus.create(ValidationStatus.createErrorMessage(Messages.medHasDuplicateMetaclassesValidationMsg));
        }
        if (validateEachName) {
            String[] stringArray = metaclassNames;
            int n = metaclassNames.length;
            int n2 = 0;
            while (n2 < n) {
                String metaclassName = stringArray[n2];
                status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validateMetaclassName(metaclassName));
                ++n2;
            }
        }
        return status;
    }

    public static MedStatus validateMetamodelUri(String metamodelUri, Collection<String> extendableMetamodelUris) {
        String errorMsg = ModelExtensionDefinitionValidator.uriCheck(Messages.metamodelUri, metamodelUri);
        if (CoreStringUtil.isEmpty((String)errorMsg) && (extendableMetamodelUris == null || !extendableMetamodelUris.contains(metamodelUri))) {
            errorMsg = NLS.bind((String)Messages.metamodelUriNotExtendableValidationMsg, (Object)metamodelUri);
        }
        if (CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.OK_STATUS;
        }
        return ValidationStatus.createErrorMessage(errorMsg);
    }

    public static MedStatus validateModelType(String supportedModelType, Set<String> validModelTypes) {
        String errorMsg = ModelExtensionDefinitionValidator.emptyCheck(Messages.modelType, supportedModelType);
        if (!CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.createErrorMessage(errorMsg);
        }
        if (validModelTypes != null && !validModelTypes.isEmpty() && validModelTypes.contains(supportedModelType)) {
            return ValidationStatus.OK_STATUS;
        }
        return ValidationStatus.createErrorMessage(NLS.bind((String)Messages.invalidModelType, (Object)supportedModelType));
    }

    public static MedStatus validateModelTypes(Collection<String> supportedModelTypes, Set<String> validModelTypes) {
        if (supportedModelTypes == null || supportedModelTypes.isEmpty()) {
            ValidationStatus status = ValidationStatus.OK_STATUS;
            return ModelExtensionDefinitionValidator.addStatus(status, ValidationStatus.createErrorMessage(Messages.noModelTypeDefinedMsg));
        }
        MedStatus status = ValidationStatus.OK_STATUS;
        for (String modelType : supportedModelTypes) {
            status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validateModelType(modelType, validModelTypes));
        }
        if (new HashSet<String>(supportedModelTypes).size() != supportedModelTypes.size()) {
            status = ModelExtensionDefinitionValidator.addStatus(status, ValidationStatus.createErrorMessage(Messages.duplicateModelType));
        }
        return status;
    }

    public static MedStatus validateNamespacePrefix(String namespacePrefix, Collection<String> existingNamespacePrefixes) {
        String errorMsg = ModelExtensionDefinitionValidator.emptyCheck(Messages.namespacePrefix, namespacePrefix);
        if (!CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.createErrorMessage(errorMsg);
        }
        MedStatus status = ValidationStatus.OK_STATUS;
        String errorMsg2 = ModelExtensionDefinitionValidator.containsSpacesCheck(Messages.namespacePrefix, namespacePrefix);
        if (!CoreStringUtil.isEmpty((String)errorMsg2)) {
            status = ModelExtensionDefinitionValidator.addStatus(status, ValidationStatus.createErrorMessage(errorMsg2));
        }
        if (!CoreStringUtil.isEmpty((String)(errorMsg2 = ModelExtensionDefinitionValidator.containsSpecialCharactersCheck(Messages.namespacePrefix, namespacePrefix)))) {
            status = ModelExtensionDefinitionValidator.addStatus(status, ValidationStatus.createErrorMessage(errorMsg2));
        }
        if (existingNamespacePrefixes != null && existingNamespacePrefixes.contains(namespacePrefix)) {
            status = ModelExtensionDefinitionValidator.addStatus(status, ValidationStatus.createWarningMessage(NLS.bind((String)Messages.namespacePrefixExistsValidationMsg, (Object)namespacePrefix)));
        }
        return status;
    }

    public static MedStatus validateNamespaceUri(String namespaceUri, Collection<String> existingNamespaceUris) {
        MedStatus status = ValidationStatus.OK_STATUS;
        String errorMsg = ModelExtensionDefinitionValidator.uriCheck(Messages.namespaceUri, namespaceUri);
        if (!CoreStringUtil.isEmpty((String)errorMsg)) {
            status = ModelExtensionDefinitionValidator.addStatus(status, ValidationStatus.createErrorMessage(errorMsg));
        }
        if (existingNamespaceUris != null && existingNamespaceUris.contains(namespaceUri)) {
            status = ModelExtensionDefinitionValidator.addStatus(status, ValidationStatus.createWarningMessage(NLS.bind((String)Messages.namespaceUriExistsValidationMsg, (Object)namespaceUri)));
        }
        return status;
    }

    public static MedStatus validatePropertyAdvancedAttribute(boolean proposedValue) {
        return ValidationStatus.OK_STATUS;
    }

    public static MedStatus validatePropertyAllowedValue(String runtimeType, String allowedValue) {
        String errorMsg = ModelExtensionDefinitionValidator.emptyCheck(Messages.allowedValue, allowedValue);
        if (!CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.createErrorMessage(errorMsg);
        }
        if (CoreStringUtil.isEmpty((String)runtimeType) || ModelExtensionDefinitionValidator.validatePropertyRuntimeType(runtimeType).isError()) {
            return ValidationStatus.OK_STATUS;
        }
        errorMsg = ModelExtensionPropertyDefinition.Utils.isValidValue(Messages.propertyAllowedValue, ModelExtensionPropertyDefinition.Utils.convertRuntimeType(runtimeType), allowedValue, true, null);
        if (!CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.createErrorMessage(errorMsg);
        }
        return ValidationStatus.OK_STATUS;
    }

    public static MedStatus validatePropertyAllowedValues(String runtimeType, String[] allowedValues) {
        if (ArrayUtil.isNullOrEmpty((Object[])allowedValues)) {
            return ValidationStatus.OK_STATUS;
        }
        MedStatus status = ValidationStatus.OK_STATUS;
        String[] stringArray = allowedValues;
        int n = allowedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String allowedValue = stringArray[n2];
            status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validatePropertyAllowedValue(runtimeType, allowedValue));
            ArrayList<String> temp = new ArrayList<String>(Arrays.asList(allowedValues));
            temp.remove(allowedValue);
            for (Object e : temp) {
                if (!e.equals(allowedValue)) continue;
                status = ModelExtensionDefinitionValidator.addStatus(status, ValidationStatus.createErrorMessage(NLS.bind((String)Messages.duplicateAllowedValue, (Object)allowedValue)));
            }
            ++n2;
        }
        return status;
    }

    public static MedStatus validatePropertyDefaultValue(String runtimeType, String defaultValue, String[] allowedValues) {
        if (ModelExtensionDefinitionValidator.validatePropertyRuntimeType(runtimeType).isError()) {
            return ValidationStatus.OK_STATUS;
        }
        String errorMsg = ModelExtensionPropertyDefinition.Utils.isValidValue(Messages.propertyDefaultValue, ModelExtensionPropertyDefinition.Utils.convertRuntimeType(runtimeType), defaultValue, true, allowedValues);
        if (CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.OK_STATUS;
        }
        return ValidationStatus.createErrorMessage(errorMsg);
    }

    public static MedStatus validatePropertyDefinition(String simpleId, String runtimeType, boolean requiresDefaultValue, String defaultValue, boolean requiresFixedValue, String fixedValue, Collection<Translation> descriptions, Collection<Translation> displayNames, String[] allowedValues) {
        MedStatus status = ValidationStatus.OK_STATUS;
        status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validatePropertySimpleId(simpleId));
        status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validatePropertyRuntimeType(runtimeType));
        if (requiresDefaultValue) {
            status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validatePropertyDefaultValue(runtimeType, defaultValue, allowedValues));
        }
        if (requiresFixedValue) {
            status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validatePropertyFixedValue(runtimeType, fixedValue, allowedValues));
        }
        status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validateTranslations(Messages.propertyDescription, descriptions, true));
        status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validateTranslations(Messages.propertyDisplayName, displayNames, true));
        status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validatePropertyAllowedValues(runtimeType, allowedValues));
        return status;
    }

    public static MedStatus validatePropertyDefinitions(Map<String, Collection<ModelExtensionPropertyDefinition>> medPropDefns) {
        MedStatus status = ValidationStatus.OK_STATUS;
        for (String metaclassName : medPropDefns.keySet()) {
            if (ModelExtensionDefinitionValidator.validateMetaclassName(metaclassName).isError()) continue;
            Collection<ModelExtensionPropertyDefinition> props = medPropDefns.get(metaclassName);
            if (props == null || props.isEmpty()) {
                status = ModelExtensionDefinitionValidator.addStatus(status, ValidationStatus.createErrorMessage(NLS.bind((String)Messages.extendedMetaclassHasNoPropertiesValidationMsg, (Object)metaclassName)));
                continue;
            }
            for (Collection<ModelExtensionPropertyDefinition> propDefns : medPropDefns.values()) {
                HashSet<String> ids = new HashSet<String>();
                for (ModelExtensionPropertyDefinition propDefn : propDefns) {
                    if (!ids.add(propDefn.getSimpleId())) {
                        status = ModelExtensionDefinitionValidator.addStatus(status, ValidationStatus.createErrorMessage(NLS.bind((String)Messages.duplicatePropertyIdValidatinMsg, (Object)propDefn.getSimpleId())));
                    }
                    status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validatePropertyDefinition(propDefn.getSimpleId(), propDefn.getRuntimeType(), !CoreStringUtil.isEmpty((String)propDefn.getDefaultValue()), propDefn.getDefaultValue(), !CoreStringUtil.isEmpty((String)propDefn.getFixedValue()), propDefn.getFixedValue(), propDefn.getDescriptions(), propDefn.getDisplayNames(), propDefn.getAllowedValues()));
                }
            }
        }
        return status;
    }

    public static MedStatus validatePropertyFixedValue(String runtimeType, String fixedValue, String[] allowedValues) {
        if (ModelExtensionDefinitionValidator.validatePropertyRuntimeType(runtimeType).isError()) {
            return ValidationStatus.OK_STATUS;
        }
        String errorMsg = ModelExtensionPropertyDefinition.Utils.isValidValue(Messages.propertyFixedValue, ModelExtensionPropertyDefinition.Utils.convertRuntimeType(runtimeType), fixedValue, true, allowedValues);
        if (CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.OK_STATUS;
        }
        return ValidationStatus.createErrorMessage(errorMsg);
    }

    public static MedStatus validatePropertyIndexedAttribute(boolean proposedValue) {
        return ValidationStatus.OK_STATUS;
    }

    public static MedStatus validatePropertyMaskedAttribute(boolean proposedValue) {
        return ValidationStatus.OK_STATUS;
    }

    public static MedStatus validatePropertyRequiredAttribute(boolean proposedValue) {
        return ValidationStatus.OK_STATUS;
    }

    public static MedStatus validatePropertyRuntimeType(String runtimeType) {
        String errorMsg = null;
        try {
            ModelExtensionPropertyDefinition.Utils.convertRuntimeType(runtimeType);
        }
        catch (IllegalArgumentException e) {
            errorMsg = e.getLocalizedMessage();
        }
        if (CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.OK_STATUS;
        }
        return ValidationStatus.createErrorMessage(errorMsg);
    }

    public static MedStatus validatePropertySimpleId(String proposedValue) {
        String errorMsg = ModelExtensionDefinitionValidator.emptyCheck(Messages.propertySimpleId, proposedValue);
        if (!CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.createErrorMessage(errorMsg);
        }
        errorMsg = ModelExtensionDefinitionValidator.containsOnlyIdCharactersCheck(Messages.propertySimpleId, proposedValue);
        if (CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.OK_STATUS;
        }
        return ValidationStatus.createErrorMessage(errorMsg);
    }

    public static MedStatus validateTranslation(Locale locale, String text) {
        MedStatus status = ModelExtensionDefinitionValidator.validateTranslationLocale(locale);
        status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validateTranslationText(text));
        return status;
    }

    public static MedStatus validateTranslationLocale(Locale locale) {
        if (locale == null) {
            return ValidationStatus.createErrorMessage(Messages.localeMissingValidationMsg);
        }
        return ValidationStatus.OK_STATUS;
    }

    public static MedStatus validateTranslations(String translationType, Collection<Translation> translations, boolean validateEachTranslation) {
        if (translations == null || translations.isEmpty()) {
            return ValidationStatus.OK_STATUS;
        }
        MedStatus status = ValidationStatus.OK_STATUS;
        HashSet<Locale> locales = new HashSet<Locale>(translations.size());
        for (Translation translation : translations) {
            String errorMsg = ModelExtensionDefinitionValidator.nullCheck(translationType, translation);
            if (!CoreStringUtil.isEmpty((String)errorMsg)) {
                status = ModelExtensionDefinitionValidator.addStatus(status, ValidationStatus.createErrorMessage(errorMsg));
                break;
            }
            if (validateEachTranslation) {
                status = ModelExtensionDefinitionValidator.addStatus(status, ModelExtensionDefinitionValidator.validateTranslation(translation.getLocale(), translation.getTranslation()));
            }
            if (locales.add(translation.getLocale())) continue;
            status = ModelExtensionDefinitionValidator.addStatus(status, ValidationStatus.createErrorMessage(NLS.bind((String)Messages.duplicateTranslationLocaleValidationMsg, (Object)translationType)));
        }
        return status;
    }

    public static ValidationStatus validateTranslationText(String text) {
        String errorMsg = ModelExtensionDefinitionValidator.emptyCheck(Messages.translation, text);
        if (CoreStringUtil.isEmpty((String)errorMsg)) {
            errorMsg = ModelExtensionDefinitionValidator.emptyCheck(Messages.translation, text.trim());
        }
        if (CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.OK_STATUS;
        }
        return ValidationStatus.createErrorMessage(errorMsg);
    }

    public static ValidationStatus validateVersion(String version) {
        String errorMsg = ModelExtensionDefinitionValidator.emptyCheck(Messages.version, version);
        if (!CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.createErrorMessage(errorMsg);
        }
        errorMsg = ModelExtensionDefinitionValidator.containsSpacesCheck(Messages.version, version);
        if (!CoreStringUtil.isEmpty((String)errorMsg)) {
            return ValidationStatus.createErrorMessage(errorMsg);
        }
        int newVersion = -1;
        try {
            newVersion = Integer.parseInt(version);
        }
        catch (Exception exception) {
            return ValidationStatus.createErrorMessage(NLS.bind((String)Messages.versionIsNotAnIntegerValidationMsg, (Object)version));
        }
        if (newVersion < 1) {
            return ValidationStatus.createErrorMessage(NLS.bind((String)Messages.versionLessThanDefaultValidationMsg, (Object)1));
        }
        return ValidationStatus.OK_STATUS;
    }

    private ModelExtensionDefinitionValidator() {
    }
}

