/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.convertor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.teiid.designer.extension.convertor.MxdConstants;
import org.teiid.designer.extension.convertor.mxd.DisplayType;
import org.teiid.designer.extension.convertor.mxd.MetaclassType;
import org.teiid.designer.extension.convertor.mxd.ObjectFactory;
import org.teiid.designer.extension.convertor.mxd.PropertyType;
import org.teiid.designer.runtime.spi.TeiidPropertyDefinition;

public class TeiidPropertyDefinitionConvertor
implements MxdConstants {
    private final ObjectFactory factory = new ObjectFactory();
    private Map<String, MetaclassType> metaclassTypeMap;

    private MetaclassType getMetaclassType(String name) {
        if (name == null) {
            throw new IllegalStateException("The MetaclassType name cannot be null");
        }
        MetaclassType metaclassType = this.metaclassTypeMap.get(name);
        if (metaclassType == null) {
            metaclassType = this.factory.createMetaclassType();
            if (MxdConstants.TargetObjectMappings.TABLE.getTeiidClass().equals(name)) {
                metaclassType.setName(MxdConstants.TargetObjectMappings.TABLE.getDesignerClass());
            } else if (MxdConstants.TargetObjectMappings.PROCEDURE.getTeiidClass().equals(name)) {
                metaclassType.setName(MxdConstants.TargetObjectMappings.PROCEDURE.getDesignerClass());
            } else if (MxdConstants.TargetObjectMappings.COLUMN.getTeiidClass().equals(name)) {
                metaclassType.setName(MxdConstants.TargetObjectMappings.COLUMN.getDesignerClass());
            } else {
                throw new IllegalStateException("Unsupported MetaclassType " + name);
            }
            this.metaclassTypeMap.put(name, metaclassType);
        }
        return metaclassType;
    }

    public Collection<MetaclassType> getMetaclasses(Collection<TeiidPropertyDefinition> extensions) {
        this.metaclassTypeMap = new HashMap<String, MetaclassType>();
        for (TeiidPropertyDefinition defn : extensions) {
            String[] appClasses;
            String owner = defn.getOwner();
            if (owner == null) {
                throw new IllegalStateException("A translator property definition " + defn.getName() + " does not contain an owner property");
            }
            String[] stringArray = appClasses = owner.split(",");
            int n = appClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Object defaultValue;
                String dataType;
                String displayName;
                String description;
                String appClass = stringArray[n2];
                MetaclassType metaclassType = this.getMetaclassType(appClass);
                PropertyType propertyType = this.factory.createPropertyType();
                metaclassType.getProperty().add(propertyType);
                String name = defn.getName();
                String[] segments = name.split("}");
                name = segments[segments.length - 1];
                propertyType.setName(name);
                propertyType.setAdvanced(defn.isAdvanced());
                propertyType.setRequired(defn.isRequired());
                propertyType.setMasked(defn.isMasked());
                if (defn.isConstrainedToAllowedValues()) {
                    for (String allowedValue : defn.getAllowedValues()) {
                        propertyType.getAllowedValue().add(allowedValue);
                    }
                }
                if ((description = defn.getDescription()) != null && description.length() > 0) {
                    DisplayType descriptionType = this.factory.createDisplayType();
                    descriptionType.setValue(description);
                    propertyType.getDescription().add(descriptionType);
                }
                if ((displayName = defn.getDisplayName()) != null && displayName.length() > 0) {
                    displayName = displayName.replaceAll("\"", "");
                    DisplayType displayType = this.factory.createDisplayType();
                    displayType.setValue(displayName);
                    propertyType.getDisplay().add(displayType);
                }
                if ((dataType = defn.getPropertyTypeClassName()) != null && dataType.length() > 0) {
                    String[] segments2 = dataType.toLowerCase().split("\\.");
                    dataType = segments2[segments2.length - 1];
                    MxdConstants.ValidDataTypes.validateDataType(dataType);
                    propertyType.setType(dataType);
                }
                if ((defaultValue = defn.getDefaultValue()) != null) {
                    propertyType.setDefaultValue(defaultValue.toString());
                }
                ++n2;
            }
        }
        return this.metaclassTypeMap.values();
    }
}

