/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.ui.tree;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.compare.DifferenceDescriptor;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.ui.UiConstants;
import org.teiid.designer.compare.ui.tree.CompareTreePanel;
import org.teiid.designer.compare.ui.tree.DifferenceAnalysis;
import org.teiid.designer.compare.ui.tree.DifferenceDescriptorPanel;
import org.teiid.designer.compare.ui.tree.MappingLabelDecorator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.common.widget.StatusLabel;

public class DifferenceReportsPanel
extends Composite
implements CoreStringUtil.Constants {
    private static final String OLD_FILE_TEXT = UiConstants.Util.getString("DifferenceReportsPanel.oldFile.text", new Object[0]);
    private static final String NEW_FILE_TEXT = UiConstants.Util.getString("DifferenceReportsPanel.newFile.text", new Object[0]);
    private static final String FILE_IMG_PFX = UiConstants.Util.getString("DifferenceReportsPanel.fileImagePrefix", new Object[0]);
    private static final String FILE_IMG_SFX = UiConstants.Util.getString("DifferenceReportsPanel.fileImageSuffix", new Object[0]);
    private static final String FIRST_FILE_TEXT = UiConstants.Util.getString("DifferenceReportsPanel.firstFile.text", new Object[0]);
    private static final String SECOND_FILE_TEXT = UiConstants.Util.getString("DifferenceReportsPanel.secondFile.text", new Object[0]);
    private static final String DIFFERENCES_GROUP = UiConstants.Util.getString("DifferenceReportsPanel.differencesGroup", new Object[0]);
    public static final int USE_OLD_NEW_TERMINOLOGY = 1;
    public static final int USE_FIRST_SECOND_TERMINOLOGY = 2;
    private Composite pnlOuter;
    private Composite pnlHeader;
    private Composite pnlMessage;
    private StatusLabel slblMessage;
    private boolean showMessage = true;
    private Composite pnlNames;
    private Label oldLabel;
    private Label oldImgLabel;
    private Label oldFld;
    private Label newLabel;
    private Label newImgLabel;
    private Label newFld;
    private String sOldObjectName = "";
    private String sNewObjectName = "";
    private Composite pnlCounts;
    private Label oldOnlyLabel;
    private Label oldOnlyImgLabel;
    private Text txtAdds;
    private Text txtMods;
    private Label newOnlyLabel;
    private Label newOnlyImgLabel;
    private Text txtDeletes;
    private CompareTreePanel treePanel;
    private DifferenceDescriptorPanel diffDescriptorPanel;
    private String treeTitle;
    private String tableTitle;
    private List<DifferenceReport> theDifferenceReports;
    private String sMessage;
    private String sModelName;
    private int terminology = 1;
    private boolean bDisplayOnlyPrimaryMetamodelObjects = false;

    public DifferenceReportsPanel(Composite theParent, String theTreeTitle, String theTableTitle, boolean enablePropertySelection, boolean showCheckboxes) {
        super(theParent, 0);
        this.treeTitle = theTreeTitle;
        this.tableTitle = theTableTitle;
        this.initialize(enablePropertySelection, showCheckboxes);
    }

    public DifferenceReportsPanel(Composite theParent, String theTreeTitle, String theTableTitle, boolean enablePropertySelection, boolean showCheckboxes, boolean showMessage) {
        super(theParent, 0);
        this.treeTitle = theTreeTitle;
        this.tableTitle = theTableTitle;
        this.showMessage = showMessage;
        this.initialize(enablePropertySelection, showCheckboxes);
    }

    public DifferenceReportsPanel(Composite theParent, String theTreeTitle, String theTableTitle, boolean enablePropertySelection, boolean showCheckboxes, boolean showMessage, int iTerminology) {
        super(theParent, 0);
        this.treeTitle = theTreeTitle;
        this.tableTitle = theTableTitle;
        this.showMessage = showMessage;
        this.terminology = iTerminology;
        this.initialize(enablePropertySelection, showCheckboxes);
    }

    public DifferenceReportsPanel(Composite theParent, String theTreeTitle, String theTableTitle, boolean enablePropertySelection, boolean showCheckboxes, boolean showMessage, boolean bDisplayOnlyPrimaryMetamodelObjects) {
        super(theParent, 0);
        this.treeTitle = theTreeTitle;
        this.tableTitle = theTableTitle;
        this.showMessage = showMessage;
        this.bDisplayOnlyPrimaryMetamodelObjects = bDisplayOnlyPrimaryMetamodelObjects;
        this.initialize(enablePropertySelection, showCheckboxes);
    }

    public DifferenceReportsPanel(Composite parent, String treeTitle, String tableTitle, boolean enablePropertySelection, boolean showCheckboxes, DifferenceReport diffReport) {
        this(parent, treeTitle, tableTitle, enablePropertySelection, showCheckboxes, Collections.singletonList(diffReport));
    }

    public DifferenceReportsPanel(Composite parent, String treeTitle, String tableTitle, boolean enablePropertySelection, boolean showCheckboxes, boolean showMessage, DifferenceReport diffReport, int iTerminology) {
        this(parent, treeTitle, tableTitle, enablePropertySelection, showCheckboxes, showMessage, iTerminology);
        if (diffReport != null) {
            this.setDifferenceReports(Collections.singletonList(diffReport));
        }
    }

    public DifferenceReportsPanel(Composite parent, String treeTitle, String tableTitle, boolean enablePropertySelection, boolean showCheckboxes, List<DifferenceReport> diffReports) {
        this(parent, treeTitle, tableTitle, enablePropertySelection, showCheckboxes, true);
        this.setDifferenceReports(diffReports);
    }

    public TreeViewer getTreeViewer() {
        return this.treePanel.getTreeViewer();
    }

    public TableViewer getTableViewer() {
        return this.diffDescriptorPanel.getTableViewer();
    }

    public void setDisplayOnlyPrimaryMetamodelObjects(boolean b) {
        this.bDisplayOnlyPrimaryMetamodelObjects = b;
    }

    public void setDifferenceReports(List<DifferenceReport> theDifferenceReports) {
        DRStats stats = this.getStats(theDifferenceReports);
        if (stats.allChanges() > 5000) {
            this.txtAdds.setText(String.valueOf(stats.adds));
            this.txtMods.setText(String.valueOf(stats.diffs));
            this.txtDeletes.setText(String.valueOf(stats.deletes));
            String msg = UiConstants.Util.getString("DifferenceReportsPanel.tooManyChanges", new Object[0]);
            this.setMessage(msg, 2);
        } else {
            this.treePanel.setDifferenceReports(theDifferenceReports);
            this.theDifferenceReports = theDifferenceReports;
            if (theDifferenceReports != null && theDifferenceReports.size() > 0 && theDifferenceReports.get(0) != null && theDifferenceReports.get(0).getMapping() != null) {
                this.updateStats();
                this.treeSetup();
            }
        }
    }

    public DifferenceReport getDifferenceReport() {
        return this.theDifferenceReports.get(0);
    }

    public void setMessage(String sMessage, int severity) {
        this.sMessage = sMessage;
        if (this.slblMessage != null) {
            this.slblMessage.setText(sMessage, severity);
            this.slblMessage.update();
        }
    }

    public void setMessage(String sMessage) {
        this.sMessage = sMessage;
        if (this.slblMessage != null) {
            this.slblMessage.setText(sMessage);
            this.slblMessage.update();
        }
    }

    public void setTerminologyStyle(int terminology) {
        this.terminology = terminology;
        this.diffDescriptorPanel.setTerminologyStyle(terminology);
        this.treePanel.setTerminology(terminology);
    }

    public void setModelName(String sModelName) {
        this.sModelName = sModelName;
        this.sModelName.equals(this.sMessage);
    }

    public String getModelName() {
        return this.sModelName;
    }

    private void initialize(boolean enablePropertySelection, boolean showCheckboxes) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
        this.pnlOuter = new Composite((Composite)this, 0);
        GridLayout gridLayout01 = new GridLayout();
        gridLayout01.numColumns = 1;
        gridLayout01.verticalSpacing = 1;
        gridLayout01.marginHeight = 1;
        this.pnlOuter.setLayout((Layout)gridLayout01);
        GridData gd01 = new GridData(1808);
        this.pnlOuter.setLayoutData((Object)gd01);
        this.createHeaderPanel(this.pnlOuter);
        Group diffGroup = WidgetFactory.createGroup((Composite)this.pnlOuter, (String)DIFFERENCES_GROUP, (int)0);
        diffGroup.setLayoutData((Object)new GridData(1808));
        this.treePanel = new CompareTreePanel((Composite)diffGroup, this.treeTitle, showCheckboxes, this.bDisplayOnlyPrimaryMetamodelObjects, this.terminology);
        this.diffDescriptorPanel = new DifferenceDescriptorPanel((Composite)diffGroup, this.tableTitle, enablePropertySelection, showCheckboxes, this.terminology);
        GridData descGD = new GridData(1808);
        descGD.heightHint = 140;
        this.diffDescriptorPanel.setLayoutData(descGD);
        this.diffDescriptorPanel.clear();
        this.treePanel.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    DifferenceReportsPanel.this.updateDescriptorPanel(null);
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    for (Object object : selection) {
                        if (!(object instanceof Mapping)) continue;
                        DifferenceDescriptor descriptor = DifferenceAnalysis.getDifferenceDescriptor((Mapping)object);
                        DifferenceReportsPanel.this.updateDescriptorPanel(descriptor);
                    }
                }
            }
        });
        this.getTreeViewer().getTree().setFocus();
    }

    private void createHeaderPanel(Composite parent) {
        this.pnlHeader = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 1;
        gridLayout.marginHeight = 1;
        this.pnlHeader.setLayout((Layout)gridLayout);
        GridData gd1 = new GridData(768);
        this.pnlHeader.setLayoutData((Object)gd1);
        gd1.widthHint = 300;
        if (this.showMessage) {
            this.pnlMessage = new Composite(this.pnlHeader, 0);
            GridLayout gridLayout2z = new GridLayout();
            this.pnlMessage.setLayout((Layout)gridLayout2z);
            GridData gd3 = new GridData(768);
            gd3.heightHint = 55;
            this.pnlMessage.setLayoutData((Object)gd3);
            this.slblMessage = new StatusLabel(this.pnlMessage);
            GridData gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            this.slblMessage.setLayoutData((Object)gd);
            if (this.sMessage != null) {
                this.slblMessage.setText(this.sMessage);
            } else {
                this.slblMessage.setText("");
            }
        } else {
            this.pnlNames = WidgetFactory.createPanel((Composite)this.pnlHeader, (int)8, (int)768, (int)1, (int)2);
            GridLayout layout = (GridLayout)this.pnlNames.getLayout();
            layout.makeColumnsEqualWidth = true;
            Composite pnlLabel = WidgetFactory.createPanel((Composite)this.pnlNames, (int)8, (int)768, (int)1, (int)4);
            layout = (GridLayout)pnlLabel.getLayout();
            layout.horizontalSpacing = 0;
            this.oldLabel = WidgetFactory.createLabel((Composite)pnlLabel, (int)640, (String)this.getOldFileString());
            WidgetFactory.createLabel((Composite)pnlLabel, (String)FILE_IMG_PFX).setHorizontalMargin(0);
            this.oldImgLabel = WidgetFactory.createLabel((Composite)pnlLabel, (Image)MappingLabelDecorator.OLD_IMG);
            this.oldImgLabel.setHorizontalMargin(0);
            WidgetFactory.createLabel((Composite)pnlLabel, (String)FILE_IMG_SFX).setLeftMargin(0);
            this.oldFld = WidgetFactory.createLabel((Composite)this.pnlNames, (int)768, (String)this.sOldObjectName);
            pnlLabel = WidgetFactory.createPanel((Composite)this.pnlNames, (int)8, (int)768, (int)1, (int)4);
            layout = (GridLayout)pnlLabel.getLayout();
            layout.horizontalSpacing = 0;
            this.newLabel = WidgetFactory.createLabel((Composite)pnlLabel, (int)640, (String)this.getNewFileString());
            WidgetFactory.createLabel((Composite)pnlLabel, (String)FILE_IMG_PFX).setHorizontalMargin(0);
            this.newImgLabel = WidgetFactory.createLabel((Composite)pnlLabel, (Image)MappingLabelDecorator.NEW_IMG);
            this.newImgLabel.setHorizontalMargin(0);
            WidgetFactory.createLabel((Composite)pnlLabel, (String)FILE_IMG_SFX).setLeftMargin(0);
            this.newFld = WidgetFactory.createLabel((Composite)this.pnlNames, (int)768, (String)this.sNewObjectName);
        }
        this.pnlCounts = new Composite(this.pnlHeader, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 21;
        gridLayout2.verticalSpacing = 1;
        gridLayout2.horizontalSpacing = 0;
        gridLayout2.marginHeight = 1;
        this.pnlCounts.setLayout((Layout)gridLayout2);
        GridData gridData7 = new GridData();
        gridData7.horizontalAlignment = 2;
        gridData7.verticalAlignment = 2;
        gridData7.grabExcessHorizontalSpace = true;
        gridData7.grabExcessVerticalSpace = false;
        this.pnlCounts.setLayoutData((Object)gridData7);
        WidgetFactory.createLabel((Composite)this.pnlCounts, (String)UiConstants.Util.getString("DifferenceReportsPanel.deletes.text", new Object[0]));
        this.oldOnlyLabel = WidgetFactory.createLabel((Composite)this.pnlCounts, (String)this.getOldFileString());
        WidgetFactory.createLabel((Composite)this.pnlCounts, (String)FILE_IMG_PFX).setHorizontalMargin(0);
        this.oldOnlyImgLabel = WidgetFactory.createLabel((Composite)this.pnlCounts, (Image)MappingLabelDecorator.OLD_IMG);
        this.oldOnlyImgLabel.setHorizontalMargin(0);
        WidgetFactory.createLabel((Composite)this.pnlCounts, (String)FILE_IMG_SFX).setLeftMargin(0);
        this.txtDeletes = WidgetFactory.createTextField((Composite)this.pnlCounts, (int)0, (String)"");
        this.txtDeletes.setEditable(false);
        this.txtDeletes.setEnabled(true);
        Label lbl = WidgetFactory.createLabel((Composite)this.pnlCounts, (String)UiConstants.Util.getString("DifferenceReportsPanel.mods.text", new Object[0]));
        ((GridData)lbl.getLayoutData()).horizontalIndent = 20;
        WidgetFactory.createLabel((Composite)this.pnlCounts, (String)FILE_IMG_PFX).setHorizontalMargin(0);
        WidgetFactory.createLabel((Composite)this.pnlCounts, (Image)MappingLabelDecorator.CHG_IMG).setHorizontalMargin(0);
        WidgetFactory.createLabel((Composite)this.pnlCounts, (String)FILE_IMG_SFX).setLeftMargin(0);
        this.txtMods = WidgetFactory.createTextField((Composite)this.pnlCounts, (int)0, (String)"");
        this.txtMods.setEditable(false);
        this.txtMods.setEnabled(true);
        lbl = WidgetFactory.createLabel((Composite)this.pnlCounts, (String)UiConstants.Util.getString("DifferenceReportsPanel.adds.text", new Object[0]));
        ((GridData)lbl.getLayoutData()).horizontalIndent = 20;
        this.newOnlyLabel = WidgetFactory.createLabel((Composite)this.pnlCounts, (String)this.getNewFileString());
        WidgetFactory.createLabel((Composite)this.pnlCounts, (String)FILE_IMG_PFX).setHorizontalMargin(0);
        this.newOnlyImgLabel = WidgetFactory.createLabel((Composite)this.pnlCounts, (Image)MappingLabelDecorator.NEW_IMG);
        this.newOnlyImgLabel.setHorizontalMargin(0);
        WidgetFactory.createLabel((Composite)this.pnlCounts, (String)FILE_IMG_SFX).setLeftMargin(0);
        this.txtAdds = WidgetFactory.createTextField((Composite)this.pnlCounts, (int)0, (String)"");
        this.txtAdds.setEditable(false);
        this.txtAdds.setEnabled(true);
    }

    private void refreshNamesPanel() {
        if (this.sOldObjectName != null) {
            if (!this.sOldObjectName.equals("")) {
                String oldLabelText = this.getOldFileString();
                String newLabelText = this.getNewFileString();
                if (!this.showMessage) {
                    this.oldLabel.setText(oldLabelText);
                    this.oldImgLabel.setImage(oldLabelText == OLD_FILE_TEXT ? MappingLabelDecorator.OLD_IMG : MappingLabelDecorator.FIRST_IMG);
                    this.oldFld.setText(this.sOldObjectName);
                    this.newLabel.setText(newLabelText);
                    this.newImgLabel.setImage(newLabelText == NEW_FILE_TEXT ? MappingLabelDecorator.NEW_IMG : MappingLabelDecorator.SECOND_IMG);
                    this.newFld.setText(this.sNewObjectName);
                }
                this.oldOnlyLabel.setText(oldLabelText);
                this.oldOnlyLabel.layout();
                this.oldOnlyImgLabel.setImage(oldLabelText == OLD_FILE_TEXT ? MappingLabelDecorator.OLD_IMG : MappingLabelDecorator.FIRST_IMG);
                this.newOnlyLabel.setText(newLabelText);
                this.newOnlyImgLabel.setImage(newLabelText == NEW_FILE_TEXT ? MappingLabelDecorator.NEW_IMG : MappingLabelDecorator.SECOND_IMG);
            } else {
                if (!this.showMessage) {
                    this.oldLabel.setText("");
                    this.oldImgLabel.setImage(null);
                    this.oldFld.setText("");
                    this.newLabel.setText("");
                    this.newImgLabel.setImage(null);
                    this.newFld.setText("");
                }
                this.oldOnlyLabel.setText("");
                this.oldOnlyImgLabel.setImage(null);
                this.newOnlyLabel.setText("");
                this.newOnlyImgLabel.setImage(null);
            }
        }
    }

    private String getOldFileString() {
        String sOldFileText = OLD_FILE_TEXT;
        if (this.terminology == 1) {
            sOldFileText = OLD_FILE_TEXT;
        } else if (this.terminology == 2) {
            sOldFileText = FIRST_FILE_TEXT;
        }
        return sOldFileText;
    }

    private String getNewFileString() {
        String sNewFileText = NEW_FILE_TEXT;
        if (this.terminology == 1) {
            sNewFileText = NEW_FILE_TEXT;
        } else if (this.terminology == 2) {
            sNewFileText = SECOND_FILE_TEXT;
        }
        return sNewFileText;
    }

    public void setObjectNames(String sOldName, String sNewName) {
        this.setOldObjectName(sOldName);
        this.setNewObjectName(sNewName);
        this.refreshNamesPanel();
    }

    private void setOldObjectName(String sName) {
        this.sOldObjectName = sName;
    }

    private void setNewObjectName(String sName) {
        this.sNewObjectName = sName;
    }

    private void treeSetup() {
        this.getTreeViewer().getTree().setVisible(false);
        ITreeContentProvider itcp = (ITreeContentProvider)this.getTreeViewer().getContentProvider();
        Object[] roots = itcp.getElements(this.getTreeViewer().getInput());
        if (this.theDifferenceReports.size() == 1) {
            this.getTreeViewer().reveal(roots[0]);
            this.getTreeViewer().expandToLevel(2);
        } else if (this.theDifferenceReports.size() > 1) {
            this.getTreeViewer().reveal(roots[0]);
            this.getTreeViewer().expandToLevel(3);
        }
        this.getTreeViewer().getTree().setVisible(true);
        this.treePanel.selectFirstDiff();
    }

    private void updateStats() {
        if (this.theDifferenceReports != null && this.theDifferenceReports.get(0) != null) {
            this.treePanel.generateStats();
            this.treePanel.initTreeSelections();
            this.txtAdds.setText(String.valueOf(this.treePanel.getAdditionCount()));
            this.txtMods.setText(String.valueOf(this.treePanel.getChangeCount()));
            this.txtDeletes.setText(String.valueOf(this.treePanel.getDeletionCount()));
            this.pnlHeader.layout(new Control[]{this.txtAdds, this.txtDeletes, this.txtMods});
        }
        if (this.sMessage != null && this.slblMessage != null) {
            this.slblMessage.setText(this.sMessage);
        }
    }

    void updateDescriptorPanel(DifferenceDescriptor descriptor) {
        if (descriptor != null) {
            this.diffDescriptorPanel.setDescriptor(descriptor);
        } else {
            this.diffDescriptorPanel.clear();
        }
    }

    public void forceRelayout() {
        Composite pnlParent;
        this.getDialogAncestor();
        this.setRedraw(true);
        int iCount = 0;
        Composite pnlSecondLastParent = null;
        for (pnlParent = this.getParent(); pnlParent != null && iCount <= 100 && !(pnlParent instanceof Shell); pnlParent = pnlParent.getParent(), ++iCount) {
            pnlSecondLastParent = pnlParent;
        }
        if (pnlParent != null) {
            if (pnlParent instanceof SashForm) {
                if (pnlSecondLastParent != null && pnlSecondLastParent instanceof ViewForm) {
                    pnlSecondLastParent.pack();
                } else {
                    pnlParent.pack();
                }
                this.wiggle((SashForm)pnlParent);
            } else if (pnlParent instanceof Shell) {
                ((Shell)pnlParent).pack();
            }
        }
    }

    private Dialog getDialogAncestor() {
        return null;
    }

    private DRStats getStats(List<DifferenceReport> differenceReports) {
        DRStats result = new DRStats();
        if (differenceReports == null) {
            return result;
        }
        for (DifferenceReport dr : differenceReports) {
            if (dr != null) {
                result.adds += dr.getTotalAdditions();
                result.deletes += dr.getTotalDeletions();
                result.diffs += dr.getTotalChanges();
                continue;
            }
            String msg = "DifferenceReportsPanel.getStats encountered null report - skipping its stats";
            ModelerCore.Util.log(2, msg);
        }
        return result;
    }

    private void wiggle(SashForm sf) {
        int iWiggleFactor = 1;
        int[] weights = sf.getWeights();
        int iCurrentFirstWeight = weights[0];
        weights[0] = iCurrentFirstWeight + iWiggleFactor;
        sf.setWeights(weights);
        weights[0] = iCurrentFirstWeight - iWiggleFactor;
        sf.setWeights(weights);
    }

    class DRStats {
        int diffs = 0;
        int adds = 0;
        int deletes = 0;

        DRStats() {
        }

        int allChanges() {
            return this.diffs + this.adds + this.deletes;
        }
    }

    class PaintAdaptableComposite
    extends ScrolledComposite
    implements PaintListener {
        private boolean bCompletedInitialWiggle;

        public PaintAdaptableComposite(Composite parent, int style) {
            super(parent, style);
            this.bCompletedInitialWiggle = false;
            parent.addPaintListener((PaintListener)this);
        }

        public void paintControl(PaintEvent e) {
            if (!this.bCompletedInitialWiggle) {
                int iFudgeFactor = 3;
                Rectangle rect = this.getShell().getBounds();
                rect.x += iFudgeFactor;
                this.getShell().setBounds(rect);
                this.getShell().pack();
                rect.x -= iFudgeFactor;
                this.getShell().setBounds(rect);
                this.getShell().pack();
                this.getShell().layout(true);
                this.bCompletedInitialWiggle = true;
            }
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return super.computeSize(wHint, hHint, changed);
        }

        public Point computeSize(int wHint, int hHint) {
            return super.computeSize(wHint, hHint);
        }

        public void dispose() {
            super.dispose();
            this.getParent().removePaintListener((PaintListener)this);
        }
    }
}

