/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.ui.tree;

import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.teiid.designer.compare.DifferenceDescriptor;
import org.teiid.designer.compare.DifferenceType;
import org.teiid.designer.compare.ui.tree.MappingLabelDecorator;
import org.teiid.designer.compare.ui.tree.MappingLabelProvider;

public class DifferenceAnalysis {
    public static ILabelProvider getMappingDecoratingLabelProvider(int terminology) {
        return new DecoratingLabelProvider(DifferenceAnalysis.getMappingLabelProvider(), DifferenceAnalysis.getMappingLabelDecorator(terminology));
    }

    public static ILabelProvider getMappingLabelProvider() {
        return new MappingLabelProvider();
    }

    public static ILabelDecorator getMappingLabelDecorator(int terminology) {
        return new MappingLabelDecorator(terminology);
    }

    public static boolean isAdd(Mapping mapping) {
        DifferenceType type;
        boolean isAdd = false;
        DifferenceDescriptor descriptor = DifferenceAnalysis.getDifferenceDescriptor(mapping);
        if (descriptor != null && (type = descriptor.getType()).getValue() == 1) {
            isAdd = true;
        }
        return isAdd;
    }

    public static boolean isChange(Mapping mapping) {
        DifferenceType type;
        boolean isChange = false;
        DifferenceDescriptor descriptor = DifferenceAnalysis.getDifferenceDescriptor(mapping);
        if (descriptor != null && (type = descriptor.getType()).getValue() == 3) {
            isChange = true;
        }
        return isChange;
    }

    public static boolean isDelete(Mapping mapping) {
        DifferenceType type;
        boolean isDelete = false;
        DifferenceDescriptor descriptor = DifferenceAnalysis.getDifferenceDescriptor(mapping);
        if (descriptor != null && (type = descriptor.getType()).getValue() == 2) {
            isDelete = true;
        }
        return isDelete;
    }

    public static boolean isUnchanged(Mapping mapping) {
        DifferenceType type;
        boolean isNoChange = false;
        DifferenceDescriptor descriptor = DifferenceAnalysis.getDifferenceDescriptor(mapping);
        if (descriptor != null && (type = descriptor.getType()).getValue() == 0) {
            isNoChange = true;
        }
        return isNoChange;
    }

    public static boolean isChangeBelow(Mapping mapping) {
        DifferenceType type;
        boolean isChange = false;
        DifferenceDescriptor descriptor = DifferenceAnalysis.getDifferenceDescriptor(mapping);
        if (descriptor != null && (type = descriptor.getType()).getValue() == 4) {
            isChange = true;
        }
        return isChange;
    }

    public static DifferenceDescriptor getDifferenceDescriptor(Mapping mapping) {
        DifferenceDescriptor descriptor = null;
        MappingHelper helper = mapping.getHelper();
        if (helper != null && helper instanceof DifferenceDescriptor) {
            descriptor = (DifferenceDescriptor)helper;
        }
        return descriptor;
    }
}

