/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.test.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.test.util.JobUtils;
import org.jboss.tools.test.util.ResourcesUtils;
import org.jboss.tools.test.util.TestDescription;
import org.jboss.tools.test.util.TestDescriptionFactory;
import org.osgi.framework.Bundle;

public class TestProjectProvider {
    IProject project;
    boolean makeCopy = false;
    TestDescriptionFactory tests = null;

    public TestProjectProvider(String bundleName, String projectPath, String name, boolean makeCopy) throws CoreException {
        try {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (this.project != null && !this.project.isAccessible()) {
                this.project = projectPath == null ? ResourcesUtils.importProject(bundleName, "projects/" + name, null) : ResourcesUtils.importProject(bundleName, projectPath, name, null);
                if (this.project != null) {
                    this.project.build(10, null);
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, bundleName, e.getMessage(), (Throwable)e));
        }
        catch (InvocationTargetException e) {
            throw new CoreException((IStatus)new Status(4, bundleName, e.getMessage(), (Throwable)e));
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, bundleName, e.getMessage(), (Throwable)e));
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void dispose() {
        if (this.project == null || !this.project.exists()) {
            return;
        }
        try {
            boolean oldAutoBuilding = true;
            try {
                oldAutoBuilding = ResourcesUtils.setBuildAutomatically(false);
                JobUtils.waitForIdle(10L);
                this.project.close(null);
                JobUtils.waitForIdle(10L);
                this.project.delete(true, null);
                JobUtils.waitForIdle(10L);
            }
            finally {
                ResourcesUtils.setBuildAutomatically(oldAutoBuilding);
            }
        }
        catch (CoreException ex) {
            ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.jboss.tools.tests"));
            Status error = new Status(4, "org.jboss.tools.test", "Exception occurs during project deletion", (Throwable)ex);
            log.log((IStatus)error);
        }
    }

    public Set<TestDescription> getTestDescriptions() {
        if (this.tests == null && this.project != null && this.project.isOpen()) {
            IFile f = this.project.getFile((IPath)new Path("/testCases.xml"));
            this.tests = new TestDescriptionFactory(f);
        }
        return this.tests != null ? this.tests.getTestDescriptions() : null;
    }

    public ArrayList<TestDescription> getTestDescriptions(String name) {
        this.getTestDescriptions();
        return this.tests != null ? this.tests.getTestDescriptions(name) : null;
    }
}

