/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.test;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.test.util.TestProjectProvider;

public class ESBModelTest
extends TestCase {
    TestProjectProvider provider = null;
    IProject project = null;
    boolean makeCopy = true;
    static String VALUE_FILTER_PROPERTY = "valueFilter";
    static String ATTR_MESSAGE_STORE_CLASS = "message store class";
    static String MESSAGE_STORE_CLASS_VALUE_FILTER_ID = "org.jboss.tools.esb.ui.editor.attribute.MessageStoreClassValueFilter";
    static String ATTR_CLASS = "class";
    static String ACTION_CLASS_VALUE_FILTER_ID = "org.jboss.tools.esb.ui.editor.attribute.ActionClassValueFilter";

    public void setUp() throws Exception {
        this.provider = new TestProjectProvider("org.jboss.tools.esb.core.test", null, "Test", true);
        this.project = this.provider.getProject();
        this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testListener() {
        XModelObject object = this.getFileObject("esb-1.2", "jboss-esb-listener.xml", "FileESB120");
        StringBuffer errorList = new StringBuffer();
        this.checkAttributeValue(object, "Services/custom-listener-example/Listeners/custom-listener", "is gateway", "true", errorList);
        this.checkAttributeValue(object, "Services/arrival-service/Listeners/arrival-queue-listener", "is gateway", "true", errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testJMSExample() {
        XModelObject object = this.getFileObject("esb-1.0.1", "jboss-esb-jms.xml");
        StringBuffer errorList = new StringBuffer();
        this.checkAttributeValue(object, "Providers/JBossMQ", "connection factory", "ConnectionFactory", errorList);
        this.checkAttributeValue(object, "Providers/JBossMQ/quickstartGwChannel/Filter", "destination name", "queue/quickstart_helloworld_file_notifier_Request_gw", errorList);
        this.checkAttributeValue(object, "Services/FileRouterListener/Actions/notificationAction/notification-details/NotificationList1", "tag", "NotificationList", errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testFTPExample() {
        XModelObject object = this.getFileObject("esb-1.0.1", "jboss-esb-ftp.xml");
        StringBuffer errorList = new StringBuffer();
        this.checkAttributeValue(object, "Providers/FTPprovider", "hostname", "@FTP_HOSTNAME@", errorList);
        String ftpFilterPath = "Providers/FTPprovider/helloFTPChannel/Filter";
        String[][] ftpFilterAttrValues = new String[][]{{"username", "@FTP_USERNAME@"}, {"password", "@FTP_PASSWORD@"}, {"read only", "true"}, {"passive", "false"}, {"directory", "@FTP_DIRECTORY@"}, {"input suffix", ".dat"}, {"work suffix", ".esbWorking"}, {"post delete", "false"}, {"post suffix", ".COMPLETE"}, {"error delete", "false"}, {"error suffix", ".HAS_ERROR"}};
        this.checkAttributes(object, ftpFilterPath, ftpFilterAttrValues, errorList);
        String ftpGatewayPath = "Services/myFileListener/Listeners/FtpGateway";
        this.checkAttributeValue(object, ftpGatewayPath, "channel id ref", "helloFTPChannel", errorList);
        this.checkAttributeValue(object, String.valueOf(ftpGatewayPath) + "/remoteFileSystemStrategy-configFile", "value", "/ftpfile-cache-config.xml", errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testHibernateExample() {
        XModelObject object = this.getFileObject("esb-1.0.1", "jboss-esb-hibernate.xml");
        StringBuffer errorList = new StringBuffer();
        String hibProviderPath = "Providers/Hibernateprovider";
        this.checkAttributeValue(object, hibProviderPath, "hibernate cfg file", "hibernate.cfg.xml", errorList);
        String hibFilterPath = String.valueOf(hibProviderPath) + "/helloHibernateChannel/org.jboss.soa.esb.samples.quickstart.hibernateaction.Order";
        String[][] hibFilterAttrValues = new String[][]{{"class name", "org.jboss.soa.esb.samples.quickstart.hibernateaction.Order"}, {"event", "onLoad,onDelete"}};
        this.checkAttributes(object, hibFilterPath, hibFilterAttrValues, errorList);
        String hibListenerPath = "Services/myJmsListener/Listeners/HibernateGateway";
        String[][] hibListeneAttrValues = new String[][]{{"channel id ref", "helloHibernateChannel"}, {"max threads", "1"}, {"is gateway", "true"}};
        this.checkAttributes(object, hibListenerPath, hibListeneAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testJBRExample() {
        XModelObject object = this.getFileObject("esb-1.0.1", "jboss-esb-jbr.xml");
        StringBuffer errorList = new StringBuffer();
        String jbrProviderPath = "Providers/JBR-Http";
        String[][] jbrProviderAttrValues = new String[][]{{"protocol", "http"}, {"host", "localhost"}};
        this.checkAttributes(object, jbrProviderPath, jbrProviderAttrValues, errorList);
        String jbrBusPath = String.valueOf(jbrProviderPath) + "/Http-1";
        String[][] jbrBusAttrValues = new String[][]{{"port", "9876"}};
        this.checkAttributes(object, jbrBusPath, jbrBusAttrValues, errorList);
        String jbrListenerPath = "Services/MyWssService/Listeners/Http-Gateway";
        String[][] jbrListenerAttrValues = new String[][]{{"channel id ref", "Http-1"}, {"max threads", "1"}, {"is gateway", "true"}};
        this.checkAttributes(object, jbrListenerPath, jbrListenerAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testFSExample() {
        XModelObject object = this.getFileObject("esb-1.0.1", "jboss-esb-fs.xml");
        StringBuffer errorList = new StringBuffer();
        String fsProviderPath = "Providers/FSprovider1";
        String fsFilterPath = String.valueOf(fsProviderPath) + "/helloFileChannel/Filter";
        String[][] fsFilterAttrValues = new String[][]{{"directory", "@INPUTDIR@"}, {"input suffix", ".dat"}, {"work suffix", ".esbWorking"}, {"post delete", "false"}, {"post directory", "@OUTPUTDIR@"}, {"post suffix", ".sentToEsb"}, {"error delete", "false"}, {"error directory", "@ERRORDIR@"}, {"error suffix", ".IN_ERROR"}};
        this.checkAttributes(object, fsFilterPath, fsFilterAttrValues, errorList);
        String fsListenerPath = "Services/myFileListener/Listeners/FileGateway";
        String[][] fsListenerAttrValues = new String[][]{{"channel id ref", "helloFileChannel"}, {"max threads", "1"}, {"is gateway", "true"}, {"poll frequency seconds", "10"}};
        this.checkAttributes(object, fsListenerPath, fsListenerAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testSQLExample() {
        XModelObject object = this.getFileObject("esb-1.0.1", "jboss-esb-sql.xml");
        StringBuffer errorList = new StringBuffer();
        String sqlProviderPath = "Providers/SQLprovider";
        String[][] sqlProviderAttrValues = new String[][]{{"url", "jdbc:hsqldb:hsql://localhost:1703"}, {"driver", "org.hsqldb.jdbcDriver"}, {"username", "sa"}, {"password", ""}};
        this.checkAttributes(object, sqlProviderPath, sqlProviderAttrValues, errorList);
        String sqlFilterPath = "Providers/SQLprovider/helloSQLChannel/Filter";
        String[][] sqlFilterAttrValues = new String[][]{{"tablename", "GATEWAY_TABLE"}, {"status column", "STATUS_COL"}, {"order by", "DATA_COLUMN"}, {"where condition", "DATA_COLUMN like 'data%'"}, {"message id column", "UNIQUE_ID"}};
        this.checkAttributes(object, sqlFilterPath, sqlFilterAttrValues, errorList);
        String sqlListenerPath = "Services/myJmsListener/Listeners/SqlGateway";
        String[][] sqlListenerAttrValues = new String[][]{{"channel id ref", "helloSQLChannel"}, {"max threads", "1"}, {"is gateway", "true"}};
        this.checkAttributes(object, sqlListenerPath, sqlListenerAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testNotifiers() {
        XModelObject object = this.getFileObject("esb-1.2", "jboss-esb-notifiers.xml", "FileESB120");
        StringBuffer errorList = new StringBuffer();
        String sendResponseNotifierPath = "Services/s/Actions/SendResponseNotifier";
        String[][] sendResponseNotifierAttrValues = new String[][]{{"name", "SendResponseNotifier"}, {"ok method", "notifyOK"}, {"exception method", "notifyError"}};
        this.checkAttributes(object, sendResponseNotifierPath, sendResponseNotifierAttrValues, errorList);
        String errQueuePath = String.valueOf(sendResponseNotifierPath) + "/err/NotifyQueues/queue#MincomJMS_reply";
        String[][] errQueueAttrValues = new String[][]{{"jndi name", "queue/MincomJMS_reply"}};
        this.checkAttributes(object, errQueuePath, errQueueAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testNotifyEmail() {
        XModelObject object = this.getFileObject("esb-1.2", "jboss-esb-notifiers.xml", "FileESB120");
        StringBuffer errorList = new StringBuffer();
        String notifyEmailPath = "Services/s/Actions/SendResponseNotifier/ok/NotifyEmail";
        String[][] notifyEmailAttrValues = new String[][]{{"from", "person@somewhere.com"}, {"send to", "person@elsewhere.com"}, {"subject", "theSubject"}, {"host", "localhost"}, {"port", "8801"}, {"username", "smtpUsername"}, {"password", "smtpPassword"}, {"auth", "true"}, {"copy to", "person@somewhereelse.com"}, {"attachment name", "attachment"}};
        this.checkAttributes(object, notifyEmailPath, notifyEmailAttrValues, errorList);
        String attachmentPath = String.valueOf(notifyEmailPath) + "/attachThisFile.txt";
        String[][] attachmentAttrValues = new String[][]{{"file", "attachThisFile.txt"}};
        this.checkAttributes(object, attachmentPath, attachmentAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testNonUniqueProviders() {
        XModelObject object = this.getFileObject("esb-1.2", "jboss-esb-uninique.xml", "FileESB120");
        XModelObject[] os = object.getChildByPath("Providers").getChildren();
        ESBModelTest.assertEquals((int)2, (int)os.length);
        int i = 0;
        while (i < os.length) {
            String name = os[i].getAttributeValue("name");
            ESBModelTest.assertEquals((String)"http", (String)name);
            ++i;
        }
    }

    public void testRiftsawBPELExample() {
        XModelObject object = this.getFileObject("esb-1.2", "jboss-esb-bpel.xml", "FileESB120");
        ESBModelTest.assertNotNull((Object)object);
        this.doTestRiftsawBPELExample(object);
        object = this.getFileObject("esb-1.3", "jboss-esb-bpel.xml", "FileESB130");
        ESBModelTest.assertNotNull((Object)object);
        this.doTestRiftsawBPELExample(object);
    }

    public void doTestRiftsawBPELExample(XModelObject object) {
        StringBuffer errorList = new StringBuffer();
        String bpelActionPath = "Services/s/Actions/action2";
        String[][] bpelActionAttrValues = new String[][]{{"name", "action2"}, {"class", "org.jboss.soa.esb.actions.bpel.BPELInvoke"}, {"service", "{http://www.jboss.org/bpel/examples/wsdl}HelloService"}, {"operation", "hello"}, {"port", "HelloPort"}, {"request part name", "TestPart"}, {"response part name", "TestPart"}};
        this.checkAttributes(object, bpelActionPath, bpelActionAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testCamelExample() {
        XModelObject object = this.getFileObject("esb-1.3", "jboss-esb-camel.xml", "FileESB130");
        StringBuffer errorList = new StringBuffer();
        String camelProviderPath = "Providers/camel";
        String[][] camelProviderAttrValues = new String[][]{{"name", "camel"}};
        this.checkAttributes(object, camelProviderPath, camelProviderAttrValues, errorList);
        String camelBusPath = String.valueOf(camelProviderPath) + "/11";
        String[][] camelBusAttrValues = new String[][]{{"async", "false"}, {"timeout", "123"}};
        this.checkAttributes(object, camelBusPath, camelBusAttrValues, errorList);
        String fromPath = String.valueOf(camelBusPath) + "/www.yandex.ru";
        String[][] fromAttrValues = new String[][]{{"uri", "www.yandex.ru"}};
        this.checkAttributes(object, fromPath, fromAttrValues, errorList);
        String camelGatewayPath = "Services/s/Listeners/camel";
        String[][] camelGatewayAttrValues = new String[][]{{"channel id ref", "11"}, {"async", "true"}, {"timeout", "1000"}};
        this.checkAttributes(object, camelGatewayPath, camelGatewayAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testBusinessRulesProcessor_4_9() {
        XModelObject object = this.getFileObject("esb-1.3", "jboss-esb-brp.xml", "FileESB130");
        StringBuffer errorList = new StringBuffer();
        String orderDiscountRuleServicePath = "Services/s/Actions/OrderDiscountRuleService";
        String[][] orderDiscountRuleServiceAttrValues = new String[][]{{"rule set", "drl/OrderDiscount.drl"}, {"rule reload", "true"}, {"rule multithread evaluation", "true"}, {"rule max threads", "7"}};
        this.checkAttributes(object, orderDiscountRuleServicePath, orderDiscountRuleServiceAttrValues, errorList);
        String routePath = String.valueOf(orderDiscountRuleServicePath) + "/body.Order";
        String[][] routeAttrValues = new String[][]{{"esb", "body.Order"}};
        this.checkAttributes(object, routePath, routeAttrValues, errorList);
        String orderEventsRuleServiceStatefulPath = "Services/s/Actions/OrderEventsRuleServiceStateful";
        String[][] orderEventsRuleServiceStatefulAttrValues = new String[][]{{"rule set", "drl/OrderEvents.drl"}, {"rule reload", "false"}, {"stateful", "true"}, {"rule audit type", "THREADED_FILE"}, {"rule audit file", "myaudit"}, {"rule audit interval", "1000"}, {"rule clock type", "REALTIME"}, {"rule event processing type", "STREAM"}, {"rule fire method", "FIRE_UNTIL_HALT"}};
        this.checkAttributes(object, orderEventsRuleServiceStatefulPath, orderEventsRuleServiceStatefulAttrValues, errorList);
        String channelPath = String.valueOf(orderEventsRuleServiceStatefulPath) + "/chan2";
        String[][] channelAttrValues = new String[][]{{"channel name", "chan2"}, {"service category", "cat1"}, {"service name", "svc1"}, {"channel class", "org.jboss.soa.esb.services.rules.ServiceChannel"}, {"set payload location", "org.jboss.soa.esb.message.defaultEntry"}, {"timeout", "30000"}};
        this.checkAttributes(object, channelPath, channelAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testContentBasedRouter() {
        XModelObject object = this.getFileObject("esb-1.3", "jboss-esb-cbr.xml", "FileESB130");
        StringBuffer errorList = new StringBuffer();
        String cbrRouterPath = "Services/s/Actions/cbr-router";
        String[][] orderDiscountRuleServiceAttrValues = new String[][]{{"cbr alias", "Drools"}, {"rule set", "/META-INF/drools/airport-code.drl"}};
        this.checkAttributes(object, cbrRouterPath, orderDiscountRuleServiceAttrValues, errorList);
        String objectPath = String.valueOf(cbrRouterPath) + "/body.'org.jboss.soa.esb.message.defaultEntry'";
        String[][] objectAttrValues = new String[][]{{"esb", "body.'org.jboss.soa.esb.message.defaultEntry'"}};
        this.checkAttributes(object, objectPath, objectAttrValues, errorList);
        String routePath = String.valueOf(cbrRouterPath) + "/ERROR";
        String[][] routeAttrValues = new String[][]{{"service name", "error-service"}, {"service category", "com.example.soa"}, {"destination name", "ERROR"}};
        this.checkAttributes(object, routePath, routeAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testContentBasedRouter2() {
        XModelObject object = this.getFileObject("esb-1.3", "jboss-esb-cbr.xml", "FileESB130");
        StringBuffer errorList = new StringBuffer();
        String cbrRouterPath = "Services/s/Actions/Route";
        String routePath = String.valueOf(cbrRouterPath) + "/ALL-1";
        String[][] routeAttrValues = new String[][]{{"service name", "FTP Service"}, {"service category", "Trade OTC"}, {"destination name", "ALL-1"}};
        this.checkAttributes(object, routePath, routeAttrValues, errorList);
        routePath = String.valueOf(cbrRouterPath) + "/ALL-2";
        routeAttrValues = new String[][]{{"service name", "FTP Service"}, {"service category", "Trade OTC"}, {"destination name", "ALL-2"}};
        this.checkAttributes(object, routePath, routeAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testContentBasedWiretap() {
        XModelObject object = this.getFileObject("esb-1.3", "jboss-esb-cbr.xml", "FileESB130");
        StringBuffer errorList = new StringBuffer();
        String cbrWiretapPath = "Services/s/Actions/cb-wiretap";
        String[][] orderDiscountRuleServiceAttrValues = new String[][]{{"cbr alias", "Drools"}, {"rule set", "/META-INF/drools/airport-code.drl"}};
        this.checkAttributes(object, cbrWiretapPath, orderDiscountRuleServiceAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testMessageFilter() {
        XModelObject object = this.getFileObject("esb-1.3", "jboss-esb-cbr.xml", "FileESB130");
        StringBuffer errorList = new StringBuffer();
        String cbrWiretapPath = "Services/s/Actions/message-filter";
        String[][] orderDiscountRuleServiceAttrValues = new String[][]{{"cbr alias", "Drools"}, {"rule set", "/META-INF/drools/airport-code.drl"}};
        this.checkAttributes(object, cbrWiretapPath, orderDiscountRuleServiceAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    public void testSoapClient() {
        XModelObject object = this.getFileObject("esb-1.3", "jboss-esb-client.xml", "FileESB131");
        StringBuffer errorList = new StringBuffer();
        String cbrWiretapPath = "Services/s1/Actions/client";
        String[][] clientAttrValues = new String[][]{{"endpoint url", "http://host/servername"}, {"file", "httpclient.properties"}};
        this.checkAttributes(object, cbrWiretapPath, clientAttrValues, errorList);
        ESBModelTest.assertTrue((String)errorList.toString(), (errorList.length() == 0 ? 1 : 0) != 0);
    }

    XModelObject getFileObject(String parentPath, String xmlname) {
        return this.getFileObject(parentPath, xmlname, "FileESB101");
    }

    XModelObject getFileObject(String parentPath, String xmlname, String entity) {
        IFile f = this.project.getFile((IPath)new Path(String.valueOf(parentPath) + "/" + xmlname));
        ESBModelTest.assertTrue((String)("Cannot find " + xmlname), (f != null ? 1 : 0) != 0);
        XModelObject object = EclipseResourceUtil.createObjectForResource((IResource)f);
        ESBModelTest.assertTrue((String)("Cannot create model for " + xmlname), (object != null ? 1 : 0) != 0);
        ESBModelTest.assertTrue((String)("Wrong entity for " + xmlname), (boolean)entity.equals(object.getModelEntity().getName()));
        return object;
    }

    void checkAttributes(XModelObject object, String path, String[][] attrValuePairs, StringBuffer errorList) {
        int i = 0;
        while (i < attrValuePairs.length) {
            String attrName = attrValuePairs[i][0];
            String attrValue = attrValuePairs[i][1];
            this.checkAttributeValue(object, path, attrName, attrValue, errorList);
            ++i;
        }
    }

    protected boolean checkAttributeValue(XModelObject object, String path, String attribute, String testValue, StringBuffer errorList) {
        XModelObject child = object.getChildByPath(path);
        if (child == null) {
            errorList.append("Cannot find object at " + path).append("\n");
            return false;
        }
        if (child.getModelEntity().getAttribute(attribute) == null) {
            errorList.append("Attribute " + attribute + " is not found in object " + path).append("\n");
            return false;
        }
        String realValue = child.getAttributeValue(attribute);
        if (realValue == null || !realValue.equals(testValue)) {
            errorList.append("Attribute " + attribute + " in object " + path + " has unexpected value '" + realValue + "'").append("\n");
            return false;
        }
        return true;
    }

    public void testValueFilters() throws Exception {
        XModelObject object = this.getFileObject("esb-1.0.1", "jboss-esb-jms.xml");
        XModelMetaData meta = object.getModel().getMetaData();
        XAttribute a = meta.getEntity("ESBPreActionMessagePersister101").getAttribute(ATTR_MESSAGE_STORE_CLASS);
        ESBModelTest.assertNotNull((Object)a);
        String valueFilter = a.getProperty(VALUE_FILTER_PROPERTY);
        ESBModelTest.assertEquals((String)MESSAGE_STORE_CLASS_VALUE_FILTER_ID, (String)valueFilter);
        a = meta.getEntity("ESBPreActionMessagePersister101").getAttribute(ATTR_MESSAGE_STORE_CLASS);
        ESBModelTest.assertNotNull((Object)a);
        valueFilter = a.getProperty(VALUE_FILTER_PROPERTY);
        ESBModelTest.assertEquals((String)MESSAGE_STORE_CLASS_VALUE_FILTER_ID, (String)valueFilter);
        a = meta.getEntity("ESBAction101").getAttribute(ATTR_CLASS);
        ESBModelTest.assertNotNull((Object)a);
        valueFilter = a.getProperty(VALUE_FILTER_PROPERTY);
        ESBModelTest.assertEquals((String)ACTION_CLASS_VALUE_FILTER_ID, (String)valueFilter);
        a = meta.getEntity("ESBAction120").getAttribute(ATTR_CLASS);
        ESBModelTest.assertNotNull((Object)a);
        valueFilter = a.getProperty(VALUE_FILTER_PROPERTY);
        ESBModelTest.assertEquals((String)ACTION_CLASS_VALUE_FILTER_ID, (String)valueFilter);
    }

    protected void tearDown() throws Exception {
        if (this.provider != null) {
            this.provider.dispose();
        }
    }
}

