/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.proc.ITeiidXmlColumnInfo;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlColumnInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlImportXmlConfigurationPage;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.common.table.CheckBoxEditingSupport;
import org.teiid.designer.ui.common.table.ComboBoxEditingSupport;
import org.teiid.designer.ui.common.table.TableViewerBuilder;

public class EditColumnsPanel {
    private final String EMPTY = "";
    private final int NAME_PROP = 0;
    private final int DEFAULT_VALUE_PROP = 1;
    private final int XML_PATH_PROP = 2;
    TableViewerBuilder columnsViewer;
    final TeiidXmlImportXmlConfigurationPage configPage;

    public EditColumnsPanel(Composite parent, TeiidXmlImportXmlConfigurationPage configPage) {
        this.configPage = configPage;
        this.createPanel(parent);
    }

    private void createPanel(Composite parent) {
        this.columnsViewer = new TableViewerBuilder(parent, 2820);
        GridDataFactory.fillDefaults().hint(-1, 80).applyTo((Control)this.columnsViewer.getControl());
        TableViewerColumn column = this.columnsViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(String.valueOf(Messages.ColumnName) + this.getSpaces(25));
        column.setEditingSupport((EditingSupport)new ColumnInfoTextEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer(), 0));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(0));
        column = this.columnsViewer.createColumn(16384, 10, 20, true);
        column.getColumn().setText(Messages.ForOrdinality);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(1));
        column.setEditingSupport((EditingSupport)new OrdinalityEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        column = this.columnsViewer.createColumn(16384, 20, 30, true);
        column.getColumn().setText(String.valueOf(Messages.dataTypeLabel) + this.getSpaces(2));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(2));
        column.setEditingSupport((EditingSupport)new DatatypeComboEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        column = this.columnsViewer.createColumn(16384, 20, 30, true);
        column.getColumn().setText(String.valueOf(Messages.DefaultValue) + this.getSpaces(2));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(3));
        column.setEditingSupport((EditingSupport)new ColumnInfoTextEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer(), 1));
        column = this.columnsViewer.createColumn(16384, 20, 30, true);
        column.getColumn().setText(Messages.Path);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(4));
        column.setEditingSupport((EditingSupport)new ColumnInfoTextEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer(), 2));
        if (this.getFileInfo() != null) {
            for (ITeiidXmlColumnInfo iTeiidXmlColumnInfo : this.getFileInfo().getColumnInfoList()) {
                this.columnsViewer.add((Object)iTeiidXmlColumnInfo);
            }
        }
    }

    private String getSpaces(int nSpaces) {
        StringBuffer sb = new StringBuffer(nSpaces);
        int i = 0;
        while (i < nSpaces) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    private TeiidXmlFileInfo getFileInfo() {
        return this.configPage.getFileInfo();
    }

    public void refresh() {
        this.columnsViewer.getTable().removeAll();
        for (ITeiidXmlColumnInfo iTeiidXmlColumnInfo : this.getFileInfo().getColumnInfoList()) {
            this.columnsViewer.add((Object)iTeiidXmlColumnInfo);
        }
    }

    public void refresh(Object element) {
        this.columnsViewer.refresh(element);
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        this.columnsViewer.addSelectionChangedListener(listener);
    }

    public TeiidXmlColumnInfo getSelectedColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.columnsViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof ITeiidXmlColumnInfo) {
                return (TeiidXmlColumnInfo)obj;
            }
            ++n2;
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.columnsViewer.getTable().getSelectionIndex();
    }

    public void selectRow(int index) {
        if (index > -1) {
            this.columnsViewer.getTable().select(index);
        } else {
            this.columnsViewer.setSelection((ISelection)new StructuredSelection());
        }
    }

    class ColumnDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ColumnDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof ITeiidXmlColumnInfo) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((ITeiidXmlColumnInfo)element).getName();
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return ((ITeiidXmlColumnInfo)element).getDatatype();
                    }
                    case 3: {
                        return ((ITeiidXmlColumnInfo)element).getDefaultValue();
                    }
                    case 4: {
                        return ((ITeiidXmlColumnInfo)element).getRelativePath();
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
            }
            if (this.columnNumber == 1) {
                if (element instanceof ITeiidXmlColumnInfo) {
                    if (((ITeiidXmlColumnInfo)element).getOrdinality()) {
                        return UiPlugin.getDefault().getImage("icons/full/cview16/checked_box.png");
                    }
                    return UiPlugin.getDefault().getImage("icons/full/cview16/unchecked_box.png");
                }
                return null;
            }
            return null;
        }
    }

    class ColumnInfoTextEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;
        private int type;

        public ColumnInfoTextEditingSupport(ColumnViewer viewer, int type) {
            super(viewer);
            this.type = type;
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof ITeiidXmlColumnInfo) {
                switch (this.type) {
                    case 0: {
                        return ((ITeiidXmlColumnInfo)element).getName();
                    }
                    case 1: {
                        return ((ITeiidXmlColumnInfo)element).getDefaultValue();
                    }
                    case 2: {
                        return ((ITeiidXmlColumnInfo)element).getRelativePath();
                    }
                }
            }
            return "";
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof ITeiidXmlColumnInfo) {
                switch (this.type) {
                    case 0: {
                        String oldValue = ((ITeiidXmlColumnInfo)element).getName();
                        String newValue = (String)value;
                        if (newValue == null || newValue.length() <= 0 || newValue.equalsIgnoreCase(oldValue)) break;
                        ((TeiidXmlColumnInfo)element).setName(newValue);
                        EditColumnsPanel.this.refresh(element);
                        EditColumnsPanel.this.getFileInfo().columnChanged((ITeiidXmlColumnInfo)element);
                        EditColumnsPanel.this.configPage.handleInfoChanged(false);
                        break;
                    }
                    case 1: {
                        String oldValue = ((ITeiidXmlColumnInfo)element).getDefaultValue();
                        String newValue = (String)value;
                        if (newValue == null || newValue.length() <= 0 || newValue.equalsIgnoreCase(oldValue)) break;
                        ((TeiidXmlColumnInfo)element).setDefaultValue(newValue);
                        EditColumnsPanel.this.refresh(element);
                        EditColumnsPanel.this.getFileInfo().columnChanged((ITeiidXmlColumnInfo)element);
                        EditColumnsPanel.this.configPage.handleInfoChanged(false);
                        break;
                    }
                    case 2: {
                        String oldValue = ((ITeiidXmlColumnInfo)element).getRelativePath();
                        String newValue = (String)value;
                        if (newValue == null || newValue.length() <= 0 || newValue.equalsIgnoreCase(oldValue)) break;
                        ((TeiidXmlColumnInfo)element).setRelativePath(newValue);
                        EditColumnsPanel.this.refresh(element);
                        EditColumnsPanel.this.getFileInfo().columnChanged((ITeiidXmlColumnInfo)element);
                        EditColumnsPanel.this.configPage.handleInfoChanged(false);
                    }
                }
            }
        }
    }

    class DatatypeComboEditingSupport
    extends ComboBoxEditingSupport {
        private String[] datatypes;

        public DatatypeComboEditingSupport(ColumnViewer viewer) {
            super(viewer);
            IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
            Set unsortedDatatypes = service.getAllDataTypeNames();
            ArrayList<Object> dTypes = new ArrayList<Object>();
            Object[] sortedStrings = unsortedDatatypes.toArray(new String[unsortedDatatypes.size()]);
            Arrays.sort(sortedStrings);
            Object[] objectArray = sortedStrings;
            int n = sortedStrings.length;
            int n2 = 0;
            while (n2 < n) {
                Object dType = objectArray[n2];
                dTypes.add(dType);
                ++n2;
            }
            this.datatypes = dTypes.toArray(new String[dTypes.size()]);
        }

        protected String getElementValue(Object element) {
            return ((ITeiidXmlColumnInfo)element).getDatatype();
        }

        protected String[] refreshItems(Object element) {
            return this.datatypes;
        }

        protected void setElementValue(Object element, String newValue) {
            if (!((ITeiidXmlColumnInfo)element).getOrdinality()) {
                ((TeiidXmlColumnInfo)element).setDatatype(newValue);
                EditColumnsPanel.this.configPage.handleInfoChanged(false);
            }
        }
    }

    class OrdinalityEditingSupport
    extends CheckBoxEditingSupport {
        public OrdinalityEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected void setElementValue(Object element, Object newValue) {
            if (element instanceof ITeiidXmlColumnInfo && newValue instanceof Boolean) {
                TeiidXmlColumnInfo info = (TeiidXmlColumnInfo)element;
                if (info.getOrdinality()) {
                    EditColumnsPanel.this.getFileInfo().setOrdinality(info, false);
                    EditColumnsPanel.this.configPage.handleInfoChanged(false);
                } else {
                    EditColumnsPanel.this.getFileInfo().setOrdinality(info, true);
                    EditColumnsPanel.this.configPage.handleInfoChanged(false);
                }
            }
        }
    }
}

