/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile.panels;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.query.proc.ITeiidXmlColumnInfo;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlColumnInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlImportXmlConfigurationPage;
import org.teiid.designer.transformation.ui.wizards.xmlfile.panels.EditColumnsPanel;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class ColumnsInfoPanel {
    private Button addButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private Text rootPathText;
    TreeViewer schemaTreeViewer;
    EditColumnsPanel editColumnsPanel;
    final TeiidXmlImportXmlConfigurationPage configPage;
    boolean refreshing = false;

    public ColumnsInfoPanel(Composite parent, TeiidXmlImportXmlConfigurationPage configPage) {
        this.configPage = configPage;
        this.init(parent);
    }

    public TeiidXmlFileInfo getFileInfo() {
        return this.configPage.getFileInfo();
    }

    public void refresh() {
        this.refreshing = true;
        this.editColumnsPanel.refresh();
        this.rootPathText.setText(this.getFileInfo().getRootPath());
        this.refreshing = false;
    }

    public Text getRootPathText() {
        return this.rootPathText;
    }

    private void init(Composite parent) {
        Group columnInfoGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.ColumnInfo, (int)0, (int)1, (int)2);
        Label prefixLabel = new Label((Composite)columnInfoGroup, 0);
        prefixLabel.setText(Messages.RootPath);
        prefixLabel.setToolTipText(Messages.RootPathTooltip);
        this.rootPathText = WidgetFactory.createTextField((Composite)columnInfoGroup, (int)0);
        GridData gd = new GridData(768);
        gd.minimumWidth = 50;
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        this.rootPathText.setLayoutData((Object)gd);
        this.rootPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ColumnsInfoPanel.this.handleRootPathChanged();
            }
        });
        this.rootPathText.setToolTipText(Messages.RootPathTooltip);
        Composite leftToolbarPanel = new Composite((Composite)columnInfoGroup, 0);
        GridLayout tbGL = new GridLayout();
        tbGL.marginHeight = 0;
        tbGL.marginWidth = 0;
        tbGL.verticalSpacing = 2;
        leftToolbarPanel.setLayout((Layout)tbGL);
        GridData ltpGD = new GridData(1040);
        ltpGD.heightHint = 120;
        leftToolbarPanel.setLayoutData((Object)ltpGD);
        this.addButton = new Button(leftToolbarPanel, 8);
        this.addButton.setText(Messages.addLabel);
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.setEnabled(true);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsInfoPanel.this.configPage.createColumn();
                ColumnsInfoPanel.this.editColumnsPanel.refresh();
                ColumnsInfoPanel.this.notifyColumnDataChanged();
            }
        });
        this.deleteButton = new Button(leftToolbarPanel, 8);
        this.deleteButton.setText(Messages.deleteLabel);
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidXmlColumnInfo info = ColumnsInfoPanel.this.editColumnsPanel.getSelectedColumn();
                if (info != null) {
                    ColumnsInfoPanel.this.getFileInfo().removeColumn(info);
                    ColumnsInfoPanel.this.deleteButton.setEnabled(false);
                    ColumnsInfoPanel.this.editColumnsPanel.selectRow(-1);
                    ColumnsInfoPanel.this.notifyColumnDataChanged();
                }
            }
        });
        this.upButton = new Button(leftToolbarPanel, 8);
        this.upButton.setText(Messages.moveUpLabel);
        this.upButton.setLayoutData((Object)new GridData(768));
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidXmlColumnInfo info = ColumnsInfoPanel.this.editColumnsPanel.getSelectedColumn();
                if (info != null) {
                    int selectedIndex = ColumnsInfoPanel.this.editColumnsPanel.getSelectedIndex();
                    ColumnsInfoPanel.this.getFileInfo().moveColumnUp(info);
                    ColumnsInfoPanel.this.downButton.setEnabled(ColumnsInfoPanel.this.getFileInfo().canMoveDown(info));
                    ColumnsInfoPanel.this.upButton.setEnabled(ColumnsInfoPanel.this.getFileInfo().canMoveUp(info));
                    ColumnsInfoPanel.this.editColumnsPanel.refresh();
                    ColumnsInfoPanel.this.notifyColumnDataChanged();
                    ColumnsInfoPanel.this.editColumnsPanel.selectRow(selectedIndex - 1);
                }
            }
        });
        this.downButton = new Button(leftToolbarPanel, 8);
        this.downButton.setText(Messages.moveDownLabel);
        this.downButton.setLayoutData((Object)new GridData(768));
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidXmlColumnInfo info = ColumnsInfoPanel.this.editColumnsPanel.getSelectedColumn();
                if (info != null) {
                    int selectedIndex = ColumnsInfoPanel.this.editColumnsPanel.getSelectedIndex();
                    ColumnsInfoPanel.this.getFileInfo().moveColumnDown(info);
                    ColumnsInfoPanel.this.downButton.setEnabled(ColumnsInfoPanel.this.getFileInfo().canMoveDown(info));
                    ColumnsInfoPanel.this.upButton.setEnabled(ColumnsInfoPanel.this.getFileInfo().canMoveUp(info));
                    ColumnsInfoPanel.this.editColumnsPanel.refresh();
                    ColumnsInfoPanel.this.notifyColumnDataChanged();
                    ColumnsInfoPanel.this.editColumnsPanel.selectRow(selectedIndex + 1);
                }
            }
        });
        this.editColumnsPanel = new EditColumnsPanel((Composite)columnInfoGroup, this.configPage);
        this.editColumnsPanel.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    ColumnsInfoPanel.this.deleteButton.setEnabled(false);
                    ColumnsInfoPanel.this.upButton.setEnabled(false);
                    ColumnsInfoPanel.this.downButton.setEnabled(false);
                } else {
                    boolean enable = true;
                    Object[] objs = sel.toArray();
                    ITeiidXmlColumnInfo columnInfo = null;
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (!(obj instanceof ITeiidXmlColumnInfo)) {
                            enable = false;
                            break;
                        }
                        columnInfo = (ITeiidXmlColumnInfo)obj;
                        ++n2;
                    }
                    if (objs.length == 0) {
                        enable = false;
                    }
                    ColumnsInfoPanel.this.deleteButton.setEnabled(enable);
                    if (enable) {
                        ColumnsInfoPanel.this.upButton.setEnabled(ColumnsInfoPanel.this.getFileInfo().canMoveUp(columnInfo));
                        ColumnsInfoPanel.this.downButton.setEnabled(ColumnsInfoPanel.this.getFileInfo().canMoveDown(columnInfo));
                    }
                }
            }
        });
    }

    private void handleRootPathChanged() {
        String currentRootPath = this.getFileInfo().getRootPath();
        if (!StringUtilities.equals((String)currentRootPath, (String)this.rootPathText.getText())) {
            this.getFileInfo().setRootPath(this.rootPathText.getText());
        }
    }

    private void notifyColumnDataChanged() {
        if (!this.refreshing) {
            this.configPage.handleInfoChanged(false);
        }
    }

    public void disableButtons() {
        this.deleteButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    public void setEnabled(boolean enable) {
        this.addButton.setEnabled(enable);
        this.disableButtons();
        this.rootPathText.setEnabled(enable);
        this.refresh();
    }

    public void notifySelection(boolean selected) {
        this.addButton.setEnabled(selected);
    }
}

