/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlAttribute;

public class XmlElement {
    public static final String SEPARATOR = "/";
    private List<XmlElement> elementChildren = new ArrayList<XmlElement>();
    private List<XmlAttribute> attributeChildren = new ArrayList<XmlAttribute>();
    private String name;
    private XmlElement parent;
    private Position position;

    public XmlElement(String name) {
        this.name = name;
    }

    public Object[] getChildrenDTDElements() {
        return this.elementChildren.toArray(new Object[0]);
    }

    public XmlElement addChildElement(XmlElement element) {
        this.elementChildren.add(element);
        element.setParent(this);
        return this;
    }

    public void setParent(XmlElement element) {
        this.parent = element;
    }

    public XmlElement getParent() {
        return this.parent;
    }

    public XmlElement addChildAttribute(XmlAttribute attribute) {
        this.attributeChildren.add(attribute);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getAttributeValue(String localName) {
        for (XmlAttribute attribute : this.attributeChildren) {
            if (!attribute.getName().equals(localName)) continue;
            return attribute.getValue();
        }
        return null;
    }

    public Object[] getAttributes() {
        return this.attributeChildren.toArray(new Object[0]);
    }

    public void clear() {
        this.elementChildren.clear();
        this.attributeChildren.clear();
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getFullPath() {
        String path = SEPARATOR + this.getName();
        XmlElement thisElement = this;
        while (thisElement.getParent() != null) {
            path = SEPARATOR + thisElement.getParent().getName() + path;
            thisElement = thisElement.getParent();
        }
        return path;
    }
}

