/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.Base64;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.datatools.connectivity.model.Parameter;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.URLHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoHelper;
import org.teiid.designer.datatools.ui.actions.EditConnectionProfileAction;
import org.teiid.designer.datatools.ui.dialogs.NewTeiidFilteredCPWizard;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.file.FlatFileRelationalModelFactory;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportSourcePage;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.viewsupport.FileSystemLabelProvider;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public class TeiidXmlImportSourcePage
extends AbstractWizardPage
implements UiConstants,
InternalUiConstants.Widgets,
CoreStringUtil.Constants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidMetadataImportSourcePage.class);
    private static final String TITLE = TeiidXmlImportSourcePage.getString("title");
    private static final String XML_TITLE = TeiidXmlImportSourcePage.getString("xmlTitle");
    private static final String INITIAL_MESSAGE = TeiidXmlImportSourcePage.getString("initialMessage");
    private static final String FLAT_FILE_SOURCE_LABEL = TeiidXmlImportSourcePage.getString("sourceLabel");
    private static final String NEW_BUTTON = "New...";
    private static final String EDIT_BUTTON = "Edit...";
    private static final String INVALID_PAGE_MESSAGE = TeiidXmlImportSourcePage.getString("invalidPageMessage");
    private static final String EMPTY_STRING = "";
    private static final String DOT_XML = ".XML";
    private static final String DOT_XML_LOWER = ".xml";
    private static final String GET_TEXT_FILES = "getTextFiles()";
    private static final String INVOKE_HTTP = "invokeHttp()";
    private static final String XML_URL_FILE_ID = "org.teiid.designer.datatools.profiles.xml.fileurl";
    private static final String XML_FILE_ID = "org.teiid.designer.datatools.profiles.xml.localfile";
    private static final String TEIID_WS_ID = "org.teiid.designer.datatools.profiles.ws.WSConnectionProfile";
    private static final String LOCAL_FILE_NAME_KEY = "LocalFilePath";
    private static final String FILE_URL_NAME_KEY = "URL";
    private static final int DEFAULT_READING_SIZE = 8192;
    private ILabelProvider srcLabelProvider;
    private Combo srcCombo;
    private Text dataFileFolderText;
    private Button editCPButton;
    private TableViewerBuilder fileViewer;
    private DataFolderContentProvider fileContentProvider;
    private TableViewerColumn fileNameColumn;
    private Text sourceModelContainerText;
    private Text sourceModelFileText;
    private Text sourceHelpText;
    private IPath sourceModelFilePath;
    private Map parameterMap;
    private Text selectedFileText;
    private ProfileManager profileManager = ProfileManager.getInstance();
    private Collection<IConnectionProfile> connectionProfiles;
    private TeiidMetadataImportInfo info;
    private TeiidXmlFileInfo xmlFileInfo;
    boolean creatingControl = false;
    boolean synchronizing = false;
    boolean processingChecks = false;
    IStatus fileParsingStatus;
    IConnectionInfoHelper connectionInfoHelper;
    Properties designerProperties;
    final ViewerFilter sourceModelFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean doSelect = false;
            if (element instanceof IResource) {
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        try {
                            doSelect = ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                        }
                        catch (CoreException e) {
                            UiConstants.Util.log((Throwable)e);
                        }
                    } else if (element instanceof IContainer) {
                        doSelect = true;
                    } else if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                        ModelResource theModel = null;
                        try {
                            theModel = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)true);
                        }
                        catch (Exception ex) {
                            ModelerCore.Util.log((Throwable)ex);
                        }
                        if (theModel != null && ModelIdentifier.isRelationalSourceModel((ModelResource)theModel)) {
                            doSelect = true;
                        }
                    }
                }
            } else if (element instanceof IContainer) {
                doSelect = true;
            }
            return doSelect;
        }
    };

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public TeiidXmlImportSourcePage(TeiidMetadataImportInfo info) {
        this(null, info);
    }

    public TeiidXmlImportSourcePage(Object selection, TeiidMetadataImportInfo info) {
        super(TeiidMetadataImportSourcePage.class.getSimpleName(), TITLE);
        this.info = info;
        this.setPageComplete(false);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importTeiidMetadataWiz.gif"));
        this.connectionInfoHelper = new ConnectionInfoHelper();
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout());
        mainPanel.setLayoutData((Object)new GridData(272));
        mainPanel.setSize(mainPanel.computeSize(-1, -1));
        this.setControl((Control)mainPanel);
        this.createProfileGroup(mainPanel);
        this.createFolderContentsListGroup(mainPanel);
        this.createSourceModelGroup(mainPanel);
        this.setMessage(INITIAL_MESSAGE);
    }

    private void createProfileGroup(Composite parent) {
        Group profileGroup = WidgetFactory.createGroup((Composite)parent, (String)FLAT_FILE_SOURCE_LABEL, (int)0, (int)2, (int)3);
        profileGroup.setLayoutData((Object)new GridData(768));
        this.srcLabelProvider = new LabelProvider(){

            public String getText(Object source) {
                return ((IConnectionProfile)source).getName();
            }
        };
        this.srcCombo = WidgetFactory.createCombo((Composite)profileGroup, (int)8, (int)768, (List)((ArrayList)this.connectionProfiles), null, (ILabelProvider)this.srcLabelProvider, (boolean)true);
        this.srcCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TeiidXmlImportSourcePage.this.profileComboSelectionChanged();
                TeiidXmlImportSourcePage.this.fileViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.srcCombo.setVisibleItemCount(10);
        WidgetFactory.createButton((Composite)profileGroup, (String)NEW_BUTTON).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TeiidXmlImportSourcePage.this.createNewConnectionProfile();
            }
        });
        this.editCPButton = WidgetFactory.createButton((Composite)profileGroup, (String)EDIT_BUTTON);
        this.editCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TeiidXmlImportSourcePage.this.editConnectionProfile();
            }
        });
        this.editCPButton.setEnabled(false);
    }

    private void createFolderContentsListGroup(Composite parent) {
        String groupLabel = TeiidXmlImportSourcePage.getString("folderXmlContentsGroup");
        Group folderContentsGroup = WidgetFactory.createGroup((Composite)parent, (String)groupLabel, (int)4, (int)3, (int)2);
        GridData gd_1 = new GridData(1808);
        gd_1.heightHint = 180;
        folderContentsGroup.setLayoutData((Object)gd_1);
        Label locationLabel = new Label((Composite)folderContentsGroup, 0);
        locationLabel.setText(TeiidXmlImportSourcePage.getString("folderLocation"));
        this.dataFileFolderText = new Text((Composite)folderContentsGroup, 2052);
        this.dataFileFolderText.setBackground(WidgetUtil.getReadOnlyBackgroundColor());
        this.dataFileFolderText.setForeground(WidgetUtil.getDarkBlueColor());
        this.dataFileFolderText.setLayoutData((Object)new GridData(768));
        this.dataFileFolderText.setEditable(false);
        this.createFileTableViewer((Composite)folderContentsGroup);
        Label selectedFileLabel = new Label((Composite)folderContentsGroup, 0);
        selectedFileLabel.setText(TeiidXmlImportSourcePage.getString("selectedXmlFile"));
        this.selectedFileText = new Text((Composite)folderContentsGroup, 2052);
        this.selectedFileText.setBackground(WidgetUtil.getReadOnlyBackgroundColor());
        this.selectedFileText.setForeground(WidgetUtil.getDarkBlueColor());
        this.selectedFileText.setLayoutData((Object)new GridData(768));
        this.selectedFileText.setEditable(false);
    }

    private void createFileTableViewer(Composite parent) {
        this.fileViewer = new TableViewerBuilder(parent, 2852);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 160).span(2, -1).applyTo((Control)this.fileViewer.getTableComposite());
        this.fileContentProvider = new DataFolderContentProvider();
        this.fileViewer.setContentProvider((IContentProvider)this.fileContentProvider);
        this.fileViewer.setLabelProvider((IBaseLabelProvider)new FileSystemLabelProvider());
        this.fileViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (TeiidXmlImportSourcePage.this.processingChecks) {
                    return;
                }
                TeiidXmlImportSourcePage.this.processingChecks = true;
                if (e.detail == 32) {
                    TableItem tableItem = (TableItem)e.item;
                    boolean wasChecked = tableItem.getChecked();
                    if (tableItem.getData() instanceof File) {
                        TeiidXmlImportSourcePage.this.fileViewer.getTable().setSelection(new TableItem[]{tableItem});
                        if (wasChecked) {
                            TableItem[] tableItemArray = TeiidXmlImportSourcePage.this.fileViewer.getTable().getItems();
                            int n = tableItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TableItem item = tableItemArray[n2];
                                if (item != tableItem) {
                                    item.setChecked(false);
                                }
                                ++n2;
                            }
                        }
                        TeiidXmlImportSourcePage.this.info.setDoProcessXml((File)tableItem.getData(), wasChecked);
                    }
                }
                TeiidXmlImportSourcePage.this.processingChecks = false;
                TeiidXmlImportSourcePage.this.synchronizeUI();
                TeiidXmlImportSourcePage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fileNameColumn = this.fileViewer.createColumn(16384, 100, 40, false);
        if (this.info.getFileMode() == 3) {
            this.fileNameColumn.getColumn().setText("XML Data File URL");
        } else {
            this.fileNameColumn.getColumn().setText(TeiidXmlImportSourcePage.getString("xmlDataFileNameColumn"));
        }
        this.fileNameColumn.setLabelProvider((CellLabelProvider)new DataFileContentColumnLabelProvider());
    }

    private void createSourceModelGroup(Composite parent) {
        Group sourceGroup = WidgetFactory.createGroup((Composite)parent, (String)TeiidXmlImportSourcePage.getString("sourceModelDefinitionGroup"), (int)0, (int)1, (int)3);
        sourceGroup.setLayoutData((Object)new GridData(768));
        Label locationLabel = new Label((Composite)sourceGroup, 0);
        locationLabel.setText(TeiidXmlImportSourcePage.getString("location"));
        this.sourceModelContainerText = new Text((Composite)sourceGroup, 2052);
        GridData gridData = new GridData(768);
        this.sourceModelContainerText.setLayoutData((Object)gridData);
        this.sourceModelContainerText.setBackground(Display.getCurrent().getSystemColor(19));
        this.sourceModelContainerText.setEditable(false);
        Button browseButton = new Button((Composite)sourceGroup, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(TeiidXmlImportSourcePage.getString("browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidXmlImportSourcePage.this.handleSourceModelLocationBrowse();
            }
        });
        Label fileLabel = new Label((Composite)sourceGroup, 0);
        fileLabel.setText(TeiidXmlImportSourcePage.getString("name"));
        this.sourceModelFileText = new Text((Composite)sourceGroup, 2052);
        gridData = new GridData(768);
        this.sourceModelFileText.setLayoutData((Object)gridData);
        this.sourceModelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TeiidXmlImportSourcePage.this.handleSourceModelTextChanged();
            }
        });
        browseButton = new Button((Composite)sourceGroup, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(TeiidXmlImportSourcePage.getString("browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidXmlImportSourcePage.this.handleSourceModelBrowse();
            }
        });
        new Label((Composite)sourceGroup, 0);
        Group helpGroup = WidgetFactory.createGroup((Composite)sourceGroup, (String)TeiidXmlImportSourcePage.getString("modelStatus"), (int)2, (int)2);
        helpGroup.setLayoutData((Object)new GridData(768));
        this.sourceHelpText = new Text((Composite)helpGroup, 72);
        this.sourceHelpText.setBackground(WidgetUtil.getReadOnlyBackgroundColor());
        this.sourceHelpText.setForeground(WidgetUtil.getDarkBlueColor());
        GridData gd = new GridData(768);
        gd.heightHint = 40;
        gd.horizontalSpan = 3;
        this.sourceHelpText.setLayoutData((Object)gd);
    }

    void profileComboSelectionChanged() {
        if (this.srcCombo.getSelectionIndex() > -1) {
            String cpName = this.srcCombo.getItem(this.srcCombo.getSelectionIndex());
            for (IConnectionProfile profile : this.connectionProfiles) {
                if (!profile.getName().equalsIgnoreCase(cpName)) continue;
                this.setConnectionProfile(profile);
                this.setDataFolderLocation();
                this.clearFileListViewer();
                this.loadFileListViewer();
                break;
            }
        } else {
            this.setConnectionProfile(null);
        }
        this.synchronizeUI();
        this.validatePage();
        this.editCPButton.setEnabled(this.getConnectionProfile() != null);
    }

    public void setDesignerProperties(Properties properties) {
        this.designerProperties = properties;
    }

    private void setConnectionProfile(IConnectionProfile profile) {
        if (profile == null || this.isInvalidXmlFileProfile(profile)) {
            this.fileViewer.setInput(null);
            this.clearFileListViewer();
        }
        this.info.setConnectionProfile(profile);
    }

    private IConnectionProfile getConnectionProfile() {
        return this.info.getConnectionProfile();
    }

    private boolean isRestConnectionProfile() {
        IConnectionProfile profile = this.info.getConnectionProfile();
        if (profile != null) {
            return profile.getProviderId().equals(TEIID_WS_ID);
        }
        return false;
    }

    private boolean isValidProfileForPage(IConnectionProfile profile) {
        boolean isValid = false;
        if (this.info.isXmlLocalFileMode() && profile.getProviderId().equalsIgnoreCase(XML_FILE_ID)) {
            isValid = true;
        } else if (this.info.isXmlUrlFileMode() && (profile.getProviderId().equalsIgnoreCase(XML_URL_FILE_ID) || profile.getProviderId().equalsIgnoreCase(TEIID_WS_ID))) {
            isValid = true;
        }
        return isValid;
    }

    private boolean isInvalidXmlFileProfile(IConnectionProfile profile) {
        File theXmlFile = this.getFileForConnectionProfile(profile);
        return theXmlFile != null && theXmlFile.exists() && !theXmlFile.isFile();
    }

    private void clearFileListViewer() {
        this.info.clearXmlFileInfos();
        this.info.clearFileInfos();
        this.fileViewer.getTable().clearAll();
    }

    private void loadFileListViewer() {
        if (this.getConnectionProfile() != null) {
            File theXmlFile = this.getFileForConnectionProfile(this.getConnectionProfile());
            String urlString = this.getUrlStringForConnectionProfile();
            if (theXmlFile != null) {
                if (theXmlFile.exists() && theXmlFile.isFile()) {
                    this.setXmlFile(theXmlFile, false, null);
                }
            } else if (urlString != null && urlString.trim().length() > 0) {
                File xmlFile = null;
                this.fileViewer.setInput((Object)"no input");
                xmlFile = this.isRestConnectionProfile() ? this.getXmlFileFromRestUrl(this.getConnectionProfile()) : this.getXmlFileFromUrl(urlString);
                if (xmlFile != null && xmlFile.exists()) {
                    this.setXmlFile(xmlFile, true, urlString);
                }
            } else {
                this.fileViewer.setInput(null);
                MessageDialog.openError((Shell)this.getShell(), (String)TeiidXmlImportSourcePage.getString("invalidXmlConnectionProfileTitle"), (String)TeiidXmlImportSourcePage.getString("invalidXmlConnectionProfileMessage"));
            }
        }
    }

    private int write(OutputStream out, InputStream is) throws IOException {
        byte[] l_buffer = new byte[8192];
        int writen = 0;
        try {
            int l_nbytes = 0;
            int readLength = l_buffer.length;
            while ((l_nbytes = is.read(l_buffer, 0, readLength)) != -1) {
                out.write(l_buffer, 0, l_nbytes);
                writen += l_nbytes;
            }
            int n = writen;
            return n;
        }
        finally {
            try {
                is.close();
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * Loose catch block
     */
    private File getXmlFileFromRestUrl(IConnectionProfile profile) {
        Properties props = profile.getBaseProperties();
        String endpoint = ConnectionInfoHelper.readEndPointProperty((Properties)props);
        String username = (String)props.get("AuthUserName");
        String password = (String)props.get("AuthPassword");
        File xmlFile = null;
        FileOutputStream fos = null;
        if (props.get("Parameter map") != null && !(props.get("Parameter map") instanceof String)) {
            this.parameterMap = (Map)props.get("Parameter map");
        }
        try {
            try {
                endpoint = this.getUrl(endpoint, this.parameterMap);
                URL url = new URL(endpoint);
                HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
                String filePath = TeiidXmlImportSourcePage.formatPath(url);
                if (username != null && !username.isEmpty()) {
                    httpConn.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])(String.valueOf(username) + ':' + password).getBytes()));
                }
                httpConn.setDoOutput(false);
                if (props.get("Accept") != null) {
                    httpConn.setRequestProperty("Accept", (String)props.get("Accept"));
                } else {
                    httpConn.setRequestProperty("Accept", "application/xml");
                }
                if (props.get("Content-Type") != null) {
                    httpConn.setRequestProperty("Content-Type", (String)props.get("Content-Type"));
                } else {
                    httpConn.setRequestProperty("Content-Type", "application/xml");
                }
                for (Object key : props.keySet()) {
                    String keyStr = (String)key;
                    if ("Authorization".equalsIgnoreCase(keyStr) || "AuthPassword".equalsIgnoreCase(keyStr) || "SecurityType".equalsIgnoreCase(keyStr) || "AuthUserName".equalsIgnoreCase(keyStr) || "EndPoint".equalsIgnoreCase(keyStr) || "Content-Type".equalsIgnoreCase(keyStr) || "Accept".equalsIgnoreCase(keyStr) || "Parameter map".equalsIgnoreCase(keyStr)) continue;
                    httpConn.setRequestProperty(keyStr, props.getProperty(keyStr));
                }
                InputStream is = httpConn.getInputStream();
                xmlFile = File.createTempFile(CoreStringUtil.createFileName((String)filePath), DOT_XML_LOWER);
                fos = new FileOutputStream(xmlFile);
                this.write(fos, is);
            }
            catch (MalformedURLException ex) {
                Util.log((Throwable)ex);
                MessageDialog.openError((Shell)this.getShell(), (String)TeiidXmlImportSourcePage.getString("malformedUrlErrorTitle"), (String)UiConstants.Util.getString("malformedUrlErrorMessage", new Object[]{endpoint, ex.getMessage()}));
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (ProtocolException ex) {
                Util.log((Throwable)ex);
                MessageDialog.openError((Shell)this.getShell(), (String)TeiidXmlImportSourcePage.getString("protocolErrorTitle"), (String)UiConstants.Util.getString("protocolUrlErrorMessage", new Object[]{endpoint, ex.getMessage()}));
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException ex) {
                Util.log((Throwable)ex);
                MessageDialog.openError((Shell)this.getShell(), (String)TeiidXmlImportSourcePage.getString("ioErrorTitle"), (String)UiConstants.Util.getString("ioErrorMessage", new Object[]{endpoint, ex.getMessage()}));
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return xmlFile;
    }

    private File getXmlFileFromUrl(String urlString) {
        File xmlFile = null;
        URL newUrl = null;
        try {
            newUrl = URLHelper.buildURL((String)urlString);
        }
        catch (MalformedURLException e) {
            Util.log((Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)TeiidXmlImportSourcePage.getString("malformedUrlErrorTitle"), (String)UiConstants.Util.getString("malformedUrlErrorMessage", new Object[]{urlString, e.getMessage()}));
        }
        if (newUrl != null) {
            boolean resolved = true;
            try {
                resolved = URLHelper.resolveUrl((URL)newUrl);
            }
            catch (Exception exception) {
                resolved = false;
            }
            if (resolved) {
                try {
                    String filePath = TeiidXmlImportSourcePage.formatPath(newUrl);
                    xmlFile = URLHelper.createFileFromUrl((URL)newUrl, (String)CoreStringUtil.createFileName((String)filePath), (String)DOT_XML_LOWER);
                }
                catch (MalformedURLException theException) {
                    Util.log((Throwable)theException);
                }
                catch (IOException theException) {
                    Util.log((Throwable)theException);
                }
            }
        }
        return xmlFile;
    }

    String getUrl(String url, Map parameterMap) {
        StringBuilder previewUrl = new StringBuilder();
        String urlText = url;
        StringBuilder parameters = this.buildParameterString(url, parameterMap);
        previewUrl.append(urlText).append((CharSequence)parameters);
        return previewUrl.toString();
    }

    private StringBuilder buildParameterString(String url, Map<String, Parameter> parameterMap) {
        StringBuilder parameterString = new StringBuilder();
        if (parameterMap == null) {
            return parameterString;
        }
        for (String key : parameterMap.keySet()) {
            Parameter value = parameterMap.get(key);
            if (value.getType().equals((Object)"URI")) {
                parameterString.append("/").append(key);
            }
            if (!value.getType().equals((Object)Parameter.Type.Query)) continue;
            if (parameterString.length() == 0 || !parameterString.toString().contains("?")) {
                parameterString.append("?");
            } else {
                parameterString.append("&");
            }
            parameterString.append(key).append("=").append(value.getDefaultValue());
        }
        return parameterString;
    }

    private void setXmlFile(File xmlFile, boolean isUrl, String urlString) {
        this.fileViewer.setInput((Object)xmlFile);
        TeiidXmlFileInfo fileInfo = this.info.getXmlFileInfo(xmlFile);
        if (fileInfo == null) {
            fileInfo = new TeiidXmlFileInfo(xmlFile);
            fileInfo.setIsUrl(isUrl);
            if (isUrl) {
                fileInfo.setParameterMap(this.parameterMap);
                fileInfo.setXmlFileUrl(urlString);
            }
            this.info.addXmlFileInfo(fileInfo);
        }
        this.info.addXmlFileInfo(fileInfo);
        this.fileViewer.getTable().select(0);
        this.fileViewer.getTable().getItem(0).setChecked(true);
        this.info.setDoProcessXml(fileInfo.getDataFile(), true);
        this.fileParsingStatus = fileInfo.getParsingStatus();
        if (this.fileParsingStatus.getSeverity() == 4) {
            MessageDialog.openError((Shell)this.getShell(), (String)TeiidXmlImportSourcePage.getString("parsingErrorTitle"), (String)this.fileParsingStatus.getMessage());
        }
    }

    public static String formatPath(URL newUrl) {
        String filePath = newUrl.getFile();
        while (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        int dotLocation = filePath.indexOf(".");
        if (dotLocation > -1) {
            filePath = filePath.substring(0, dotLocation);
        }
        return filePath;
    }

    private File getFileForConnectionProfile(IConnectionProfile profile) {
        Properties props;
        String fileListValue;
        if (profile != null && (fileListValue = (String)(props = profile.getBaseProperties()).get(LOCAL_FILE_NAME_KEY)) != null) {
            return new File(fileListValue);
        }
        return null;
    }

    private String getUrlStringForConnectionProfile() {
        if (this.getConnectionProfile() != null) {
            Properties props = this.getConnectionProfile().getBaseProperties();
            if (this.isRestConnectionProfile()) {
                String fileListValue = ConnectionInfoHelper.readEndPointProperty((Properties)props);
                if (fileListValue != null) {
                    return fileListValue;
                }
            } else {
                String fileListValue = (String)props.get(FILE_URL_NAME_KEY);
                if (fileListValue != null) {
                    return fileListValue;
                }
            }
        }
        return null;
    }

    void createNewConnectionProfile() {
        NewTeiidFilteredCPWizard wiz = null;
        wiz = this.info.getFileMode() == 3 ? new NewTeiidFilteredCPWizard(XML_URL_FILE_ID) : (this.info.getFileMode() == 2 ? new NewTeiidFilteredCPWizard(XML_FILE_ID) : new NewTeiidFilteredCPWizard(TEIID_WS_ID));
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
        wizardDialog.setBlockOnOpen(true);
        CPListener listener = new CPListener();
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        if (wizardDialog.open() == 0) {
            this.refreshConnectionProfiles();
            this.resetCPComboItems();
            this.setConnectionProfile(listener.getChangedProfile());
            this.selectProfile(listener.getChangedProfile());
            ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
        }
    }

    void selectProfile(IConnectionProfile profile) {
        int index = 0;
        String[] stringArray = this.srcCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && item.equalsIgnoreCase(profile.getName())) {
                this.srcCombo.select(index);
                this.profileComboSelectionChanged();
                break;
            }
            ++index;
            ++n2;
        }
    }

    void resetCPComboItems() {
        if (this.srcCombo != null) {
            WidgetUtil.setComboItems((Combo)this.srcCombo, this.connectionProfiles, (ILabelProvider)this.srcLabelProvider, (boolean)true);
        }
    }

    void editConnectionProfile() {
        if (this.getConnectionProfile() != null) {
            IConnectionProfile currentProfile = this.getConnectionProfile();
            EditConnectionProfileAction action = new EditConnectionProfileAction(this.getShell(), currentProfile);
            CPListener listener = new CPListener();
            ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
            action.run();
            if (action.wasFinished()) {
                this.setConnectionProfile(listener.getChangedProfile());
                this.refreshConnectionProfiles();
                WidgetUtil.setComboItems((Combo)this.srcCombo, this.connectionProfiles, (ILabelProvider)this.srcLabelProvider, (boolean)true);
                WidgetUtil.setComboText((Combo)this.srcCombo, (Object)this.getConnectionProfile(), (ILabelProvider)this.srcLabelProvider);
                this.selectConnectionProfile(currentProfile.getName());
                ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
                this.profileComboSelectionChanged();
            } else {
                ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
            }
        }
    }

    void handleSourceModelLocationBrowse() {
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)ModelerCore.getWorkspace().getRoot(), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.sourceModelContainerText != null) {
            this.info.setSourceModelLocation(folder.getFullPath().makeRelative());
            this.sourceModelFilePath = this.info.getSourceModelLocation();
            this.sourceModelContainerText.setText(this.info.getSourceModelLocation().makeRelative().toString());
        } else {
            this.info.setSourceModelLocation((IPath)new Path(EMPTY_STRING));
            this.sourceModelContainerText.setText(EMPTY_STRING);
        }
        if (this.sourceModelFileText.getText() != null && this.sourceModelFileText.getText().length() > -1) {
            this.info.setSourceModelExists(this.sourceModelExists());
        }
        this.validatePage();
    }

    void handleSourceModelBrowse() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)TeiidXmlImportSourcePage.getString("selectSourceModelTitle"), (String)TeiidXmlImportSourcePage.getString("selectSourceModelMessage"), (boolean)false, null, (ViewerFilter)this.sourceModelFilter, (ISelectionStatusValidator)new ModelResourceSelectionValidator(false), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections != null && selections.length == 1 && this.sourceModelFileText != null && selections[0] instanceof IFile) {
            IFile modelFile = (IFile)selections[0];
            IPath folderPath = modelFile.getFullPath().removeLastSegments(1);
            String modelName = modelFile.getFullPath().lastSegment();
            this.info.setSourceModelExists(true);
            this.info.setSourceModelLocation(folderPath);
            this.info.setSourceModelName(modelName);
        }
        if (this.info.getSourceModelName() != null) {
            this.sourceModelFilePath = this.info.getSourceModelLocation();
            this.sourceModelContainerText.setText(this.info.getSourceModelLocation().makeRelative().toString());
            this.sourceModelFileText.setText(this.info.getSourceModelName());
        } else {
            this.sourceModelFileText.setText(EMPTY_STRING);
            this.sourceModelContainerText.setText(EMPTY_STRING);
        }
        this.info.setSourceModelExists(this.sourceModelExists());
        this.validatePage();
    }

    void handleSourceModelTextChanged() {
        if (this.synchronizing) {
            return;
        }
        String newName = EMPTY_STRING;
        if (this.sourceModelFileText.getText() != null && this.sourceModelFileText.getText().length() > -1) {
            newName = this.sourceModelFileText.getText();
            this.info.setSourceModelName(newName);
            this.info.setSourceModelExists(this.sourceModelExists());
        }
        this.validatePage();
    }

    void synchronizeUI() {
        this.synchronizing = true;
        if (this.info.getSourceModelLocation() != null) {
            this.sourceModelFilePath = this.info.getSourceModelLocation();
            this.sourceModelContainerText.setText(this.info.getSourceModelLocation().makeRelative().toString());
        } else {
            this.sourceModelContainerText.setText(EMPTY_STRING);
        }
        if (this.info.getSourceModelName() != null) {
            this.sourceModelFileText.setText(this.info.getSourceModelName());
        } else {
            this.sourceModelFileText.setText(EMPTY_STRING);
        }
        String fileName = EMPTY_STRING;
        String sourceFileName = EMPTY_STRING;
        this.xmlFileInfo = null;
        for (TeiidXmlFileInfo fileInfo : this.info.getXmlFileInfos()) {
            if (!fileInfo.doProcess()) continue;
            this.xmlFileInfo = fileInfo;
            fileName = this.xmlFileInfo.getDataFile().getName();
            if (this.info.getSourceModelName() != null) {
                sourceFileName = this.info.getSourceModelName();
                break;
            }
            sourceFileName = "SourceProcedures";
            this.info.setSourceModelName(sourceFileName);
            break;
        }
        this.selectedFileText.setText(fileName);
        this.sourceModelFileText.setText(sourceFileName);
        this.synchronizing = false;
    }

    private boolean sourceModelExists() {
        ModelWorkspaceItem item;
        if (this.sourceModelFilePath == null) {
            return false;
        }
        IPath modelPath = new Path(this.sourceModelFilePath.toOSString()).append(this.sourceModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        return (item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1)) != null;
    }

    public void selectConnectionProfile(String name) {
        if (name == null) {
            return;
        }
        int cpIndex = -1;
        int i = 0;
        String[] stringArray = this.srcCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && item.length() > 0 && item.toUpperCase().equalsIgnoreCase(name.toUpperCase())) {
                cpIndex = i;
                break;
            }
            ++i;
            ++n2;
        }
        if (cpIndex > -1) {
            this.srcCombo.select(cpIndex);
            this.profileComboSelectionChanged();
        }
    }

    private void setProfileFromProperties() {
        String profileName;
        if (this.designerProperties != null && (profileName = DesignerPropertiesUtil.getConnectionProfileName((Properties)this.designerProperties)) != null && !profileName.isEmpty()) {
            this.selectConnectionProfile(profileName);
        }
    }

    private void refreshConnectionProfiles() {
        IConnectionProfile[] tempProfiles;
        this.connectionProfiles = new ArrayList<IConnectionProfile>();
        IConnectionProfile[] iConnectionProfileArray = tempProfiles = this.profileManager.getProfilesByCategory("org.teiid.designer.import.category");
        int n = tempProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile profile = iConnectionProfileArray[n2];
            if (this.info.isXmlLocalFileMode() && profile.getProviderId().equalsIgnoreCase(XML_FILE_ID)) {
                this.connectionProfiles.add(profile);
            } else if (this.info.isXmlUrlFileMode() && profile.getProviderId().equalsIgnoreCase(XML_URL_FILE_ID)) {
                this.connectionProfiles.add(profile);
            } else if (this.info.isRestUrlFileMode() && profile.getProviderId().equalsIgnoreCase(TEIID_WS_ID)) {
                this.connectionProfiles.add(profile);
            }
            ++n2;
        }
    }

    private boolean validatePage() {
        IConnectionProfile connProfile = this.getConnectionProfile();
        if (connProfile == null) {
            this.setThisPageComplete(TeiidXmlImportSourcePage.getString("noConnectionProfileSelected"), 3);
            return false;
        }
        File theXmlFile = this.getFileForConnectionProfile(connProfile);
        if (theXmlFile != null && theXmlFile.exists() && !theXmlFile.isFile()) {
            this.setThisPageComplete(TeiidXmlImportSourcePage.getString("invalidXmlFileConnProfileMesage"), 3);
            return false;
        }
        this.setSourceHelpMessage();
        boolean fileSelected = false;
        TableItem[] tableItemArray = this.fileViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                fileSelected = true;
                break;
            }
            ++n2;
        }
        if (!fileSelected) {
            this.setThisPageComplete(TeiidXmlImportSourcePage.getString("noXmlDataFilesSelected"), 3);
            return false;
        }
        if (this.fileParsingStatus.getSeverity() == 4) {
            this.setThisPageComplete(this.fileParsingStatus.getMessage(), 3);
            return false;
        }
        boolean validProj = false;
        IProject[] iProjectArray = ModelerCore.getWorkspace().getRoot().getProjects();
        int n3 = iProjectArray.length;
        n = 0;
        while (n < n3) {
            IProject proj = iProjectArray[n];
            try {
                boolean result;
                boolean bl = result = proj.isOpen() && !proj.hasNature("org.teiid.designer.core.hiddenProjectNature") && proj.hasNature("org.teiid.designer.core.modelNature");
                if (result) {
                    validProj = true;
                    break;
                }
            }
            catch (CoreException e) {
                UiConstants.Util.log((Throwable)e);
            }
            ++n;
        }
        if (!validProj) {
            this.setThisPageComplete(TeiidXmlImportSourcePage.getString("noOpenProjectsMessage"), 3);
            return false;
        }
        if (this.srcCombo.getText().length() == 0) {
            this.setThisPageComplete(INVALID_PAGE_MESSAGE, 3);
            return false;
        }
        String container = this.sourceModelContainerText.getText();
        if (CoreStringUtil.isEmpty((String)container)) {
            this.setThisPageComplete(TeiidXmlImportSourcePage.getString("sourceFileLocationMustBeSpecified"), 3);
            return false;
        }
        IProject project = this.getTargetProject();
        if (project == null) {
            this.setThisPageComplete(TeiidXmlImportSourcePage.getString("sourceFileLocationMustBeSpecified"), 3);
            return false;
        }
        String fileText = this.sourceModelFileText.getText().trim();
        if (fileText.length() == 0) {
            this.setThisPageComplete(TeiidXmlImportSourcePage.getString("sourceFileNameMustBeSpecified"), 3);
            return false;
        }
        IStatus status = ModelNameUtil.validate((String)fileText, (String)".xmi", null, (int)5);
        if (status.getSeverity() == 4) {
            this.setThisPageComplete(String.valueOf(ModelNameUtil.MESSAGES.INVALID_SOURCE_MODEL_NAME) + status.getMessage(), 3);
            return false;
        }
        if (this.info.sourceModelExists() && !this.sourceModelHasSameConnectionProfile()) {
            this.setThisPageComplete(Util.getString(String.valueOf(I18N_PREFIX) + "connectionProfileForModelIsDifferent", (Object)fileText), 3);
            return false;
        }
        this.setThisPageComplete(EMPTY_STRING, 0);
        return validProj;
    }

    private void setThisPageComplete(String message, int severity) {
        WizardUtil.setPageComplete((WizardPage)this, (String)message, (int)severity);
    }

    public IProject getTargetProject() {
        IWorkspaceRoot root;
        IResource resource;
        IProject result = null;
        String containerName = this.getSourceContainerName();
        if (!CoreStringUtil.isEmpty((String)containerName) && (resource = (root = ModelerCore.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource.getProject();
        }
        return result;
    }

    public String getSourceContainerName() {
        String result = null;
        result = ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric() ? this.getHiddenProjectPath() : this.sourceModelContainerText.getText().trim();
        return result;
    }

    private String getHiddenProjectPath() {
        String result = null;
        IProject hiddenProj = ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject(false);
        if (hiddenProj != null) {
            result = hiddenProj.getFullPath().makeRelative().toString();
        }
        return result;
    }

    private void setSourceHelpMessage() {
        if (this.creatingControl) {
            return;
        }
        String procedureName = GET_TEXT_FILES;
        if (this.info.isXmlUrlFileMode()) {
            procedureName = INVOKE_HTTP;
        }
        if (this.info.sourceModelExists()) {
            if (this.sourceHasProcedure()) {
                this.sourceHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "existingSourceModelHasProcedure", new Object[]{this.info.getSourceModelName(), procedureName}));
            } else {
                this.sourceHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "existingSourceModelHasNoProcedure", new Object[]{this.info.getSourceModelName(), procedureName}));
            }
        } else if (this.xmlFileInfo == null || !this.xmlFileInfo.doProcess() || this.info.getSourceModelName() == null || this.info.getSourceModelName().length() == 0) {
            this.sourceHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "sourceModelUndefined", new Object[0]));
        } else {
            this.sourceHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "sourceModelWillBeCreated", new Object[]{this.info.getSourceModelName(), procedureName}));
        }
    }

    private boolean sourceHasProcedure() {
        IFile sourceModel;
        ModelResource smr;
        if (this.sourceModelFilePath == null) {
            return false;
        }
        IPath modelPath = new Path(this.sourceModelFilePath.toOSString()).append(this.sourceModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        if ((smr = ModelUtilities.getModelResourceForIFile((IFile)(sourceModel = ModelerCore.getWorkspace().getRoot().getFile(modelPath)), (boolean)false)) != null) {
            if (this.info.isXmlLocalFileMode()) {
                return FlatFileRelationalModelFactory.procedureExists(smr, "getTextFiles");
            }
            if (this.info.isXmlUrlFileMode()) {
                return FlatFileRelationalModelFactory.procedureExists(smr, "invokeHttp");
            }
        }
        return false;
    }

    private boolean sourceModelHasSameConnectionProfile() {
        IFile sourceModel;
        ModelResource smr;
        if (this.sourceModelFilePath == null) {
            return false;
        }
        IPath modelPath = new Path(this.sourceModelFilePath.toOSString()).append(this.sourceModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        if ((smr = ModelUtilities.getModelResourceForIFile((IFile)(sourceModel = ModelerCore.getWorkspace().getRoot().getFile(modelPath)), (boolean)false)) != null) {
            IConnectionProfile profile = this.connectionInfoHelper.getConnectionProfile(smr);
            if (profile == null || this.info.getConnectionProfile() == null) {
                return false;
            }
            if (profile.getName().equalsIgnoreCase(this.info.getConnectionProfile().getName())) {
                return true;
            }
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(XML_TITLE);
            this.fileNameColumn.getColumn().setText(TeiidXmlImportSourcePage.getString("xmlDataFileNameColumn"));
            IConnectionProfile currentProfile = this.getConnectionProfile();
            if (currentProfile == null) {
                this.fileViewer.setInput(null);
                this.info.setSourceModelName(null);
                this.setSourceHelpMessage();
            } else if (!this.isValidProfileForPage(currentProfile)) {
                this.setConnectionProfile(null);
                this.fileViewer.setInput(null);
                this.info.setSourceModelName(null);
                this.setSourceHelpMessage();
            } else if (this.isInvalidXmlFileProfile(currentProfile)) {
                this.fileViewer.setInput(null);
                this.info.setSourceModelName(null);
                this.setSourceHelpMessage();
            }
            this.setDataFolderLocation();
            this.refreshConnectionProfiles();
            this.resetCPComboItems();
            this.loadFileListViewer();
            this.synchronizeUI();
            this.setProfileFromProperties();
            this.validatePage();
        }
    }

    private void setDataFolderLocation() {
        IConnectionProfile profile = this.getConnectionProfile();
        if (profile != null) {
            Properties props = profile.getBaseProperties();
            String home = (String)props.get("ParentDirectory");
            if (home != null) {
                String location = home;
                if (location.length() > 60) {
                    int len = location.length();
                    location = "..." + location.substring(len - 60, len);
                }
                this.dataFileFolderText.setText(location);
                this.dataFileFolderText.setToolTipText(home);
            } else {
                String URL2 = (String)props.get(FILE_URL_NAME_KEY);
                if (URL2 != null) {
                    String location = URL2;
                    if (location.length() > 60) {
                        int len = location.length();
                        location = "..." + location.substring(len - 60, len);
                    }
                    this.dataFileFolderText.setText(location);
                    this.dataFileFolderText.setToolTipText(URL2);
                } else {
                    this.dataFileFolderText.setText(EMPTY_STRING);
                    this.dataFileFolderText.setToolTipText(EMPTY_STRING);
                }
            }
        } else {
            this.dataFileFolderText.setText(EMPTY_STRING);
            this.dataFileFolderText.setToolTipText(EMPTY_STRING);
        }
    }

    public class CPListener
    implements IProfileListener {
        IConnectionProfile latestProfile;

        public void profileAdded(IConnectionProfile profile) {
            this.latestProfile = profile;
        }

        public void profileChanged(IConnectionProfile profile) {
            this.latestProfile = profile;
        }

        public void profileDeleted(IConnectionProfile profile) {
        }

        public IConnectionProfile getChangedProfile() {
            return this.latestProfile;
        }
    }

    class DataFileContentColumnLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            if (element instanceof File) {
                return ((File)element).getName();
            }
            return TeiidXmlImportSourcePage.EMPTY_STRING;
        }

        public String getToolTipText(Object element) {
            return TeiidXmlImportSourcePage.getString("fileNameColumnTooltip");
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    class DataFolderContentProvider
    implements ITreeContentProvider {
        private Object[] NO_CHILDREN = new Object[0];

        DataFolderContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object theParent) {
            File[] result = null;
            if (theParent instanceof File) {
                result = ((File)theParent).listFiles();
            }
            return result == null ? this.NO_CHILDREN : result;
        }

        public Object[] getElements(Object theInput) {
            if (theInput instanceof File && ((File)theInput).isDirectory()) {
                File[] allFiles = ((File)theInput).listFiles();
                ArrayList<File> goodFilesList = new ArrayList<File>();
                File[] fileArray = allFiles;
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File theFile = fileArray[n2];
                    if (!theFile.isDirectory() && theFile.getName().toUpperCase().endsWith(TeiidXmlImportSourcePage.DOT_XML)) {
                        goodFilesList.add(theFile);
                    }
                    ++n2;
                }
                return goodFilesList.toArray(new File[0]);
            }
            if (theInput instanceof File) {
                ArrayList<File> goodFilesList = new ArrayList<File>();
                File theFile = (File)theInput;
                if (theFile.getName().toUpperCase().endsWith(TeiidXmlImportSourcePage.DOT_XML)) {
                    goodFilesList.add(theFile);
                }
                return goodFilesList.toArray(new File[0]);
            }
            ArrayList goodFilesList = new ArrayList();
            return goodFilesList.toArray(new File[0]);
        }

        public Object getParent(Object theElement) {
            return theElement instanceof File ? ((File)theElement).getParentFile() : null;
        }

        public boolean hasChildren(Object theElement) {
            Object[] kids = this.getChildren(theElement);
            return kids != null && kids.length > 0;
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
        }
    }
}

