/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IProcedureService;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.proc.ITeiidXmlColumnInfo;
import org.teiid.designer.query.proc.ITeiidXmlFileInfo;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.wizards.file.TeiidFileInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlColumnInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlAttribute;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlElement;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlFileContentHandler;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlParser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class TeiidXmlFileInfo
extends TeiidFileInfo
implements UiConstants,
ITeiidXmlFileInfo<TeiidXmlColumnInfo> {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidXmlFileInfo.class);
    private static final String XSI_NAMESPACE_PREFIX = "xsi";
    private int numberOfCachedLines = 20;
    private int numberOfLinesInFile = 0;
    private String rootPath = "";
    private String commonRootPath = "";
    private boolean doProcess;
    private String[] cachedFirstLines;
    private List<TeiidXmlColumnInfo> columnInfoList;
    private Map<String, Object> parameterMap = new HashMap<String, Object>();
    private XmlElement rootNode;
    private Map<String, String> namespaceMap;
    private IStatus parsingStatus;
    private String xmlFileUrl;
    private boolean isUrl = false;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object arg1) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, arg1);
    }

    public TeiidXmlFileInfo(File dataFile) {
        super(dataFile, false);
        CoreArgCheck.isNotNull((Object)dataFile, (String)"dataFile is null");
        this.initialize();
    }

    public TeiidXmlFileInfo(TeiidXmlFileInfo info) {
        super(info.getDataFile(), false);
        this.inject(info);
    }

    public void inject(TeiidXmlFileInfo info) {
        CoreArgCheck.isNotNull((Object)info.getDataFile(), (String)"dataFile is null");
        this.cachedFirstLines = info.cachedFirstLines;
        this.numberOfLinesInFile = info.getNumberOfLinesInFile();
        this.rootPath = info.getRootPath();
        this.parameterMap = info.parameterMap;
        this.columnInfoList = new ArrayList<TeiidXmlColumnInfo>();
        for (ITeiidXmlColumnInfo iTeiidXmlColumnInfo : info.getColumnInfoList()) {
            TeiidXmlColumnInfo colInfo = (TeiidXmlColumnInfo)iTeiidXmlColumnInfo;
            this.columnInfoList.add(new TeiidXmlColumnInfo(colInfo.getXmlElement(), colInfo.getXmlAttribute(), colInfo.getSymbolName(), colInfo.getOrdinality(), colInfo.getDatatype(), colInfo.getDefaultValue(), this.getRootPath(), colInfo.getFullXmlPath()));
        }
        this.setStatus(info.getStatus());
        if (info.getViewTableName() != null) {
            this.setViewTableName(info.getViewTableName());
        } else {
            this.setViewTableName("");
        }
        if (info.getViewProcedureName() != null) {
            this.setViewProcedureName(info.getViewProcedureName());
        } else {
            this.setViewProcedureName("");
        }
        this.validate();
    }

    private void initialize() {
        this.setStatus(Status.OK_STATUS);
        this.cachedFirstLines = new String[0];
        this.columnInfoList = new ArrayList<TeiidXmlColumnInfo>();
        this.namespaceMap = new HashMap<String, String>();
        this.parsingStatus = this.parseXmlFile();
        this.setViewTableName("new_table");
        this.validate();
    }

    public void setIsUrl(boolean value) {
        this.isUrl = value;
    }

    public boolean isUrl() {
        return this.isUrl;
    }

    public void setXmlFileUrl(String theUrlValue) {
        this.xmlFileUrl = theUrlValue;
    }

    public String getXmlFileUrl() {
        return this.xmlFileUrl;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String path) {
        this.rootPath = path;
        for (TeiidXmlColumnInfo colInfo : this.columnInfoList) {
            colInfo.setRootPath(this.rootPath);
        }
        this.validate();
    }

    private void loadHeader() {
        block19: {
            this.cachedFirstLines = new String[0];
            ArrayList<String> lines = new ArrayList<String>(7);
            if (this.getDataFile() != null && this.getDataFile().exists()) {
                InputStreamReader fr = null;
                BufferedReader in = null;
                try {
                    try {
                        String str;
                        int iLines = 0;
                        fr = new FileReader(this.getDataFile());
                        in = new BufferedReader(fr);
                        while ((str = in.readLine()) != null) {
                            if (++iLines > this.numberOfCachedLines) continue;
                            lines.add(str);
                        }
                        this.numberOfLinesInFile = iLines;
                        this.cachedFirstLines = lines.toArray(new String[0]);
                    }
                    catch (Exception e) {
                        Util.log(4, (Throwable)e, Util.getString(String.valueOf(I18N_PREFIX) + "problemLoadingFileContentsMessage", (Object)this.getDataFile().getName()));
                        try {
                            fr.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fr.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    fr.close();
                }
                catch (IOException iOException) {}
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String[] getCachedFirstLines() {
        return this.cachedFirstLines;
    }

    public List<TeiidXmlColumnInfo> getColumnInfoList() {
        return this.columnInfoList;
    }

    public void addNewColumn(Object obj) {
        if (obj instanceof XmlElement) {
            TeiidXmlColumnInfo newColumnInfo = new TeiidXmlColumnInfo((XmlElement)obj, this.getRootPath());
            this.columnInfoList.add(newColumnInfo);
        } else if (obj instanceof XmlAttribute) {
            TeiidXmlColumnInfo newColumnInfo = new TeiidXmlColumnInfo((XmlAttribute)obj, this.getRootPath());
            this.columnInfoList.add(newColumnInfo);
        }
        this.validate();
    }

    public void removeColumn(ITeiidXmlColumnInfo theInfo) {
        this.columnInfoList.remove(theInfo);
        this.validate();
    }

    public void columnChanged(ITeiidXmlColumnInfo columnInfo) {
        this.validate();
    }

    @Override
    public void validate() {
        if (this.getRootPath() == null || this.getRootPath().length() == 0) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", TeiidXmlFileInfo.getString("status.rootPathUndefined")));
            return;
        }
        if (this.columnInfoList.isEmpty()) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", TeiidXmlFileInfo.getString("status.noColumnsDefined")));
            return;
        }
        for (ITeiidXmlColumnInfo iTeiidXmlColumnInfo : this.getColumnInfoList()) {
            if (iTeiidXmlColumnInfo.getStatus().getSeverity() != 4) continue;
            this.setStatus(iTeiidXmlColumnInfo.getStatus());
            return;
        }
        for (ITeiidXmlColumnInfo iTeiidXmlColumnInfo : this.getColumnInfoList()) {
            if (iTeiidXmlColumnInfo.getStatus().getSeverity() == 0) continue;
            this.setStatus(iTeiidXmlColumnInfo.getStatus());
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.getColumnInfoList().size());
        for (ITeiidXmlColumnInfo iTeiidXmlColumnInfo : this.getColumnInfoList()) {
            if (arrayList.contains(iTeiidXmlColumnInfo.getName().toUpperCase())) {
                this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", TeiidXmlFileInfo.getString("status.duplicateColumnNames", iTeiidXmlColumnInfo.getName())));
                return;
            }
            arrayList.add(iTeiidXmlColumnInfo.getName().toUpperCase());
        }
        this.setStatus(Status.OK_STATUS);
    }

    public void setDoProcess(boolean doProcess) {
        this.doProcess = doProcess;
    }

    public boolean doProcess() {
        return this.doProcess;
    }

    public void setNumberOfCachedFileLines(int nLines) {
        this.numberOfCachedLines = nLines;
        this.loadHeader();
    }

    public int getNumberOfCachedFileLines() {
        return this.numberOfCachedLines;
    }

    public int getNumberOfLinesInFile() {
        return this.numberOfLinesInFile;
    }

    public void setOrdinality(TeiidXmlColumnInfo columnInfo, boolean value) {
        if (!value) {
            columnInfo.setOrdinality(false);
        } else {
            for (TeiidXmlColumnInfo info : this.columnInfoList) {
                if (info == columnInfo || !info.getOrdinality()) continue;
                info.setOrdinality(false);
            }
            if (!columnInfo.getDatatype().equalsIgnoreCase("integer")) {
                columnInfo.setDatatype("integer");
            }
            columnInfo.setOrdinality(true);
        }
        this.validate();
    }

    public void moveColumnUp(TeiidXmlColumnInfo columnInfo) {
        int startIndex = this.getColumnIndex(columnInfo);
        if (startIndex > 0) {
            TeiidXmlColumnInfo priorInfo = this.getColumnInfoList().get(startIndex - 1);
            TeiidXmlColumnInfo[] infos = this.getColumnInfoList().toArray(new TeiidXmlColumnInfo[0]);
            infos[startIndex - 1] = columnInfo;
            infos[startIndex] = priorInfo;
            ArrayList<TeiidXmlColumnInfo> colInfos = new ArrayList<TeiidXmlColumnInfo>(infos.length);
            TeiidXmlColumnInfo[] teiidXmlColumnInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                TeiidXmlColumnInfo info = teiidXmlColumnInfoArray[n2];
                colInfos.add(info);
                ++n2;
            }
            this.columnInfoList = colInfos;
        }
    }

    public void moveColumnDown(TeiidXmlColumnInfo columnInfo) {
        int startIndex = this.getColumnIndex(columnInfo);
        if (startIndex < this.getColumnInfoList().size() - 1) {
            TeiidXmlColumnInfo afterInfo = this.getColumnInfoList().get(startIndex + 1);
            TeiidXmlColumnInfo[] infos = this.getColumnInfoList().toArray(new TeiidXmlColumnInfo[0]);
            infos[startIndex + 1] = columnInfo;
            infos[startIndex] = afterInfo;
            ArrayList<TeiidXmlColumnInfo> colInfos = new ArrayList<TeiidXmlColumnInfo>(infos.length);
            TeiidXmlColumnInfo[] teiidXmlColumnInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                TeiidXmlColumnInfo info = teiidXmlColumnInfoArray[n2];
                colInfos.add(info);
                ++n2;
            }
            this.columnInfoList = colInfos;
        }
    }

    public boolean canMoveUp(ITeiidXmlColumnInfo columnInfo) {
        return this.getColumnIndex(columnInfo) > 0;
    }

    public boolean canMoveDown(ITeiidXmlColumnInfo columnInfo) {
        return this.getColumnIndex(columnInfo) < this.getColumnInfoList().size() - 1;
    }

    private int getColumnIndex(ITeiidXmlColumnInfo columnInfo) {
        int i = 0;
        for (ITeiidXmlColumnInfo iTeiidXmlColumnInfo : this.getColumnInfoList()) {
            if (iTeiidXmlColumnInfo == columnInfo) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("Teiid Metadata File Info: ");
        text.append("file name = ").append(this.getDataFile().getName());
        text.append(", view table name = ").append(this.getViewTableName());
        return text.toString();
    }

    public String getSqlStringTemplate() {
        return this.getSqlString("myRelModel");
    }

    public String getSqlString(String relationalModelName) {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IProcedureService procedureService = queryService.getProcedureService();
        return procedureService.getSQLStatement((ITeiidXmlFileInfo)this, relationalModelName);
    }

    public String getSqlString(String relationalModelName, String relationalViewModelName, String virtualProcedureName) {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IProcedureService procedureService = queryService.getProcedureService();
        return procedureService.getSQLStatement((ITeiidXmlFileInfo)this, relationalModelName, relationalViewModelName, virtualProcedureName);
    }

    public XmlElement getRootNode() {
        return this.rootNode;
    }

    public String getCommonRootPath() {
        return this.commonRootPath;
    }

    public IStatus getParsingStatus() {
        return this.parsingStatus;
    }

    public String getNamespaceString() {
        if (this.namespaceMap.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("XMLNAMESPACES").append("(");
        int i = 0;
        for (String prefix : this.namespaceMap.keySet()) {
            String uri;
            if (i == 0 && prefix.length() == 0) {
                uri = this.namespaceMap.get(prefix);
                sb.append("DEFAULT").append(" ").append("'").append(uri).append("'");
            } else {
                if (prefix.equalsIgnoreCase(XSI_NAMESPACE_PREFIX)) continue;
                if (i > 0) {
                    sb.append(",").append(" ");
                }
                uri = this.namespaceMap.get(prefix);
                sb.append("'").append(uri).append("'").append(" ").append("AS").append(" ").append(prefix);
            }
            ++i;
        }
        sb.append(")").append(" ").append(",").append(" ");
        return sb.toString();
    }

    public IStatus parseXmlFile() {
        XmlParser xmlParser = new XmlParser();
        XmlFileContentHandler contentHandler = new XmlFileContentHandler();
        contentHandler.setDocumentLocator(new LocatorImpl());
        xmlParser.setContentHandler(contentHandler);
        try {
            xmlParser.doParse(this.getDataFile());
        }
        catch (RuntimeException ex) {
            String message = Util.getString("TeiidXmlFileInfo.parsingError", (Object)ex.getMessage());
            return new Status(4, "org.teiid.designer.transformation.ui", message, (Throwable)ex);
        }
        catch (IOException ex) {
            String message = Util.getString("TeiidXmlFileInfo.parsingError", (Object)ex.getMessage());
            return new Status(4, "org.teiid.designer.transformation.ui", message, (Throwable)ex);
        }
        catch (SAXException ex) {
            String message = Util.getString("TeiidXmlFileInfo.parsingError", (Object)ex.getMessage());
            return new Status(4, "org.teiid.designer.transformation.ui", message, (Throwable)ex);
        }
        this.namespaceMap.clear();
        this.namespaceMap.putAll(contentHandler.getNamespaceMap());
        this.rootNode = contentHandler.getRootElement();
        if (this.rootNode == null) {
            String message = TeiidXmlFileInfo.getString("noRootNodeParsingError");
            return new Status(4, "org.teiid.designer.transformation.ui", message);
        }
        this.determineCommonRootPath();
        this.setRootPath(this.commonRootPath);
        return Status.OK_STATUS;
    }

    private void determineCommonRootPath() {
        StringBuilder commonRoot = new StringBuilder();
        ArrayList<String> segmentList = new ArrayList<String>();
        segmentList.add(this.rootNode.getFullPath());
        Object[] objectArray = this.rootNode.getChildrenDTDElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            this.addChildPaths((XmlElement)node, segmentList);
            ++n2;
        }
        String[][] segments = new String[segmentList.size()][];
        int shortestPathLength = 0;
        int i = 0;
        while (i < segmentList.size()) {
            segments[i] = ((String)segmentList.get(i)).split("/");
            if (i == 0) {
                shortestPathLength = segments[i].length;
            }
            if (shortestPathLength > segments[i].length) {
                shortestPathLength = segments[i].length;
            }
            ++i;
        }
        int j = 0;
        while (j < shortestPathLength) {
            String thisSegment = segments[0][j];
            boolean allMatched = true;
            int i2 = 0;
            while (i2 < segments.length && allMatched) {
                if (segments[i2].length < j) {
                    allMatched = false;
                    break;
                }
                allMatched &= segments[i2][j].equals(thisSegment);
                ++i2;
            }
            if (!allMatched) break;
            commonRoot.append("/").append(thisSegment);
            ++j;
        }
        commonRoot = new StringBuilder(commonRoot.toString().replaceAll("//", "/"));
        this.commonRootPath = commonRoot.toString();
    }

    private void addChildPaths(XmlElement element, List<String> segmentList) {
        segmentList.add(element.getFullPath());
        Object[] objectArray = element.getChildrenDTDElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            this.addChildPaths((XmlElement)node, segmentList);
            ++n2;
        }
    }

    public Map<String, Object> getParameterMap() {
        return this.parameterMap == null ? Collections.EMPTY_MAP : this.parameterMap;
    }

    public void setParameterMap(Map parameterMap) {
        this.parameterMap = parameterMap;
    }
}

