/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.proc.ITeiidXmlColumnInfo;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlAttribute;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlElement;

public class TeiidXmlColumnInfo
implements ITeiidXmlColumnInfo {
    private static final String TEXT_SEGMENT = "text()";
    private static final String AT_SIGN = "@";
    private static final String DOT_DOT = "..";
    private IElementSymbol nameSymbol;
    private String datatype;
    private int width = 10;
    private boolean forOrdinality;
    private String defaultValue = "";
    private String relativePath = "";
    private String rootXmlPath = "";
    private XmlElement xmlElement;
    private XmlAttribute xmlAttribute;
    private IStatus status;
    private boolean pathOverriden = false;
    boolean initializing = false;

    public TeiidXmlColumnInfo(XmlElement element, String rootPath) {
        this(element, rootPath, "string");
    }

    public TeiidXmlColumnInfo(XmlAttribute attribute, String rootPath) {
        this(attribute, rootPath, "string");
    }

    public TeiidXmlColumnInfo(XmlAttribute attribute, String rootPath, String datatype) {
        CoreArgCheck.isNotNull((Object)attribute, (String)"attribute is null");
        CoreArgCheck.isNotEmpty((String)datatype, (String)"datatype is null");
        this.initializing = true;
        this.xmlAttribute = attribute;
        this.xmlElement = attribute.getElement();
        this.setRootPath(rootPath);
        this.initNameSymbol(this.xmlAttribute.getName());
        this.setRelativePathInternal(attribute);
        this.datatype = datatype;
        this.defaultValue = "";
        this.validate();
        this.initializing = false;
    }

    public TeiidXmlColumnInfo(XmlElement element, String rootPath, String datatype) {
        CoreArgCheck.isNotNull((Object)element, (String)"element is null");
        CoreArgCheck.isNotEmpty((String)datatype, (String)"datatype is null");
        this.initializing = true;
        this.xmlElement = element;
        this.setRootPath(rootPath);
        this.setRelativePathInternal(element);
        this.initNameSymbol(element.getName());
        this.datatype = datatype;
        this.defaultValue = "";
        this.validate();
        this.initializing = false;
    }

    public TeiidXmlColumnInfo(XmlElement element, XmlAttribute attribute, String name, boolean ordinality, String datatype, String defaultValue, String rootPath, String fullXmlPath) {
        this.initializing = true;
        this.xmlElement = element;
        this.xmlAttribute = attribute;
        this.setRootPath(rootPath);
        this.setRelativePathInternal(element);
        this.initNameSymbol(name);
        this.datatype = datatype;
        this.forOrdinality = ordinality;
        this.defaultValue = defaultValue == null ? "" : defaultValue;
        this.initializing = false;
    }

    private void initNameSymbol(String name) {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        this.nameSymbol = factory.createElementSymbol(name.replaceAll("\\.", "_"));
    }

    public String getSymbolName() {
        return this.nameSymbol.toString();
    }

    public String getName() {
        String name = this.nameSymbol.toString();
        return name.replaceAll("\"", "");
    }

    public void setName(String name) {
        CoreArgCheck.isNotNull((Object)name, (String)"name is null");
        this.initNameSymbol(name);
        this.validate();
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        CoreArgCheck.isNotNull((Object)datatype, (String)"datatype is null");
        this.datatype = datatype;
        this.validate();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        CoreArgCheck.isPositive((int)width, (String)"width is less than 1");
        this.width = width;
        this.validate();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue == null ? "" : defaultValue;
        this.validate();
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
        this.validate();
    }

    private void setRelativePathInternal(Object obj) {
        String rootPath = this.rootXmlPath;
        if (obj instanceof XmlElement) {
            XmlElement element = (XmlElement)obj;
            String fullPath = element.getFullPath();
            StringBuffer relativePathBuff = new StringBuffer(this.getRelativePath(fullPath, rootPath));
            if (!relativePathBuff.toString().isEmpty() && !relativePathBuff.toString().endsWith("/")) {
                relativePathBuff.append("/");
            }
            relativePathBuff.append(TEXT_SEGMENT);
            this.setRelativePath(relativePathBuff.toString());
            return;
        }
        if (obj instanceof XmlAttribute) {
            XmlAttribute attr = (XmlAttribute)obj;
            XmlElement element = attr.getElement();
            String fullPath = element.getFullPath();
            StringBuffer relativePathBuff = new StringBuffer(this.getRelativePath(fullPath, rootPath));
            if (!relativePathBuff.toString().isEmpty() && !relativePathBuff.toString().endsWith("/")) {
                relativePathBuff.append("/");
            }
            relativePathBuff.append(AT_SIGN + attr.getName());
            this.setRelativePath(relativePathBuff.toString());
            return;
        }
    }

    public String getRelativePath() {
        return this.relativePath.toString();
    }

    public void setXmlElement(XmlElement element) {
        this.xmlElement = element;
    }

    public void setXmlAttribute(XmlAttribute attribute) {
        this.xmlAttribute = attribute;
        this.xmlElement = attribute.getElement();
    }

    public String getFullXmlPath() {
        return String.valueOf(this.rootXmlPath) + "/" + this.relativePath;
    }

    public void setRootPath(String thePath) {
        boolean rootPathChanged = false;
        String newRootPath = null;
        newRootPath = thePath != null && thePath.length() > 0 ? thePath : "";
        if (!this.rootXmlPath.equalsIgnoreCase(newRootPath)) {
            rootPathChanged = true;
        }
        if (rootPathChanged) {
            if (!this.initializing && this.fullPathExists()) {
                if (this.isXmlAttribute()) {
                    String fullPath = String.valueOf(this.xmlElement.getFullPath()) + "/" + AT_SIGN + this.getXmlAttribute().getName();
                    String relativePath = this.getRelativePath(fullPath, newRootPath);
                    this.setRelativePath(relativePath);
                } else {
                    String fullPath = this.xmlElement.getFullPath();
                    if (this.relativePath != null && !this.relativePath.isEmpty() && TEXT_SEGMENT.equalsIgnoreCase(this.getLastSegment(this.relativePath))) {
                        String shortPath = fullPath;
                        String newFullPath = String.valueOf(shortPath) + "/" + TEXT_SEGMENT;
                        String relativePath = this.getRelativePath(newFullPath, newRootPath);
                        this.setRelativePath(relativePath);
                    } else {
                        String theFullPath = this.xmlElement.getFullPath();
                        String relativePath = this.getRelativePath(theFullPath, newRootPath);
                        this.setRelativePath(relativePath);
                    }
                }
            }
            this.rootXmlPath = newRootPath;
        }
        if (!this.initializing) {
            this.validate();
        }
    }

    public XmlElement getXmlElement() {
        return this.xmlElement;
    }

    public XmlAttribute getXmlAttribute() {
        return this.xmlAttribute;
    }

    public boolean isXmlAttribute() {
        return this.xmlAttribute != null;
    }

    public boolean getOrdinality() {
        return this.forOrdinality;
    }

    public void setOrdinality(boolean value) {
        this.forOrdinality = value;
        this.validate();
    }

    public boolean isPathOverridden() {
        return this.pathOverriden;
    }

    public void setPathOverridden(boolean value) {
        this.pathOverriden = value;
        this.validate();
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    private void validate() {
        boolean pathOK = this.fullPathExists();
        if (!pathOK) {
            this.setStatus((IStatus)new Status(2, "org.teiid.designer.transformation.ui", NLS.bind((String)Messages.InvalidPathWarning, (Object)this.getRelativePath(), (Object)this.getName())));
            return;
        }
        this.setStatus(Status.OK_STATUS);
    }

    private boolean fullPathExists() {
        String fullXmlElementPath = this.xmlElement.getFullPath();
        boolean pathOK = true;
        if (this.isXmlAttribute()) {
            String thisFullPath = this.getFullXmlPath();
            thisFullPath = this.collapseDotDots(thisFullPath);
            String shortPath = this.removeLastSegment(thisFullPath);
            int nSegs = this.getPathSegments(shortPath).size();
            if (this.getMatchingSegmentCount(fullXmlElementPath, shortPath) != nSegs) {
                pathOK = false;
            }
        } else {
            String thisFullPath = this.getFullXmlPath();
            if (TEXT_SEGMENT.equalsIgnoreCase(this.getLastSegment(thisFullPath))) {
                thisFullPath = this.collapseDotDots(thisFullPath);
                String shortPath = this.removeLastSegment(thisFullPath);
                int nSegs = this.getPathSegments(shortPath).size();
                if (this.getMatchingSegmentCount(fullXmlElementPath, shortPath) != nSegs) {
                    pathOK = false;
                }
            } else {
                pathOK = thisFullPath.equals(fullXmlElementPath);
            }
        }
        return pathOK;
    }

    private String getRelativePath(String fullPath, String rootPath) {
        StringBuffer resultBuff = new StringBuffer();
        int nMatch = this.getMatchingSegmentCount(fullPath, rootPath);
        int extraSegs = this.getPathSegments(rootPath).size() - nMatch;
        List<String> segments = this.getPathSegments(fullPath);
        int i = 0;
        while (i < segments.size()) {
            if (i >= nMatch) {
                if (i != nMatch) {
                    resultBuff.append("/");
                }
                resultBuff.append(segments.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < extraSegs) {
            resultBuff.insert(0, "../");
            ++i;
        }
        return resultBuff.toString();
    }

    private String removeLastSegment(String path) {
        StringBuffer resultBuff = new StringBuffer();
        List<String> segments = this.getPathSegments(path);
        int i = 0;
        while (i < segments.size() - 1) {
            resultBuff.append("/" + segments.get(i));
            ++i;
        }
        return resultBuff.toString();
    }

    private String getLastSegment(String path) {
        String lastSegment = "";
        List<String> segments = this.getPathSegments(path);
        if (segments.size() > 0) {
            lastSegment = segments.get(segments.size() - 1);
        }
        return lastSegment;
    }

    private List<String> getPathSegments(String path) {
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            segments.add(st.nextToken());
        }
        return segments;
    }

    private int getMatchingSegmentCount(String path1, String path2) {
        int path2Size;
        int matchingSegs = 0;
        List<String> path1Segs = this.getPathSegments(path1);
        List<String> path2Segs = this.getPathSegments(path2);
        int path1Size = path1Segs.size();
        if (path1Size <= (path2Size = path2Segs.size())) {
            int i = 0;
            while (i < path1Segs.size()) {
                String path1Seg = path1Segs.get(i);
                String path2Seg = path2Segs.get(i);
                if (path1Seg != null && path1Seg.equalsIgnoreCase(path2Seg)) {
                    ++matchingSegs;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < path2Segs.size()) {
                String path1Seg = path1Segs.get(i);
                String path2Seg = path2Segs.get(i);
                if (path2Seg != null && path2Seg.equalsIgnoreCase(path1Seg)) {
                    ++matchingSegs;
                }
                ++i;
            }
        }
        return matchingSegs;
    }

    private String collapseDotDots(String originalStr) {
        String theString = originalStr;
        while (theString.indexOf("/..") != -1) {
            int dotdotIndex = theString.indexOf("/..");
            String leadingStr = theString.substring(0, dotdotIndex);
            String trailingStr = theString.substring(dotdotIndex + 3);
            int lastDelim = leadingStr.lastIndexOf("/");
            if (lastDelim != -1) {
                String newLeading = leadingStr.substring(0, lastDelim);
                theString = String.valueOf(newLeading) + trailingStr;
                continue;
            }
            theString = String.valueOf(leadingStr) + trailingStr;
        }
        return theString;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("Teiid XML Metadata Column Info: ");
        text.append("\tname =").append(this.getName());
        text.append("\n\tsymbol name = ").append(this.getSymbolName());
        text.append("\n\tdatatype =").append(this.getDatatype());
        text.append("\n\tfullPath =").append(this.getFullXmlPath());
        return text.toString();
    }
}

