/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.rest;

import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportWizard;
import org.teiid.designer.transformation.ui.wizards.rest.TeiidRestImportProcessor;
import org.teiid.designer.transformation.ui.wizards.rest.TeiidRestImportSourcePage;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlImportOptionsPage;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlImportXmlConfigurationPage;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;

public class TeiidRestImportWizard
extends TeiidMetadataImportWizard {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidRestImportWizard.class);
    private static final String TITLE = TeiidRestImportWizard.getString("title");
    private static final ImageDescriptor IMAGE = UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importTeiidMetadataWiz.gif");
    TeiidXmlImportOptionsPage optionsPage;
    TeiidRestImportSourcePage sourcePage;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public TeiidRestImportWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), TITLE, IMAGE);
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection inputSelection) {
        super.init(workbench, inputSelection);
        this.getFileInfo().setFileMode(4);
    }

    @Override
    public void addPages() {
        this.sourcePage = new TeiidRestImportSourcePage(this.getFileInfo());
        this.addPage((IWizardPage)this.sourcePage);
        TeiidXmlImportXmlConfigurationPage sqlPage = new TeiidXmlImportXmlConfigurationPage(this.getFileInfo());
        this.addPage((IWizardPage)sqlPage);
    }

    @Override
    public boolean finish() {
        final TeiidRestImportProcessor processor = new TeiidRestImportProcessor(this.getFileInfo(), this.getShell());
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                processor.execute();
            }
        }, (boolean)false);
        if (this.getDesignerProperties() != null) {
            DesignerPropertiesUtil.setSourceModelName((Properties)this.getDesignerProperties(), (String)this.getFileInfo().getSourceModelName());
            DesignerPropertiesUtil.setViewModelName((Properties)this.getDesignerProperties(), (String)this.getFileInfo().getViewModelName());
            if (!this.getFileInfo().getXmlFileInfos().isEmpty() && this.getFileInfo().getXmlFileInfos().size() == 1) {
                TeiidXmlFileInfo info = this.getFileInfo().getXmlFileInfos().iterator().next();
                DesignerPropertiesUtil.setPreviewTargetModelName((Properties)this.getDesignerProperties(), (String)this.getFileInfo().getViewModelName());
                DesignerPropertiesUtil.setPreviewTargetObjectName((Properties)this.getDesignerProperties(), (String)info.getViewProcedureName());
            }
        }
        return true;
    }

    public void setFileOption(int option) {
        this.getFileInfo().setFileMode(option);
    }

    @Override
    protected void updateForProperties() {
        Properties desProps = this.getDesignerProperties();
        if (desProps == null || desProps.isEmpty()) {
            return;
        }
        IProject project = DesignerPropertiesUtil.getProject((Properties)this.getDesignerProperties());
        IContainer srcFolderResrc = DesignerPropertiesUtil.getSourcesFolder((Properties)desProps);
        IContainer viewFolderResrc = DesignerPropertiesUtil.getViewsFolder((Properties)desProps);
        if (srcFolderResrc != null) {
            this.getFileInfo().setSourceModelLocation(srcFolderResrc.getFullPath());
        } else if (project != null) {
            this.getFileInfo().setSourceModelLocation(project.getFullPath());
        }
        if (viewFolderResrc != null) {
            this.getFileInfo().setViewModelLocation(viewFolderResrc.getFullPath());
        } else if (project != null) {
            this.getFileInfo().setViewModelLocation(project.getFullPath());
        }
        String profileName = DesignerPropertiesUtil.getConnectionProfileName((Properties)desProps);
        if (profileName != null && !profileName.isEmpty()) {
            this.sourcePage.setDesignerProperties(desProps);
        }
        this.optionsPage.setDesignerProperties(desProps);
        if (!this.openProjectExists()) {
            DesignerPropertiesUtil.setProjectStatus((Properties)desProps, (String)"noOpenProject");
        }
    }
}

