/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.URLHelper;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoHelper;
import org.teiid.designer.datatools.ui.actions.EditConnectionProfileAction;
import org.teiid.designer.datatools.ui.dialogs.NewTeiidFilteredCPWizard;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataFileInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.viewsupport.FileSystemLabelProvider;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public class TeiidMetadataImportSourcePage
extends AbstractWizardPage
implements UiConstants,
InternalUiConstants.Widgets,
CoreStringUtil.Constants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidMetadataImportSourcePage.class);
    private static final String TITLE = TeiidMetadataImportSourcePage.getString("title");
    private static final String INITIAL_MESSAGE = TeiidMetadataImportSourcePage.getString("initialMessage");
    private static final String FLAT_FILE_SOURCE_LABEL = TeiidMetadataImportSourcePage.getString("sourceLabel");
    private static final String NEW_BUTTON = "New...";
    private static final String EDIT_BUTTON = "Edit...";
    private static final String INVALID_PAGE_MESSAGE = TeiidMetadataImportSourcePage.getString("invalidPageMessage");
    private static final String HOME = "HOME";
    private static final String URI = "URI";
    private static final String INCLTYPELINE = "INCLTYPELINE";
    private static final String INCLCOLUMNNAME = "INCLCOLUMNNAME";
    private static final String VALUE_YES = "YES";
    private static final String VALUE_COMMA = "COMMA";
    private static final String CHARSET = "CHARSET";
    private static final String EMPTY_STRING = "";
    private static final String DOT_XML = ".XML";
    private static final String FILTER_INIT = "*.*";
    private static final String DOT_TXT_LOWER = ".txt";
    private static final String GET_TEXT_FILES = "getTextFiles";
    private static final String ODA_FLAT_FILE_ID = "org.eclipse.datatools.connectivity.oda.flatfile";
    private static final String FLAT_FILE_URL_ID = "org.teiid.designer.datatools.profiles.flatfile.fileurl";
    private static final String FILE_LIST_PROPERTY_KEY = "FILELIST";
    private static final String UNKNOWN_FOLDER = TeiidMetadataImportSourcePage.getString("unknownFolderText");
    private ILabelProvider srcLabelProvider;
    private Combo srcCombo;
    private Text dataFileFolderText;
    private Text fileFilterText;
    private Button editCPButton;
    private TableViewerBuilder fileViewer;
    private DataFolderContentProvider fileContentProvider;
    private TableViewerColumn fileNameColumn;
    private Text sourceModelContainerText;
    private Text sourceModelFileText;
    private Text sourceHelpText;
    private IPath sourceModelFilePath;
    private Text selectedFileText;
    private ProfileManager profileManager = ProfileManager.getInstance();
    private Collection<IConnectionProfile> connectionProfiles;
    private TeiidMetadataImportInfo info;
    private final ConnectionProfileInfo profileInfo = new ConnectionProfileInfo();
    boolean creatingControl = false;
    boolean synchronizing = false;
    boolean processingChecks = false;
    IStatus fileParsingStatus;
    IConnectionInfoHelper connectionInfoHelper;
    static String[] TEXT_FILE_EXTENSIONS = new String[]{"TXT", "CSV", "TSV"};
    final ViewerFilter sourceModelFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean doSelect = false;
            if (element instanceof IResource) {
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        try {
                            doSelect = ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                        }
                        catch (CoreException e) {
                            ModelerCore.Util.log((Throwable)e);
                        }
                    } else if (element instanceof IContainer) {
                        doSelect = true;
                    } else if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                        ModelResource theModel = null;
                        try {
                            theModel = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)true);
                        }
                        catch (Exception ex) {
                            ModelerCore.Util.log((Throwable)ex);
                        }
                        if (theModel != null && ModelIdentifier.isRelationalSourceModel((ModelResource)theModel)) {
                            doSelect = true;
                        }
                    }
                }
            } else if (element instanceof IContainer) {
                doSelect = true;
            }
            return doSelect;
        }
    };

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public TeiidMetadataImportSourcePage(TeiidMetadataImportInfo info) {
        this(null, info);
    }

    public TeiidMetadataImportSourcePage(Object selection, TeiidMetadataImportInfo info) {
        super(TeiidMetadataImportSourcePage.class.getSimpleName(), TITLE);
        this.info = info;
        this.setPageComplete(false);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importTeiidMetadataWiz.gif"));
        this.connectionInfoHelper = new ConnectionInfoHelper();
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout());
        mainPanel.setLayoutData((Object)new GridData(272));
        mainPanel.setSize(mainPanel.computeSize(-1, -1));
        this.setControl((Control)mainPanel);
        this.createProfileGroup(mainPanel);
        this.createFolderContentsListGroup(mainPanel);
        this.createSourceModelGroup(mainPanel);
        this.setMessage(INITIAL_MESSAGE);
    }

    private void createProfileGroup(Composite parent) {
        Group profileGroup = WidgetFactory.createGroup((Composite)parent, (String)FLAT_FILE_SOURCE_LABEL, (int)0, (int)2, (int)3);
        profileGroup.setLayoutData((Object)new GridData(768));
        this.refreshConnectionProfiles();
        this.srcLabelProvider = new LabelProvider(){

            public String getText(Object source) {
                return ((IConnectionProfile)source).getName();
            }
        };
        this.srcCombo = WidgetFactory.createCombo((Composite)profileGroup, (int)8, (int)768, (List)((ArrayList)this.connectionProfiles), null, (ILabelProvider)this.srcLabelProvider, (boolean)true);
        this.srcCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TeiidMetadataImportSourcePage.this.profileSelectionChanged();
                TeiidMetadataImportSourcePage.this.fileViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.srcCombo.setVisibleItemCount(10);
        WidgetFactory.createButton((Composite)profileGroup, (String)NEW_BUTTON).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TeiidMetadataImportSourcePage.this.createNewConnectionProfile();
            }
        });
        this.editCPButton = WidgetFactory.createButton((Composite)profileGroup, (String)EDIT_BUTTON);
        this.editCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TeiidMetadataImportSourcePage.this.editConnectionProfile();
            }
        });
        this.editCPButton.setEnabled(false);
    }

    private void createFolderContentsListGroup(Composite parent) {
        String groupLabel = TeiidMetadataImportSourcePage.getString("folderContentsGroup");
        if (!this.info.isFlatFileLocalMode()) {
            groupLabel = TeiidMetadataImportSourcePage.getString("folderXmlContentsGroup");
        }
        Group folderContentsGroup = WidgetFactory.createGroup((Composite)parent, (String)groupLabel, (int)4, (int)3, (int)2);
        GridData gd_1 = new GridData(1808);
        gd_1.heightHint = 180;
        folderContentsGroup.setLayoutData((Object)gd_1);
        Label locationLabel = new Label((Composite)folderContentsGroup, 0);
        locationLabel.setText(TeiidMetadataImportSourcePage.getString("folderLocation"));
        this.dataFileFolderText = new Text((Composite)folderContentsGroup, 2052);
        this.dataFileFolderText.setBackground(Display.getCurrent().getSystemColor(19));
        this.dataFileFolderText.setForeground(Display.getCurrent().getSystemColor(10));
        this.dataFileFolderText.setLayoutData((Object)new GridData(768));
        this.dataFileFolderText.setEditable(false);
        Label fileFilterLabel = new Label((Composite)folderContentsGroup, 0);
        fileFilterLabel.setText(TeiidMetadataImportSourcePage.getString("fileFilterLabel"));
        this.createFilterTextBox((Composite)folderContentsGroup);
        this.createFileTableViewer((Composite)folderContentsGroup);
        Label selectedFileLabel = new Label((Composite)folderContentsGroup, 0);
        selectedFileLabel.setText(TeiidMetadataImportSourcePage.getString("selectedXmlFile"));
        this.selectedFileText = new Text((Composite)folderContentsGroup, 2052);
        this.selectedFileText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedFileText.setForeground(Display.getCurrent().getSystemColor(10));
        this.selectedFileText.setLayoutData((Object)new GridData(768));
        this.selectedFileText.setEditable(false);
    }

    protected void createFilterTextBox(Composite parent) {
        this.fileFilterText = new Text(parent, 2048);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.fileFilterText.setLayoutData((Object)data);
        this.fileFilterText.setFont(parent.getFont());
        this.fileFilterText.setText(FILTER_INIT);
        this.setImportInfoFileFilter(FILTER_INIT);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                for (TeiidMetadataFileInfo fileInfo : TeiidMetadataImportSourcePage.this.info.getFileInfos()) {
                    fileInfo.setDoProcess(false);
                }
                TableItem[] tableItemArray = TeiidMetadataImportSourcePage.this.fileViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(false);
                    ++n2;
                }
                String filterText = TeiidMetadataImportSourcePage.this.fileFilterText.getText();
                TeiidMetadataImportSourcePage.this.setImportInfoFileFilter(filterText);
                TeiidMetadataImportSourcePage.this.fileContentProvider.setFilterString(filterText);
                TeiidMetadataImportSourcePage.this.fileViewer.refresh();
                TeiidMetadataImportSourcePage.this.synchronizeUI();
                TeiidMetadataImportSourcePage.this.validatePage();
            }
        };
        this.fileFilterText.addListener(24, listener);
    }

    private void setImportInfoFileFilter(String filterText) {
        this.info.setFileFilterText(filterText);
    }

    private void createFileTableViewer(Composite parent) {
        this.fileViewer = new TableViewerBuilder(parent, 2852);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 160).span(2, -1).applyTo((Control)this.fileViewer.getTableComposite());
        this.fileContentProvider = new DataFolderContentProvider();
        this.fileContentProvider.setFilterString(FILTER_INIT);
        this.fileViewer.getTableViewer().setSorter(new ViewerSorter());
        this.fileViewer.setContentProvider((IContentProvider)this.fileContentProvider);
        this.fileViewer.setLabelProvider((IBaseLabelProvider)new FileSystemLabelProvider());
        this.fileViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (TeiidMetadataImportSourcePage.this.processingChecks) {
                    return;
                }
                TeiidMetadataImportSourcePage.this.processingChecks = true;
                if (e.detail == 32) {
                    TeiidMetadataFileInfo fileInfo;
                    TableItem tableItem = (TableItem)e.item;
                    boolean wasChecked = tableItem.getChecked();
                    if (tableItem.getData() instanceof File) {
                        TableItem item;
                        TeiidMetadataImportSourcePage.this.fileViewer.getTable().setSelection(new TableItem[]{tableItem});
                        if (TeiidMetadataImportSourcePage.this.info.isFlatFileLocalMode()) {
                            if (wasChecked) {
                                TableItem[] tableItemArray = TeiidMetadataImportSourcePage.this.fileViewer.getTable().getItems();
                                int n = tableItemArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    item = tableItemArray[n2];
                                    if (item != tableItem) {
                                        item.setChecked(false);
                                    }
                                    ++n2;
                                }
                            }
                            TeiidMetadataImportSourcePage.this.info.setDoProcess((File)tableItem.getData(), wasChecked);
                        } else {
                            if (wasChecked) {
                                TableItem[] tableItemArray = TeiidMetadataImportSourcePage.this.fileViewer.getTable().getItems();
                                int n = tableItemArray.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    item = tableItemArray[n3];
                                    if (item != tableItem) {
                                        item.setChecked(false);
                                    }
                                    ++n3;
                                }
                            }
                            TeiidMetadataImportSourcePage.this.info.setDoProcessXml((File)tableItem.getData(), wasChecked);
                        }
                    }
                    if (wasChecked && (fileInfo = TeiidMetadataImportSourcePage.this.info.getCheckedFileInfo()) != null && ((TeiidMetadataImportSourcePage)TeiidMetadataImportSourcePage.this).profileInfo.columnsInFirstLine) {
                        fileInfo.setFirstDataRow(1);
                    }
                }
                TeiidMetadataImportSourcePage.this.processingChecks = false;
                TeiidMetadataImportSourcePage.this.synchronizeUI();
                TeiidMetadataImportSourcePage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fileNameColumn = this.fileViewer.createColumn(16384, 100, 40, false);
        this.fileNameColumn.getColumn().setText(TeiidMetadataImportSourcePage.getString("dataFileNameColumn"));
        this.fileNameColumn.setLabelProvider((CellLabelProvider)new DataFileContentColumnLabelProvider());
    }

    private void createSourceModelGroup(Composite parent) {
        Group sourceGroup = WidgetFactory.createGroup((Composite)parent, (String)TeiidMetadataImportSourcePage.getString("sourceModelDefinitionGroup"), (int)0, (int)1, (int)3);
        sourceGroup.setLayoutData((Object)new GridData(768));
        Label locationLabel = new Label((Composite)sourceGroup, 0);
        locationLabel.setText(TeiidMetadataImportSourcePage.getString("location"));
        this.sourceModelContainerText = new Text((Composite)sourceGroup, 2052);
        GridData gridData = new GridData(768);
        this.sourceModelContainerText.setLayoutData((Object)gridData);
        this.sourceModelContainerText.setBackground(Display.getCurrent().getSystemColor(19));
        this.sourceModelContainerText.setEditable(false);
        Button browseButton = new Button((Composite)sourceGroup, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(TeiidMetadataImportSourcePage.getString("browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidMetadataImportSourcePage.this.handleSourceModelLocationBrowse();
            }
        });
        Label fileLabel = new Label((Composite)sourceGroup, 0);
        fileLabel.setText(TeiidMetadataImportSourcePage.getString("name"));
        this.sourceModelFileText = new Text((Composite)sourceGroup, 2052);
        gridData = new GridData(768);
        this.sourceModelFileText.setLayoutData((Object)gridData);
        this.sourceModelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TeiidMetadataImportSourcePage.this.handleSourceModelTextChanged();
            }
        });
        browseButton = new Button((Composite)sourceGroup, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(TeiidMetadataImportSourcePage.getString("browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidMetadataImportSourcePage.this.handleSourceModelBrowse();
            }
        });
        new Label((Composite)sourceGroup, 0);
        Group helpGroup = WidgetFactory.createGroup((Composite)sourceGroup, (String)TeiidMetadataImportSourcePage.getString("modelStatus"), (int)2, (int)2);
        helpGroup.setLayoutData((Object)new GridData(768));
        this.sourceHelpText = new Text((Composite)helpGroup, 72);
        this.sourceHelpText.setBackground(Display.getCurrent().getSystemColor(19));
        this.sourceHelpText.setForeground(Display.getCurrent().getSystemColor(10));
        GridData gd = new GridData(768);
        gd.heightHint = 35;
        gd.horizontalSpan = 3;
        this.sourceHelpText.setLayoutData((Object)gd);
    }

    void profileSelectionChanged() {
        if (this.srcCombo.getSelectionIndex() > -1) {
            String cpName = this.srcCombo.getItem(this.srcCombo.getSelectionIndex());
            for (IConnectionProfile profile : this.connectionProfiles) {
                String delimiterType;
                String secondLineDatatypes;
                if (!profile.getName().equalsIgnoreCase(cpName)) continue;
                this.setConnectionProfile(profile);
                Properties props = profile.getBaseProperties();
                this.setDataFolderLocation(props);
                String charset = (String)props.get(CHARSET);
                if (charset != null) {
                    this.profileInfo.charset = charset;
                }
                this.clearFileListViewer();
                this.loadFileListViewer();
                if (!this.info.getFileInfos().isEmpty()) break;
                String firstLineHasColumns = (String)props.get(INCLCOLUMNNAME);
                if (firstLineHasColumns != null) {
                    this.profileInfo.columnsInFirstLine = firstLineHasColumns.equalsIgnoreCase(VALUE_YES);
                }
                if ((secondLineDatatypes = (String)props.get(INCLTYPELINE)) != null) {
                    this.profileInfo.includeTypeLine = secondLineDatatypes.equalsIgnoreCase(VALUE_YES);
                }
                if ((delimiterType = (String)props.get(INCLTYPELINE)) != null) {
                    this.profileInfo.delimiterType = delimiterType;
                }
                break;
            }
        } else {
            this.setConnectionProfile(null);
        }
        this.synchronizeUI();
        this.validatePage();
        this.editCPButton.setEnabled(this.getConnectionProfile() != null);
    }

    private void setDataFolderLocation(Properties profileBaseProps) {
        if (profileBaseProps != null) {
            String home = (String)profileBaseProps.get(HOME);
            if (home != null) {
                this.profileInfo.home = home;
                String location = home;
                if (location.length() > 60) {
                    int len = location.length();
                    location = "..." + location.substring(len - 60, len);
                }
                this.dataFileFolderText.setText(location);
                this.dataFileFolderText.setToolTipText(home);
            } else {
                String uri = (String)profileBaseProps.get(URI);
                if (uri != null) {
                    File parentDir;
                    String location = null;
                    File aFile = new File(uri);
                    if (aFile.exists() && aFile.isFile() && (parentDir = aFile.getParentFile()) != null && parentDir.exists() && parentDir.isDirectory()) {
                        this.profileInfo.home = location = parentDir.getAbsolutePath();
                    }
                    if (location == null) {
                        this.dataFileFolderText.setText(UNKNOWN_FOLDER);
                        this.dataFileFolderText.setToolTipText(TeiidMetadataImportSourcePage.getString("unknownFolderTooltip"));
                    } else {
                        this.dataFileFolderText.setText(location);
                        this.dataFileFolderText.setToolTipText(location);
                    }
                } else {
                    String url = (String)profileBaseProps.get("URL");
                    if (url != null) {
                        String location = url;
                        if (location.length() > 60) {
                            int len = location.length();
                            location = "..." + location.substring(len - 60, len);
                        }
                        this.dataFileFolderText.setText(location);
                        this.dataFileFolderText.setToolTipText(url);
                    } else {
                        this.dataFileFolderText.setText(EMPTY_STRING);
                        this.dataFileFolderText.setToolTipText(EMPTY_STRING);
                    }
                }
            }
        } else {
            this.dataFileFolderText.setText(EMPTY_STRING);
            this.dataFileFolderText.setToolTipText(EMPTY_STRING);
        }
    }

    private void setConnectionProfile(IConnectionProfile profile) {
        if (profile == null) {
            this.fileViewer.setInput(null);
            this.clearFileListViewer();
        }
        this.info.setConnectionProfile(profile);
    }

    private IConnectionProfile getConnectionProfile() {
        return this.info.getConnectionProfile();
    }

    private void clearFileListViewer() {
        this.info.clearXmlFileInfos();
        this.info.clearFileInfos();
        this.fileViewer.getTableViewer().remove((Object[])this.fileViewer.getTable().getItems());
    }

    private void loadFileListViewer() {
        if (this.getConnectionProfile() != null) {
            if (this.info.isFlatFileLocalMode()) {
                File folder = this.getFolderForConnectionProfile();
                File file = this.getFileForConnectionProfile();
                if (this.hasExistingFileOrFolder(file, folder)) {
                    TableItem[] items;
                    this.fileParsingStatus = Status.OK_STATUS;
                    if (file != null && file.exists() && file.isFile()) {
                        TeiidMetadataFileInfo fileInfo = this.info.getFileInfo(file);
                        if (fileInfo == null) {
                            fileInfo = new TeiidMetadataFileInfo(file);
                            this.info.addFileInfo(fileInfo);
                        }
                        fileInfo.setIsUrl(false);
                        this.fileViewer.setInput((Object)file);
                        this.fileViewer.getTable().select(0);
                        this.fileViewer.getTable().getItem(0).setChecked(true);
                        this.info.setDoProcess(fileInfo.getDataFile(), true);
                    } else {
                        this.fileViewer.setInput((Object)folder);
                    }
                    TableItem[] tableItemArray = items = this.fileViewer.getTable().getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TeiidMetadataFileInfo fileInfo;
                        File theFile;
                        TableItem item = tableItemArray[n2];
                        Object data = item.getData();
                        if (!(data == null || !(data instanceof File) || (theFile = (File)data).isDirectory() || (fileInfo = this.info.getFileInfo(theFile)) != null && fileInfo.getCharset().equals(this.profileInfo.charset))) {
                            this.info.addFileInfo(new TeiidMetadataFileInfo(theFile, this.profileInfo.charset));
                        }
                        ++n2;
                    }
                    tableItemArray = this.fileViewer.getTable().getColumns();
                    n = tableItemArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        TableItem column = tableItemArray[n2];
                        column.setWidth(column.getWidth() + 4);
                        ++n2;
                    }
                } else {
                    this.fileViewer.setInput(null);
                    this.dataFileFolderText.setText(UNKNOWN_FOLDER);
                    this.dataFileFolderText.setToolTipText(TeiidMetadataImportSourcePage.getString("unknownFolderTooltip"));
                }
            } else {
                String urlString = this.getUrlStringForConnectionProfile();
                if (urlString != null && urlString.trim().length() > 0) {
                    File theFile = null;
                    this.fileViewer.setInput((Object)"no input");
                    URL newUrl = null;
                    try {
                        newUrl = URLHelper.buildURL((String)urlString);
                    }
                    catch (MalformedURLException e) {
                        Util.log((Throwable)e);
                        MessageDialog.openError((Shell)this.getShell(), (String)TeiidMetadataImportSourcePage.getString("malformedUrlErrorTitle"), (String)UiConstants.Util.getString("malformedUrlErrorMessage", new Object[]{urlString, e.getMessage()}));
                    }
                    if (newUrl != null) {
                        boolean resolved = true;
                        try {
                            resolved = URLHelper.resolveUrl((URL)newUrl);
                        }
                        catch (Exception exception) {
                            resolved = false;
                        }
                        if (resolved) {
                            try {
                                String filePath = TeiidMetadataImportSourcePage.formatPath(newUrl);
                                theFile = URLHelper.createFileFromUrl((URL)newUrl, (String)CoreStringUtil.createFileName((String)filePath), (String)DOT_TXT_LOWER);
                            }
                            catch (MalformedURLException theException) {
                                Util.log((Throwable)theException);
                            }
                            catch (IOException theException) {
                                Util.log((Throwable)theException);
                            }
                        }
                    }
                    if (theFile != null && theFile.exists()) {
                        this.fileParsingStatus = Status.OK_STATUS;
                        TeiidMetadataFileInfo fileInfo = this.info.getFileInfo(theFile);
                        if (fileInfo == null) {
                            fileInfo = new TeiidMetadataFileInfo(theFile);
                            this.info.addFileInfo(fileInfo);
                        }
                        fileInfo.setIsUrl(true);
                        fileInfo.setFileUrl(urlString);
                        fileInfo.setCharSet(this.profileInfo.charset);
                        this.fileViewer.setInput((Object)theFile);
                        this.fileViewer.getTable().select(0);
                        this.fileViewer.getTable().getItem(0).setChecked(true);
                        this.info.setDoProcess(fileInfo.getDataFile(), true);
                    }
                } else {
                    this.fileViewer.setInput(null);
                    MessageDialog.openError((Shell)this.getShell(), (String)TeiidMetadataImportSourcePage.getString("invalidXmlConnectionProfileTitle"), (String)TeiidMetadataImportSourcePage.getString("invalidXmlConnectionProfileMessage"));
                }
            }
        }
    }

    private boolean hasExistingFileOrFolder(File theFile, File theFolder) {
        if (theFolder != null && theFolder.exists() && theFolder.isDirectory()) {
            return true;
        }
        return theFile != null && theFile.exists() && theFile.isFile();
    }

    public static String formatPath(URL newUrl) {
        String filePath = newUrl.getPath();
        while (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        int dotLocation = filePath.indexOf(".");
        if (dotLocation > -1) {
            filePath = filePath.substring(0, dotLocation);
        }
        return filePath;
    }

    private File getFolderForConnectionProfile() {
        if (this.getConnectionProfile() != null) {
            File aFile;
            Properties props = this.getConnectionProfile().getBaseProperties();
            String home = (String)props.get(HOME);
            if (home != null) {
                return new File(home);
            }
            String fileURI = (String)props.get(URI);
            if (fileURI != null && (aFile = new File(fileURI)).exists() && aFile.isFile()) {
                return aFile.getParentFile();
            }
        }
        return null;
    }

    private File getFileForConnectionProfile() {
        if (this.getConnectionProfile() != null) {
            File uriFile;
            Properties props = this.getConnectionProfile().getBaseProperties();
            String fileListValue = (String)props.get(FILE_LIST_PROPERTY_KEY);
            if (fileListValue != null) {
                return new File(fileListValue);
            }
            String fileUriValue = (String)props.get(URI);
            if (fileUriValue != null && (uriFile = new File(fileUriValue)).exists() && uriFile.isFile()) {
                return uriFile;
            }
        }
        return null;
    }

    private String getUrlStringForConnectionProfile() {
        if (this.getConnectionProfile() != null) {
            Properties props = this.getConnectionProfile().getBaseProperties();
            String fileListValue = (String)props.get(FILE_LIST_PROPERTY_KEY);
            if (fileListValue != null) {
                return fileListValue;
            }
            String url = (String)props.get("URL");
            if (url != null) {
                return url;
            }
        }
        return null;
    }

    void createNewConnectionProfile() {
        NewTeiidFilteredCPWizard wiz = null;
        wiz = this.info.isFlatFileLocalMode() ? new NewTeiidFilteredCPWizard(ODA_FLAT_FILE_ID) : new NewTeiidFilteredCPWizard(FLAT_FILE_URL_ID);
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
        wizardDialog.setBlockOnOpen(true);
        CPListener listener = new CPListener();
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        if (wizardDialog.open() == 0) {
            this.refreshConnectionProfiles();
            this.resetCPComboItems();
            this.setConnectionProfile(listener.getChangedProfile());
            this.selectProfile(listener.getChangedProfile());
        }
        ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
    }

    void selectProfile(IConnectionProfile profile) {
        int index = 0;
        String[] stringArray = this.srcCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && item.equalsIgnoreCase(profile.getName())) {
                this.srcCombo.select(index);
                this.profileSelectionChanged();
                break;
            }
            ++index;
            ++n2;
        }
    }

    void resetCPComboItems() {
        if (this.srcCombo != null) {
            WidgetUtil.setComboItems((Combo)this.srcCombo, this.connectionProfiles, (ILabelProvider)this.srcLabelProvider, (boolean)true);
        }
    }

    void editConnectionProfile() {
        if (this.getConnectionProfile() != null) {
            IConnectionProfile currentProfile = this.getConnectionProfile();
            EditConnectionProfileAction action = new EditConnectionProfileAction(this.getShell(), currentProfile);
            CPListener listener = new CPListener();
            ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
            action.run();
            if (action.wasFinished()) {
                this.setConnectionProfile(listener.getChangedProfile());
                this.refreshConnectionProfiles();
                WidgetUtil.setComboItems((Combo)this.srcCombo, this.connectionProfiles, (ILabelProvider)this.srcLabelProvider, (boolean)true);
                WidgetUtil.setComboText((Combo)this.srcCombo, (Object)this.getConnectionProfile(), (ILabelProvider)this.srcLabelProvider);
                this.selectConnectionProfile(currentProfile.getName());
                ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
                this.profileSelectionChanged();
            } else {
                ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
            }
        }
    }

    void handleSourceModelLocationBrowse() {
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)ModelerCore.getWorkspace().getRoot(), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.sourceModelContainerText != null) {
            this.info.setSourceModelLocation(folder.getFullPath().makeRelative());
            this.sourceModelFilePath = this.info.getSourceModelLocation();
            this.sourceModelContainerText.setText(this.info.getSourceModelLocation().makeRelative().toString());
        } else {
            this.info.setSourceModelLocation((IPath)new Path(EMPTY_STRING));
            this.sourceModelContainerText.setText(EMPTY_STRING);
        }
        if (this.sourceModelFileText.getText() != null && this.sourceModelFileText.getText().length() > -1) {
            this.info.setSourceModelExists(this.sourceModelExists());
        }
        this.validatePage();
    }

    void handleSourceModelBrowse() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)TeiidMetadataImportSourcePage.getString("selectSourceModelTitle"), (String)TeiidMetadataImportSourcePage.getString("selectSourceModelMessage"), (boolean)false, null, (ViewerFilter)this.sourceModelFilter, (ISelectionStatusValidator)new ModelResourceSelectionValidator(false), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections != null && selections.length == 1 && this.sourceModelFileText != null && selections[0] instanceof IFile) {
            IFile modelFile = (IFile)selections[0];
            IPath folderPath = modelFile.getFullPath().removeLastSegments(1);
            String modelName = modelFile.getFullPath().lastSegment();
            this.info.setSourceModelExists(true);
            this.info.setSourceModelLocation(folderPath);
            this.info.setSourceModelName(modelName);
        }
        if (this.info.getSourceModelName() != null) {
            this.sourceModelFilePath = this.info.getSourceModelLocation();
            this.sourceModelContainerText.setText(this.info.getSourceModelLocation().makeRelative().toString());
            this.sourceModelFileText.setText(this.info.getSourceModelName());
        } else {
            this.sourceModelFileText.setText(EMPTY_STRING);
        }
        this.info.setSourceModelExists(this.sourceModelExists());
        this.validatePage();
    }

    void handleSourceModelTextChanged() {
        if (this.synchronizing) {
            return;
        }
        String newName = EMPTY_STRING;
        if (this.sourceModelFileText.getText() != null && this.sourceModelFileText.getText().length() > -1) {
            newName = this.sourceModelFileText.getText();
            this.info.setSourceModelName(newName);
            this.sourceModelFilePath = this.info.getSourceModelLocation();
            this.info.setSourceModelExists(this.sourceModelExists());
        }
        this.validatePage();
    }

    void synchronizeUI() {
        this.synchronizing = true;
        if (this.info.isFlatFileUrlMode() || this.info.isFlatFileLocalMode()) {
            this.setFlatFileModelNames();
        } else {
            String fileName = EMPTY_STRING;
            for (TeiidXmlFileInfo xmlFileInfo : this.info.getXmlFileInfos()) {
                if (!xmlFileInfo.doProcess()) continue;
                fileName = xmlFileInfo.getDataFile().getName();
                break;
            }
            this.selectedFileText.setText(fileName);
        }
        if (this.info.getSourceModelLocation() != null) {
            this.sourceModelContainerText.setText(this.info.getSourceModelLocation().makeRelative().toString());
        } else {
            this.sourceModelContainerText.setText(EMPTY_STRING);
        }
        if (this.info.getSourceModelName() != null) {
            this.sourceModelFilePath = this.info.getSourceModelLocation();
            this.sourceModelFileText.setText(this.info.getSourceModelName());
        } else {
            this.sourceModelFileText.setText(EMPTY_STRING);
        }
        this.synchronizing = false;
    }

    private void setFlatFileModelNames() {
        String initialName;
        String fileName = EMPTY_STRING;
        String fileName_wo_extension = null;
        for (TeiidMetadataFileInfo tmFileInfo : this.info.getFileInfos()) {
            if (!tmFileInfo.doProcess()) continue;
            fileName = tmFileInfo.getDataFile().getName();
            Path path = new Path(fileName);
            fileName_wo_extension = path.removeFileExtension().toString();
            break;
        }
        this.selectedFileText.setText(fileName);
        if (fileName_wo_extension != null && (this.info.getSourceModelName() == null || this.info.getSourceModelName().length() == 0)) {
            initialName = "SourceModel";
            if (this.info.getSourceModelLocation() != null) {
                initialName = ModelNameUtil.getNewUniqueModelName((String)initialName, (IContainer)this.info.getTargetProject());
            }
            this.info.setSourceModelName(initialName);
        }
        if (fileName_wo_extension != null && (this.info.getViewModelName() == null || this.info.getViewModelName().length() == 0)) {
            initialName = "ViewModel";
            if (this.info.getViewModelLocation() != null) {
                initialName = ModelNameUtil.getNewUniqueModelName((String)initialName, (IContainer)this.info.getTargetProject());
            }
            this.info.setViewModelName(initialName);
        }
    }

    private boolean sourceModelExists() {
        ModelWorkspaceItem item;
        if (this.sourceModelFilePath == null) {
            return false;
        }
        IPath modelPath = new Path(this.sourceModelFilePath.toOSString()).append(this.sourceModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        return (item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1)) != null;
    }

    public void selectConnectionProfile(String name) {
        if (name == null) {
            return;
        }
        int cpIndex = -1;
        int i = 0;
        String[] stringArray = this.srcCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && item.length() > 0 && item.toUpperCase().equalsIgnoreCase(name.toUpperCase())) {
                cpIndex = i;
                break;
            }
            ++i;
            ++n2;
        }
        if (cpIndex > -1) {
            this.srcCombo.select(cpIndex);
            this.profileSelectionChanged();
        }
    }

    private void refreshConnectionProfiles() {
        block4: {
            IConnectionProfile[] tempProfiles;
            block3: {
                IConnectionProfile[] tempProfiles2;
                this.connectionProfiles = new ArrayList<IConnectionProfile>();
                if (!this.info.isFlatFileLocalMode()) break block3;
                IConnectionProfile[] iConnectionProfileArray = tempProfiles2 = this.profileManager.getProfilesByCategory(ODA_FLAT_FILE_ID);
                int n = tempProfiles2.length;
                int n2 = 0;
                while (n2 < n) {
                    IConnectionProfile profile = iConnectionProfileArray[n2];
                    this.connectionProfiles.add(profile);
                    ++n2;
                }
                break block4;
            }
            if (!this.info.isFlatFileUrlMode()) break block4;
            IConnectionProfile[] iConnectionProfileArray = tempProfiles = this.profileManager.getProfilesByCategory("org.teiid.designer.import.category");
            int n = tempProfiles.length;
            int n3 = 0;
            while (n3 < n) {
                IConnectionProfile profile = iConnectionProfileArray[n3];
                if (profile.getProviderId().equalsIgnoreCase(FLAT_FILE_URL_ID)) {
                    this.connectionProfiles.add(profile);
                }
                ++n3;
            }
        }
    }

    private boolean validatePage() {
        this.setSourceHelpMessage();
        String folderText = this.dataFileFolderText.getText();
        if (folderText != null && folderText.equals(UNKNOWN_FOLDER)) {
            this.setThisPageComplete(TeiidMetadataImportSourcePage.getString("unknownFolderErrorMsg"), 3);
            return false;
        }
        boolean fileSelected = false;
        TableItem[] tableItemArray = this.fileViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                fileSelected = true;
                break;
            }
            ++n2;
        }
        if (!fileSelected) {
            if (this.info.isFlatFileLocalMode() || this.info.isFlatFileUrlMode()) {
                this.setThisPageComplete(TeiidMetadataImportSourcePage.getString("noDataFilesSelected"), 3);
            }
            return false;
        }
        if (this.fileParsingStatus.getSeverity() == 4) {
            this.setThisPageComplete(this.fileParsingStatus.getMessage(), 3);
            return false;
        }
        Collection openModelProjects = DotProjectUtils.getOpenModelProjects();
        if (openModelProjects.size() == 0) {
            this.setThisPageComplete(TeiidMetadataImportSourcePage.getString("noOpenProjectsMessage"), 3);
            return false;
        }
        if (this.srcCombo.getText().length() == 0) {
            this.setThisPageComplete(INVALID_PAGE_MESSAGE, 3);
            return false;
        }
        String container = this.sourceModelContainerText.getText();
        if (CoreStringUtil.isEmpty((String)container)) {
            this.setThisPageComplete(Util.getString(String.valueOf(I18N_PREFIX) + "sourceFileLocationMustBeSpecified", new Object[0]), 3);
            return false;
        }
        IProject project = this.info.getTargetProject();
        if (project == null) {
            this.setThisPageComplete(Util.getString(String.valueOf(I18N_PREFIX) + "sourceFileLocationMustBeSpecified", new Object[0]), 3);
            return false;
        }
        String fileText = this.sourceModelFileText.getText().trim();
        IStatus status = ModelNameUtil.validate((String)fileText, (String)".xmi", null, (int)1);
        if (status.getSeverity() == 4) {
            this.setThisPageComplete(String.valueOf(ModelNameUtil.MESSAGES.INVALID_SOURCE_MODEL_NAME) + status.getMessage(), 3);
            return false;
        }
        if (this.info.sourceModelExists() && !this.sourceModelHasSameConnectionProfile()) {
            this.setThisPageComplete(Util.getString(String.valueOf(I18N_PREFIX) + "connectionProfileForModelIsDifferent", (Object)fileText), 3);
            return false;
        }
        if (this.info.getCheckedFileInfo() != null && !this.isKnownTextFileExtension(this.info.getCheckedFileInfo().getDataFile())) {
            this.setThisPageComplete(TeiidMetadataImportSourcePage.getString("nonStandardFileExtensionSelected"), 2);
        } else {
            this.setThisPageComplete(EMPTY_STRING, 0);
        }
        return openModelProjects.size() > 0;
    }

    private void setThisPageComplete(String message, int severity) {
        WizardUtil.setPageComplete((WizardPage)this, (String)message, (int)severity);
    }

    public String getSourceContainerName() {
        String result = null;
        result = ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric() ? this.getHiddenProjectPath() : this.sourceModelContainerText.getText().trim();
        return result;
    }

    private String getHiddenProjectPath() {
        String result = null;
        IProject hiddenProj = ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject(false);
        if (hiddenProj != null) {
            result = hiddenProj.getFullPath().makeRelative().toString();
        }
        return result;
    }

    private void setSourceHelpMessage() {
        if (this.creatingControl) {
            return;
        }
        String proceedureName = "getTextFiles()";
        if (this.info.sourceModelExists()) {
            if (this.sourceHasProcedure()) {
                this.sourceHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "existingSourceModelHasProcedure", new Object[]{this.info.getSourceModelName(), proceedureName}));
            } else {
                this.sourceHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "existingSourceModelHasNoProcedure", new Object[]{this.info.getSourceModelName(), proceedureName}));
            }
        } else if (this.info.getSourceModelName() == null || this.info.getSourceModelName().length() == 0) {
            this.sourceHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "sourceModelUndefined", new Object[0]));
        } else {
            this.sourceHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "sourceModelWillBeCreated", new Object[]{this.info.getSourceModelName(), proceedureName}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sourceHasProcedure() {
        IFile sourceModel;
        ModelResource smr;
        if (this.sourceModelFilePath == null) {
            return false;
        }
        IPath modelPath = new Path(this.sourceModelFilePath.toOSString()).append(this.sourceModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        if ((smr = ModelUtilities.getModelResourceForIFile((IFile)(sourceModel = ModelerCore.getWorkspace().getRoot().getFile(modelPath)), (boolean)false)) == null) return false;
        try {
            Object obj;
            EObject eObj;
            Iterator iterator = smr.getAllRootEObjects().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((eObj = (EObject)(obj = iterator.next())) instanceof Procedure) || !GET_TEXT_FILES.equalsIgnoreCase(ModelObjectUtilities.getName((EObject)eObj)));
            return true;
        }
        catch (ModelWorkspaceException err) {
            Util.log((Throwable)err);
        }
        return false;
    }

    private boolean sourceModelHasSameConnectionProfile() {
        IFile sourceModel;
        ModelResource smr;
        if (this.sourceModelFilePath == null) {
            return false;
        }
        IPath modelPath = new Path(this.sourceModelFilePath.toOSString()).append(this.sourceModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        if ((smr = ModelUtilities.getModelResourceForIFile((IFile)(sourceModel = ModelerCore.getWorkspace().getRoot().getFile(modelPath)), (boolean)false)) != null) {
            IConnectionProfile profile = this.connectionInfoHelper.getConnectionProfile(smr);
            if (profile == null || this.info.getConnectionProfile() == null) {
                return false;
            }
            if (profile.getName().equalsIgnoreCase(this.info.getConnectionProfile().getName())) {
                return true;
            }
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fileContentProvider.setIsFlatFileContent(true);
            this.setTitle(TITLE);
            this.fileNameColumn.getColumn().setText(TeiidMetadataImportSourcePage.getString("dataFileNameColumn"));
            IConnectionProfile currentProfile = this.getConnectionProfile();
            if (currentProfile == null) {
                this.fileViewer.setInput(null);
                this.info.setSourceModelName(null);
                this.setSourceHelpMessage();
            } else if (!this.isValidProfileForPage(currentProfile)) {
                this.setConnectionProfile(null);
                this.fileViewer.setInput(null);
                this.info.setSourceModelName(null);
                this.setSourceHelpMessage();
            }
            this.refreshConnectionProfiles();
            this.resetCPComboItems();
            this.loadFileListViewer();
            this.synchronizeUI();
            this.validatePage();
        }
    }

    private boolean isValidProfileForPage(IConnectionProfile profile) {
        boolean isValid = false;
        if (this.info.isFlatFileLocalMode() && profile.getProviderId().equalsIgnoreCase(ODA_FLAT_FILE_ID)) {
            isValid = true;
        } else if (this.info.isFlatFileUrlMode() && profile.getProviderId().equalsIgnoreCase(FLAT_FILE_URL_ID)) {
            isValid = true;
        }
        return isValid;
    }

    private boolean isKnownTextFileExtension(File file) {
        Path filePath = new Path(file.getPath());
        String ext = filePath.getFileExtension().toUpperCase();
        String[] stringArray = TEXT_FILE_EXTENSIONS;
        int n = TEXT_FILE_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.equalsIgnoreCase(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public class CPListener
    implements IProfileListener {
        IConnectionProfile latestProfile;

        public void profileAdded(IConnectionProfile profile) {
            this.latestProfile = profile;
        }

        public void profileChanged(IConnectionProfile profile) {
            this.latestProfile = profile;
        }

        public void profileDeleted(IConnectionProfile profile) {
        }

        public IConnectionProfile getChangedProfile() {
            return this.latestProfile;
        }
    }

    class ConnectionProfileInfo {
        public boolean includeTypeLine = false;
        public boolean columnsInFirstLine = false;
        public String home;
        public String delimiterType = "COMMA";
        public String charset = "UTF-8";

        ConnectionProfileInfo() {
        }
    }

    class DataFileContentColumnLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            if (element instanceof File) {
                String name = ((File)element).getName();
                if (TeiidMetadataImportSourcePage.this.isKnownTextFileExtension((File)element)) {
                    name = String.valueOf(name) + "     <<<<";
                }
                return name;
            }
            return TeiidMetadataImportSourcePage.EMPTY_STRING;
        }

        public String getToolTipText(Object element) {
            return TeiidMetadataImportSourcePage.getString("fileNameColumnTooltip");
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    class DataFolderContentProvider
    implements ITreeContentProvider {
        boolean isFlatFileContent = true;
        private DefaultFilterMatcher filterMatcher;
        private Object[] NO_CHILDREN;

        DataFolderContentProvider() {
            this.filterMatcher = new DefaultFilterMatcher();
            this.NO_CHILDREN = new Object[0];
        }

        public void setFilterString(String pattern) {
            this.filterMatcher.setFilter(String.valueOf(pattern) + "*", true, false);
        }

        public void dispose() {
        }

        public Object[] getChildren(Object theParent) {
            File[] result = null;
            if (theParent instanceof File) {
                result = ((File)theParent).listFiles();
            }
            return result == null ? this.NO_CHILDREN : result;
        }

        public Object[] getElements(Object theInput) {
            if (theInput instanceof File && ((File)theInput).isDirectory()) {
                File[] allFiles = ((File)theInput).listFiles();
                ArrayList<File> goodFilesList = new ArrayList<File>();
                File[] fileArray = allFiles;
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File theFile = fileArray[n2];
                    if (!theFile.isDirectory()) {
                        if (this.isFlatFileContent) {
                            if (this.isValidTextFile(theFile)) {
                                goodFilesList.add(theFile);
                            }
                        } else if (theFile.getName().toUpperCase().endsWith(TeiidMetadataImportSourcePage.DOT_XML)) {
                            goodFilesList.add(theFile);
                        }
                    }
                    ++n2;
                }
                return goodFilesList.toArray(new File[0]);
            }
            if (theInput instanceof File) {
                ArrayList<File> goodFilesList = new ArrayList<File>();
                File theFile = (File)theInput;
                if (this.isFlatFileContent) {
                    if (this.isValidTextFile(theFile)) {
                        goodFilesList.add(theFile);
                    }
                } else if (theFile.getName().toUpperCase().endsWith(TeiidMetadataImportSourcePage.DOT_XML)) {
                    goodFilesList.add(theFile);
                }
                return goodFilesList.toArray(new File[0]);
            }
            ArrayList goodFilesList = new ArrayList();
            return goodFilesList.toArray(new File[0]);
        }

        private boolean isValidTextFile(File file) {
            boolean isValid = false;
            String fileName = file.getName().toUpperCase();
            if (this.filterMatcher.match(fileName)) {
                isValid = true;
            }
            return isValid;
        }

        public Object getParent(Object theElement) {
            return theElement instanceof File ? ((File)theElement).getParentFile() : null;
        }

        public boolean hasChildren(Object theElement) {
            Object[] kids = this.getChildren(theElement);
            return kids != null && kids.length > 0;
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
        }

        public void setIsFlatFileContent(boolean isFlatFileContent) {
            this.isFlatFileContent = isFlatFileContent;
        }
    }

    class DefaultFilterMatcher
    implements FilteredList.FilterMatcher {
        private StringMatcher fMatcher;

        DefaultFilterMatcher() {
        }

        public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
            this.fMatcher = new StringMatcher(String.valueOf(pattern) + '*', ignoreCase, ignoreWildCards);
        }

        public boolean match(Object element) {
            return this.fMatcher.match(element.toString());
        }
    }
}

