/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.util.NewModelObjectHelperManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.transformation.TransformationFactory;
import org.teiid.designer.query.proc.ITeiidColumnInfo;
import org.teiid.designer.query.proc.ITeiidMetadataFileInfo;
import org.teiid.designer.transformation.ui.wizards.file.FlatFileRelationalModelFactory;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataFileInfo;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;
import org.teiid.designer.transformation.validation.TransformationValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class FlatFileViewModelFactory
extends FlatFileRelationalModelFactory {
    public static final String RELATIONAL_PACKAGE_URI = "http://www.metamatrix.com/metamodels/Relational";
    public static final RelationalFactory relationalFactory = RelationalFactory.eINSTANCE;
    public static final TransformationFactory transformationFactory = TransformationFactory.eINSTANCE;
    public static final DatatypeManager datatypeManager = ModelerCore.getWorkspaceDatatypeManager();

    public ModelResource createViewRelationalModel(IPath location, String modelName) throws ModelWorkspaceException {
        ModelResource resrc = ModelerCore.createModelResource((IPath)location, (String)modelName);
        resrc.getModelAnnotation().setPrimaryMetamodelUri(RELATIONAL_PACKAGE_URI);
        resrc.getModelAnnotation().setModelType(ModelType.VIRTUAL_LITERAL);
        ModelUtilities.initializeModelContainers((ModelResource)resrc, (String)"Create Model Containers", (Object)this);
        return resrc;
    }

    private void createColumns(ITeiidMetadataFileInfo info, BaseTable baseTable) throws ModelerCoreException {
        EObject stringType = datatypeManager.findDatatype("string");
        for (ITeiidColumnInfo columnInfo : info.getColumnInfoList()) {
            Column column = factory.createColumn();
            column.setName(columnInfo.getName());
            column.setNameInSource(columnInfo.getSymbolName());
            column.setLength(columnInfo.getWidth());
            column.setDefaultValue(columnInfo.getDefaultValue());
            column.setFixedLength(info.isFixedWidthColumns());
            EObject datatype = datatypeManager.findDatatype(columnInfo.getDatatype());
            if (datatype != null) {
                column.setType(datatype);
                if (stringType != null && stringType == datatype) {
                    if (info.isFixedWidthColumns()) {
                        column.setLength(columnInfo.getWidth());
                    } else {
                        column.setLength(4000);
                    }
                }
            }
            baseTable.getColumns().add((Object)column);
        }
    }

    public void createViewTable(ModelResource modelResource, TeiidMetadataFileInfo info, String relationalModelName) throws ModelerCoreException {
        BaseTable table = factory.createBaseTable();
        table.setName(info.getViewTableName());
        this.createColumns(info, table);
        this.addValue(modelResource, table, this.getModelResourceContents(modelResource));
        NewModelObjectHelperManager.helpCreate((Object)table, null);
        String sqlString = info.getSqlString(relationalModelName);
        SqlTransformationMappingRoot tRoot = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)table);
        TransformationHelper.setSelectSqlString((Object)tRoot, (String)sqlString, (boolean)false, (Object)this);
        TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)tRoot, (Object)this);
        TransformationValidator validator = new TransformationValidator(tRoot);
        validator.validateSql(sqlString, 0, true);
    }
}

